/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class StyleNameTest
extends BaseTestCase {
    private String fileName = "StyleNameTest.xml";

    public void testNameSpace() throws Exception {
        this.openDesign(this.fileName);
        NameSpace styleNs = this.design.getNameHelper().getNameSpace(0);
        StyleNameTest.assertEquals((int)3, (int)styleNs.getCount());
        StyleNameTest.assertTrue((boolean)styleNs.contains("my-style-test"));
        StyleNameTest.assertTrue((boolean)styleNs.contains("my-style-test-1"));
        StyleNameTest.assertTrue((boolean)styleNs.contains("styletest"));
        List styles = this.design.getSlot(0).getContents();
        DesignElement style = (DesignElement)styles.get(0);
        StyleNameTest.assertEquals((Object)style, (Object)styleNs.getElement(style.getName().toLowerCase()));
        StyleNameTest.assertTrue((boolean)styleNs.contains(style.getName()));
        StyleNameTest.assertTrue((boolean)styleNs.getElements().containsAll(styles));
        ElementFactory factory = this.designHandle.getElementFactory();
        String styleName = ((DesignElement)styles.get(0)).getName();
        StyleNameTest.assertEquals((String)"My-style-test", (String)styleName);
        SharedStyleHandle styleHandle = factory.newStyle(styleName);
        StyleNameTest.assertEquals((String)"My-style-test1", (String)styleHandle.getName());
        styleHandle = factory.newStyle("my-Style-tesT1");
        StyleNameTest.assertEquals((String)"my-Style-tesT11", (String)styleHandle.getName());
        styleHandle = factory.newStyle("My-Style-tesT1");
        StyleNameTest.assertEquals((String)"My-Style-tesT12", (String)styleHandle.getName());
    }

    public void testNameValidator() throws Exception {
        this.openDesign(this.fileName);
        String invalidName = "style name";
        SharedStyleHandle styleHandle = this.designHandle.getElementFactory().newStyle(invalidName);
        try {
            this.designHandle.getStyles().add((DesignElementHandle)styleHandle);
            StyleNameTest.fail();
        }
        catch (SemanticException e) {
            StyleNameTest.assertEquals((String)"Error.NameException.INVALID_STYLE_NAME", (String)e.getErrorCode());
        }
        styleHandle = this.designHandle.getStyles().get(0);
        try {
            styleHandle.setName(invalidName);
            StyleNameTest.fail();
        }
        catch (SemanticException e) {
            StyleNameTest.assertEquals((String)"Error.NameException.INVALID_STYLE_NAME", (String)e.getErrorCode());
        }
    }

    public void testCompatibleWithName() throws Exception {
        this.openDesign("StyleNameTest_1.xml");
        this.save();
        StyleNameTest.assertTrue((boolean)this.compareFile("StyleNameTest_golden.xml"));
        this.openLibrary("StyleNameTest_2.xml");
        this.saveLibrary();
        StyleNameTest.assertTrue((boolean)this.compareFile("StyleNameTest_golden_1.xml"));
    }

    public void testCompatibleRename() throws Exception {
        this.openDesign("StyleNameTest_3.xml");
        DesignElementHandle styleHandle = this.designHandle.getStyles().get(0);
        StyleNameTest.assertEquals((String)"My style", (String)styleHandle.getName());
        DesignElementHandle labelHandle = this.designHandle.findElement("label_1");
        StyleNameTest.assertEquals((Object)styleHandle, (Object)labelHandle.getStyle());
        styleHandle = this.designHandle.getStyles().get(1);
        StyleNameTest.assertEquals((String)"test-style", (String)styleHandle.getName());
        labelHandle = this.designHandle.findElement("label_2");
        StyleNameTest.assertEquals((Object)styleHandle, (Object)labelHandle.getStyle());
        styleHandle = this.designHandle.getStyles().get(2);
        StyleNameTest.assertEquals((String)"Test-Style1", (String)styleHandle.getName());
        labelHandle = this.designHandle.findElement("label_3");
        StyleNameTest.assertEquals((Object)styleHandle, (Object)labelHandle.getStyle());
        this.save();
        StyleNameTest.assertTrue((boolean)this.compareFile("StyleNameTest_golden_2.xml"));
        this.openLibrary("StyleNameTest_4.xml");
        this.saveLibrary();
        StyleNameTest.assertTrue((boolean)this.compareFile("StyleNameTest_golden_3.xml"));
    }

    public void testCompatibleRename_1() throws Exception {
        this.openDesign("StyleNameTest_5.xml");
        this.save();
        StyleNameTest.assertTrue((boolean)this.compareFile("StyleNameTest_golden_4.xml"));
    }

    public void testCompatibleRename_2() throws Exception {
        this.openDesign("StyleNameTest_6.xml");
        DesignElementHandle labelHandle = this.designHandle.findElement("label_1");
        StyleNameTest.assertNotNull((Object)labelHandle.getStringProperty("style"));
        StyleNameTest.assertNotNull((Object)labelHandle.getStyle());
        ThemeHandle themeHandle = this.designHandle.getTheme();
        StyleNameTest.assertNotNull((Object)themeHandle);
        StyleHandle libStyle = themeHandle.findStyle("My style");
        StyleNameTest.assertEquals((Object)libStyle, (Object)labelHandle.getStyle());
        labelHandle = this.designHandle.findElement("label_3");
        StyleNameTest.assertNotNull((Object)labelHandle.getStringProperty("style"));
        StyleNameTest.assertNotNull((Object)labelHandle.getStyle());
    }
}

