/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.extension;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.MultiViewsHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.StyleEvent;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IllegalContentInfo;
import org.eclipse.birt.report.model.api.extension.UndefinedPropertyInfo;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfo;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfoList;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.IClassInfo;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IMethodInfo;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.ExtensionPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class PeerExtensionTest
extends BaseTestCase {
    private static final String HEADER_PROP = "header";
    private static final String DETAIL_PROP = "detail";
    private static final String FOOTER_PROP = "footer";
    private static final String TESTING_BOX_NAME = "TestingBox";
    private static final String FILE_NAME = "PeerExtensionTest.xml";
    private static final String FILE_NAME_1 = "PeerExtensionTest_1.xml";
    private static final String FILE_NAME_2 = "PeerExtensionTest_2.xml";
    private static final String FILE_NAME_3 = "PeerExtensionTest_3.xml";
    private static final String FILE_NAME_5 = "PeerExtensionTest_5.xml";
    private static final String FILE_NAME_6 = "PeerExtensionTest_6.xml";
    private static final String FILE_NAME_7 = "PeerExtensionTest_7.xml";
    private static final String FILE_NAME_10 = "PeerExtensionTest_10.xml";
    private static final String FILE_NAME_11 = "PeerExtensionTest_11.xml";
    private static final String FILE_NAME_9 = "PeerExtensionTest_9.xml";
    private static final String POINTS_PROP_NAME = "points";
    private static final String TESTING_TABLE_NAME = "TestingTable";
    private static final String FILE_NAME_4 = "PeerExtensionTest_4.xml";
    private static final String FILE_NAME_14 = "PeerExtensionTest_14.xml";
    private static final String FILE_NAME_15 = "PeerExtensionTest_15.xml";
    private static final String FILE_NAME_16 = "PeerExtensionTest_16.xml";
    protected static final String TESTING_TABLE = "TestingTable";
    protected static final String TESTING_TABLE1 = "TestingTable1";
    protected static final String TABLE = "Table";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        ThreadResources.setLocale((ULocale)ULocale.ENGLISH);
    }

    public void testVirtualExtension() throws Exception {
        this.openDesign(FILE_NAME_5);
        ExtendedItemHandle handle = (ExtendedItemHandle)this.designHandle.findElement("newHeaderMatrix");
        PeerExtensionTest.assertNotNull((Object)handle);
    }

    public void testExtensionMeta() {
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        PeerExtensionTest.assertTrue((dd.getExtensions().size() >= 2 ? 1 : 0) != 0);
        ExtensionElementDefn extDefn = (ExtensionElementDefn)dd.getExtension(TESTING_BOX_NAME);
        PeerExtensionTest.assertNotNull((Object)extDefn);
        PeerExtensionTest.assertEquals((String)TESTING_BOX_NAME, (String)extDefn.getDisplayName());
        PeerExtensionTest.assertNull((Object)extDefn.getDisplayNameKey());
        PeerExtensionTest.assertEquals((String)TESTING_BOX_NAME, (String)extDefn.getName());
        PeerExtensionTest.assertEquals((int)2, (int)extDefn.getNameOption());
        PeerExtensionTest.assertEquals((boolean)true, (boolean)extDefn.allowsUserProperties());
        PeerExtensionTest.assertEquals((String)TESTING_BOX_NAME, (String)extDefn.getName());
        PeerExtensionTest.assertEquals((String)extDefn.getXmlName(), (String)((ElementDefn)dd.getElement("ExtendedItem")).getXmlName());
        PropertyDefn propDefn = (PropertyDefn)extDefn.getProperty(POINTS_PROP_NAME);
        PeerExtensionTest.assertEquals((int)20, (int)propDefn.getTypeCode());
        PeerExtensionTest.assertEquals((int)14, (int)propDefn.getSubTypeCode());
        PeerExtensionTest.assertTrue((boolean)extDefn.isContainer());
        PeerExtensionTest.assertEquals((int)0, (int)extDefn.getSlotCount());
        PropertyDefn slotPropertyDefn = (PropertyDefn)extDefn.getProperty(HEADER_PROP);
        PeerExtensionTest.assertEquals((int)23, (int)slotPropertyDefn.getTypeCode());
        PeerExtensionTest.assertEquals((String)"Element.TestingBox.slot.header", (String)slotPropertyDefn.getDisplayNameID());
        PeerExtensionTest.assertEquals((String)"defaultHeader", (String)slotPropertyDefn.getDisplayName());
        PeerExtensionTest.assertFalse((boolean)slotPropertyDefn.isList());
        List allowedElements = slotPropertyDefn.getAllowedElements(false);
        PeerExtensionTest.assertEquals((int)3, (int)allowedElements.size());
        PeerExtensionTest.assertTrue((boolean)allowedElements.contains(dd.getElement("Label")));
        PeerExtensionTest.assertTrue((boolean)allowedElements.contains(dd.getElement("Grid")));
        PeerExtensionTest.assertTrue((boolean)allowedElements.contains(dd.getElement("TestingMatrix")));
        slotPropertyDefn = (PropertyDefn)extDefn.getProperty(DETAIL_PROP);
        PeerExtensionTest.assertEquals((String)"Element.TestingBox.slot.detail", (String)slotPropertyDefn.getDisplayNameID());
        PeerExtensionTest.assertEquals((String)"defaultDetail", (String)slotPropertyDefn.getDisplayName());
        PeerExtensionTest.assertTrue((boolean)slotPropertyDefn.isList());
        PeerExtensionTest.assertEquals((int)4, (int)slotPropertyDefn.getAllowedElements(false).size());
        PeerExtensionTest.assertTrue((slotPropertyDefn.getAllowedElements().size() > 4 ? 1 : 0) != 0);
        slotPropertyDefn = (PropertyDefn)extDefn.getProperty(FOOTER_PROP);
        PeerExtensionTest.assertEquals((String)FOOTER_PROP, (String)slotPropertyDefn.getName());
        PeerExtensionTest.assertEquals((String)"Element.TestingBox.slot.footer", (String)slotPropertyDefn.getDisplayNameID());
        PeerExtensionTest.assertEquals((String)"defaultFooter", (String)slotPropertyDefn.getDisplayName());
        PeerExtensionTest.assertFalse((boolean)slotPropertyDefn.isList());
    }

    public void testParser() throws Exception {
        this.openDesign(FILE_NAME);
        ExtendedItemHandle extendedItem = (ExtendedItemHandle)this.designHandle.findElement("testBox");
        PeerExtensionTest.assertNotNull((Object)extendedItem);
        List points = (List)extendedItem.getProperty(POINTS_PROP_NAME);
        PeerExtensionTest.assertEquals((int)3, (int)points.size());
        PeerExtensionTest.assertEquals((double)13.1, (double)((Double)points.get(0)), (double)0.001);
        PeerExtensionTest.assertEquals((double)14.0, (double)((Double)points.get(1)), (double)0.001);
        PeerExtensionTest.assertEquals((double)15.678, (double)((Double)points.get(2)), (double)0.001);
        Object slotPropertyVaiue = extendedItem.getProperty(HEADER_PROP);
        ExtendedItemHandle contentExtendedItem = (ExtendedItemHandle)slotPropertyVaiue;
        PeerExtensionTest.assertEquals((String)"headerMatrix", (String)contentExtendedItem.getName());
        PeerExtensionTest.assertEquals((Object)contentExtendedItem, (Object)this.designHandle.findElement("headerMatrix"));
        PeerExtensionTest.assertEquals((Object)contentExtendedItem, (Object)this.designHandle.getElementByID(contentExtendedItem.getID()));
        PropertyHandle propHandle = extendedItem.getPropertyHandle(HEADER_PROP);
        PeerExtensionTest.assertTrue((boolean)extendedItem.getPropertyDefn(HEADER_PROP).canContain(MetaDataDictionary.getInstance().getElement("Label")));
        PeerExtensionTest.assertFalse((boolean)propHandle.canContain("Label"));
        propHandle = extendedItem.getPropertyHandle(DETAIL_PROP);
        TableHandle table = (TableHandle)propHandle.get(0);
        PeerExtensionTest.assertEquals((String)"testTable", (String)table.getName());
        SlotHandle slot = table.getDetail().get(0).getSlot(0).get(0).getSlot(0);
        contentExtendedItem = (ExtendedItemHandle)slot.get(0);
        PeerExtensionTest.assertEquals((String)"detailBox", (String)contentExtendedItem.getName());
        propHandle = extendedItem.getPropertyHandle(FOOTER_PROP);
        GridHandle grid = (GridHandle)propHandle.get(0);
        PeerExtensionTest.assertEquals((String)"footerGrid", (String)grid.getName());
        this.openDesign(FILE_NAME_4);
        extendedItem = (ExtendedItemHandle)this.designHandle.findElement("testTable");
        PeerExtensionTest.assertNotNull((Object)extendedItem);
        PeerExtensionTest.assertNotNull((Object)extendedItem.getReportItem());
        PeerExtensionTest.assertEquals((String)"TestingTable", (String)extendedItem.getExtensionName());
        PeerExtensionTest.assertNotNull((Object)extendedItem.getDefn());
        ExtensionPropertyDefn propDefn = (ExtensionPropertyDefn)extendedItem.getPropertyDefn("customComments");
        PeerExtensionTest.assertFalse((boolean)propDefn.hasOwnModel());
    }

    public void testWriter() throws Exception {
        this.openDesign(FILE_NAME);
        ExtendedItemHandle extendedItem = (ExtendedItemHandle)this.designHandle.findElement("testBox");
        PeerExtensionTest.assertNotNull((Object)extendedItem);
        PropertyHandle propHandle = extendedItem.getPropertyHandle(DETAIL_PROP);
        LabelHandle label = this.designHandle.getElementFactory().newLabel("addLabel");
        propHandle.add((DesignElementHandle)label);
        IDesignElement clonedExtendedItem = extendedItem.copy();
        this.designHandle.rename(clonedExtendedItem.getHandle((Module)this.design));
        propHandle.paste(clonedExtendedItem);
        ExtendedItemHandle extendedTable = this.designHandle.getElementFactory().newExtendedItem("testExtendedTable", "TestingTable");
        extendedTable.setProperty("dataSet", (Object)"tableDataSet");
        extendedTable.setProperty("color", (Object)"red");
        extendedTable.setProperty("usage", (Object)"testusagevalue");
        this.designHandle.getBody().add((DesignElementHandle)extendedTable);
        this.save();
        PeerExtensionTest.assertTrue((boolean)this.compareFile("PeerExtensionTest_golden.xml"));
    }

    public void testPropertySearch() throws Exception {
        this.openDesign(FILE_NAME_1);
        ExtendedItemHandle extendedItem = (ExtendedItemHandle)this.designHandle.findElement("testBox");
        PeerExtensionTest.assertNotNull((Object)extendedItem);
        ExtendedItemHandle contentExtendedItem = (ExtendedItemHandle)this.designHandle.findElement("headerMatrix");
        PeerExtensionTest.assertEquals((String)"black", (String)contentExtendedItem.getStringProperty("color"));
        TableHandle table = (TableHandle)this.designHandle.findElement("testTable");
        PeerExtensionTest.assertEquals((Object)extendedItem, (Object)table.getContainer());
        PeerExtensionTest.assertEquals((String)"black", (String)extendedItem.getStringProperty("color"));
        PeerExtensionTest.assertEquals((String)"fantasy", (String)table.getStringProperty("fontFamily"));
        PeerExtensionTest.assertEquals((String)"larger", (String)table.getStringProperty("fontSize"));
        LabelHandle label = (LabelHandle)this.designHandle.findElement("testLabel");
        PeerExtensionTest.assertEquals((String)"black", (String)label.getStringProperty("color"));
        PeerExtensionTest.assertEquals((String)"fantasy", (String)label.getStringProperty("fontFamily"));
        PeerExtensionTest.assertEquals((String)"larger", (String)label.getStringProperty("fontSize"));
        PeerExtensionTest.assertEquals((String)"normal", (String)label.getStringProperty("fontWeight"));
        PeerExtensionTest.assertEquals((String)"normal", (String)label.getStringProperty("fontStyle"));
    }

    public void testCommand() throws Exception {
        this.openDesign(FILE_NAME);
        ExtendedItemHandle extendedItem = (ExtendedItemHandle)this.designHandle.findElement("testBox");
        PeerExtensionTest.assertNotNull((Object)extendedItem);
        PropertyHandle points = extendedItem.getPropertyHandle(POINTS_PROP_NAME);
        try {
            points.addItem((Object)"p16");
            PeerExtensionTest.fail();
        }
        catch (SemanticException e) {
            PeerExtensionTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
        points.removeItem(1);
        PeerExtensionTest.assertEquals((int)2, (int)points.getListValue().size());
        points.addItem((Object)"18.9");
        PropertyHandle propHandle = extendedItem.getPropertyHandle(HEADER_PROP);
        ExtendedItemHandle contentExtendedItem = (ExtendedItemHandle)propHandle.get(0);
        LabelHandle label = this.designHandle.getElementFactory().newLabel("label1");
        try {
            propHandle.add((DesignElementHandle)label);
            PeerExtensionTest.fail();
        }
        catch (SemanticException semanticException) {}
        contentExtendedItem.drop();
        PeerExtensionTest.assertEquals((int)0, (int)propHandle.getContentCount());
        propHandle.add((DesignElementHandle)label);
        PeerExtensionTest.assertEquals((int)1, (int)propHandle.getContentCount());
        PeerExtensionTest.assertEquals((Object)extendedItem, (Object)label.getContainer());
        propHandle = extendedItem.getPropertyHandle(DETAIL_PROP);
        TableHandle table = (TableHandle)propHandle.get(0);
        TableGroupHandle tableGroup = this.designHandle.getElementFactory().newTableGroup();
        table.getGroups().add((DesignElementHandle)tableGroup);
        PeerExtensionTest.assertEquals((Object)table, (Object)tableGroup.getContainer());
        ListHandle list = this.designHandle.getElementFactory().newList("list");
        propHandle.add((DesignElementHandle)list);
        PeerExtensionTest.assertEquals((int)2, (int)propHandle.getContentCount());
        this.save();
        PeerExtensionTest.assertTrue((boolean)this.compareFile("PeerExtensionTest_golden_1.xml"));
    }

    public void testParserErrorRecover() throws Exception {
        this.openDesign(FILE_NAME_2);
        ExtendedItemHandle extendedItem = (ExtendedItemHandle)this.designHandle.findElement("testBox");
        PeerExtensionTest.assertNotNull((Object)extendedItem);
        PeerExtensionTest.assertEquals((String)"nonExistingExtension", (String)extendedItem.getExtensionName());
        PeerExtensionTest.assertEquals((String)"1.2mm", (String)extendedItem.getStringProperty("x"));
        PeerExtensionTest.assertEquals((String)"11.2mm", (String)extendedItem.getStringProperty("y"));
        PeerExtensionTest.assertEquals((String)"firstDataSet", (String)extendedItem.getStringProperty("dataSet"));
        PeerExtensionTest.assertNull((Object)this.designHandle.findElement("testTable"));
        LabelHandle label = this.designHandle.getElementFactory().newLabel("testLabel");
        PeerExtensionTest.assertEquals((String)"testLabel1", (String)label.getName());
        this.designHandle.getBody().add((DesignElementHandle)label);
        this.save();
        PeerExtensionTest.assertTrue((boolean)this.compareFile("PeerExtensionTest_golden_2.xml"));
    }

    public void testExtensionNameProp() throws Exception {
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        PeerExtensionTest.assertTrue((dd.getExtensions().size() >= 3 ? 1 : 0) != 0);
        ElementDefn extendedCell = (ElementDefn)dd.getExtension("TestingTable");
        PeerExtensionTest.assertNotNull((Object)extendedCell);
        PeerExtensionTest.assertEquals((Object)dd.getElement("ReportItem"), (Object)extendedCell.getParent());
        PropertyDefn extensionName = (PropertyDefn)extendedCell.getProperty("extensionName");
        PeerExtensionTest.assertNotNull((Object)extensionName);
    }

    public void testActionHandleInExtension() throws Exception {
        this.openDesign(FILE_NAME_3);
        ExtendedItemHandle extendedItem = (ExtendedItemHandle)this.designHandle.findElement("testBox");
        PeerExtensionTest.assertNotNull((Object)extendedItem);
        PropertyDefn actionDefn = (PropertyDefn)extendedItem.getPropertyDefn("action");
        PeerExtensionTest.assertNotNull((Object)actionDefn);
        ImageHandle image = (ImageHandle)this.designHandle.findElement("testImage");
        ActionHandle imageAction = image.getActionHandle();
        PeerExtensionTest.assertNotNull((Object)imageAction);
        String actionString = ModuleUtil.serializeAction((ActionHandle)imageAction);
        ActionHandle extendedAction = ModuleUtil.deserializeAction((String)actionString, (DesignElementHandle)extendedItem);
        PeerExtensionTest.assertNotNull((Object)extendedAction);
        PeerExtensionTest.assertNotNull((Object)extendedItem.getProperty("action"));
        PeerExtensionTest.assertEquals((Object)extendedItem, (Object)extendedAction.getElementHandle());
    }

    public void testExtensionLoaderErrorHandler() throws Exception {
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        PeerExtensionTest.assertTrue((dd.getExtensions().size() >= 2 ? 1 : 0) != 0);
        PeerExtensionTest.assertNull((Object)dd.getExtension("wrongTestExtension"));
    }

    public void testExtensionAllowedUnits() throws Exception {
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        ExtensionElementDefn extDefn = (ExtensionElementDefn)dd.getExtension("TestingTable");
        IElementPropertyDefn defn = extDefn.getProperty("width");
        IChoiceSet set = defn.getAllowedUnits();
        PeerExtensionTest.assertNotNull((Object)set.findChoice("in"));
        PeerExtensionTest.assertNotNull((Object)set.findChoice("cm"));
        PeerExtensionTest.assertNull((Object)set.findChoice("mm"));
        PeerExtensionTest.assertNull((Object)set.findChoice("pt"));
        set = dd.getElement(TABLE).findProperty("width").getAllowedUnits();
        PeerExtensionTest.assertNotNull((Object)set.findChoice("in"));
        PeerExtensionTest.assertNotNull((Object)set.findChoice("cm"));
        PeerExtensionTest.assertNotNull((Object)set.findChoice("mm"));
        PeerExtensionTest.assertNotNull((Object)set.findChoice("pt"));
        this.openDesign(FILE_NAME_4);
        ExtendedItemHandle extendedItem = (ExtendedItemHandle)this.designHandle.findElement("testTable");
        defn = extendedItem.getPropertyDefn("width");
        set = defn.getAllowedUnits();
        PeerExtensionTest.assertNotNull((Object)set.findChoice("in"));
        PeerExtensionTest.assertNotNull((Object)set.findChoice("cm"));
        PeerExtensionTest.assertNull((Object)set.findChoice("mm"));
        PeerExtensionTest.assertNull((Object)set.findChoice("pt"));
    }

    public void testPredefinedStyles() throws Exception {
        this.openDesign(FILE_NAME_6);
        SharedStyleHandle style = this.designHandle.findStyle("testing-box");
        DesignElementHandle extendedItem = this.designHandle.findElement("headerMatrix");
        PeerExtensionTest.assertEquals((String)"400", (String)extendedItem.getStringProperty("fontWeight"));
        PeerExtensionTest.assertEquals((String)"x-small", (String)extendedItem.getStringProperty("fontSize"));
        PeerExtensionTest.assertFalse((boolean)extendedItem.getPropertyHandle("fontFamily").isSet());
        PeerExtensionTest.assertEquals((String)style.getStringProperty("fontFamily"), (String)extendedItem.getStringProperty("fontFamily"));
        PeerExtensionTest.assertFalse((boolean)extendedItem.getPropertyHandle("fontStyle").isSet());
        PeerExtensionTest.assertEquals((String)style.getStringProperty("fontStyle"), (String)extendedItem.getStringProperty("fontStyle"));
        PeerExtensionTest.assertFalse((boolean)extendedItem.getPropertyHandle("color").isSet());
        PeerExtensionTest.assertEquals((String)style.getStringProperty("color"), (String)extendedItem.getStringProperty("color"));
        PeerExtensionTest.assertFalse((boolean)extendedItem.getPropertyHandle("fontVariant").isSet());
        PeerExtensionTest.assertEquals((String)style.getStringProperty("fontVariant"), (String)extendedItem.getStringProperty("fontVariant"));
        extendedItem = this.designHandle.findElement("detailMatrix");
        PeerExtensionTest.assertEquals((String)"x-small", (String)extendedItem.getStringProperty("fontSize"));
        PeerExtensionTest.assertEquals((String)"400", (String)extendedItem.getStringProperty("fontWeight"));
        PeerExtensionTest.assertEquals((String)"oblique", (String)extendedItem.getStringProperty("fontStyle"));
        PeerExtensionTest.assertEquals((String)"red", (String)extendedItem.getStringProperty("color"));
        PeerExtensionTest.assertTrue((boolean)extendedItem.getPropertyHandle("fontFamily").isSet());
        PeerExtensionTest.assertFalse((boolean)extendedItem.getPropertyHandle("fontVariant").isSet());
        PeerExtensionTest.assertEquals((String)style.getStringProperty("fontVariant"), (String)extendedItem.getStringProperty("fontVariant"));
        extendedItem = this.designHandle.findElement("detailMatrixOne");
        PeerExtensionTest.assertEquals((String)"small", (String)extendedItem.getStringProperty("fontSize"));
        PeerExtensionTest.assertEquals((String)"oblique", (String)extendedItem.getStringProperty("fontStyle"));
        PeerExtensionTest.assertEquals((String)"red", (String)extendedItem.getStringProperty("color"));
        PeerExtensionTest.assertTrue((boolean)extendedItem.getPropertyHandle("fontFamily").isSet());
        PeerExtensionTest.assertFalse((boolean)extendedItem.getPropertyHandle("fontVariant").isSet());
        PeerExtensionTest.assertEquals((String)style.getStringProperty("fontVariant"), (String)extendedItem.getStringProperty("fontVariant"));
    }

    public void testPredefinedStylesBroadCast() throws Exception {
        this.openDesign(FILE_NAME_6);
        SharedStyleHandle style = this.designHandle.findStyle("testPredefinedStyle");
        DesignElementHandle detailMaxtrix = this.designHandle.findElement("detailMatrix");
        MyListener styleEventListener = new MyListener();
        detailMaxtrix.addListener((Listener)styleEventListener);
        style.setBorderLeftStyle("dotted");
        PeerExtensionTest.assertEquals((int)2, (int)styleEventListener.getEventCount());
        style.setStringProperty("color", "red");
        PeerExtensionTest.assertEquals((int)4, (int)styleEventListener.getEventCount());
    }

    public void testResolveForExtensionProperty() throws Exception {
        this.openDesign(FILE_NAME_7);
        DesignElementHandle extendedItem = this.designHandle.findElement("testTable");
        ElementRefValue value = (ElementRefValue)extendedItem.getElement().getProperty((Module)this.design, "cube");
        PeerExtensionTest.assertEquals((String)"testCube", (String)value.getName());
        PeerExtensionTest.assertFalse((boolean)value.isResolved());
        TabularCubeHandle cube = this.designHandle.getElementFactory().newTabularCube("testCube");
        this.designHandle.getCubes().add((DesignElementHandle)cube);
        value = (ElementRefValue)extendedItem.getElement().getProperty((Module)this.design, "cube");
        PeerExtensionTest.assertEquals((String)"testCube", (String)value.getName());
        PeerExtensionTest.assertEquals((Object)cube.getElement(), (Object)value.getTargetElement());
        PeerExtensionTest.assertTrue((boolean)value.isResolved());
    }

    public void testBackRef() throws Exception {
        this.openDesign("PeerExtensionTest_8.xml");
        DesignElementHandle extendedItem = this.designHandle.findElement("testTable");
        DesignElementHandle cubeHandle = this.designHandle.getCubes().get(0);
        extendedItem.setProperty("cube", (Object)"Customer Cube");
        Iterator iterator = cubeHandle.clientsIterator();
        PeerExtensionTest.assertTrue((boolean)iterator.hasNext());
        DesignElementHandle client = (DesignElementHandle)iterator.next();
        PeerExtensionTest.assertEquals((String)"testTable", (String)client.getName());
        PeerExtensionTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testGetMethods() throws Exception {
        this.openDesign(FILE_NAME);
        ExtendedItemHandle extendedItem = (ExtendedItemHandle)this.designHandle.findElement("testBox");
        PeerExtensionTest.assertNotNull((Object)extendedItem);
        List retList = extendedItem.getMethods("onRender");
        PeerExtensionTest.assertFalse((boolean)retList.isEmpty());
        IMethodInfo method = (IMethodInfo)retList.get(0);
        PeerExtensionTest.assertEquals((String)"getMethod1", (String)method.getName());
        PeerExtensionTest.assertEquals((String)"java.lang.String", (String)method.getReturnType());
        retList = extendedItem.getMethods("onPrepare");
        PeerExtensionTest.assertNull((Object)retList);
        retList = extendedItem.getMethods("onCreate");
        PeerExtensionTest.assertNotNull((Object)retList);
        method = (IMethodInfo)retList.get(0);
        PeerExtensionTest.assertEquals((String)"performOnCreate", (String)method.getName());
        PeerExtensionTest.assertEquals((String)"java.lang.String", (String)method.getReturnType());
        Iterator arguList = method.argumentListIterator();
        IArgumentInfoList argus = (IArgumentInfoList)arguList.next();
        IArgumentInfo argu = (IArgumentInfo)argus.argumentsIterator().next();
        IClassInfo clazz = argu.getClassType();
        PeerExtensionTest.assertEquals((String)"java.lang.Boolean", (String)clazz.getName());
    }

    public void testElementProperty() throws Exception {
        this.openDesign(FILE_NAME_1);
        this.designHandle.includeLibrary("LibraryWithElementProperty.xml", "lib");
        LibraryHandle lib = this.designHandle.getLibrary("lib");
        DesignElementHandle libBox = lib.findElement("LibraryBox");
        DesignElementHandle designBox = this.designHandle.getElementFactory().newElementFrom(libBox, "designBox");
        this.designHandle.getBody().add(designBox);
        this.save();
        PeerExtensionTest.assertTrue((boolean)this.compareFile("PeerExtensionTest_golden_3.xml"));
    }

    public void testDataBindingRef() throws Exception {
        this.openDesign(FILE_NAME_10);
        ExtendedItemHandle matrix1 = (ExtendedItemHandle)this.designHandle.findElement("myMatrix1");
        PeerExtensionTest.assertNotNull((Object)matrix1);
        TableHandle table1 = (TableHandle)this.designHandle.findElement("myTable1");
        PeerExtensionTest.assertNotNull((Object)table1);
        matrix1.setDataBindingReference((ReportItemHandle)table1);
        PeerExtensionTest.assertEquals((Object)"Data Set", (Object)matrix1.getProperty("dataSet"));
        Iterator columns = matrix1.columnBindingsIterator();
        ComputedColumnHandle column = (ComputedColumnHandle)columns.next();
        this.verifyColumnValues(column);
        DataItemHandle data1 = (DataItemHandle)this.designHandle.findElement("myData1");
        PeerExtensionTest.assertNotNull((Object)data1);
        data1.setDataBindingReference((ReportItemHandle)matrix1);
        PeerExtensionTest.assertEquals((Object)"Data Set", (Object)matrix1.getProperty("dataSet"));
        columns = data1.columnBindingsIterator();
        column = (ComputedColumnHandle)columns.next();
        this.verifyColumnValues(column);
    }

    private void verifyColumnValues(ComputedColumnHandle column) {
        PeerExtensionTest.assertEquals((String)"CUSTOMERNUMBER", (String)column.getName());
        PeerExtensionTest.assertEquals((String)"dataSetRow[\"CUSTOMERNUMBER\"]", (String)column.getExpression());
        PeerExtensionTest.assertEquals((String)"integer", (String)column.getDataType());
    }

    public void testMultiView() throws Exception {
        this.openDesign("PeerExtensionMultiViewTest.xml");
        ExtendedItemHandle table1 = (ExtendedItemHandle)this.designHandle.findElement("MyTable1");
        MultiViewsHandle view1 = (MultiViewsHandle)table1.getProperty("multiViews");
        PeerExtensionTest.assertNotNull((Object)view1);
        List views = view1.getListProperty("views");
        PeerExtensionTest.assertEquals((int)2, (int)views.size());
        ExtendedItemHandle box1 = (ExtendedItemHandle)views.get(0);
        PeerExtensionTest.assertEquals((String)"firstDataSet", (String)box1.getDataSet().getName());
        PropertyHandle prop = box1.getPropertyHandle("dataSet");
        PeerExtensionTest.assertTrue((boolean)prop.isReadOnly());
        prop = box1.getPropertyHandle("filter");
        PeerExtensionTest.assertTrue((boolean)prop.isReadOnly());
        ExtendedItemHandle table2 = this.designHandle.getElementFactory().newExtendedItem("table2", "TestingTable");
        this.designHandle.getBody().add((DesignElementHandle)table2);
        table2.setDataSet(this.designHandle.findDataSet("firstDataSet"));
        MultiViewsHandle view2 = this.designHandle.getElementFactory().newMultiView();
        table2.getPropertyHandle("multiViews").add((DesignElementHandle)view2);
        ExtendedItemHandle box3 = this.designHandle.getElementFactory().newExtendedItem("box3", TESTING_BOX_NAME);
        view2.add("views", (DesignElementHandle)box3);
        PeerExtensionTest.assertEquals((String)"firstDataSet", (String)box3.getDataSet().getName());
        this.save();
        PeerExtensionTest.assertTrue((boolean)this.compareFile("PeerExtensionMultiViewTest_golden.xml"));
    }

    public void testParserCompatibility() throws Exception {
        this.openDesign(FILE_NAME_11);
        ExtendedItemHandle extendedHandle = (ExtendedItemHandle)this.designHandle.findElement("testBox");
        PeerExtensionTest.assertNotNull((Object)extendedHandle);
        PeerExtensionTest.assertEquals((String)"1.1", (String)extendedHandle.getExtensionVersion());
        extendedHandle.setExtensionVersion("1.2");
        PeerExtensionTest.assertEquals((String)"1.2", (String)extendedHandle.getExtensionVersion());
        Map propMap = extendedHandle.getUndefinedProperties();
        String propName = "shape";
        UndefinedPropertyInfo propInfor = (UndefinedPropertyInfo)propMap.get(propName);
        PeerExtensionTest.assertEquals((Object)"circle", (Object)propInfor.getValue());
        PeerExtensionTest.assertEquals((String)"1.1", (String)propInfor.getExtensionVersion());
        PeerExtensionTest.assertEquals((String)"cube", (String)extendedHandle.getStringProperty("shape"));
        propName = POINTS_PROP_NAME;
        propInfor = (UndefinedPropertyInfo)propMap.get(propName);
        List valueList = (List)propInfor.getValue();
        PeerExtensionTest.assertEquals((int)3, (int)valueList.size());
        PeerExtensionTest.assertEquals((Object)"13.1", valueList.get(0));
        PeerExtensionTest.assertEquals((Object)"ttt", valueList.get(1));
        PeerExtensionTest.assertEquals((Object)"15.678", valueList.get(2));
        propName = "noProp";
        propInfor = (UndefinedPropertyInfo)propMap.get(propName);
        PeerExtensionTest.assertEquals((Object)"123", (Object)propInfor.getValue());
        Map illegalChildrenMap = extendedHandle.getIllegalContents();
        propName = DETAIL_PROP;
        List illegalChildren = (List)illegalChildrenMap.get(propName);
        PeerExtensionTest.assertEquals((int)3, (int)illegalChildren.size());
        IllegalContentInfo info = (IllegalContentInfo)illegalChildren.get(0);
        DesignElementHandle content = info.getContent();
        PeerExtensionTest.assertEquals((String)"testData", (String)content.getName());
        PeerExtensionTest.assertNull((Object)content.getContainer());
        PeerExtensionTest.assertNull((Object)this.designHandle.findElement(content.getName()));
        PeerExtensionTest.assertEquals((int)1, (int)info.getIndex());
        info = (IllegalContentInfo)illegalChildren.get(1);
        PeerExtensionTest.assertEquals((String)"testData_1", (String)info.getContent().getName());
        PeerExtensionTest.assertEquals((int)3, (int)info.getIndex());
        info = (IllegalContentInfo)illegalChildren.get(2);
        PeerExtensionTest.assertEquals((String)"extend_item", (String)info.getContent().getName());
        PeerExtensionTest.assertTrue((boolean)(info.getContent() instanceof ExtendedItemHandle));
        PeerExtensionTest.assertEquals((int)5, (int)info.getIndex());
        propName = HEADER_PROP;
        illegalChildren = (List)illegalChildrenMap.get(propName);
        PeerExtensionTest.assertEquals((int)1, (int)illegalChildren.size());
        info = (IllegalContentInfo)illegalChildren.get(0);
        PeerExtensionTest.assertEquals((String)"testData_2", (String)info.getContent().getName());
        PeerExtensionTest.assertEquals((int)0, (int)info.getIndex());
        extendedHandle = (ExtendedItemHandle)this.designHandle.findElement("testBox_1");
        propMap = extendedHandle.getUndefinedProperties();
        PeerExtensionTest.assertEquals((int)1, (int)propMap.size());
        illegalChildrenMap = extendedHandle.getIllegalContents();
        PeerExtensionTest.assertTrue((boolean)illegalChildrenMap.isEmpty());
        PeerExtensionTest.assertTrue((boolean)(extendedHandle.getContent(HEADER_PROP, 0) instanceof LabelHandle));
    }

    public void testExtensionStyleDefn() throws Exception {
        this.openDesign("PeerExtensionTest_12.xml");
        ExtendedItemHandle matrix = (ExtendedItemHandle)this.designHandle.getElementByID(10L);
        ExtendedItemHandle box = (ExtendedItemHandle)this.designHandle.getElementByID(20L);
        StyleHandle style = box.getPrivateStyle();
        PeerExtensionTest.assertNull((Object)style);
        style = matrix.getPrivateStyle();
        PeerExtensionTest.assertNotNull((Object)style);
        PeerExtensionTest.assertNotNull((Object)style.getDefn().getProperty("fontFamily"));
    }

    public void testUseOwnSearch() throws Exception {
        this.openDesign("PeerExtensionTest_13.xml");
        ExtendedItemHandle table1 = (ExtendedItemHandle)this.designHandle.findElement("table1");
        ExtendedItemHandle table2 = (ExtendedItemHandle)this.designHandle.findElement("table2");
        PeerExtensionTest.assertNull((Object)table1.getFactoryPropertyHandle("color"));
        PeerExtensionTest.assertEquals((String)"red", (String)table2.getFactoryPropertyHandle("color").getStringValue());
        PeerExtensionTest.assertEquals((Object)"blue", (Object)table1.getReportItem().getProperty("color"));
        PeerExtensionTest.assertEquals((Object)"blue", (Object)table1.getProperty("color"));
        PeerExtensionTest.assertEquals((Object)"red", (Object)table2.getReportItem().getProperty("color"));
        PeerExtensionTest.assertNull((Object)table1.getFactoryPropertyHandle("highlightRules"));
        List rules = (List)table1.getReportItem().getProperty("highlightRules");
        PeerExtensionTest.assertEquals((int)1, (int)rules.size());
        rules = table1.getListProperty("highlightRules");
        PeerExtensionTest.assertEquals((int)1, (int)rules.size());
        rules = (List)table2.getFactoryPropertyHandle("highlightRules").getValue();
        PeerExtensionTest.assertEquals((int)1, (int)rules.size());
        rules = (List)table2.getReportItem().getProperty("highlightRules");
        PeerExtensionTest.assertEquals((int)1, (int)rules.size());
    }

    public void testExtensionMultiViewProperty() throws Exception {
        this.openDesign("ExtensionMultiViewPropertyTest.xml");
        TableHandle table = (TableHandle)this.designHandle.findElement("MyTable1");
        PeerExtensionTest.assertEquals((String)"red", (String)table.getStringProperty("color"));
        ExtendedItemHandle box = (ExtendedItemHandle)table.getCurrentView();
        PeerExtensionTest.assertEquals((String)"black", (String)box.getStringProperty("color"));
    }

    public void testValidationOnNestedExtendedItem() throws Exception {
        this.openDesign(FILE_NAME_14);
        this.designHandle.checkReport();
        List errors = this.design.getAllExceptions();
        ArrayList<ExtendedElementException> extendedErrors = new ArrayList<ExtendedElementException>();
        int i = 0;
        while (i < errors.size()) {
            SemanticException error = (SemanticException)((Object)errors.get(i));
            if (error instanceof ExtendedElementException) {
                extendedErrors.add((ExtendedElementException)error);
            }
            ++i;
        }
        PeerExtensionTest.assertEquals((int)3, (int)extendedErrors.size());
        PeerExtensionTest.assertEquals((String)"testBox", (String)((ExtendedElementException)extendedErrors.get(0)).getElement().getName());
        PeerExtensionTest.assertEquals((String)"detailBox", (String)((ExtendedElementException)extendedErrors.get(1)).getElement().getName());
        PeerExtensionTest.assertEquals((String)"detailBox1", (String)((ExtendedElementException)extendedErrors.get(2)).getElement().getName());
    }

    public void testUserProperty() throws Exception {
        this.openDesign(FILE_NAME_15);
        ExtendedItemHandle itemHandle = (ExtendedItemHandle)this.designHandle.findElement("testBox");
        UserPropertyDefn userDefn = (UserPropertyDefn)itemHandle.getUserProperties().get(0);
        String propName = "myProp1";
        PeerExtensionTest.assertEquals((String)propName, (String)userDefn.getName());
        PeerExtensionTest.assertEquals((String)"property1 value", (String)itemHandle.getStringProperty(propName));
        itemHandle.setProperty(propName, (Object)"new value");
        userDefn = new UserPropertyDefn();
        propName = "prop2";
        userDefn.setName(propName);
        userDefn.setType(MetaDataDictionary.getInstance().getPropertyType(2));
        itemHandle.addUserPropertyDefn(userDefn);
        itemHandle.setProperty(propName, (Object)"3");
        this.save();
        PeerExtensionTest.assertTrue((boolean)this.compareFile("PeerExtensionTest_golden_4.xml"));
    }

    public void testMultipleInheritance() throws Exception {
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        IElementDefn tmpDefn = dd.getExtension(TESTING_TABLE1);
        IElementPropertyDefn tmpPropDefn = tmpDefn.getProperty("width");
        IChoiceSet tmpSet = tmpPropDefn.getAllowedUnits();
        IChoice[] tmpChoices = tmpSet.getChoices();
        PeerExtensionTest.assertEquals((int)2, (int)tmpChoices.length);
        tmpPropDefn = tmpDefn.getProperty("color");
        PeerExtensionTest.assertTrue((boolean)((ElementPropertyDefn)tmpPropDefn).enableContextSearch());
    }

    public void testCloneWithExtendedStructureProp() throws Exception {
        this.openDesign(FILE_NAME_9);
        ExtendedItemHandle itemHandle = (ExtendedItemHandle)this.designHandle.findElement("testBox");
        DesignElementHandle copiedHandle = itemHandle.copy().getHandle((Module)this.design);
        this.designHandle.rename(copiedHandle);
        this.designHandle.getBody().paste(copiedHandle);
        Structure action = (Structure)copiedHandle.getElement().getProperty((Module)this.design, "action");
        PeerExtensionTest.assertNotNull((Object)action.getContext());
    }

    public void testAllowExpressionProperties() throws Exception {
        this.openDesign(FILE_NAME_16);
        ExtendedItemHandle itemHandle = (ExtendedItemHandle)this.designHandle.findElement("action1");
        ExpressionHandle exprHandle = itemHandle.getExpressionProperty("test1");
        PeerExtensionTest.assertEquals((String)"1+1in", (String)exprHandle.getStringExpression());
        PeerExtensionTest.assertEquals((String)"javascript", (String)exprHandle.getType());
        exprHandle = itemHandle.getExpressionProperty("test2");
        PeerExtensionTest.assertEquals((String)"50", (String)exprHandle.getStringExpression());
        PeerExtensionTest.assertEquals((String)"constant", (String)exprHandle.getType());
        exprHandle = itemHandle.getExpressionProperty("test1");
        exprHandle.setExpression((Object)new DimensionValue(11.0, "em"));
        exprHandle.setType("constant");
        itemHandle.setProperty("test2", (Object)new Expression((Object)"30+20", "javascript"));
        this.save();
        PeerExtensionTest.assertTrue((boolean)this.compareFile("PeerExtensionTest_golden_16.xml"));
    }

    public void testElementRefListProperty() throws Exception {
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        IElementDefn elementDefn = dd.getExtension(TESTING_TABLE1);
        IElementPropertyDefn tmpDefn = elementDefn.getProperty("elementRefList");
        PeerExtensionTest.assertTrue((boolean)(tmpDefn instanceof PropertyDefn));
        PropertyDefn propDefn = (PropertyDefn)tmpDefn;
        PeerExtensionTest.assertEquals((int)20, (int)propDefn.getTypeCode());
        PeerExtensionTest.assertEquals((int)15, (int)propDefn.getSubTypeCode());
        PeerExtensionTest.assertEquals((String)TABLE, (String)propDefn.getTargetElementType().getName());
        ExtendedItemHandle testTable1 = this.createDesign().getElementFactory().newExtendedItem("Test", TESTING_TABLE1);
        PropertyHandle propHandle = testTable1.getPropertyHandle("elementRefList");
        TableHandle[] tables = new TableHandle[3];
        int i = 0;
        while (i < tables.length) {
            tables[i] = this.designHandle.getElementFactory().newTableItem("table1");
            this.designHandle.getBody().add((DesignElementHandle)tables[i]);
            propHandle.addItem((Object)tables[i]);
            ++i;
        }
        propHandle.addItem((Object)"NonexistElement");
        PeerExtensionTest.assertEquals((int)4, (int)propHandle.getItems().size());
        i = 0;
        while (i < 3) {
            PeerExtensionTest.assertEquals((Object)tables[i], propHandle.getItems().get(i));
            ++i;
        }
        PeerExtensionTest.assertNull(propHandle.getItems().get(3));
    }

    private static class MyListener
    implements Listener {
        private int eventCount = 0;

        private MyListener() {
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            if (ev instanceof StyleEvent) {
                ++this.eventCount;
            }
        }

        int getEventCount() {
            return this.eventCount;
        }
    }
}

