/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.i18n;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.util.BaseTestCase;

public abstract class BaseMessageFileTest
extends BaseTestCase {
    protected static final String DEFAULT_MESSAGE_FILE = "Messages.properties";
    protected static final String CHARSET = "8859_1";
    protected static final String DISPLAY_NAME_ID_ATTRIB = "displayNameID";
    protected static final String TAG_ID_ATTRIB = "tagID";
    protected static final String TOOL_TIP_ID_ATTRIB = "toolTipID";
    protected Properties props = new Properties();
    protected Map<String, String> resourceKeyMap = new LinkedHashMap<String, String>();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.loadMessageFile();
    }

    @Override
    public void tearDown() {
        this.props.clear();
        this.resourceKeyMap.clear();
    }

    protected void loadMessageFile() throws IOException {
        this.loadProperties(this.getMessageFileInputStream());
    }

    protected void loadProperties(InputStream is) throws IOException {
        this.props.load(is);
    }

    protected abstract InputStream getMessageFileInputStream();

    protected abstract void loadRomFile() throws IOException;

    protected void loadResourceKeys(String fileName, InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = br.readLine();
        int lineCount = 1;
        while (line != null) {
            String tagId;
            String toolTipId;
            String description = String.valueOf(fileName) + "@line " + lineCount;
            String displayNameId = this.getResourceKey(line, DISPLAY_NAME_ID_ATTRIB);
            if (displayNameId != null && !this.resourceKeyMap.containsKey(displayNameId)) {
                this.resourceKeyMap.put(displayNameId, description);
            }
            if ((toolTipId = this.getResourceKey(line, TOOL_TIP_ID_ATTRIB)) != null && !this.resourceKeyMap.containsKey(toolTipId)) {
                this.resourceKeyMap.put(toolTipId, description);
            }
            if ((tagId = this.getResourceKey(line, TAG_ID_ATTRIB)) != null && !this.resourceKeyMap.containsKey(tagId)) {
                this.resourceKeyMap.put(tagId, description);
            }
            line = br.readLine();
            ++lineCount;
        }
        br.close();
    }

    private String getResourceKey(String line, String name) {
        int index1 = line.indexOf(name);
        if (index1 == -1) {
            return null;
        }
        int index2 = line.indexOf(61, index1);
        if (index2 == -1) {
            return null;
        }
        String str = line.substring(index1, index2);
        if (!name.equalsIgnoreCase(str.trim())) {
            return null;
        }
        int start = line.indexOf(34, index1);
        int end = line.indexOf(34, start + 1);
        String id = line.substring(start + 1, end);
        return id;
    }

    public void testDuplicateMessages() throws IOException {
        boolean success = true;
        InputStream is = this.getMessageFileInputStream();
        BufferedReader in = new BufferedReader(new InputStreamReader(is, CHARSET));
        Hashtable<String, String> collection = new Hashtable<String, String>();
        String line = in.readLine();
        int lineIndex = 1;
        StringBuffer errorMessage = new StringBuffer();
        while (line != null) {
            if (StringUtil.isBlank((String)line) || line.startsWith("#")) {
                line = in.readLine();
                ++lineIndex;
                continue;
            }
            String[] data = line.split("=");
            if (data.length != 2) {
                errorMessage.append("errors of i18n in line " + lineIndex);
                errorMessage.append('\n');
                line = in.readLine();
                ++lineIndex;
                continue;
            }
            if (collection.containsKey(data[0])) {
                errorMessage.append("duplicate messages in line " + lineIndex);
                errorMessage.append('\n');
                success = false;
            } else {
                collection.put(data[0], data[1]);
            }
            line = in.readLine();
            ++lineIndex;
        }
        BaseMessageFileTest.assertTrue((String)errorMessage.toString(), (boolean)success);
    }

    public void testRom() throws Exception {
        this.loadRomFile();
        this.checkResourceKeyMap();
    }

    protected void checkResourceKeyMap() {
        boolean success = true;
        StringBuffer errorMessage = new StringBuffer();
        for (Map.Entry<String, String> entry : this.resourceKeyMap.entrySet()) {
            String resourceKey = entry.getKey();
            if (this.props.containsKey(resourceKey)) continue;
            String description = entry.getValue();
            errorMessage.append(String.valueOf(resourceKey) + " in " + description + " not exist in message file");
            errorMessage.append('\n');
            success = false;
        }
        BaseMessageFileTest.assertTrue((String)errorMessage.toString(), (boolean)success);
    }
}

