/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.library;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ConfigVariableHandle;
import org.eclipse.birt.report.model.api.CustomColorHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.IllegalOperationException;
import org.eclipse.birt.report.model.api.IncludeScriptHandle;
import org.eclipse.birt.report.model.api.IncludedCssStyleSheetHandle;
import org.eclipse.birt.report.model.api.IncludedLibraryHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.LibraryException;
import org.eclipse.birt.report.model.api.elements.structures.ConfigVariable;
import org.eclipse.birt.report.model.api.elements.structures.CustomColor;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.elements.structures.IncludedLibrary;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.elements.Label;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class DesignLoadLibraryTest
extends BaseTestCase {
    public void testLoadDesignWithInexistentLibrary() throws Exception {
        this.openDesign("DesignWithInexistentLibrary.xml");
        List libraries = this.designHandle.getAllLibraries();
        DesignLoadLibraryTest.assertEquals((int)1, (int)libraries.size());
        LibraryHandle libHandle = (LibraryHandle)libraries.get(0);
        DesignLoadLibraryTest.assertFalse((boolean)libHandle.isValid());
        DesignLoadLibraryTest.assertEquals((String)"inexistentLibrary.xml", (String)libHandle.getRelativeFileName());
        DesignLoadLibraryTest.assertEquals((String)"Error.DesignParserException.FILE_NOT_FOUND", (String)((ErrorDetail)libHandle.getErrorList().get(0)).getErrorCode());
        ReportElementHandle element = (ReportElementHandle)this.designHandle.findElement("myText");
        DesignLoadLibraryTest.assertTrue((boolean)element.isValidLayoutForCompoundElement());
        element = (ReportElementHandle)this.designHandle.findElement("myGrid");
        DesignLoadLibraryTest.assertFalse((boolean)element.isValidLayoutForCompoundElement());
        element = (ReportElementHandle)this.designHandle.findElement("myTable");
        DesignLoadLibraryTest.assertFalse((boolean)element.isValidLayoutForCompoundElement());
        element = (ReportElementHandle)this.designHandle.findElement("myTable1");
        DesignLoadLibraryTest.assertFalse((boolean)element.isValidLayoutForCompoundElement());
    }

    public void testLoadDesignWithInvalidLibrary() throws Exception {
        this.openDesign("DesignWithInvalidLibrary.xml");
        List libraries = this.designHandle.getAllLibraries();
        DesignLoadLibraryTest.assertEquals((int)1, (int)libraries.size());
        DesignLoadLibraryTest.assertFalse((boolean)((LibraryHandle)libraries.get(0)).isValid());
    }

    public void testLoadDesignWithSemanticErrorLibrary() throws Exception {
        this.openDesign("DesignWithSemanticErrorLibrary.xml");
        List libraries = this.designHandle.getAllLibraries();
        DesignLoadLibraryTest.assertEquals((int)1, (int)libraries.size());
        LibraryHandle oneLibraryHandle = (LibraryHandle)libraries.get(0);
        DesignLoadLibraryTest.assertTrue((boolean)oneLibraryHandle.isValid());
        List errorList = oneLibraryHandle.getErrorList();
        DesignLoadLibraryTest.assertEquals((int)1, (int)errorList.size());
        DesignLoadLibraryTest.assertEquals((String)"Error.PropertyValueException.VALUE_EXISTS", (String)((ErrorDetail)errorList.get(0)).getErrorCode());
    }

    public void testLoadDesignWithDuplicateNamespace() throws Exception {
        try {
            this.openDesign("DesignWithDuplicateNamespace.xml");
            DesignLoadLibraryTest.fail();
        }
        catch (DesignFileException e) {
            DesignLoadLibraryTest.assertEquals((String)"Error.LibraryException.DUPLICATE_LIBRARY_NAMESPACE", (String)((ErrorDetail)e.getErrorList().get(0)).getErrorCode());
        }
        this.openDesign("DesignWithDuplicateNamespace1.xml");
    }

    public void testLoadDesignWithDuplicateNames() throws Exception {
        try {
            this.openDesign("DesignWithDuplicatedNameLibrary.xml");
            DesignLoadLibraryTest.assertTrue((boolean)true);
        }
        catch (DesignFileException e) {
            DesignLoadLibraryTest.fail((String)("Open DesignWithDuplicatedNameLibrary.xml Error: " + e.getMessage()));
        }
        SimpleMasterPageHandle masterPageHandle = (SimpleMasterPageHandle)this.designHandle.getElementByID(74L);
        SimpleMasterPageHandle parentHandle = (SimpleMasterPageHandle)masterPageHandle.getExtends();
        DesignElementHandle handle = parentHandle.getPageHeader().get(0);
        DesignLoadLibraryTest.assertEquals((String)"NewGrid", (String)handle.getName());
        handle = masterPageHandle.getPageHeader().get(0);
        DesignLoadLibraryTest.assertEquals((String)"NewGrid211", (String)handle.getName());
        GridHandle gridHandle = (GridHandle)this.designHandle.getBody().get(2);
        DesignLoadLibraryTest.assertEquals((String)"NewGrid", (String)gridHandle.getName());
        LabelHandle labelHandle = (LabelHandle)this.designHandle.getBody().get(1);
        DesignLoadLibraryTest.assertEquals((String)"label", (String)labelHandle.getName());
        DesignLoadLibraryTest.assertEquals((String)"label", (String)labelHandle.getExtends().getName());
    }

    public void testLoadDesignWithSameLibraryFiles() throws DesignFileException {
        this.openDesign("DesignWithSameLibraryFiles.xml");
        List errors = this.designHandle.getErrorList();
        DesignLoadLibraryTest.assertEquals((int)1, (int)errors.size());
        ErrorDetail error1 = (ErrorDetail)errors.get(0);
        DesignLoadLibraryTest.assertEquals((String)"Error.LibraryException.LIBRARY_ALREADY_INCLUDED", (String)error1.getErrorCode());
    }

    public void testLoadDesignWithThreeLibrary() throws Exception {
        this.openDesign("DesignWithThreeLibrary.xml");
        List libraries = this.designHandle.getAllLibraries();
        DesignLoadLibraryTest.assertEquals((int)3, (int)libraries.size());
        LibraryHandle libraryHandle1 = (LibraryHandle)libraries.get(0);
        LibraryHandle libraryHandle2 = (LibraryHandle)libraries.get(1);
        DesignLoadLibraryTest.assertTrue((boolean)libraryHandle1.isValid());
        DesignLoadLibraryTest.assertTrue((boolean)libraryHandle2.isValid());
        PropertyHandle propHandle = this.designHandle.getPropertyHandle("libraries");
        ArrayList list = propHandle.getListValue();
        DesignLoadLibraryTest.assertEquals((int)3, (int)list.size());
        IncludedLibrary includeLibrary = (IncludedLibrary)list.get(0);
        DesignLoadLibraryTest.assertEquals((String)"Library_1.xml", (String)includeLibrary.getFileName());
        DesignLoadLibraryTest.assertEquals((String)"Lib1", (String)includeLibrary.getNamespace());
        DesignLoadLibraryTest.assertEquals((String)includeLibrary.getFileName(), (String)libraryHandle1.getRelativeFileName());
        includeLibrary = (IncludedLibrary)list.get(1);
        DesignLoadLibraryTest.assertEquals((String)"Library_2.xml", (String)includeLibrary.getFileName());
        DesignLoadLibraryTest.assertEquals((String)"Library_2", (String)includeLibrary.getNamespace());
        DesignLoadLibraryTest.assertEquals((String)includeLibrary.getFileName(), (String)libraryHandle2.getRelativeFileName());
        includeLibrary = (IncludedLibrary)list.get(2);
        DesignLoadLibraryTest.assertEquals((String)"Library_3.xml", (String)includeLibrary.getFileName());
        DesignLoadLibraryTest.assertEquals((String)"Lib3", (String)includeLibrary.getNamespace());
        DesignLoadLibraryTest.assertEquals((String)"W.C. Fields", (String)libraryHandle2.getStringProperty("author"));
        DesignLoadLibraryTest.assertEquals((String)"http://company.com/reportHelp.html", (String)libraryHandle2.getStringProperty("helpGuide"));
        DesignLoadLibraryTest.assertEquals((String)"Whiz-Bang Plus", (String)libraryHandle2.getStringProperty("createdBy"));
        DesignLoadLibraryTest.assertEquals((String)"TITLE_ID", (String)libraryHandle2.getStringProperty("titleID"));
        DesignLoadLibraryTest.assertEquals((String)"Sample Report", (String)libraryHandle2.getStringProperty("title"));
        DesignLoadLibraryTest.assertEquals((String)"First sample report.", (String)libraryHandle2.getStringProperty("comments"));
        DesignLoadLibraryTest.assertEquals((String)"DESCRIP_ID", (String)libraryHandle2.getStringProperty("descriptionID"));
        DesignLoadLibraryTest.assertEquals((String)"This is a first sample report.", (String)libraryHandle2.getStringProperty("description"));
        PropertyHandle colorPalette = libraryHandle2.getPropertyHandle("colorPalette");
        ArrayList colors = colorPalette.getListValue();
        DesignLoadLibraryTest.assertEquals((int)2, (int)colors.size());
        CustomColor color = (CustomColor)colors.get(0);
        DesignLoadLibraryTest.assertEquals((String)"cus red", (String)color.getName());
        DesignLoadLibraryTest.assertEquals((int)111, (int)color.getRGB());
        DesignLoadLibraryTest.assertEquals((String)"cus red key", (String)color.getDisplayNameID());
        DesignLoadLibraryTest.assertEquals((String)"cus red display", (String)color.getDisplayName());
        color = (CustomColor)colors.get(1);
        DesignLoadLibraryTest.assertEquals((String)"cus blue", (String)color.getName());
        DesignLoadLibraryTest.assertEquals((int)222, (int)color.getRGB());
        DesignLoadLibraryTest.assertEquals((String)"cus blue key", (String)color.getDisplayNameID());
        PropertyHandle configVarHandle = libraryHandle2.getPropertyHandle("configVars");
        ArrayList configVars = configVarHandle.getListValue();
        DesignLoadLibraryTest.assertEquals((int)4, (int)configVars.size());
        ConfigVariable var = (ConfigVariable)configVars.get(0);
        DesignLoadLibraryTest.assertEquals((String)"var1", (String)var.getName());
        DesignLoadLibraryTest.assertEquals((String)"mumble.jpg", (String)var.getValue());
        var = (ConfigVariable)configVars.get(1);
        DesignLoadLibraryTest.assertEquals((String)"var2", (String)var.getName());
        DesignLoadLibraryTest.assertEquals((String)"abcdefg", (String)var.getValue());
        var = (ConfigVariable)configVars.get(2);
        DesignLoadLibraryTest.assertEquals((String)"var3", (String)var.getName());
        DesignLoadLibraryTest.assertEquals((String)"", (String)var.getValue());
        var = (ConfigVariable)configVars.get(3);
        DesignLoadLibraryTest.assertEquals((String)"var4", (String)var.getName());
        DesignLoadLibraryTest.assertEquals(null, (String)var.getValue());
        PropertyHandle imageHandle = libraryHandle2.getPropertyHandle("images");
        ArrayList images = imageHandle.getListValue();
        DesignLoadLibraryTest.assertEquals((int)3, (int)images.size());
        EmbeddedImage image = (EmbeddedImage)images.get(0);
        DesignLoadLibraryTest.assertEquals((String)"image1", (String)image.getName());
        DesignLoadLibraryTest.assertEquals((String)"image/bmp", (String)image.getType((Module)this.design));
        DesignLoadLibraryTest.assertEquals((String)"imagetesAAA", (String)new String(Base64.encodeBase64((byte[])image.getData((Module)this.design))).substring(0, 11));
        image = (EmbeddedImage)images.get(1);
        DesignLoadLibraryTest.assertEquals((String)"image2", (String)image.getName());
        DesignLoadLibraryTest.assertEquals((String)"image/gif", (String)image.getType((Module)this.design));
        DesignLoadLibraryTest.assertEquals((String)"/9j/4AAQSkZJRgA", (String)new String(Base64.encodeBase64((byte[])image.getData((Module)this.design))).substring(0, 15));
        image = (EmbeddedImage)images.get(2);
        DesignLoadLibraryTest.assertEquals((String)"image3", (String)image.getName());
        DesignLoadLibraryTest.assertEquals((String)"image/bmp", (String)image.getType((Module)this.design));
        DesignLoadLibraryTest.assertEquals((String)"AAAA", (String)new String(Base64.encodeBase64((byte[])image.getData((Module)this.design))));
    }

    public void testVisibleElements() throws Exception {
        this.openDesign("DesignWithElementReferenceLibrary.xml");
        DesignLoadLibraryTest.assertEquals((int)3, (int)this.designHandle.getAllStyles().size());
        DesignLoadLibraryTest.assertEquals((int)6, (int)this.designHandle.getAllDataSources().size());
        DesignLoadLibraryTest.assertEquals((int)3, (int)this.designHandle.getVisibleDataSets().size());
        DesignLoadLibraryTest.assertEquals((int)4, (int)this.designHandle.getAllDataSets().size());
        DesignLoadLibraryTest.assertEquals((int)3, (int)this.designHandle.getVisibleDataSets().size());
    }

    public void testFindAndNativeFind() throws Exception {
        this.openDesign("DesignWithElementReferenceLibrary.xml");
        List libraries = this.designHandle.getAllLibraries();
        DesignLoadLibraryTest.assertTrue((boolean)((LibraryHandle)libraries.get(0)).isValid());
        DesignLoadLibraryTest.assertTrue((boolean)((LibraryHandle)libraries.get(1)).isValid());
        DesignLoadLibraryTest.assertTrue((boolean)((LibraryHandle)libraries.get(2)).isValid());
        DesignLoadLibraryTest.assertNotNull((Object)this.designHandle.findElement("label1"));
        DesignLoadLibraryTest.assertNull((Object)this.designHandle.findElement("LibA.libLabel1"));
        DesignLoadLibraryTest.assertNotNull((Object)this.designHandle.findNativeStyle("style1"));
        DesignLoadLibraryTest.assertNotNull((Object)this.designHandle.findStyle("style1"));
        DesignLoadLibraryTest.assertNotNull((Object)this.designHandle.findNativeStyle("style2"));
        DesignLoadLibraryTest.assertNotNull((Object)this.designHandle.findStyle("style2"));
        DesignLoadLibraryTest.assertNull((Object)this.designHandle.findNativeStyle("style3"));
        DesignLoadLibraryTest.assertNotNull((Object)this.designHandle.findStyle("style3"));
        List elements = this.designHandle.getAllStyles();
        this.assertEquals(new String[]{"style1", "style3", "style2"}, this.getNameArray(elements));
        DesignLoadLibraryTest.assertNotNull((Object)this.designHandle.findDataSource("LibA.dataSource1"));
        DesignLoadLibraryTest.assertNotNull((Object)this.designHandle.findDataSource("dataSource2"));
        elements = this.designHandle.getVisibleDataSources();
        this.assertEquals(new String[]{"dataSource1", "dataSource2", "dataSource3"}, this.getNameArray(elements));
        elements = this.designHandle.getAllDataSources();
        this.assertEquals(new String[]{"dataSource1", "dataSource2", "dataSource3", "dataSource1", "dataSource1", "dataSource1"}, this.getNameArray(elements));
        DesignLoadLibraryTest.assertNotNull((Object)this.designHandle.findDataSet("LibA.dataSet1"));
        DesignLoadLibraryTest.assertNotNull((Object)this.designHandle.findDataSet("dataSet2"));
        elements = this.designHandle.getVisibleDataSets();
        this.assertEquals(new String[]{"dataSet2", "dataSet3", "dataSet4"}, this.getNameArray(elements));
        elements = this.designHandle.getVisibleDataSets();
        this.assertEquals(new String[]{"dataSet2", "dataSet3", "dataSet4"}, this.getNameArray(elements));
    }

    public void testInludeLibraryWithoutGivenNamespace() throws DesignFileException, SemanticException {
        this.openDesign("DesignWithoutLibrary.xml");
        this.designHandle.includeLibrary("Library_1.xml", null);
        List list = this.designHandle.getLibraries();
        DesignLoadLibraryTest.assertEquals((int)1, (int)list.size());
        LibraryHandle lib = (LibraryHandle)list.get(0);
        DesignLoadLibraryTest.assertEquals((String)"Library_1", (String)lib.getNamespace());
    }

    private String[] getNameArray(List list) {
        assert (list != null);
        String[] elementNames = new String[list.size()];
        int i = 0;
        for (DesignElementHandle element : list) {
            elementNames[i++] = element.getName();
        }
        return elementNames;
    }

    private void assertEquals(String[] strings1, String[] strings2) {
        DesignLoadLibraryTest.assertEquals((int)strings1.length, (int)strings2.length);
        int i = 0;
        while (i < strings1.length) {
            DesignLoadLibraryTest.assertEquals((String)strings1[i], (String)strings2[i]);
            ++i;
        }
    }

    public void testStyleResolver() throws Exception {
        this.openDesign("DesignWithElementReferenceLibrary.xml");
        LabelHandle label = (LabelHandle)this.designHandle.findElement("label1");
        DesignLoadLibraryTest.assertEquals((String)"style3", (String)label.getStringProperty("style"));
        SharedStyleHandle libStyleHandle = label.getStyle();
        DesignLoadLibraryTest.assertNotNull((Object)libStyleHandle);
        DesignLoadLibraryTest.assertEquals((String)"style3", (String)libStyleHandle.getName());
        SharedStyleHandle designStyleHandle = this.designHandle.getElementFactory().newStyle("style3");
        this.designHandle.getStyles().add((DesignElementHandle)designStyleHandle);
        DesignLoadLibraryTest.assertEquals((Object)designStyleHandle, (Object)label.getStyle());
        this.designHandle.getStyles().drop((DesignElementHandle)designStyleHandle);
        DesignLoadLibraryTest.assertEquals((Object)libStyleHandle, (Object)label.getStyle());
        this.designHandle.getCommandStack().undo();
        DesignLoadLibraryTest.assertEquals((Object)designStyleHandle, (Object)label.getStyle());
        this.designHandle.getCommandStack().undo();
        DesignLoadLibraryTest.assertEquals((Object)libStyleHandle, (Object)label.getStyle());
        this.designHandle.getCommandStack().redo();
        DesignLoadLibraryTest.assertEquals((Object)designStyleHandle, (Object)label.getStyle());
        designStyleHandle.drop();
        DesignLoadLibraryTest.assertEquals((Object)libStyleHandle, (Object)label.getStyle());
        designStyleHandle = this.designHandle.getElementFactory().newStyle("style3");
        this.designHandle.getStyles().add((DesignElementHandle)designStyleHandle);
        DesignLoadLibraryTest.assertEquals((Object)designStyleHandle, (Object)label.getStyle());
        designStyleHandle.setName("newStyle");
        DesignLoadLibraryTest.assertEquals((String)"newStyle", (String)label.getStyle().getName());
        this.designHandle.getCommandStack().undo();
        DesignLoadLibraryTest.assertEquals((String)"style3", (String)label.getStyle().getName());
        this.designHandle.getCommandStack().redo();
        DesignLoadLibraryTest.assertEquals((String)"newStyle", (String)label.getStyle().getName());
        designStyleHandle.drop();
        DesignLoadLibraryTest.assertNull((Object)label.getStyle());
    }

    public void testDataSourceReference() throws Exception {
        this.openDesign("DesignWithElementReferenceLibrary.xml");
        DataSourceHandle libADataSource1 = this.designHandle.findDataSource("LibA.dataSource1");
        DataSourceHandle dataSource1 = this.designHandle.findDataSource("dataSource1");
        DataSourceHandle dataSource3 = this.designHandle.findDataSource("dataSource3");
        DesignLoadLibraryTest.assertEquals((String)"LibA.dataSource1", (String)dataSource3.getExtends().getQualifiedName());
        DesignLoadLibraryTest.assertEquals((String)"lib_beforeopen", (String)dataSource3.getBeforeOpen());
        DataSetHandle libADataSet1 = this.designHandle.findDataSet("LibA.dataSet1");
        DataSetHandle dataSet2 = this.designHandle.findDataSet("dataSet2");
        DataSetHandle dataSet3 = this.designHandle.findDataSet("dataSet3");
        DesignLoadLibraryTest.assertNotNull((Object)libADataSource1);
        DesignLoadLibraryTest.assertNotNull((Object)dataSource1);
        DesignLoadLibraryTest.assertNotNull((Object)libADataSet1);
        DesignLoadLibraryTest.assertNotNull((Object)dataSet2);
        DesignLoadLibraryTest.assertNotNull((Object)dataSet3);
        DesignLoadLibraryTest.assertTrue((boolean)(dataSet2.getRoot() instanceof ReportDesignHandle));
        DesignLoadLibraryTest.assertTrue((boolean)(dataSet3.getRoot() instanceof ReportDesignHandle));
        dataSet3.setDataSource("LibA.dataSource1");
        DesignLoadLibraryTest.assertEquals((Object)"LibA.dataSource1", (Object)dataSet3.getProperty("dataSource"));
        DesignLoadLibraryTest.assertNotNull((Object)dataSet3.getDataSource());
        dataSet3.setDataSource("dataSource1");
        DesignLoadLibraryTest.assertEquals((Object)dataSource1, (Object)dataSet3.getDataSource());
        this.designHandle.getCommandStack().undo();
        DesignLoadLibraryTest.assertEquals((Object)"LibA.dataSource1", (Object)dataSet3.getProperty("dataSource"));
        DesignLoadLibraryTest.assertNotNull((Object)dataSet3.getDataSource());
        this.designHandle.getCommandStack().undo();
        DesignLoadLibraryTest.assertEquals((Object)dataSource1, (Object)dataSet3.getDataSource());
        this.designHandle.getCommandStack().redo();
        DesignLoadLibraryTest.assertEquals((Object)"LibA.dataSource1", (Object)dataSet3.getProperty("dataSource"));
        DesignLoadLibraryTest.assertNotNull((Object)dataSet3.getDataSource());
        this.designHandle.getCommandStack().redo();
        DesignLoadLibraryTest.assertEquals((Object)dataSource1, (Object)dataSet3.getDataSource());
    }

    public void testDataSetReference() throws Exception {
        this.openDesign("DesignWithElementReferenceLibrary.xml");
        DataSetHandle dataSet2 = this.designHandle.findDataSet("dataSet2");
        DataSetHandle libADataSet1 = this.designHandle.findDataSet("LibA.dataSet1");
        DataSetHandle dataSet4 = this.designHandle.findDataSet("dataSet4");
        DesignLoadLibraryTest.assertEquals((String)"LibA.dataSet1", (String)dataSet4.getExtends().getQualifiedName());
        TableHandle table1 = (TableHandle)this.designHandle.findElement("table1");
        DesignLoadLibraryTest.assertNotNull((Object)table1.getDataSet());
        DesignLoadLibraryTest.assertEquals((Object)"LibA.dataSet1", (Object)table1.getProperty("dataSet"));
        DesignLoadLibraryTest.assertNotNull((Object)table1.getDataSet());
        table1.setDataSet(dataSet2);
        DesignLoadLibraryTest.assertEquals((String)"dataSet2", (String)table1.getStringProperty("dataSet"));
        table1.setDataSet(libADataSet1);
        DesignLoadLibraryTest.assertEquals((String)"LibA.dataSet1", (String)table1.getStringProperty("dataSet"));
        DesignLoadLibraryTest.assertNotNull((Object)table1.getDataSet());
        this.designHandle.getCommandStack().undo();
        DesignLoadLibraryTest.assertEquals((String)"dataSet2", (String)table1.getStringProperty("dataSet"));
        DesignLoadLibraryTest.assertEquals((Object)dataSet2, (Object)table1.getDataSet());
        this.designHandle.getCommandStack().undo();
        DesignLoadLibraryTest.assertEquals((String)"LibA.dataSet1", (String)table1.getStringProperty("dataSet"));
        DesignLoadLibraryTest.assertNotNull((Object)table1.getDataSet());
        this.designHandle.getCommandStack().redo();
        DesignLoadLibraryTest.assertEquals((String)"dataSet2", (String)table1.getStringProperty("dataSet"));
        DesignLoadLibraryTest.assertEquals((Object)dataSet2, (Object)table1.getDataSet());
        this.designHandle.getCommandStack().redo();
        DesignLoadLibraryTest.assertEquals((String)"LibA.dataSet1", (String)table1.getStringProperty("dataSet"));
        TableHandle table2 = (TableHandle)this.designHandle.findElement("table2");
        DesignLoadLibraryTest.assertNotNull((Object)table2.getDataSet());
        DesignLoadLibraryTest.assertEquals((String)"dataSet2", (String)table2.getDataSet().getName());
        table2.getDataSet().drop();
        DesignLoadLibraryTest.assertNull((Object)table2.getDataSet());
        DesignLoadLibraryTest.assertEquals((String)"dataSet2", (String)table2.getStringProperty("dataSet"));
        TableHandle table4 = (TableHandle)this.designHandle.findElement("table4");
        DesignLoadLibraryTest.assertNotNull((Object)table4.getDataSet());
        DesignLoadLibraryTest.assertEquals((String)"dataSet4", (String)table4.getDataSet().getName());
    }

    public void testPropertiesOfDesignElementExtendingLibraryElement() throws Exception {
        this.openDesign("DesignWithElementReferenceLibrary.xml");
        LabelHandle label2 = (LabelHandle)this.designHandle.findElement("label2");
        DesignLoadLibraryTest.assertEquals((String)"libLabel1", (String)label2.getExtends().getName());
        DesignLoadLibraryTest.assertEquals((String)"Design Label", (String)label2.getText());
        DesignLoadLibraryTest.assertEquals((Object)this.designHandle.findStyle("style1"), (Object)label2.getStyle());
        DesignLoadLibraryTest.assertEquals((String)"blue", (String)label2.getPrivateStyle().getColor().getStringValue());
        DesignLoadLibraryTest.assertEquals((String)"15cm", (String)label2.getX().getStringValue());
        DesignLoadLibraryTest.assertEquals((String)"18pt", (String)label2.getPrivateStyle().getFontSize().getStringValue());
        DesignLoadLibraryTest.assertEquals((String)"5cm", (String)label2.getY().getStringValue());
        DesignLoadLibraryTest.assertEquals((String)"bolder", (String)label2.getPrivateStyle().getFontWeight());
        LibraryHandle libHandle = (LibraryHandle)this.designHandle.getAllLibraries().get(0);
        LabelHandle libLabel1 = (LabelHandle)libHandle.findElement("libLabel1");
        DesignLoadLibraryTest.assertEquals((String)"Library Label", (String)libLabel1.getText());
        DesignLoadLibraryTest.assertEquals((Object)libHandle.findStyle("style1"), (Object)libLabel1.getStyle());
        DesignLoadLibraryTest.assertEquals((String)"15cm", (String)libLabel1.getX().getStringValue());
        DesignLoadLibraryTest.assertEquals((String)"18pt", (String)libLabel1.getPrivateStyle().getFontSize().getStringValue());
        DesignLoadLibraryTest.assertEquals((String)"red", (String)libLabel1.getPrivateStyle().getColor().getStringValue());
        DesignLoadLibraryTest.assertEquals((String)"bolder", (String)libLabel1.getPrivateStyle().getFontWeight());
        DesignLoadLibraryTest.assertEquals((String)"5cm", (String)libLabel1.getY().getStringValue());
    }

    public void testExtendingLibraryElement() throws Exception {
        this.openDesign("DesignWithElementReferenceLibrary.xml");
        LibraryHandle libHandle = (LibraryHandle)this.designHandle.getAllLibraries().get(0);
        LabelHandle libLabel1 = (LabelHandle)libHandle.findElement("libLabel1");
        Iterator iter = libLabel1.derivedIterator();
        DesignLoadLibraryTest.assertEquals((Object)this.designHandle.findElement("label2"), iter.next());
        DesignLoadLibraryTest.assertFalse((boolean)iter.hasNext());
        LabelHandle designLabel3 = (LabelHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)libLabel1, "label3");
        iter = libLabel1.derivedIterator();
        DesignLoadLibraryTest.assertEquals((Object)this.designHandle.findElement("label2"), iter.next());
        DesignLoadLibraryTest.assertEquals((Object)designLabel3, iter.next());
        DesignLoadLibraryTest.assertFalse((boolean)iter.hasNext());
        this.designHandle.getBody().add((DesignElementHandle)designLabel3);
        designLabel3.setText("New Label3");
        designLabel3.setStyleName("style1");
        DesignLoadLibraryTest.assertEquals((String)"New Label3", (String)designLabel3.getText());
        DesignLoadLibraryTest.assertEquals((Object)this.designHandle.findStyle("style1"), (Object)designLabel3.getStyle());
        DesignLoadLibraryTest.assertEquals((String)"blue", (String)designLabel3.getPrivateStyle().getColor().getStringValue());
        DesignLoadLibraryTest.assertEquals((String)"15cm", (String)designLabel3.getX().getStringValue());
        DesignLoadLibraryTest.assertEquals((String)"18pt", (String)designLabel3.getPrivateStyle().getFontSize().getStringValue());
        DesignLoadLibraryTest.assertEquals((String)"5cm", (String)designLabel3.getY().getStringValue());
        DesignLoadLibraryTest.assertEquals((String)"bolder", (String)designLabel3.getPrivateStyle().getFontWeight());
        designLabel3.drop();
        iter = libLabel1.derivedIterator();
        DesignLoadLibraryTest.assertEquals((Object)this.designHandle.findElement("label2"), iter.next());
        DesignLoadLibraryTest.assertFalse((boolean)iter.hasNext());
        this.designHandle.getCommandStack().undo();
        iter = libLabel1.derivedIterator();
        DesignLoadLibraryTest.assertEquals((Object)this.designHandle.findElement("label2"), iter.next());
        DesignLoadLibraryTest.assertEquals((Object)designLabel3, iter.next());
        DesignLoadLibraryTest.assertFalse((boolean)iter.hasNext());
        this.designHandle.getCommandStack().redo();
        iter = libLabel1.derivedIterator();
        DesignLoadLibraryTest.assertEquals((Object)this.designHandle.findElement("label2"), iter.next());
        DesignLoadLibraryTest.assertFalse((boolean)iter.hasNext());
        TableHandle libTable1 = (TableHandle)libHandle.findElement("libTable1");
        TableHandle childTable = (TableHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)libTable1, "childTable");
        DesignLoadLibraryTest.assertEquals((String)"Employee Table", (String)childTable.getCaption());
        LabelHandle innerLabel = (LabelHandle)((CellHandle)((RowHandle)childTable.getDetail().get(0)).getCells().get(0)).getContent().get(0);
        DesignLoadLibraryTest.assertEquals((String)"Cell 1-1", (String)innerLabel.getText());
    }

    public void testExtendingLibraryTable() throws Exception {
        this.openDesign("DesignWithElementReferenceLibrary.xml");
        TableHandle table = (TableHandle)this.designHandle.findElement("table3");
        DesignLoadLibraryTest.assertEquals((String)"Employee Table", (String)table.getCaption());
        SlotHandle headerSlot = table.getHeader();
        DesignLoadLibraryTest.assertEquals((int)1, (int)headerSlot.getCount());
        RowHandle row = (RowHandle)headerSlot.get(0);
        DesignLoadLibraryTest.assertEquals((int)2, (int)row.getCells().getCount());
        SlotHandle detailSlot = table.getDetail();
        DesignLoadLibraryTest.assertEquals((int)2, (int)detailSlot.getCount());
        row = (RowHandle)detailSlot.get(0);
        DesignLoadLibraryTest.assertEquals((int)2, (int)row.getCells().getCount());
        row = (RowHandle)detailSlot.get(1);
        DesignLoadLibraryTest.assertEquals((int)2, (int)row.getCells().getCount());
        row = (RowHandle)detailSlot.get(0);
        CellHandle cell = null;
        cell = (CellHandle)row.getCells().get(0);
        DesignLoadLibraryTest.assertEquals((String)"label_1_1", (String)cell.getContent().get(0).getName());
        LabelHandle interLabel = (LabelHandle)cell.getContent().get(0);
        String value = interLabel.getStringProperty("text");
        DesignLoadLibraryTest.assertEquals((String)"Cell 1-1", (String)value);
        cell = (CellHandle)row.getCells().get(1);
        DesignLoadLibraryTest.assertEquals((String)"label_1_2", (String)cell.getContent().get(0).getName());
        DesignLoadLibraryTest.assertEquals((String)"Cell 1-2", (String)cell.getContent().get(0).getStringProperty("text"));
        row = (RowHandle)detailSlot.get(1);
        cell = (CellHandle)row.getCells().get(0);
        TableHandle innerTable = (TableHandle)cell.getContent().get(0);
        DesignLoadLibraryTest.assertEquals((String)"libInnerTable", (String)innerTable.getName());
    }

    public void testAddingLibrary() throws Exception {
        this.openDesign("DesignWithoutLibrary.xml");
        this.designHandle.includeLibrary("Library_1.xml", "Lib1");
        try {
            this.designHandle.includeLibrary("Library_1.xml", "Lib2");
            DesignLoadLibraryTest.fail();
        }
        catch (LibraryException e) {
            DesignLoadLibraryTest.assertEquals((String)"Error.LibraryException.LIBRARY_ALREADY_INCLUDED", (String)e.getErrorCode());
        }
        PropertyHandle propHandle = this.designHandle.getPropertyHandle("libraries");
        ArrayList includeLibraries = propHandle.getListValue();
        DesignLoadLibraryTest.assertEquals((int)1, (int)includeLibraries.size());
        IncludedLibrary includeLibrary = (IncludedLibrary)includeLibraries.get(0);
        DesignLoadLibraryTest.assertEquals((String)"Library_1.xml", (String)includeLibrary.getFileName());
        DesignLoadLibraryTest.assertEquals((int)1, (int)this.designHandle.getAllLibraries().size());
        LibraryHandle libHandle = (LibraryHandle)this.designHandle.getAllLibraries().get(0);
        DesignLoadLibraryTest.assertTrue((boolean)libHandle.getFileName().endsWith("Library_1.xml"));
        DesignLoadLibraryTest.assertEquals((String)"W.C. Fields", (String)libHandle.getAuthor());
        DesignElementHandle pageHandle = libHandle.getMasterPages().get(0);
        DesignLoadLibraryTest.assertEquals((String)"My Page", (String)pageHandle.getName());
        this.designHandle.getCommandStack().undo();
        includeLibraries = propHandle.getListValue();
        DesignLoadLibraryTest.assertNull((Object)includeLibraries);
        DesignLoadLibraryTest.assertEquals((int)0, (int)this.designHandle.getAllLibraries().size());
        this.designHandle.getCommandStack().redo();
        propHandle = this.designHandle.getPropertyHandle("libraries");
        includeLibraries = propHandle.getListValue();
        DesignLoadLibraryTest.assertEquals((int)1, (int)includeLibraries.size());
        includeLibrary = (IncludedLibrary)includeLibraries.get(0);
        DesignLoadLibraryTest.assertEquals((String)"Library_1.xml", (String)includeLibrary.getFileName());
        DesignLoadLibraryTest.assertEquals((int)1, (int)this.designHandle.getAllLibraries().size());
        libHandle = (LibraryHandle)this.designHandle.getAllLibraries().get(0);
        DesignLoadLibraryTest.assertTrue((boolean)libHandle.getFileName().endsWith("Library_1.xml"));
        DesignLoadLibraryTest.assertEquals((String)"W.C. Fields", (String)libHandle.getAuthor());
        pageHandle = libHandle.getMasterPages().get(0);
        DesignLoadLibraryTest.assertEquals((String)"My Page", (String)pageHandle.getName());
    }

    public void testAddingLibraryBeginWithSpace() throws Exception {
        this.openDesign("DesignWithoutLibrary.xml");
        this.designHandle.includeLibrary("  Library.xml", "  Lib1");
        List libs = this.designHandle.getListProperty("libraries");
        IncludedLibrary lib = (IncludedLibrary)libs.get(0);
        DesignLoadLibraryTest.assertEquals((String)"  Library.xml", (String)lib.getFileName());
        DesignLoadLibraryTest.assertEquals((String)"Lib1", (String)lib.getNamespace());
    }

    public void testRemoveLibrary() throws Exception {
        this.openDesign("DesignWithThreeLibrary.xml");
        DesignLoadLibraryTest.assertEquals((int)3, (int)this.designHandle.getAllLibraries().size());
        LibraryHandle libHandle = (LibraryHandle)this.designHandle.getAllLibraries().get(0);
        DesignLoadLibraryTest.assertTrue((boolean)libHandle.getFileName().endsWith("Library_1.xml"));
        this.designHandle.dropLibrary(libHandle);
        DesignLoadLibraryTest.assertEquals((int)2, (int)this.designHandle.getAllLibraries().size());
        this.designHandle.getCommandStack().undo();
        DesignLoadLibraryTest.assertEquals((int)3, (int)this.designHandle.getAllLibraries().size());
        libHandle = (LibraryHandle)this.designHandle.getAllLibraries().get(0);
        DesignLoadLibraryTest.assertTrue((boolean)libHandle.getFileName().endsWith("Library_1.xml"));
        this.designHandle.getCommandStack().redo();
        DesignLoadLibraryTest.assertEquals((int)2, (int)this.designHandle.getAllLibraries().size());
    }

    public void testShiftLibraryWithoutShifting() throws Exception {
        this.openDesign("DesignWithThreeLibrary.xml");
        LabelHandle label = (LabelHandle)this.designHandle.findElement("myLabel");
        DesignLoadLibraryTest.assertEquals((String)"yellow", (String)label.getColorProperty("color").getStringValue());
        LibraryHandle library1 = (LibraryHandle)this.designHandle.getAllLibraries().get(0);
        DesignLoadLibraryTest.assertEquals((String)"Lib1", (String)library1.getNamespace());
        LibraryHandle library2 = (LibraryHandle)this.designHandle.getAllLibraries().get(1);
        DesignLoadLibraryTest.assertEquals((String)"Library_2", (String)library2.getNamespace());
        LibraryHandle library3 = (LibraryHandle)this.designHandle.getAllLibraries().get(2);
        DesignLoadLibraryTest.assertEquals((String)"Lib3", (String)library3.getNamespace());
        this.checkLibrarySequence(new LibraryHandle[]{library1, library2, library3});
        this.designHandle.shiftLibrary(library3, 100);
        this.checkLibrarySequence(new LibraryHandle[]{library1, library2, library3});
        this.designHandle.shiftLibrary(library1, -1);
        this.checkLibrarySequence(new LibraryHandle[]{library1, library2, library3});
        this.designHandle.shiftLibrary(library2, 1);
        this.checkLibrarySequence(new LibraryHandle[]{library1, library2, library3});
        this.designHandle.shiftLibrary(library2, 3);
        this.checkLibrarySequence(new LibraryHandle[]{library1, library3, library2});
        this.designHandle.getCommandStack().undo();
        this.checkLibrarySequence(new LibraryHandle[]{library1, library2, library3});
        this.designHandle.getCommandStack().redo();
        this.checkLibrarySequence(new LibraryHandle[]{library1, library3, library2});
        this.designHandle.shiftLibrary(library3, 0);
        this.checkLibrarySequence(new LibraryHandle[]{library3, library1, library2});
        this.designHandle.getCommandStack().undo();
        this.checkLibrarySequence(new LibraryHandle[]{library1, library3, library2});
        this.designHandle.getCommandStack().redo();
        this.checkLibrarySequence(new LibraryHandle[]{library3, library1, library2});
    }

    private void checkLibrarySequence(LibraryHandle[] libraries) {
        PropertyHandle propHandle = this.designHandle.getPropertyHandle("libraries");
        int i = 0;
        while (i < 3) {
            DesignLoadLibraryTest.assertEquals((Object)libraries[i], this.designHandle.getAllLibraries().get(i));
            DesignLoadLibraryTest.assertEquals((String)libraries[i].getNamespace(), (String)((IncludedLibraryHandle)propHandle.getAt(i)).getNamespace());
            ++i;
        }
    }

    public void testWriter() throws Exception {
        this.openDesign("DesignWithElementReferenceLibrary.xml");
        this.save();
        this.compareFile("DesignWithElementReferenceLibrary_golden.xml");
    }

    public void testStructureReference() throws Exception {
        this.openDesign("DesignWithElementReferenceLibrary.xml");
        DesignLoadLibraryTest.assertNotNull((Object)this.designHandle.findConfigVariable("var1"));
        DesignLoadLibraryTest.assertNull((Object)this.designHandle.findConfigVariable("var2"));
        DesignLoadLibraryTest.assertNotNull((Object)this.designHandle.findImage("image1.jpg"));
        DesignLoadLibraryTest.assertNotNull((Object)this.designHandle.findImage("LibA.image2"));
        DesignLoadLibraryTest.assertNotNull((Object)this.designHandle.findColor("lighterRed"));
        DesignLoadLibraryTest.assertNotNull((Object)this.designHandle.findColor("LibA.lighterBlue"));
        LibraryHandle libAHandle = this.designHandle.getLibrary("LibA");
        PropertyHandle propHandle = this.designHandle.getPropertyHandle("configVars");
        StructureHandle structure = propHandle.getAt(0);
        DesignLoadLibraryTest.assertEquals((Object)structure.getStructure(), (Object)this.designHandle.findConfigVariable("var1"));
        Iterator iter = this.designHandle.configVariablesIterator();
        ConfigVariableHandle configVar = (ConfigVariableHandle)iter.next();
        DesignLoadLibraryTest.assertEquals((String)"var1", (String)configVar.getName());
        DesignLoadLibraryTest.assertTrue((boolean)(configVar.getModule() instanceof ReportDesign));
        configVar = (ConfigVariableHandle)iter.next();
        DesignLoadLibraryTest.assertEquals((String)"var2", (String)configVar.getName());
        DesignLoadLibraryTest.assertTrue((boolean)(configVar.getModule() instanceof Library));
        DesignLoadLibraryTest.assertFalse((boolean)iter.hasNext());
        propHandle = this.designHandle.getPropertyHandle("images");
        structure = propHandle.getAt(0);
        DesignLoadLibraryTest.assertEquals((Object)structure.getStructure(), (Object)this.designHandle.findImage("image1.jpg"));
        iter = this.designHandle.getAllImages().iterator();
        EmbeddedImageHandle image = (EmbeddedImageHandle)iter.next();
        DesignLoadLibraryTest.assertEquals((String)"image1.jpg", (String)image.getName());
        DesignLoadLibraryTest.assertEquals((String)"image1.jpg", (String)image.getQualifiedName());
        DesignLoadLibraryTest.assertTrue((boolean)(image.getModule() instanceof ReportDesign));
        image = (EmbeddedImageHandle)iter.next();
        DesignLoadLibraryTest.assertEquals((String)"image1.jpg", (String)image.getName());
        DesignLoadLibraryTest.assertEquals((String)"LibA.image1.jpg", (String)image.getQualifiedName());
        DesignLoadLibraryTest.assertTrue((boolean)(image.getModule() instanceof Library));
        image = (EmbeddedImageHandle)iter.next();
        DesignLoadLibraryTest.assertEquals((String)"image2", (String)image.getName());
        DesignLoadLibraryTest.assertEquals((String)"LibA.image2", (String)image.getQualifiedName());
        DesignLoadLibraryTest.assertTrue((boolean)(image.getModule() instanceof Library));
        DesignLoadLibraryTest.assertFalse((boolean)iter.hasNext());
        propHandle = this.designHandle.getPropertyHandle("colorPalette");
        structure = propHandle.getAt(0);
        DesignLoadLibraryTest.assertEquals((Object)structure.getStructure(), (Object)this.designHandle.findColor("lighterRed"));
        iter = this.designHandle.customColorsIterator();
        CustomColorHandle color = (CustomColorHandle)iter.next();
        DesignLoadLibraryTest.assertEquals((String)"lighterRed", (String)color.getName());
        DesignLoadLibraryTest.assertEquals((String)"lighterRed", (String)color.getQualifiedName());
        DesignLoadLibraryTest.assertTrue((boolean)(color.getModule() instanceof ReportDesign));
        color = (CustomColorHandle)iter.next();
        DesignLoadLibraryTest.assertEquals((String)"lighterRed", (String)color.getName());
        DesignLoadLibraryTest.assertEquals((String)"LibA.lighterRed", (String)color.getQualifiedName());
        DesignLoadLibraryTest.assertTrue((boolean)(color.getModule() instanceof Library));
        color = (CustomColorHandle)iter.next();
        DesignLoadLibraryTest.assertEquals((String)"lighterBlue", (String)color.getName());
        DesignLoadLibraryTest.assertEquals((String)"LibA.lighterBlue", (String)color.getQualifiedName());
        DesignLoadLibraryTest.assertTrue((boolean)(color.getModule() instanceof Library));
        DesignLoadLibraryTest.assertFalse((boolean)iter.hasNext());
        iter = this.designHandle.customColorsIterator();
        DesignLoadLibraryTest.assertEquals((Object)structure.getStructure(), (Object)((StructureHandle)iter.next()).getStructure());
        propHandle = libAHandle.getPropertyHandle("colorPalette");
        structure = propHandle.getAt(0);
        DesignLoadLibraryTest.assertEquals((Object)structure.getStructure(), (Object)((StructureHandle)iter.next()).getStructure());
    }

    public void testCustomColorReference() throws Exception {
        this.openDesign("DesignWithElementReferenceLibrary.xml");
        LabelHandle label = (LabelHandle)this.designHandle.findElement("label3");
        DesignLoadLibraryTest.assertEquals((int)222, (int)label.getPrivateStyle().getColor().getRGB());
        DesignLoadLibraryTest.assertEquals((int)333, (int)label.getPrivateStyle().getBackgroundColor().getRGB());
        label.getPrivateStyle().getColor().setStringValue("LibA.lighterRed");
        DesignLoadLibraryTest.assertEquals((int)111, (int)label.getPrivateStyle().getColor().getRGB());
        label.getPrivateStyle().getColor().setStringValue("lighterRed");
        DesignLoadLibraryTest.assertEquals((int)333, (int)label.getPrivateStyle().getColor().getRGB());
        this.designHandle.getCommandStack().undo();
        DesignLoadLibraryTest.assertEquals((int)111, (int)label.getPrivateStyle().getColor().getRGB());
        this.designHandle.getCommandStack().undo();
        DesignLoadLibraryTest.assertEquals((int)222, (int)label.getPrivateStyle().getColor().getRGB());
        this.designHandle.getCommandStack().redo();
        DesignLoadLibraryTest.assertEquals((int)111, (int)label.getPrivateStyle().getColor().getRGB());
        this.designHandle.getCommandStack().redo();
        DesignLoadLibraryTest.assertEquals((int)333, (int)label.getPrivateStyle().getColor().getRGB());
    }

    public void testElementReferenceAfterAddingOrDroppingLibrary() throws Exception {
        this.openDesign("DesignForTestingLibraryChange.xml");
        LabelHandle label = (LabelHandle)this.designHandle.findElement("label1");
        DesignLoadLibraryTest.assertEquals((String)"blue", (String)label.getPrivateStyle().getColor().getStringValue());
        SharedStyleHandle style = this.designHandle.findNativeStyle("style1");
        style.drop();
        DesignLoadLibraryTest.assertEquals((String)"green", (String)label.getPrivateStyle().getColor().getStringValue());
        LibraryHandle library = this.designHandle.getLibrary("Lib2");
        this.designHandle.dropLibrary(library);
        DesignLoadLibraryTest.assertEquals((String)"black", (String)label.getPrivateStyle().getColor().getStringValue());
        library = this.designHandle.getLibrary("Lib1");
        this.designHandle.dropLibrary(library);
        DesignLoadLibraryTest.assertEquals((String)"black", (String)label.getPrivateStyle().getColor().getStringValue());
        this.designHandle.getCommandStack().undo();
        DesignLoadLibraryTest.assertEquals((String)"black", (String)label.getPrivateStyle().getColor().getStringValue());
        this.designHandle.getCommandStack().undo();
        DesignLoadLibraryTest.assertEquals((String)"green", (String)label.getPrivateStyle().getColor().getStringValue());
    }

    public void testDropLibrary() throws Exception {
        this.openDesign("TestDropLibrary_1.xml");
        LibraryHandle libHandle = (LibraryHandle)this.designHandle.getLibraries().get(0);
        TableHandle tableHandle = (TableHandle)this.designHandle.findElement("table1");
        TableItem parent = (TableItem)tableHandle.getExtends().getElement();
        DesignLoadLibraryTest.assertNotNull((Object)parent);
        RowHandle rowHandle = (RowHandle)tableHandle.getDetail().get(0);
        CellHandle cellHandle = (CellHandle)rowHandle.getCells().get(0);
        cellHandle.setStringProperty("color", "black");
        try {
            this.designHandle.dropLibrary(libHandle);
            DesignLoadLibraryTest.fail();
        }
        catch (SemanticException e) {
            DesignLoadLibraryTest.assertEquals((String)"Error.LibraryException.LIBRARY_HAS_DESCENDENTS", (String)e.getErrorCode());
        }
        this.designHandle.dropLibraryAndBreakExtends(libHandle);
        DesignLoadLibraryTest.assertNull((Object)tableHandle.getElement().getExtendsElement());
        DesignLoadLibraryTest.assertNull((Object)this.designHandle.getListProperty("libraries"));
        this.save();
        this.compareFile("TestDropLibrary_golden1.xml");
        this.openDesign("TestDropLibrary_2.xml");
        LibraryHandle lib2Handle = (LibraryHandle)this.designHandle.getLibraries().get(0);
        LabelHandle mylabelHandle = (LabelHandle)this.designHandle.findElement("myLabel");
        DesignLoadLibraryTest.assertEquals((String)"25pt", (String)mylabelHandle.getHeight().getStringValue());
        DesignLoadLibraryTest.assertEquals((String)"red", (String)mylabelHandle.getStringProperty("color"));
        DesignLoadLibraryTest.assertEquals((String)"First Page", (String)mylabelHandle.getText());
        try {
            this.designHandle.dropLibrary(lib2Handle);
            DesignLoadLibraryTest.fail();
        }
        catch (SemanticException e) {
            DesignLoadLibraryTest.assertEquals((String)"Error.LibraryException.LIBRARY_HAS_DESCENDENTS", (String)e.getErrorCode());
        }
        this.designHandle.dropLibraryAndBreakExtends(lib2Handle);
        DesignLoadLibraryTest.assertNull((Object)mylabelHandle.getElement().getExtendsElement());
        Label myLabel = (Label)mylabelHandle.getElement();
        DesignLoadLibraryTest.assertEquals((String)"25pt", (String)myLabel.getLocalProperty(this.designHandle.getModule(), "height").toString());
        DesignLoadLibraryTest.assertEquals((String)"red", (String)myLabel.getLocalProperty(this.designHandle.getModule(), "color").toString());
        DesignLoadLibraryTest.assertEquals((Object)"First Page", (Object)myLabel.getLocalProperty(this.designHandle.getModule(), "text"));
        DesignLoadLibraryTest.assertNull((Object)this.designHandle.getListProperty("libraries"));
        this.save();
        this.compareFile("TestDropLibrary_golden2.xml");
        this.design.getActivityStack().undo();
        Label baseLabel = (Label)mylabelHandle.getElement().getExtendsElement();
        DesignLoadLibraryTest.assertNotNull((Object)baseLabel);
        DesignLoadLibraryTest.assertEquals((String)"25pt", (String)myLabel.getLocalProperty(this.designHandle.getModule(), "height").toString());
        DesignLoadLibraryTest.assertEquals(null, (Object)myLabel.getLocalProperty(this.designHandle.getModule(), "color"));
        DesignLoadLibraryTest.assertEquals(null, (Object)myLabel.getLocalProperty(this.designHandle.getModule(), "text"));
        DesignLoadLibraryTest.assertEquals((String)"25pt", (String)mylabelHandle.getHeight().getStringValue());
        DesignLoadLibraryTest.assertEquals((String)"red", (String)mylabelHandle.getStringProperty("color"));
        DesignLoadLibraryTest.assertEquals((String)"First Page", (String)mylabelHandle.getText());
        DesignLoadLibraryTest.assertEquals((int)1, (int)this.designHandle.getListProperty("libraries").size());
        this.design.getActivityStack().redo();
        myLabel = (Label)mylabelHandle.getElement();
        DesignLoadLibraryTest.assertEquals((String)"25pt", (String)myLabel.getLocalProperty(this.designHandle.getModule(), "height").toString());
        DesignLoadLibraryTest.assertEquals((String)"red", (String)myLabel.getLocalProperty(this.designHandle.getModule(), "color").toString());
        DesignLoadLibraryTest.assertEquals((Object)"First Page", (Object)myLabel.getLocalProperty(this.designHandle.getModule(), "text"));
        DesignLoadLibraryTest.assertNull((Object)this.designHandle.getListProperty("libraries"));
    }

    public void testLibraryElementReadOnly() throws Exception {
        this.openDesign("DesignWithThreeLibrary.xml");
        LibraryHandle library1 = (LibraryHandle)this.designHandle.getAllLibraries().get(0);
        DesignLoadLibraryTest.assertEquals((String)"Lib1", (String)library1.getNamespace());
        DesignLoadLibraryTest.assertFalse((boolean)this.designHandle.isReadOnly());
        DesignLoadLibraryTest.assertTrue((boolean)library1.isReadOnly());
        SharedStyleHandle style = library1.findStyle("style1");
        try {
            style.setFontVariant("small-caps");
            DesignLoadLibraryTest.fail();
        }
        catch (Exception e) {
            DesignLoadLibraryTest.assertTrue((boolean)(e instanceof IllegalOperationException));
        }
    }

    public void testDesignIncludeLibraries() throws Exception {
        this.openDesign("DesignWithOneCompositeLibrary.xml");
        DesignLoadLibraryTest.assertEquals((int)3, (int)this.designHandle.getAllLibraries().size());
        LibraryHandle libraryComposite = this.designHandle.getLibrary("CompositeLib");
        LibraryHandle library1 = this.designHandle.getLibrary("Lib1");
        LibraryHandle library2 = this.designHandle.getLibrary("Lib2");
        DesignLoadLibraryTest.assertTrue((boolean)libraryComposite.isValid());
        DesignLoadLibraryTest.assertNull((Object)library1);
        DesignLoadLibraryTest.assertNull((Object)library2);
        List styleList = this.designHandle.getAllStyles();
        DesignLoadLibraryTest.assertEquals((int)0, (int)styleList.size());
        DataSetHandle dataSetHandle1 = libraryComposite.findDataSet("Lib1.dataSet1");
        DataSetHandle dataSetHandle2 = libraryComposite.findDataSet("Lib2.dataSet1");
        DesignLoadLibraryTest.assertNotNull((Object)dataSetHandle1);
        DesignLoadLibraryTest.assertNotNull((Object)dataSetHandle2);
        List dataSetList = this.designHandle.getAllDataSets();
        DesignLoadLibraryTest.assertEquals((int)3, (int)dataSetList.size());
        DesignLoadLibraryTest.assertEquals((int)0, (int)this.designHandle.getVisibleDataSets().size());
        dataSetList = libraryComposite.getAllDataSets();
        DesignLoadLibraryTest.assertEquals((int)3, (int)dataSetList.size());
        DesignLoadLibraryTest.assertEquals((int)1, (int)libraryComposite.getVisibleDataSets().size());
        TableHandle tableHandle1 = (TableHandle)this.designHandle.findElement("table1");
        DesignLoadLibraryTest.assertNotNull((Object)tableHandle1.getDataSet());
        TableHandle tableHandle2 = (TableHandle)this.designHandle.findElement("table2");
        DesignLoadLibraryTest.assertNotNull((Object)tableHandle2.getDataSet());
        SharedStyleHandle styleHandle = this.designHandle.findStyle("style1");
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("label1");
        DesignLoadLibraryTest.assertEquals((Object)styleHandle, (Object)labelHandle.getStyle());
        SharedStyleHandle newStyleHandle = this.designHandle.getElementFactory().newStyle("style1");
        this.designHandle.getStyles().add((DesignElementHandle)newStyleHandle);
        DesignLoadLibraryTest.assertEquals((Object)newStyleHandle, (Object)labelHandle.getStyle());
    }

    public void testDesignIncludeRecursiveLibraries() throws Exception {
        try {
            this.openDesign("DesignIncludeRecursiveLibraries.xml");
            DesignLoadLibraryTest.fail();
        }
        catch (DesignFileException e) {
            DesignLoadLibraryTest.assertEquals((String)"Error.LibraryException.LIBRARY_INCLUDED_RECURSIVELY", (String)((ErrorDetail)e.getErrorList().get(0)).getErrorCode());
        }
    }

    public void testAddingLibraryWithDuplicateNamespace1() throws Exception {
        this.openDesign("DesignWithOneLibrary.xml");
        DesignLoadLibraryTest.assertEquals((int)1, (int)this.designHandle.getAllLibraries().size());
        LibraryHandle library1 = this.designHandle.getLibrary("Lib1");
        DesignLoadLibraryTest.assertNotNull((Object)library1);
        try {
            this.designHandle.includeLibrary("Library_1.xml", "Lib1");
            DesignLoadLibraryTest.fail();
        }
        catch (Exception e) {
            DesignLoadLibraryTest.assertTrue((boolean)(e instanceof LibraryException));
            DesignLoadLibraryTest.assertEquals((String)"Error.LibraryException.DUPLICATE_LIBRARY_NAMESPACE", (String)((LibraryException)((Object)e)).getErrorCode());
        }
    }

    public void testAddStyleInDesignWithOneLibrary() throws Exception {
        this.openDesign("DesignWithOneLibrary.xml");
        DesignLoadLibraryTest.assertNotNull((Object)this.designHandle.findStyle("style1"));
        this.designHandle.getStyles().add((DesignElementHandle)this.designHandle.getElementFactory().newStyle("style1"));
    }

    public void testLocation() throws Exception {
        this.openLibrary("Library.xml");
        DesignLoadLibraryTest.assertNotNull((Object)this.libraryHandle);
        System.out.println(this.libraryHandle.getSystemId());
        LabelHandle baseLabel = (LabelHandle)this.libraryHandle.findElement("base");
        LabelHandle childLabel = (LabelHandle)this.libraryHandle.getElementFactory().newElementFrom((DesignElementHandle)baseLabel, "child");
        DesignLoadLibraryTest.assertNotNull((Object)childLabel);
        this.openDesign("DesignWithOneLibrary.xml");
        DesignLoadLibraryTest.assertNotNull((Object)this.designHandle);
        List libs = this.designHandle.getAllLibraries();
        DesignLoadLibraryTest.assertEquals((int)1, (int)libs.size());
        DesignLoadLibraryTest.assertTrue((boolean)this.designHandle.isInclude((LibraryHandle)libs.get(0)));
        this.designHandle.includeLibrary("Library.xml", "Lib");
        libs = this.designHandle.getAllLibraries();
        DesignLoadLibraryTest.assertEquals((int)2, (int)libs.size());
        DesignLoadLibraryTest.assertTrue((boolean)this.designHandle.isInclude((LibraryHandle)libs.get(0)));
        DesignLoadLibraryTest.assertTrue((boolean)this.designHandle.isInclude((LibraryHandle)libs.get(1)));
        DesignLoadLibraryTest.assertTrue((boolean)this.designHandle.isInclude(this.libraryHandle));
        LibraryHandle includeLib = (LibraryHandle)libs.get(1);
        childLabel = null;
        childLabel = (LabelHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)baseLabel, "child");
        DesignLoadLibraryTest.assertNotNull((Object)childLabel);
        this.designHandle.addElement((DesignElementHandle)childLabel, 6);
        DesignLoadLibraryTest.assertEquals((Object)this.designHandle, (Object)childLabel.getModuleHandle());
        DesignLoadLibraryTest.assertEquals((Object)includeLib, (Object)childLabel.getExtends().getModuleHandle());
        DesignLoadLibraryTest.assertEquals((String)"Lib.base", (String)childLabel.getExtends().getQualifiedName());
        NameSpace ns = ((Module)includeLib.getElement()).getNameHelper().getNameSpace(1);
        ns.rename(includeLib.findElement("base").getElement(), "base", "newBase");
        includeLib.findElement("newBase").getElement().setName("newBase");
        childLabel = null;
        childLabel = (LabelHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)baseLabel, "childTwo");
        this.designHandle.getBody().add((DesignElementHandle)childLabel);
        this.save();
        this.compareFile("LibraryWithLocation_golden.xml");
    }

    public void testGetImage() throws Exception {
        this.openDesign("DesignIncludeLibraryWithImage.xml");
        DesignLoadLibraryTest.assertEquals((int)1, (int)this.designHandle.getLibraries().size());
        DesignLoadLibraryTest.assertTrue((!this.designHandle.imagesIterator().hasNext() ? 1 : 0) != 0);
        DesignLoadLibraryTest.assertNotNull((Object)this.designHandle.findImage("Lib1.image1"));
        DesignLoadLibraryTest.assertNotNull((Object)this.designHandle.findImage("Lib1.image2"));
        DesignLoadLibraryTest.assertNotNull((Object)this.designHandle.findImage("Lib2.image2"));
        DesignLoadLibraryTest.assertNotNull((Object)this.designHandle.findImage("Lib2.image3"));
        LibraryHandle lib1 = this.designHandle.getLibrary("Lib1");
        DesignLoadLibraryTest.assertNotNull((Object)lib1);
        Iterator imageIter = lib1.imagesIterator();
        DesignLoadLibraryTest.assertTrue((boolean)imageIter.hasNext());
        EmbeddedImageHandle image = (EmbeddedImageHandle)imageIter.next();
        DesignLoadLibraryTest.assertEquals((String)"image1", (String)image.getName());
        DesignLoadLibraryTest.assertEquals((String)"Lib1.image1", (String)image.getQualifiedName());
        DesignLoadLibraryTest.assertTrue((boolean)(image.getModule() instanceof Library));
        image = (EmbeddedImageHandle)imageIter.next();
        DesignLoadLibraryTest.assertEquals((String)"image2", (String)image.getName());
        DesignLoadLibraryTest.assertEquals((String)"Lib1.image2", (String)image.getQualifiedName());
        DesignLoadLibraryTest.assertTrue((boolean)(image.getModule() instanceof Library));
        LibraryHandle lib2 = this.designHandle.getLibrary("Lib2");
        DesignLoadLibraryTest.assertNull((Object)lib2);
        DesignLoadLibraryTest.assertEquals((int)4, (int)this.designHandle.getAllImages().size());
        DesignLoadLibraryTest.assertEquals((int)4, (int)lib1.getAllImages().size());
    }

    public void testReadOnly() throws Exception {
        this.openDesign("DesignWithOneLibrary.xml");
        DesignLoadLibraryTest.assertNotNull((Object)this.designHandle);
        this.libraryHandle = this.designHandle.getLibrary("Lib1");
        DesignLoadLibraryTest.assertNotNull((Object)this.libraryHandle);
        PropertyHandle propertyHandle = this.libraryHandle.getPropertyHandle("createdBy");
        DesignLoadLibraryTest.assertTrue((boolean)propertyHandle.isReadOnly());
        propertyHandle = this.designHandle.getPropertyHandle("createdBy");
        DesignLoadLibraryTest.assertFalse((boolean)propertyHandle.isReadOnly());
    }

    public void testMultiExtendedElements() throws Exception {
        this.openDesign("DesignWithOneCompositeLibrary.xml");
        TableHandle table = (TableHandle)this.designHandle.findElement("table3");
        DesignLoadLibraryTest.assertEquals((Object)"CompositeLib.myTable", (Object)table.getProperty("extends"));
        DesignLoadLibraryTest.assertNotNull((Object)table.getDataSet());
        DesignLoadLibraryTest.assertEquals((String)"Lib1.dataSet1", (String)table.getStringProperty("dataSet"));
        DataSetHandle dataSet = this.designHandle.findDataSet(table.getStringProperty("dataSet"));
        DesignLoadLibraryTest.assertNotNull((Object)dataSet);
        dataSet = this.designHandle.findDataSet("CompositeLib.dataSet1");
        DesignLoadLibraryTest.assertNotNull((Object)dataSet);
        table = (TableHandle)this.designHandle.findElement("table4");
        DesignLoadLibraryTest.assertEquals((String)"CompositeLib.dataSet1", (String)table.getStringProperty("dataSet"));
        dataSet = table.getDataSet();
        DesignLoadLibraryTest.assertEquals((Object)"Lib2.dataSet1", (Object)dataSet.getProperty("extends"));
    }

    public void testGetExternalizedMessage() throws Exception {
        this.openDesign("LibraryWithExternalizedMessage.xml");
        LabelHandle label1Handle = (LabelHandle)this.designHandle.findElement("NewLabel");
        LabelHandle label2Handle = (LabelHandle)this.designHandle.findElement("NewLabel1");
        String displayValue = label1Handle.getDisplayText();
        DesignLoadLibraryTest.assertEquals((String)"v1", (String)displayValue);
        displayValue = label2Handle.getDisplayText();
        DesignLoadLibraryTest.assertEquals((String)"v2", (String)displayValue);
    }

    public void testLibraryWithUserProperty() throws Exception {
        this.openDesign("DesignWithUserProperty.xml");
        LabelHandle label = (LabelHandle)this.designHandle.findElement("NewLabel");
        DesignLoadLibraryTest.assertEquals((Object)this.designHandle, (Object)label.getRoot());
        label.drop();
        DesignLoadLibraryTest.assertNull((Object)label.getRoot());
        DesignLoadLibraryTest.assertNull((Object)this.designHandle.findElement("NewLabel"));
    }

    public void testGetLibResources() throws Exception {
        this.openDesign("DesignWithResourcesTest.xml");
        List libs = this.designHandle.getAllScriptLibs();
        DesignLoadLibraryTest.assertEquals((int)4, (int)libs.size());
        List includedScripts = this.designHandle.getAllIncludeScripts();
        DesignLoadLibraryTest.assertEquals((int)4, (int)includedScripts.size());
        IncludeScriptHandle script = (IncludeScriptHandle)includedScripts.get(0);
        DesignLoadLibraryTest.assertEquals((String)"a", (String)script.getFileName());
        script = (IncludeScriptHandle)includedScripts.get(1);
        DesignLoadLibraryTest.assertEquals((String)"outer", (String)script.getFileName());
        script = (IncludeScriptHandle)includedScripts.get(2);
        DesignLoadLibraryTest.assertEquals((String)"inner", (String)script.getFileName());
        script = (IncludeScriptHandle)includedScripts.get(3);
        DesignLoadLibraryTest.assertEquals((String)"outer1", (String)script.getFileName());
    }

    public void testGetAllIncludeCsses() throws Exception {
        this.openDesign("DesignWithResourcesTest.xml");
        List sheets = this.designHandle.getAllExternalIncludedCsses();
        DesignLoadLibraryTest.assertEquals((int)3, (int)sheets.size());
        IncludedCssStyleSheetHandle sheetHandle = (IncludedCssStyleSheetHandle)sheets.get(0);
        DesignLoadLibraryTest.assertEquals((String)"base2.css", (String)sheetHandle.getFileName());
        sheetHandle = (IncludedCssStyleSheetHandle)sheets.get(1);
        DesignLoadLibraryTest.assertEquals((String)"outer1.css", (String)sheetHandle.getFileName());
        sheetHandle = (IncludedCssStyleSheetHandle)sheets.get(2);
        DesignLoadLibraryTest.assertEquals((String)"outer2.css", (String)sheetHandle.getFileName());
    }

    public void testLoadDesignWithSameLibraryFile() throws Exception {
        this.openDesign("BlankDesign.xml");
        this.designHandle.includeLibrary("Library_1.xml", "libA");
        this.designHandle.includeLibrary("LibraryIncludingTwoLibraries.xml", "libB");
        DesignLoadLibraryTest.assertNotNull((Object)this.design.getLibraryWithNamespace("Lib1"));
        GridHandle tmpGrid = (GridHandle)this.designHandle.getLibrary("libB").findElement("myGrid");
        GridHandle newGrid = (GridHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)tmpGrid, "testMyGrid");
        DesignLoadLibraryTest.assertTrue((newGrid.getRows().getCount() > 0 ? 1 : 0) != 0);
    }
}

