/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.library;

import java.util.List;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.LibraryException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.elements.GridItem;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class LibraryCommandTest
extends BaseTestCase {
    public void testDropTheSecondTimeIncludedLibrary() throws Exception {
        this.openDesign("DesignWithOneLibrary.xml");
        this.designHandle.includeLibrary("LibraryToBeDrop.xml", "stay");
        this.designHandle.includeLibrary("LibraryToBeDrop_1.xml", "delete");
        LibraryHandle secLibHandle = this.designHandle.getLibrary("delete");
        this.designHandle.dropLibrary(secLibHandle);
        LibraryCommandTest.assertTrue((this.designHandle.getLibrary("stay") != null ? 1 : 0) != 0);
    }

    public void testLibraryRecursivelyIncludeLibrary() throws DesignFileException {
        this.openLibrary("LibraryIncludingTwoLibraries.xml");
        try {
            this.libraryHandle.includeLibrary("LibraryIncludingTwoLibraries.xml", null);
            LibraryCommandTest.fail();
        }
        catch (Exception exception) {
            LibraryCommandTest.assertTrue((boolean)true);
        }
        this.libraryHandle = null;
        this.openLibrary("Library_1.xml");
        LibraryCommandTest.assertNotNull((Object)this.libraryHandle);
        try {
            this.libraryHandle.includeLibrary("LibraryIncludingTwoLibraries.xml", null);
            LibraryCommandTest.fail();
        }
        catch (Exception exception) {
            LibraryCommandTest.assertTrue((boolean)true);
        }
    }

    public void testExceptionWhenDropUsedLibrary() throws DesignFileException, SemanticException {
        this.openDesign("DesignWithOneLibrary.xml");
        LibraryHandle lib = this.designHandle.getLibrary("Lib1");
        DataSourceHandle libDataSource = lib.findDataSource("dataSource1");
        DataSourceHandle designDataSource = (DataSourceHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)libDataSource, "designDataSource");
        this.designHandle.getDataSources().add((DesignElementHandle)designDataSource);
        try {
            this.designHandle.dropLibrary(lib);
            LibraryCommandTest.fail();
        }
        catch (Exception e) {
            LibraryCommandTest.assertEquals((String)"Error.LibraryException.LIBRARY_HAS_DESCENDENTS", (String)((LibraryException)((Object)e)).getErrorCode());
        }
        this.designHandle.getDataSources().drop((DesignElementHandle)designDataSource);
        try {
            this.designHandle.dropLibrary(lib);
        }
        catch (Exception exception) {
            LibraryCommandTest.fail();
        }
        this.designHandle.includeLibrary("Library_1.xml", "Lib1");
        lib = this.designHandle.getLibrary("Lib1");
        ParameterHandle parameter = lib.findParameter("para");
        LibraryCommandTest.assertNotNull((Object)parameter);
        ParameterHandle designParameter = (ParameterHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)parameter, "designPara");
        this.designHandle.getParameters().add((DesignElementHandle)designParameter);
        try {
            this.designHandle.dropLibrary(lib);
            LibraryCommandTest.fail();
        }
        catch (Exception e) {
            LibraryCommandTest.assertEquals((String)"Error.LibraryException.LIBRARY_HAS_DESCENDENTS", (String)((LibraryException)((Object)e)).getErrorCode());
        }
    }

    public void testDropLibraryWithRelativePath() throws Exception {
        this.openDesign("DesignCopyPaste.xml");
        this.designHandle.includeLibrary("../golden/LibraryParseTest_golden.xml", "testDrop");
        this.designHandle.dropLibrary(this.designHandle.getLibrary("testDrop"));
        LibraryCommandTest.assertNull((Object)this.designHandle.getLibrary("testDrop"));
        LibraryCommandTest.assertNull((Object)this.design.findIncludedLibrary("testDrop"));
    }

    public void testNameSpaceWithAddLibrary() throws Exception {
        this.openDesign("DesignToAddLibrary.xml");
        NameSpace ns = this.design.getNameHelper().getNameSpace(1);
        List elements = ns.getElements();
        TableItem designTable = (TableItem)ns.getElement("designTable");
        GridItem designGrid = (GridItem)ns.getElement("designGrid");
        LibraryCommandTest.assertEquals((int)6, (int)elements.size());
        LibraryCommandTest.assertTrue((boolean)elements.contains(designTable));
        LibraryCommandTest.assertTrue((boolean)elements.contains(designGrid));
        int i = 1;
        while (i < 5) {
            LibraryCommandTest.assertTrue((boolean)((DesignElement)elements.get(i)).isContentOf((DesignElement)designTable));
            ++i;
        }
        this.designHandle.includeLibrary("Library_1.xml", "lib2");
        LibraryCommandTest.assertNotNull((Object)designGrid.getExtendsElement());
        elements = ns.getElements();
        LibraryCommandTest.assertEquals((int)7, (int)elements.size());
        LibraryCommandTest.assertTrue((boolean)((DesignElement)elements.get(6)).isContentOf((DesignElement)designGrid));
    }
}

