/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.ColorUtil;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.ColorPropertyType;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefnFake;
import org.eclipse.birt.report.model.metadata.PropertyTypeTestCase;

public class ColorPropertyTypeTest
extends PropertyTypeTestCase {
    ColorPropertyType type = new ColorPropertyType();
    PropertyDefn propDefn = new PropertyDefnFake();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign("ColorPropertyTypeTest.xml", TEST_LOCALE);
    }

    public void testFormatRGBValue() {
        int rgbValue = Integer.decode("#FF0000");
        String value = ColorUtil.format((int)rgbValue, (int)0);
        ColorPropertyTypeTest.assertEquals((String)"16711680", (String)value);
        value = ColorUtil.format((int)rgbValue, (int)1);
        ColorPropertyTypeTest.assertEquals((String)"#FF0000", (String)value);
        value = ColorUtil.format((int)rgbValue, (int)2);
        ColorPropertyTypeTest.assertEquals((String)"0xFF0000", (String)value);
        value = ColorUtil.format((int)rgbValue, (int)3);
        ColorPropertyTypeTest.assertEquals((String)"RGB(255,0,0)", (String)value);
        value = ColorUtil.format((int)rgbValue, (int)4);
        ColorPropertyTypeTest.assertEquals((String)"RGB(100.0%,0.0%,0.0%)", (String)value);
        value = ColorUtil.format((int)rgbValue, (int)3);
        ColorPropertyTypeTest.assertEquals((String)"RGB(255,0,0)", (String)value);
    }

    @Override
    public void testValidateXml() throws PropertyValueException {
        String value = null;
        ColorPropertyTypeTest.assertEquals(null, (Object)this.type.validateXml((Module)this.design, null, null, null));
        ColorPropertyTypeTest.assertEquals(null, (Object)this.type.validateXml((Module)this.design, null, null, (Object)""));
        value = "RGB(255,0,0)";
        ColorPropertyTypeTest.assertEquals((Object)Integer.decode("#FF0000"), (Object)this.type.validateXml((Module)this.design, null, null, (Object)value));
        value = "RGB(255%,0%,0%)";
        ColorPropertyTypeTest.assertEquals((Object)Integer.decode("#FF0000"), (Object)this.type.validateXml((Module)this.design, null, null, (Object)value));
        value = "RGB(65%,0%,0%)";
        ColorPropertyTypeTest.assertNotNull((Object)this.type.validateXml((Module)this.design, null, null, (Object)value));
        value = "RGB(65.01%,0%,0%)";
        ColorPropertyTypeTest.assertNotNull((Object)this.type.validateXml((Module)this.design, null, null, (Object)value));
        value = "RGB(  255 % , 0 % , 0 % )";
        ColorPropertyTypeTest.assertEquals((Object)Integer.decode("#FF0000"), (Object)this.type.validateXml((Module)this.design, null, null, (Object)value));
        value = "RGB(  255.01 % , 0.0 % , 0.0 % )";
        ColorPropertyTypeTest.assertEquals((Object)Integer.decode("#FF0000"), (Object)this.type.validateXml((Module)this.design, null, null, (Object)value));
        value = "RGB(450,350,0)";
        ColorPropertyTypeTest.assertEquals((Object)Integer.decode("#FFFF00"), (Object)this.type.validateXml((Module)this.design, null, null, (Object)value));
        value = "red";
        ColorPropertyTypeTest.assertEquals((Object)"red", (Object)this.type.validateXml((Module)this.design, null, null, (Object)value));
        value = "123134";
        ColorPropertyTypeTest.assertEquals((String)"123134", (String)this.type.validateXml((Module)this.design, null, null, (Object)value).toString());
        value = "1234567890";
        ColorPropertyTypeTest.assertEquals((String)Integer.decode("#FFFFFF").toString(), (String)this.type.validateXml((Module)this.design, null, null, (Object)value).toString());
        value = "#FF00FF";
        ColorPropertyTypeTest.assertEquals((Object)Integer.decode("#FF00FF"), (Object)this.type.validateXml((Module)this.design, null, null, (Object)value));
        value = "#F0F";
        ColorPropertyTypeTest.assertEquals((Object)Integer.decode("#FF00FF"), (Object)this.type.validateXml((Module)this.design, null, null, (Object)value));
    }

    @Override
    public void testGetTypeCode() {
        ColorPropertyTypeTest.assertEquals((int)4, (int)this.type.getTypeCode());
    }

    @Override
    public void testGetName() {
        ColorPropertyTypeTest.assertEquals((String)"color", (String)this.type.getName());
    }

    @Override
    public void testValidateValue() throws PropertyValueException {
        ColorPropertyTypeTest.assertEquals(null, (Object)this.type.validateValue((Module)this.design, null, this.propDefn, null));
        ColorPropertyTypeTest.assertEquals(null, (Object)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)" "));
        ColorPropertyTypeTest.assertEquals((Object)Integer.decode("#FF00FF"), (Object)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)"#F0F"));
        ColorPropertyTypeTest.assertEquals((Object)Integer.decode("#FF00FF"), (Object)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)"#FF00FF"));
        ColorPropertyTypeTest.assertEquals((Object)Integer.decode("#FFFFFF"), (Object)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)"#FFFFFFF"));
        ColorPropertyTypeTest.assertEquals((Object)Integer.decode("#FF00FF"), (Object)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)"0xFF00FF"));
        ColorPropertyTypeTest.assertEquals((Object)new Integer(1234567), (Object)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)"1234567"));
        ColorPropertyTypeTest.assertEquals((Object)"red", (Object)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)"red"));
        ColorPropertyTypeTest.assertEquals((Object)Integer.decode("#FFFFFF"), (Object)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)"rgb(100.0%,100.0%,100.0%)"));
        ColorPropertyTypeTest.assertEquals((Object)Integer.decode("#FF00FF"), (Object)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)"rgb(100.0%,0.0%,100.0%)"));
        ColorPropertyTypeTest.assertEquals((Object)Integer.decode("#FF00FF"), (Object)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)"rgb(100.0%,0.0%,500.0%)"));
        ColorPropertyTypeTest.assertEquals((Object)Integer.decode("#FFFFFF"), (Object)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)"rgb(255,255,255)"));
        ColorPropertyTypeTest.assertEquals((Object)Integer.decode("#FF00FF"), (Object)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)"rgb(255,0,255)"));
        ColorPropertyTypeTest.assertEquals((Object)Integer.decode("#FFFFFF"), (Object)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)"rgb(400,400,400)"));
        Integer value = Integer.decode("#FF00FF");
        ColorPropertyTypeTest.assertEquals((Object)value, (Object)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)value));
        try {
            this.type.validateValue((Module)this.design, null, this.propDefn, (Object)Integer.decode("#FFFFFFF"));
            ColorPropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            ColorPropertyTypeTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
    }

    @Override
    public void testValidateInputString() throws PropertyValueException {
        ColorPropertyTypeTest.assertEquals(null, (Object)this.type.validateInputString((Module)this.design, null, null, null));
        ColorPropertyTypeTest.assertEquals(null, (Object)this.type.validateInputString((Module)this.design, null, null, ""));
        ThreadResources.setLocale((ULocale)TEST_LOCALE);
        ColorPropertyTypeTest.assertEquals((Object)"red", (Object)this.type.validateInputString((Module)this.design, null, this.propDefn, "\u7ea2\u8272"));
        ColorPropertyTypeTest.assertEquals((Object)"myColor1", (Object)this.type.validateInputString((Module)this.design, null, this.propDefn, "myColor1"));
    }

    public void testToCSSCompatibleColor() {
        ColorPropertyTypeTest.assertEquals(null, (String)this.type.toCSSCompatibleColor((Module)this.design, null));
        ColorPropertyTypeTest.assertEquals((String)"red", (String)this.type.toCSSCompatibleColor((Module)this.design, (Object)"red"));
        ColorPropertyTypeTest.assertEquals((String)"RGB(18,52,250)", (String)this.type.toCSSCompatibleColor((Module)this.design, (Object)"myColor1"));
        ColorPropertyTypeTest.assertEquals((String)"RGB(255,255,255)", (String)this.type.toCSSCompatibleColor((Module)this.design, (Object)"myColor2"));
        ColorPropertyTypeTest.assertEquals((String)"RGB(255,0,255)", (String)this.type.toCSSCompatibleColor((Module)this.design, (Object)Integer.decode("#FF00FF")));
        ColorPropertyTypeTest.assertEquals(null, (String)this.type.toCSSCompatibleColor((Module)this.design, new Object()));
    }

    public void testToCssColor() {
        ColorPropertyTypeTest.assertEquals(null, (String)this.type.toCssColor((Module)this.design, null));
        ColorPropertyTypeTest.assertEquals((String)"red", (String)this.type.toCssColor((Module)this.design, (Object)"red"));
        ColorPropertyTypeTest.assertEquals((String)"#ff00ff", (String)this.type.toCssColor((Module)this.design, (Object)Integer.decode("#FF00FF")));
        ColorPropertyTypeTest.assertEquals((String)"#ffffff", (String)this.type.toCssColor((Module)this.design, (Object)"myColor2"));
    }

    @Override
    public void testToDouble() {
        ColorPropertyTypeTest.assertEquals((double)-1.0, (double)this.type.toDouble((Module)this.design, null), (double)0.0);
        ColorPropertyTypeTest.assertEquals((double)123.0, (double)this.type.toDouble((Module)this.design, (Object)new Integer(123)), (double)0.0);
        ColorPropertyTypeTest.assertEquals((double)Integer.decode("#FF0000").doubleValue(), (double)this.type.toDouble((Module)this.design, (Object)"red"), (double)0.0);
        ColorPropertyTypeTest.assertEquals((double)Integer.decode("#FFFFFF").doubleValue(), (double)this.type.toDouble((Module)this.design, (Object)"myColor2"), (double)0.0);
    }

    @Override
    public void testToInteger() {
        ColorPropertyTypeTest.assertEquals((int)-1, (int)this.type.toInteger((Module)this.design, null));
        ColorPropertyTypeTest.assertEquals((int)123, (int)this.type.toInteger((Module)this.design, (Object)new Integer(123)));
        ColorPropertyTypeTest.assertEquals((int)Integer.decode("#FF0000"), (int)this.type.toInteger((Module)this.design, (Object)"red"));
        ColorPropertyTypeTest.assertEquals((int)Integer.decode("#FFFFFF"), (int)this.type.toInteger((Module)this.design, (Object)"myColor2"));
    }

    @Override
    public void testToXml() {
        ColorPropertyTypeTest.assertEquals((String)"red", (String)this.type.toXml((Module)this.design, this.propDefn, (Object)"red"));
        ColorPropertyTypeTest.assertEquals((String)"#FF00FF", (String)this.type.toXml((Module)this.design, this.propDefn, (Object)Integer.decode("#FF00FF")));
    }

    @Override
    public void testToString() {
        ColorPropertyTypeTest.assertEquals(null, (String)this.type.toString((Module)this.design, this.propDefn, null));
        ColorPropertyTypeTest.assertEquals((String)"red", (String)this.type.toString((Module)this.design, this.propDefn, (Object)"red"));
        ColorPropertyTypeTest.assertEquals((String)"#FF00FF", (String)this.type.toString((Module)this.design, this.propDefn, (Object)Integer.decode("#FF00FF")));
        ColorPropertyTypeTest.assertEquals(null, (String)this.type.toString((Module)this.design, this.propDefn, new Object()));
    }

    @Override
    public void testToDisplayString() throws PropertyValueException {
        ThreadResources.setLocale((ULocale)ULocale.ENGLISH);
        ColorPropertyTypeTest.assertEquals((String)"Red", (String)this.type.toDisplayString((Module)this.design, this.propDefn, (Object)"red"));
        ThreadResources.setLocale((ULocale)TEST_LOCALE);
        ColorPropertyTypeTest.assertEquals((String)"\u7ea2\u8272", (String)this.type.toDisplayString((Module)this.design, this.propDefn, (Object)"red"));
        ColorPropertyTypeTest.assertEquals((String)"Color 2", (String)this.type.toDisplayString((Module)this.design, this.propDefn, (Object)"myColor2"));
        this.design.getSession().setColorFormat(3);
        ColorPropertyTypeTest.assertEquals((String)"RGB(255,0,255)", (String)this.type.toDisplayString((Module)this.design, this.propDefn, (Object)Integer.decode("#FF00FF")));
        this.design.getSession().setColorFormat(4);
        ColorPropertyTypeTest.assertEquals((String)"RGB(100.0%,0.0%,100.0%)", (String)this.type.toDisplayString((Module)this.design, this.propDefn, (Object)Integer.decode("#FF00FF")));
    }

    @Override
    public void testToNumber() {
    }

    @Override
    public void testToBoolean() {
    }
}

