/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.DimensionPropertyType;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefnFake;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.metadata.PropertyTypeTestCase;

public class DimensionPropertyTypeTest
extends PropertyTypeTestCase {
    DimensionPropertyType type = new DimensionPropertyType();
    PropertyDefn propDefn = new PropertyDefnFake();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.propDefn.setType((PropertyType)this.type);
    }

    @Override
    public void testGetTypeCode() {
        DimensionPropertyTypeTest.assertEquals((int)3, (int)this.type.getTypeCode());
    }

    @Override
    public void testGetName() {
        DimensionPropertyTypeTest.assertEquals((String)"dimension", (String)this.type.getName());
    }

    @Override
    public void testValidateValue() throws PropertyValueException {
        DimensionPropertyTypeTest.assertEquals(null, (Object)this.type.validateValue((Module)this.design, null, this.propDefn, null));
        DimensionPropertyTypeTest.assertEquals(null, (Object)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)""));
        DimensionValue value = (DimensionValue)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)"1.0cm");
        DimensionPropertyTypeTest.assertEquals((String)"cm", (String)value.getUnits());
        DimensionPropertyTypeTest.assertEquals((double)1.0, (double)value.getMeasure(), (double)1.0);
        value = (DimensionValue)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)"1.0  pt");
        DimensionPropertyTypeTest.assertEquals((String)"pt", (String)value.getUnits());
        DimensionPropertyTypeTest.assertEquals((double)1.0, (double)value.getMeasure(), (double)1.0);
        DimensionValue input = new DimensionValue(1.0, "cm");
        value = (DimensionValue)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)input);
        DimensionPropertyTypeTest.assertTrue((input == value ? 1 : 0) != 0);
    }

    @Override
    public void testValidateInputString() throws PropertyValueException {
        DimensionValue value = (DimensionValue)this.type.validateInputString((Module)this.design, null, this.propDefn, "cm");
        DimensionPropertyTypeTest.assertEquals(null, (Object)value);
        value = (DimensionValue)this.type.validateInputString((Module)this.design, null, this.propDefn, " cm ");
        DimensionPropertyTypeTest.assertEquals(null, (Object)value);
        try {
            value = (DimensionValue)this.type.validateInputString((Module)this.design, null, this.propDefn, "acm");
            DimensionPropertyTypeTest.fail();
        }
        catch (PropertyValueException propertyValueException) {}
        try {
            value = (DimensionValue)this.type.validateInputString((Module)this.design, null, this.propDefn, "/cm");
            DimensionPropertyTypeTest.fail();
        }
        catch (PropertyValueException propertyValueException) {}
    }

    @Override
    public void testValidateXml() throws PropertyValueException {
        DimensionPropertyTypeTest.assertEquals(null, (Object)this.type.validateXml((Module)this.design, null, this.propDefn, null));
        DimensionPropertyTypeTest.assertEquals(null, (Object)this.type.validateXml((Module)this.design, null, this.propDefn, (Object)""));
        DimensionValue value = (DimensionValue)this.type.validateXml((Module)this.design, null, this.propDefn, (Object)"1.0cm");
        DimensionPropertyTypeTest.assertEquals((String)"cm", (String)value.getUnits());
        DimensionPropertyTypeTest.assertEquals((double)1.0, (double)value.getMeasure(), (double)1.0);
        this.resetMetadata();
        this.createDesign(ULocale.GERMAN);
        ElementFactory factory = new ElementFactory(this.designHandle.getModule());
        SimpleMasterPageHandle page = factory.newSimpleMasterPage("Page1");
        DimensionPropertyTypeTest.assertEquals((String)"0,25in", (String)page.getDisplayProperty("leftMargin"));
        DimensionPropertyTypeTest.assertEquals((String)"0.25in", (String)page.getStringProperty("leftMargin"));
    }

    @Override
    public void testToDouble() throws PropertyValueException {
        DimensionPropertyTypeTest.assertEquals((double)0.0, (double)this.type.toDouble((Module)this.design, null), (double)1.0);
        this.design.getSession().setUnits("cm");
        DimensionPropertyTypeTest.assertEquals((double)2.54, (double)this.type.toDouble((Module)this.design, (Object)new DimensionValue(1.0, "in")), (double)2.0);
    }

    @Override
    public void testToInteger() {
    }

    @Override
    public void testToXml() {
        DimensionPropertyTypeTest.assertEquals((String)"2cm", (String)this.type.toXml((Module)this.design, this.propDefn, (Object)new DimensionValue(2.0, "cm")));
        DimensionPropertyTypeTest.assertEquals((String)"2mm", (String)this.type.toXml((Module)this.design, this.propDefn, (Object)new DimensionValue(2.0, "mm")));
    }

    @Override
    public void testToString() {
        DimensionPropertyTypeTest.assertEquals((String)"2cm", (String)this.type.toString((Module)this.design, this.propDefn, (Object)new DimensionValue(2.0, "cm")));
        DimensionPropertyTypeTest.assertEquals((String)"2mm", (String)this.type.toString((Module)this.design, this.propDefn, (Object)new DimensionValue(2.0, "mm")));
    }

    @Override
    public void testToDisplayString() {
        ThreadResources.setLocale((ULocale)ULocale.ENGLISH);
        DimensionPropertyTypeTest.assertEquals((String)"1,234,567,890.123cm", (String)this.type.toDisplayString((Module)this.design, this.propDefn, (Object)new DimensionValue(1.234567890123E9, "cm")));
    }

    @Override
    public void testToNumber() throws PropertyValueException {
        DimensionPropertyTypeTest.assertEquals((double)0.0, (double)this.type.toNumber((Module)this.design, null).doubleValue(), (double)1.0);
        this.design.getSession().setUnits("cm");
        DimensionPropertyTypeTest.assertEquals((double)2.54, (double)this.type.toNumber((Module)this.design, (Object)new DimensionValue(1.0, "in")).doubleValue(), (double)2.0);
    }

    public void testValidateInputValueByEnglishULocale() throws SemanticException {
        this.createDesign(null);
        TableHandle table = this.designHandle.getElementFactory().newTableItem("table", 3);
        RowHandle row = this.designHandle.getElementFactory().newTableRow();
        CellHandle cell = this.designHandle.getElementFactory().newCell();
        LabelHandle label = this.designHandle.getElementFactory().newLabel("label");
        cell.addElement((DesignElementHandle)label, 0);
        row.addElement((DesignElementHandle)cell, 0);
        table.getHeader().add((DesignElementHandle)row);
        this.designHandle.getBody().add((DesignElementHandle)table);
        label.setProperty("marginLeft", (Object)"111,111.22pt");
        DimensionPropertyTypeTest.assertEquals((String)"111111.22pt", (String)label.getProperty("marginLeft").toString());
        label.setProperty("marginLeft", (Object)"111,111.22,555pt");
        DimensionPropertyTypeTest.assertEquals((String)"111111.22pt", (String)label.getProperty("marginLeft").toString());
        label.setProperty("marginLeft", (Object)"111.22,555pt");
        DimensionPropertyTypeTest.assertEquals((String)"111.22pt", (String)label.getProperty("marginLeft").toString());
        label.setProperty("marginLeft", (Object)"111,2222,33.22,555pt");
        DimensionPropertyTypeTest.assertEquals((String)"111222233.22pt", (String)label.getProperty("marginLeft").toString());
        label.setProperty("marginLeft", (Object)"1pt");
        DimensionPropertyTypeTest.assertEquals((String)"1pt", (String)label.getProperty("marginLeft").toString());
        label.setProperty("marginLeft", (Object)"1.1pt");
        DimensionPropertyTypeTest.assertEquals((String)"1.1pt", (String)label.getProperty("marginLeft").toString());
        try {
            label.setProperty("marginLeft", (Object)"12kpt");
            DimensionPropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            DimensionPropertyTypeTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
        try {
            label.setProperty("marginLeft", (Object)"1:\":3,>}{)(*&^? pt");
            DimensionPropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            DimensionPropertyTypeTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
        try {
            label.setProperty("marginLeft", (Object)"111,11.11.22pt");
            DimensionPropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            DimensionPropertyTypeTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
        try {
            label.setProperty("marginLeft", (Object)"111,11,.22pt");
            DimensionPropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            DimensionPropertyTypeTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
        try {
            label.setProperty("marginLeft", (Object)",11.22pt");
            DimensionPropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            DimensionPropertyTypeTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
        try {
            label.setProperty("marginLeft", (Object)",11,1.22pt");
            DimensionPropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            DimensionPropertyTypeTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
        try {
            label.setProperty("marginLeft", (Object)"1,.22pt");
            DimensionPropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            DimensionPropertyTypeTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
        try {
            label.setProperty("marginLeft", (Object)"11..22pt");
            DimensionPropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            DimensionPropertyTypeTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
        try {
            label.setProperty("marginLeft", (Object)"11,,1.22pt");
            DimensionPropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            DimensionPropertyTypeTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
        try {
            label.setProperty("marginLeft", (Object)"11,1.22,,pt");
            DimensionPropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            DimensionPropertyTypeTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
        try {
            label.setProperty("marginLeft", (Object)"11,1.22,pt");
            DimensionPropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            DimensionPropertyTypeTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
        try {
            label.setProperty("marginLeft", (Object)"+1pt");
            assert (false);
        }
        catch (PropertyValueException e) {
            DimensionPropertyTypeTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
    }

    public void testValidateInputValueByGermanULocale() throws SemanticException {
        this.createDesign(ULocale.GERMANY);
        TableHandle table = this.designHandle.getElementFactory().newTableItem("table", 3);
        RowHandle row = this.designHandle.getElementFactory().newTableRow();
        CellHandle cell = this.designHandle.getElementFactory().newCell();
        LabelHandle label = this.designHandle.getElementFactory().newLabel("label");
        cell.addElement((DesignElementHandle)label, 0);
        row.addElement((DesignElementHandle)cell, 0);
        table.getHeader().add((DesignElementHandle)row);
        this.designHandle.getBody().add((DesignElementHandle)table);
        label.setProperty("marginLeft", (Object)"111.111,22pt");
        DimensionPropertyTypeTest.assertEquals((String)"111111.22pt", (String)label.getProperty("marginLeft").toString());
        label.setProperty("marginLeft", (Object)"111.111,22.555pt");
        DimensionPropertyTypeTest.assertEquals((String)"111111.22pt", (String)label.getProperty("marginLeft").toString());
        label.setProperty("marginLeft", (Object)"111,22.555pt");
        DimensionPropertyTypeTest.assertEquals((String)"111.22pt", (String)label.getProperty("marginLeft").toString());
        label.setProperty("marginLeft", (Object)"111.2222.33,22.555pt");
        DimensionPropertyTypeTest.assertEquals((String)"111222233.22pt", (String)label.getProperty("marginLeft").toString());
        label.setProperty("marginLeft", (Object)"1pt");
        DimensionPropertyTypeTest.assertEquals((String)"1pt", (String)label.getProperty("marginLeft").toString());
        label.setProperty("marginLeft", (Object)"1,1pt");
        DimensionPropertyTypeTest.assertEquals((String)"1.1pt", (String)label.getProperty("marginLeft").toString());
        try {
            label.setProperty("marginLeft", (Object)"12kpt");
            DimensionPropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            DimensionPropertyTypeTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
        try {
            label.setProperty("marginLeft", (Object)"1:\":3,>}{)(*&^? pt");
            DimensionPropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            DimensionPropertyTypeTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
        try {
            label.setProperty("marginLeft", (Object)"111.11,11,22pt");
            DimensionPropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            DimensionPropertyTypeTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
        try {
            label.setProperty("marginLeft", (Object)"111.11.,22pt");
            DimensionPropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            DimensionPropertyTypeTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
        try {
            label.setProperty("marginLeft", (Object)".11,22pt");
            DimensionPropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            DimensionPropertyTypeTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
        try {
            label.setProperty("marginLeft", (Object)"+1pt");
            assert (false);
        }
        catch (PropertyValueException e) {
            DimensionPropertyTypeTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
    }

    @Override
    public void testToBoolean() {
    }

    class DimensionValueFake
    extends DimensionValue {
        public DimensionValueFake(double theMeasure, String theUnits) {
            super(theMeasure, theUnits);
        }

        public boolean equals(Object obj) {
            return this.toString().equals(obj.toString());
        }
    }
}

