/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import com.ibm.icu.util.ULocale;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfo;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IMethodInfo;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.AbstractMetaTest;
import org.eclipse.birt.report.model.metadata.ArgumentInfoList;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.MetaDataParserException;
import org.eclipse.birt.report.model.metadata.MetadataTestUtil;
import org.eclipse.birt.report.model.metadata.ObjectDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.SlotDefn;
import org.eclipse.birt.report.model.metadata.SystemPropertyDefn;

public class ElementDefnTest
extends AbstractMetaTest {
    private ElementDefn def = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.def = new ElementDefn();
        ThreadResources.setLocale((ULocale)ULocale.ENGLISH);
    }

    public void testGetterAndSetter() {
        MetadataTestUtil.setAllowsUserProperties((ElementDefn)this.def, (boolean)true);
        MetadataTestUtil.setCanExtends((ElementDefn)this.def, (boolean)true);
        ElementDefnTest.assertEquals((boolean)true, (boolean)this.def.canExtend());
        MetadataTestUtil.setDisplayNameKey((ObjectDefn)this.def, (String)"Element.ReportDesign");
        MetadataTestUtil.setExtends((ElementDefn)this.def, (String)"ReportElement");
        MetadataTestUtil.setHasStyle((ElementDefn)this.def, (boolean)true);
        MetadataTestUtil.setName((ObjectDefn)this.def, (String)"Name");
        MetadataTestUtil.setNameOption((ElementDefn)this.def, (int)2);
        MetadataTestUtil.setNameSpaceID((ElementDefn)this.def, (int)4);
        ElementDefnTest.assertEquals((boolean)false, (boolean)this.def.isAbstract());
        ElementDefnTest.assertEquals((boolean)true, (boolean)this.def.allowsUserProperties());
        ElementDefnTest.assertEquals((String)"Report Design", (String)this.def.getDisplayName());
        ElementDefnTest.assertEquals((Object)"Element.ReportDesign", (Object)this.def.getDisplayNameKey());
        ElementDefnTest.assertEquals((String)"ReportElement", (String)this.def.getExtends());
        ElementDefnTest.assertEquals((boolean)true, (boolean)this.def.hasStyle());
        ElementDefnTest.assertEquals((String)"Name", (String)this.def.getName());
        ElementDefnTest.assertEquals((int)2, (int)this.def.getNameOption());
        ElementDefnTest.assertEquals((int)4, (int)this.def.getNameSpaceID());
    }

    public void testGetGroupNames() {
        ThreadResources.setLocale((ULocale)ULocale.ENGLISH);
        IElementDefn elemDefn = MetaDataDictionary.getInstance().getElement("Style");
        ElementDefnTest.assertNotNull((Object)elemDefn);
        List groupNames = elemDefn.getGroupNames();
        ElementDefnTest.assertEquals((int)6, (int)groupNames.size());
    }

    public void testAddSameProperties() {
        SystemPropertyDefn propertyA = new SystemPropertyDefn();
        SystemPropertyDefn propertyB = new SystemPropertyDefn();
        propertyA.setName("ABC");
        propertyB.setName("ABC");
        try {
            this.def.addProperty((PropertyDefn)propertyA);
            this.def.addProperty((PropertyDefn)propertyB);
            ElementDefnTest.fail();
        }
        catch (MetaDataException metaDataException) {}
    }

    public void testAddThreeProperties() throws MetaDataException {
        SystemPropertyDefn propertyA = new SystemPropertyDefn();
        SystemPropertyDefn propertyB = new SystemPropertyDefn();
        SystemPropertyDefn propertyC = new SystemPropertyDefn();
        propertyA.setName("ABC");
        propertyB.setName("ABCDEF");
        propertyC.setName("ABCDEFGHI");
        this.def.addProperty((PropertyDefn)propertyA);
        this.def.addProperty((PropertyDefn)propertyB);
        this.def.addProperty((PropertyDefn)propertyC);
        List list = this.def.getLocalProperties();
        ElementDefnTest.assertTrue((boolean)list.contains(propertyA));
        ElementDefnTest.assertTrue((boolean)list.contains(propertyB));
        ElementDefnTest.assertTrue((boolean)list.contains(propertyC));
    }

    public void testGetProperty() throws MetaDataException {
        ElementDefnTest.assertNull((Object)this.def.getProperty("NotExisting"));
        ElementDefn reportItem = (ElementDefn)MetaDataDictionary.getInstance().getElement("ReportItem");
        ElementDefn label = (ElementDefn)MetaDataDictionary.getInstance().getElement("Label");
        SystemPropertyDefn p = (SystemPropertyDefn)reportItem.getProperty("bookmark");
        ElementDefnTest.assertNotNull((Object)p);
        ElementDefnTest.assertEquals((String)"Element.ReportItem.bookmark", (String)p.getDisplayNameID());
        ElementDefnTest.assertSame((Object)reportItem, (Object)label.getParent());
    }

    public void testGetLocalPropertiesAndGetProperties() {
        ElementDefn reportElement = (ElementDefn)MetaDataDictionary.getInstance().getElement("ReportElement");
        ElementDefn reportItem = (ElementDefn)MetaDataDictionary.getInstance().getElement("ReportItem");
        ElementDefn label = (ElementDefn)MetaDataDictionary.getInstance().getElement("Label");
        SystemPropertyDefn displayNameProperty = (SystemPropertyDefn)label.getProperty("displayName");
        SystemPropertyDefn fontColorProperty = (SystemPropertyDefn)label.getProperty("color");
        SystemPropertyDefn fontFamilyProperty = (SystemPropertyDefn)label.getProperty("fontFamily");
        ElementDefnTest.assertFalse((boolean)label.getLocalProperties().contains(displayNameProperty));
        ElementDefnTest.assertTrue((boolean)label.getLocalProperties().contains(fontColorProperty));
        ElementDefnTest.assertTrue((boolean)label.getLocalProperties().contains(fontFamilyProperty));
        ElementDefnTest.assertNotNull((Object)reportElement.getProperty("displayName"));
        ElementDefnTest.assertNotNull((Object)reportItem.getProperty("displayName"));
        ElementDefnTest.assertNotNull((Object)label.getProperty("displayName"));
        ElementDefnTest.assertTrue((boolean)label.getProperties().contains(displayNameProperty));
        ElementDefnTest.assertTrue((boolean)label.getProperties().contains(fontColorProperty));
        ElementDefnTest.assertTrue((boolean)label.getProperties().contains(fontFamilyProperty));
        ElementDefnTest.assertTrue((boolean)reportElement.isKindOf(MetaDataDictionary.getInstance().getElement("ReportElement")));
        ElementDefnTest.assertTrue((boolean)reportItem.isKindOf(MetaDataDictionary.getInstance().getElement("ReportElement")));
        ElementDefnTest.assertTrue((boolean)label.isKindOf(MetaDataDictionary.getInstance().getElement("ReportElement")));
        ElementDefnTest.assertFalse((boolean)reportElement.isKindOf(MetaDataDictionary.getInstance().getElement("ReportItem")));
        ElementDefnTest.assertTrue((boolean)reportItem.isKindOf(MetaDataDictionary.getInstance().getElement("ReportItem")));
        ElementDefnTest.assertTrue((boolean)label.isKindOf(MetaDataDictionary.getInstance().getElement("ReportItem")));
        ElementDefnTest.assertFalse((boolean)reportElement.isKindOf(MetaDataDictionary.getInstance().getElement("Label")));
        ElementDefnTest.assertFalse((boolean)reportItem.isKindOf(MetaDataDictionary.getInstance().getElement("Label")));
        ElementDefnTest.assertTrue((boolean)label.isKindOf(MetaDataDictionary.getInstance().getElement("Label")));
    }

    public void testGetLocalMethodsAndGetMethods() {
        IElementDefn simpleDataSetDefn = MetaDataDictionary.getInstance().getElement("SimpleDataSet");
        IElementDefn extendedDataSetDefn = MetaDataDictionary.getInstance().getElement("OdaDataSet");
        IElementDefn freeFormDefn = MetaDataDictionary.getInstance().getElement("FreeForm");
        int i = 0;
        List list = simpleDataSetDefn.getMethods();
        ElementDefnTest.assertEquals((int)5, (int)list.size());
        ElementDefnTest.assertEquals((String)"beforeOpen", (String)((PropertyDefn)list.get(i++)).getName());
        ElementDefnTest.assertEquals((String)"beforeClose", (String)((PropertyDefn)list.get(i++)).getName());
        ElementDefnTest.assertEquals((String)"onFetch", (String)((PropertyDefn)list.get(i++)).getName());
        ElementDefnTest.assertEquals((String)"afterOpen", (String)((PropertyDefn)list.get(i++)).getName());
        ElementDefnTest.assertEquals((String)"afterClose", (String)((PropertyDefn)list.get(i++)).getName());
        i = 0;
        list = simpleDataSetDefn.getLocalMethods();
        ElementDefnTest.assertEquals((int)5, (int)list.size());
        ElementDefnTest.assertEquals((String)"beforeOpen", (String)((PropertyDefn)list.get(i++)).getName());
        ElementDefnTest.assertEquals((String)"beforeClose", (String)((PropertyDefn)list.get(i++)).getName());
        ElementDefnTest.assertEquals((String)"onFetch", (String)((PropertyDefn)list.get(i++)).getName());
        ElementDefnTest.assertEquals((String)"afterOpen", (String)((PropertyDefn)list.get(i++)).getName());
        ElementDefnTest.assertEquals((String)"afterClose", (String)((PropertyDefn)list.get(i++)).getName());
        i = 0;
        list = extendedDataSetDefn.getMethods();
        ElementDefnTest.assertEquals((int)5, (int)list.size());
        ElementDefnTest.assertEquals((String)"beforeOpen", (String)((PropertyDefn)list.get(i++)).getName());
        ElementDefnTest.assertEquals((String)"beforeClose", (String)((PropertyDefn)list.get(i++)).getName());
        ElementDefnTest.assertEquals((String)"onFetch", (String)((PropertyDefn)list.get(i++)).getName());
        ElementDefnTest.assertEquals((String)"afterOpen", (String)((PropertyDefn)list.get(i++)).getName());
        ElementDefnTest.assertEquals((String)"afterClose", (String)((PropertyDefn)list.get(i++)).getName());
        i = 0;
        list = extendedDataSetDefn.getLocalMethods();
        ElementDefnTest.assertEquals((int)0, (int)list.size());
        i = 0;
        list = freeFormDefn.getMethods();
        ElementDefnTest.assertEquals((int)0, (int)list.size());
        i = 0;
        list = freeFormDefn.getLocalMethods();
        ElementDefnTest.assertEquals((int)0, (int)list.size());
    }

    public void testGetLocalExpressionsAndGetExpression() {
        IElementDefn freeFormDefn = MetaDataDictionary.getInstance().getElement("FreeForm");
        List list = freeFormDefn.getExpressions();
        ElementDefnTest.assertEquals((int)2, (int)list.size());
        ElementDefnTest.assertEquals((String)"bookmark", (String)((PropertyDefn)list.get(0)).getName());
        ElementDefnTest.assertEquals((int)0, (int)freeFormDefn.getLocalExpressions().size());
    }

    public void testElementWithOneSlot() {
        ElementDefn container = (ElementDefn)MetaDataDictionary.getInstance().getElement("FreeForm");
        ElementDefnTest.assertEquals((Object)"Element.FreeForm", (Object)container.getDisplayNameKey());
        ElementDefnTest.assertEquals((int)1, (int)container.getSlotCount());
        ElementDefnTest.assertFalse((boolean)container.hasSlot(-1));
        ElementDefnTest.assertTrue((boolean)container.hasSlot(0));
        ElementDefnTest.assertFalse((boolean)container.hasSlot(4));
        ElementDefnTest.assertNull((Object)container.getSlot(-1));
        ElementDefnTest.assertNotNull((Object)container.getSlot(0));
        ElementDefnTest.assertNull((Object)container.getSlot(4));
        ElementDefnTest.assertEquals((String)"reportItems", (String)container.getSlot(0).getName());
        ElementDefnTest.assertEquals((String)"Element.FreeForm.slot.reportItems", (String)((SlotDefn)container.getSlot(0)).getDisplayNameID());
        ElementDefnTest.assertEquals((boolean)true, (boolean)container.getSlot(0).isMultipleCardinality());
        ElementDefnTest.assertTrue((boolean)container.getSlot(0).canContain(MetaDataDictionary.getInstance().getElement("FreeForm")));
        ElementDefnTest.assertTrue((boolean)container.getSlot(0).canContain(MetaDataDictionary.getInstance().getElement("Label")));
        ElementDefnTest.assertFalse((boolean)container.canContain(-1, MetaDataDictionary.getInstance().getElement("Label")));
        ElementDefnTest.assertTrue((boolean)container.canContain(0, MetaDataDictionary.getInstance().getElement("Label")));
        ElementDefnTest.assertFalse((boolean)container.canContain(0, MetaDataDictionary.getInstance().getElement("DataSet")));
    }

    public void testElementWithNoSlot() {
        IElementDefn label = MetaDataDictionary.getInstance().getElement("Label");
        ElementDefnTest.assertEquals((int)0, (int)label.getSlotCount());
        ElementDefnTest.assertFalse((boolean)label.hasSlot(-1));
        ElementDefnTest.assertFalse((boolean)label.hasSlot(0));
        ElementDefnTest.assertNull((Object)label.getSlot(-1));
        ElementDefnTest.assertNull((Object)label.getSlot(0));
        ElementDefnTest.assertFalse((boolean)label.canContain(-1, MetaDataDictionary.getInstance().getElement("DataSource")));
        ElementDefnTest.assertFalse((boolean)label.canContain(0, MetaDataDictionary.getInstance().getElement("DataSource")));
    }

    public void testAddSlotToElement() {
        ElementDefn label = (ElementDefn)MetaDataDictionary.getInstance().getElement("Label");
        ElementDefnTest.assertEquals((int)0, (int)label.getSlotCount());
        SlotDefn slot = new SlotDefn();
        MetadataTestUtil.setDisplayNameKey((SlotDefn)slot, (String)"Data Sets");
        MetadataTestUtil.setName((SlotDefn)slot, (String)"dataSets");
        MetadataTestUtil.setMultipleCardinality((SlotDefn)slot, (boolean)true);
        MetadataTestUtil.addType((SlotDefn)slot, (String)"DataSource");
        MetadataTestUtil.addSlot((ElementDefn)label, (SlotDefn)slot);
        ElementDefnTest.assertEquals((int)1, (int)label.getSlotCount());
        MetadataTestUtil.addSlot((ElementDefn)label, (SlotDefn)slot);
        ElementDefnTest.assertEquals((int)2, (int)label.getSlotCount());
    }

    public void testBuild() throws MetaDataException {
        this.def = new ElementDefn();
        MetadataTestUtil.setName((ObjectDefn)this.def, (String)"TestElement1");
        MetadataTestUtil.setAbstract((ElementDefn)this.def, (boolean)true);
        MetadataTestUtil.setHasStyle((ElementDefn)this.def, (boolean)false);
        MetadataTestUtil.setNameOption((ElementDefn)this.def, (int)0);
        MetadataTestUtil.build((ElementDefn)this.def);
        this.def = new ElementDefn();
        MetadataTestUtil.setName((ObjectDefn)this.def, (String)"TestElement2");
        MetadataTestUtil.setHasStyle((ElementDefn)this.def, (boolean)true);
        MetadataTestUtil.addStyleProp((ElementDefn)this.def, (String)"fontSize");
        MetadataTestUtil.addStyleProp((ElementDefn)this.def, (String)"dateTimeFormat");
        MetadataTestUtil.setNameOption((ElementDefn)this.def, (int)0);
        MetadataTestUtil.setAbstract((ElementDefn)this.def, (boolean)true);
        MetadataTestUtil.build((ElementDefn)this.def);
        this.def = new ElementDefn();
        MetadataTestUtil.setAbstract((ElementDefn)this.def, (boolean)true);
        MetadataTestUtil.setName((ObjectDefn)this.def, (String)"TestElement3");
        MetadataTestUtil.setExtends((ElementDefn)this.def, (String)"ReportElement");
        MetadataTestUtil.setHasStyle((ElementDefn)this.def, (boolean)true);
        MetadataTestUtil.addStyleProp((ElementDefn)this.def, (String)"fontSize");
        MetadataTestUtil.addStyleProp((ElementDefn)this.def, (String)"dateTimeFormat");
        MetadataTestUtil.setNameOption((ElementDefn)this.def, (int)0);
        MetadataTestUtil.build((ElementDefn)this.def);
    }

    public void testMethod() throws MetaDataParserException {
        ThreadResources.setLocale((ULocale)ULocale.getDefault());
        this.loadMetaData(ElementDefnTest.class.getResourceAsStream("input/ElementDefnTest.def"));
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        IElementDefn element = dd.getElement("ReportElement");
        ElementDefnTest.assertNotNull((Object)element);
        IMethodInfo method1 = element.getProperty("method1").getMethodInfo();
        ElementDefnTest.assertNotNull((Object)method1);
        ElementDefnTest.assertEquals((String)"display-name-id", (String)method1.getDisplayNameKey());
        ElementDefnTest.assertEquals((String)"tool-tip-id", (String)method1.getToolTipKey());
        ElementDefnTest.assertEquals((String)"string", (String)method1.getReturnType());
        Iterator iter = method1.argumentListIterator();
        ArgumentInfoList argumentList = (ArgumentInfoList)iter.next();
        IArgumentInfo arg = argumentList.getArgument("arg0");
        ElementDefnTest.assertNotNull((Object)arg);
        ElementDefnTest.assertEquals((String)"method1.arg0", (String)arg.getDisplayNameKey());
        ElementDefnTest.assertEquals((String)"int", (String)arg.getType());
        arg = argumentList.getArgument("arg1");
        ElementDefnTest.assertNotNull((Object)arg);
        ElementDefnTest.assertEquals((String)"method1.arg1", (String)arg.getDisplayNameKey());
        ElementDefnTest.assertEquals((String)"string", (String)arg.getType());
        IMethodInfo method2 = element.getProperty("method2").getMethodInfo();
        ElementDefnTest.assertNotNull((Object)method2);
    }

    public void testGetStyleProperty() {
        IElementDefn reportDesign = MetaDataDictionary.getInstance().getElement("ReportDesign");
        ElementDefnTest.assertNull((Object)reportDesign.getProperty("backgroundAttachment"));
        for (ElementPropertyDefn prop : reportDesign.getProperties()) {
            ElementDefnTest.assertFalse((boolean)prop.isStyleProperty());
        }
    }

    public void testPropertyVisiblity() {
        IElementDefn dataSetDefn = MetaDataDictionary.getInstance().getElement("OdaDataSet");
        for (ElementPropertyDefn prop : dataSetDefn.getLocalProperties()) {
            if ("resultSetName".equalsIgnoreCase(prop.getName()) || "privateDriverProperties".equalsIgnoreCase(prop.getName()) || "designerState".equalsIgnoreCase(prop.getName()) || "extensionID".equalsIgnoreCase(prop.getName()) || "resultSet".equalsIgnoreCase(prop.getName()) || "parameters".equalsIgnoreCase(prop.getName())) {
                ElementDefnTest.assertFalse((boolean)dataSetDefn.isPropertyVisible(prop.getName()));
                continue;
            }
            ElementDefnTest.assertTrue((boolean)dataSetDefn.isPropertyVisible(prop.getName()));
        }
        IElementDefn reportItemDefn = MetaDataDictionary.getInstance().getElement("ReportItem");
        ElementDefnTest.assertFalse((boolean)reportItemDefn.isPropertyVisible("cube"));
        IElementDefn dataDefn = MetaDataDictionary.getInstance().getElement("Data");
        ElementDefnTest.assertFalse((boolean)dataDefn.isPropertyVisible("cube"));
    }
}

