/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import com.ibm.icu.util.ULocale;
import java.util.Iterator;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.MetadataTestUtil;
import org.eclipse.birt.report.model.metadata.ObjectDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefnFake;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ObjectDefnTest
extends BaseTestCase {
    private ObjectDefn obj = new ObjectDefn("TestObject");

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        ThreadResources.setLocale((ULocale)TEST_LOCALE);
        MetadataTestUtil.setDisplayNameKey((ObjectDefn)this.obj, (String)"Element.ReportDesign");
    }

    public void testGetterAndSetter() {
        ObjectDefnTest.assertEquals((String)"TestObject", (String)this.obj.getName());
        MetadataTestUtil.setName((ObjectDefn)this.obj, (String)"New Object Name");
        ObjectDefnTest.assertEquals((String)"\u62a5\u8868", (String)this.obj.getDisplayName());
        ObjectDefnTest.assertEquals((String)"New Object Name", (String)this.obj.getName());
    }

    public void testAddThreeProperty() {
        PropertyDefnFake propertyA = new PropertyDefnFake();
        PropertyDefnFake propertyB = new PropertyDefnFake();
        PropertyDefnFake propertyC = new PropertyDefnFake();
        propertyA.setName("property A");
        propertyB.setName("property B");
        propertyC.setName("property C");
        try {
            MetadataTestUtil.addPropertyDefn((ObjectDefn)this.obj, (PropertyDefn)propertyA);
            MetadataTestUtil.addPropertyDefn((ObjectDefn)this.obj, (PropertyDefn)propertyB);
            MetadataTestUtil.addPropertyDefn((ObjectDefn)this.obj, (PropertyDefn)propertyC);
        }
        catch (MetaDataException metaDataException) {
            ObjectDefnTest.fail();
        }
        Iterator iter = this.obj.getPropertyIterator();
        while (iter.hasNext()) {
            PropertyDefn property = (PropertyDefn)iter.next();
            ObjectDefnTest.assertTrue((property.getName().equals("property A") || property.getName().equals("property B") || property.getName().equals("property C") ? 1 : 0) != 0);
        }
        ObjectDefnTest.assertSame((Object)((Object)propertyA), (Object)this.obj.findProperty(propertyA.getName()));
        ObjectDefnTest.assertSame((Object)((Object)propertyB), (Object)this.obj.findProperty(propertyB.getName()));
        ObjectDefnTest.assertSame((Object)((Object)propertyC), (Object)this.obj.findProperty(propertyC.getName()));
        ObjectDefnTest.assertNull((Object)this.obj.findProperty("Unexisting"));
    }

    public void testAddSameProperty() {
        PropertyDefnFake propertyA = new PropertyDefnFake();
        propertyA.setName("property A");
        try {
            MetadataTestUtil.addPropertyDefn((ObjectDefn)this.obj, (PropertyDefn)propertyA);
            MetadataTestUtil.addPropertyDefn((ObjectDefn)this.obj, (PropertyDefn)propertyA);
            ObjectDefnTest.fail((String)"MetaDataException should be thrown because the name exists !");
        }
        catch (MetaDataException e) {
            ObjectDefnTest.assertEquals((String)"DUPLICATE_PROPERTY", (String)e.getErrorCode());
        }
    }
}

