/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.List;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.FreeForm;
import org.eclipse.birt.report.model.elements.Label;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.MetaDataParserException;
import org.eclipse.birt.report.model.metadata.MetadataTestUtil;
import org.eclipse.birt.report.model.metadata.SemanticTriggerDefn;
import org.eclipse.birt.report.model.metadata.SlotDefn;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class SlotDefnTest
extends BaseTestCase {
    SlotDefn slotDefn = null;

    public void testGetterAndSetter() throws DesignFileException {
        this.slotDefn = new SlotDefn();
        MetadataTestUtil.setMultipleCardinality((SlotDefn)this.slotDefn, (boolean)true);
        MetadataTestUtil.setDisplayNameKey((SlotDefn)this.slotDefn, (String)"Element.ReportDesign.slot.styles");
        MetadataTestUtil.setName((SlotDefn)this.slotDefn, (String)"Name");
        MetadataTestUtil.setID((SlotDefn)this.slotDefn, (int)99);
        SlotDefnTest.assertEquals((boolean)true, (boolean)this.slotDefn.isMultipleCardinality());
        SlotDefnTest.assertEquals((String)"Styles", (String)this.slotDefn.getDisplayName());
        SlotDefnTest.assertEquals((String)"Element.ReportDesign.slot.styles", (String)this.slotDefn.getDisplayNameID());
        SlotDefnTest.assertEquals((String)"Name", (String)this.slotDefn.getName());
        SlotDefnTest.assertEquals((int)99, (int)this.slotDefn.getSlotID());
    }

    public void testCanContain() {
        IElementDefn elementDefn = MetaDataDictionary.getInstance().getElement("FreeForm");
        SlotDefnTest.assertNotNull((Object)elementDefn);
        this.slotDefn = (SlotDefn)elementDefn.getSlot(0);
        FreeForm container = new FreeForm();
        Label label = new Label();
        Cell cell = new Cell();
        SlotDefnTest.assertTrue((boolean)this.slotDefn.canContain((DesignElement)container));
        SlotDefnTest.assertTrue((boolean)this.slotDefn.canContain((DesignElement)label));
        SlotDefnTest.assertFalse((boolean)this.slotDefn.canContain((DesignElement)cell));
        SlotDefnTest.assertTrue((boolean)this.slotDefn.canContain(MetaDataDictionary.getInstance().getElement("FreeForm")));
        SlotDefnTest.assertTrue((boolean)this.slotDefn.canContain(MetaDataDictionary.getInstance().getElement("Label")));
        SlotDefnTest.assertFalse((boolean)this.slotDefn.canContain(MetaDataDictionary.getInstance().getElement("Cell")));
        SlotDefnTest.assertTrue((this.slotDefn.getContentExtendedElements().size() > 0 ? 1 : 0) != 0);
    }

    public void testBuild() throws MetaDataException {
        this.slotDefn = new SlotDefn();
        try {
            MetadataTestUtil.build((SlotDefn)this.slotDefn);
            SlotDefnTest.fail();
        }
        catch (MetaDataException metaDataException) {}
        try {
            MetadataTestUtil.addType((SlotDefn)this.slotDefn, (String)"FreeForm");
            MetadataTestUtil.addType((SlotDefn)this.slotDefn, (String)"Label");
            MetadataTestUtil.build((SlotDefn)this.slotDefn);
            SlotDefnTest.fail();
        }
        catch (MetaDataException metaDataException) {}
        MetadataTestUtil.setDisplayNameKey((SlotDefn)this.slotDefn, (String)"Element.ReportDesign.slot.body");
        MetadataTestUtil.build((SlotDefn)this.slotDefn);
        SlotDefnTest.assertFalse((boolean)this.slotDefn.canContain(MetaDataDictionary.getInstance().getElement("DataSource")));
        SlotDefnTest.assertTrue((boolean)this.slotDefn.canContain(MetaDataDictionary.getInstance().getElement("Label")));
        SlotDefnTest.assertEquals((String)"Body", (String)this.slotDefn.getDisplayName());
    }

    public void testSemanticValidator() throws MetaDataParserException {
        IElementDefn groupDefn = MetaDataDictionary.getInstance().getElement("TableGroup");
        SlotDefn headerDefn = (SlotDefn)groupDefn.getSlot(0);
        List validators = headerDefn.getTriggerDefnSet().getTriggerList();
        SlotDefnTest.assertTrue((boolean)this.hasValidator(validators, "InconsistentColumnsValidator"));
    }

    private boolean hasValidator(List validators, String name) {
        for (SemanticTriggerDefn defn : validators) {
            if (!defn.getValidatorName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

