/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DataGroupHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.SortKeyHandle;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class DataGroupParseTest
extends BaseTestCase {
    private static final String FILE_NAME = "DataGroupParseTest.xml";

    public void testParser() throws Exception {
        this.openDesign(FILE_NAME);
        ExtendedItemHandle action1 = (ExtendedItemHandle)this.designHandle.findElement("action1");
        List groups = action1.getListProperty("dataGroups");
        DataGroupHandle group = (DataGroupHandle)groups.get(0);
        DataGroupParseTest.assertEquals((String)"group test", (String)group.getGroupName());
        DataGroupParseTest.assertEquals((String)"[Country]", (String)group.getKeyExpr());
        DataGroupParseTest.assertEquals((String)"week", (String)group.getInterval());
        DataGroupParseTest.assertTrue((3.0 == group.getIntervalRange() ? 1 : 0) != 0);
        DataGroupParseTest.assertEquals((String)"2008-1-1", (String)group.getIntervalBase());
        DataGroupParseTest.assertEquals((String)"desc", (String)group.getSortDirection());
        DataGroupParseTest.assertEquals((String)"sort-on-group-key", (String)group.getSortType());
        Iterator sorts = group.sortsIterator();
        SortKeyHandle sortHandle = (SortKeyHandle)sorts.next();
        DataGroupParseTest.assertEquals((String)"name", (String)sortHandle.getKey());
        DataGroupParseTest.assertEquals((String)"asc", (String)sortHandle.getDirection());
        sortHandle = (SortKeyHandle)sorts.next();
        DataGroupParseTest.assertEquals((String)"birthday", (String)sortHandle.getKey());
        DataGroupParseTest.assertEquals((String)"desc", (String)sortHandle.getDirection());
        Iterator filters = group.filtersIterator();
        FilterConditionHandle filterHandle = (FilterConditionHandle)filters.next();
        DataGroupParseTest.assertEquals((String)"lt", (String)filterHandle.getOperator());
        DataGroupParseTest.assertEquals((String)"filter expression", (String)filterHandle.getExpr());
        DataGroupParseTest.assertEquals((String)"value1 expression", (String)filterHandle.getValue1());
        DataGroupParseTest.assertEquals((String)"value2 expression", (String)filterHandle.getValue2());
    }

    public void testWriter() throws Exception {
        this.openDesign(FILE_NAME);
        ExtendedItemHandle action1 = (ExtendedItemHandle)this.designHandle.findElement("action1");
        List groups = action1.getListProperty("dataGroups");
        DataGroupHandle group = (DataGroupHandle)groups.get(0);
        String updatedPrefix = "updated ";
        group.setGroupName(String.valueOf(updatedPrefix) + group.getGroupName());
        group.setKeyExpr(String.valueOf(updatedPrefix) + group.getKeyExpr());
        group.setInterval("day");
        group.setIntervalRange(1.0);
        group.setIntervalBase(String.valueOf(updatedPrefix) + group.getIntervalBase());
        group.setSortDirection("asc");
        group.setSortType("complex-sort");
        this.save();
        DataGroupParseTest.assertTrue((boolean)this.compareFile("DataGroupParseTest_golden.xml"));
    }
}

