/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.List;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.GraphicMasterPageHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.elements.GraphicMasterPage;
import org.eclipse.birt.report.model.elements.ImageItem;
import org.eclipse.birt.report.model.elements.MasterPage;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ImageItemParseTest
extends BaseTestCase {
    protected ImageItem image;
    protected ImageHandle handle;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    private ImageItem findImageItemByName(String name) {
        NameSpace ns = this.design.getNameHelper().getNameSpace(1);
        ImageItemParseTest.assertTrue((boolean)ns.contains(name));
        this.image = (ImageItem)ns.getElement(name);
        this.handle = this.image.handle((Module)this.design);
        return this.image;
    }

    public void testImageContainer() throws Exception {
        this.openDesign("ImageItemParseTest.xml");
        this.image = this.findImageItemByName("Image1");
        DesignElement o = this.image.getContainer();
        ImageItemParseTest.assertTrue((boolean)(o instanceof MasterPage));
        GraphicMasterPage page = (GraphicMasterPage)this.design.findPage("My Page");
        GraphicMasterPageHandle mHandle = page.handle((Module)this.design);
        SlotHandle sHandle = mHandle.getContent();
        DesignElementHandle imageHandle = sHandle.get(2);
        ImageItemParseTest.assertTrue((boolean)(imageHandle instanceof ImageHandle));
        ImageItemParseTest.assertEquals((String)"Image1", (String)((ImageHandle)imageHandle).getElement().getName());
        imageHandle = sHandle.get(3);
        ImageItemParseTest.assertTrue((boolean)(imageHandle instanceof ImageHandle));
        ImageItemParseTest.assertEquals((String)"Image2", (String)((ImageHandle)imageHandle).getElement().getName());
    }

    public void testReadProperties() throws Exception {
        this.openDesign("ImageItemParseTest.xml");
        this.image = this.findImageItemByName("Image1");
        double scale = this.handle.getScale();
        ImageItemParseTest.assertTrue((scale == 0.8 ? 1 : 0) != 0);
        ImageItemParseTest.assertEquals((String)"figure", (String)this.handle.getRole());
        String size = this.handle.getSize();
        ImageItemParseTest.assertEquals((String)"scale-to-item", (String)size);
        String helpText = this.handle.getAltText();
        ImageItemParseTest.assertEquals((String)"Help Test For Image Item", (String)helpText);
        String refType = this.handle.getSource();
        ImageItemParseTest.assertEquals((String)"url", (String)refType);
        String url = this.handle.getURI();
        ImageItemParseTest.assertEquals((String)"http://www.eclipse.org/birt/test/1.jpg", (String)url);
        ImageItemParseTest.assertEquals((String)"hyperlink", (String)this.handle.getActionHandle().getLinkType());
        ImageItemParseTest.assertFalse((boolean)this.handle.fitToContainer());
        ImageItemParseTest.assertTrue((boolean)this.handle.isProportionalScale());
        this.image = this.findImageItemByName("Image2");
        refType = this.handle.getSource();
        ImageItemParseTest.assertEquals((String)"embed", (String)refType);
        String imageName = this.handle.getImageName();
        ImageItemParseTest.assertEquals((String)"image2.jpg", (String)imageName);
        helpText = this.handle.getHelpText();
        ImageItemParseTest.assertEquals((String)"Image2-Help-Text", (String)helpText);
        this.image = this.findImageItemByName("Image3");
        refType = this.handle.getSource();
        ImageItemParseTest.assertEquals((String)"expr", (String)refType);
        String typeExpression = this.handle.getTypeExpression();
        ImageItemParseTest.assertEquals((String)"Type Expression", (String)typeExpression);
        String valueExpression = this.handle.getValueExpression();
        ImageItemParseTest.assertEquals((String)"Value Expression", (String)valueExpression);
        helpText = this.handle.getHelpText();
        ImageItemParseTest.assertEquals((String)"Help Text", (String)helpText);
        this.image = this.findImageItemByName("Image4");
        ActionHandle actionHandle = this.image.handle((Module)this.design).getActionHandle();
        ImageItemParseTest.assertNull((Object)actionHandle);
        this.image = this.findImageItemByName("Body Image");
        this.handle = this.image.handle((Module)this.design);
        ImageItemParseTest.assertEquals((int)6, (int)this.handle.getContainer().findContentSlot((DesignElementHandle)this.handle));
        ImageItemParseTest.assertEquals((String)"bodyImage.jpg", (String)this.handle.getImageName());
        ImageItemParseTest.assertEquals((String)"BodyImage-Help-Text", (String)this.handle.getHelpText());
        ImageItemParseTest.assertEquals((String)"Body Image Key", (String)this.handle.getHelpTextKey());
        actionHandle = this.handle.getActionHandle();
        ImageItemParseTest.assertNotNull((Object)actionHandle);
        ImageItemParseTest.assertEquals((String)"http://localhost:8080/bodyImage.jpg", (String)actionHandle.getURI());
        ImageItemParseTest.assertTrue((boolean)this.handle.fitToContainer());
        ImageItemParseTest.assertEquals((String)"Div", (String)this.handle.getRole());
        ImageItemParseTest.assertEquals((String)"English", (String)this.handle.getLanguage());
        ImageItemParseTest.assertEquals((int)1, (int)this.handle.getOrder());
    }

    public void testErrors() {
        try {
            this.openDesign("ImageItemParseTest_1.xml");
            ImageItemParseTest.fail();
        }
        catch (DesignFileException e) {
            List errors = e.getErrorList();
            ImageItemParseTest.assertEquals((int)2, (int)errors.size());
            int i = 0;
            ImageItemParseTest.assertEquals((String)"Error.DesignParserException.IMAGE_REF_CONFLICT", (String)((ErrorDetail)e.getErrorList().get(i++)).getErrorCode());
            ImageItemParseTest.assertEquals((String)"Error.DesignParserException.INVALID_IMAGEREF_EXPR_VALUE", (String)((ErrorDetail)e.getErrorList().get(i++)).getErrorCode());
        }
    }

    public void testImageDefaultProperties() throws Exception {
        this.openDesign("ImageItemParseTest.xml");
        this.image = this.findImageItemByName("Image3");
        ImageItemParseTest.assertNotNull((Object)this.image);
        String size = this.handle.getSize();
        ImageItemParseTest.assertEquals((String)"size-to-image", (String)size);
        String helpText = this.handle.getAltText();
        ImageItemParseTest.assertNull((Object)helpText);
        double scale = this.handle.getScale();
        ImageItemParseTest.assertTrue((scale == 1.0 ? 1 : 0) != 0);
    }

    public void testWriteProperties() throws Exception {
        this.openDesign("ImageItemParseTest.xml");
        this.image = this.findImageItemByName("Image1");
        this.handle = this.image.handle((Module)this.design);
        this.handle.setProportionalScale(false);
        this.image = this.findImageItemByName("Image2");
        this.handle = this.image.handle((Module)this.design);
        this.handle.setName("ImageTwo");
        ImageItemParseTest.assertEquals((String)"ImageTwo", (String)this.handle.getName());
        this.handle.setSize("size-to-image");
        ImageItemParseTest.assertTrue((this.handle.getSize().compareToIgnoreCase("size-to-image") == 0 ? 1 : 0) != 0);
        this.handle.setScale(4.0);
        ImageItemParseTest.assertTrue((4.0 == this.handle.getScale() ? 1 : 0) != 0);
        this.handle.setImageName("image_two.jpg");
        ImageItemParseTest.assertEquals((String)"image_two.jpg", (String)this.handle.getImageName());
        this.image = this.findImageItemByName("Image3");
        this.handle.setTypeExpression("HelloType");
        ImageItemParseTest.assertEquals((String)"HelloType", (String)this.handle.getTypeExpression());
        this.handle.setValueExpression("HelloValue");
        ImageItemParseTest.assertEquals((String)"HelloValue", (String)this.handle.getValueExpression());
        this.image = this.findImageItemByName("Body Image");
        this.handle = this.image.handle((Module)this.design);
        this.handle.setImageName("BodyImage");
        this.handle.setBookmark("No bookmark");
        ActionHandle actionHandle = this.handle.getActionHandle();
        actionHandle.setURI("http://localhost/body.jpg");
        this.handle.setHelpText("new body image help text");
        this.handle.setHelpTextKey("new resource key for body image help text");
        this.handle.setFitToContainer(false);
        this.handle.setRole("Figure");
        this.handle.setLanguage("English");
        this.handle.setOrder(1);
        this.save();
        ImageItemParseTest.assertTrue((boolean)this.compareFile("ImageItemParseTest_golden.xml"));
    }

    public void testImageFileExist() throws Exception {
        this.openDesign("ImageItemParseTest_2.xml");
        ErrorDetail detail = (ErrorDetail)this.designHandle.getWarningList().get(0);
        ImageItemParseTest.assertEquals((String)"Error.SemanticError.UNSUPPORTED_ELEMENT", (String)detail.getErrorCode());
        detail = (ErrorDetail)this.designHandle.getWarningList().get(1);
        ImageItemParseTest.assertEquals((String)"Error.SemanticError.UNSUPPORTED_ELEMENT", (String)detail.getErrorCode());
        ImageHandle imageHandle = (ImageHandle)this.designHandle.findElement("image2");
        ImageItemParseTest.assertNotNull((Object)imageHandle);
    }
}

