/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import com.ibm.icu.util.ULocale;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetParameterHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.PrivateStyleHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextDataHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.DataItem;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ParserCompatibilityTest
extends BaseTestCase {
    private String resultSetClearFileName = "CompatibleResultSetClearTest.xml";
    private String resultSetHintClearFileName = "CompatibleResultSetHintClearTest.xml";
    private String resouceFileName = "CompatibleResourceFileTest.xml";

    public void testClearResultSet() throws Exception {
        this.openDesign(this.resultSetClearFileName);
        OdaDataSetHandle odaHandle = (OdaDataSetHandle)this.designHandle.getElementByID(5L);
        ParserCompatibilityTest.assertNull((Object)odaHandle.getListProperty("resultSet"));
    }

    public void testClearResultSetHint() throws Exception {
        this.openDesign(this.resultSetHintClearFileName);
        OdaDataSetHandle odaHandle = (OdaDataSetHandle)this.designHandle.getElementByID(5L);
        ParserCompatibilityTest.assertNull((Object)odaHandle.getListProperty("resultSetHints"));
    }

    public void testPrivateOdaDriverProperties() throws Exception {
        this.openDesign("CompatiblePublicOdaDriverProperties.xml");
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("CompatiblePublicOdaDriverProperties_golden.xml"));
        this.openDesign("CompatiblePrivateOdaDriverProperties.xml");
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("CompatiblePrivateOdaDriverProperties_golden.xml"));
    }

    public void testOldOdaDriverModelPropertyName() throws Exception {
        this.openDesign("CompatibleOldOdaDriverModelProperty.xml");
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("CompatibleOldOdaDriverModelProperty_golden.xml"));
    }

    public void testOdaDriverModelExtensionPoint() throws Exception {
        this.openDesign("CompatibleOdaDriverModelProperty.xml");
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("CompatibleOdaDriverModelProperty_golden.xml"));
    }

    public void testEncryptedProperty() throws Exception {
        this.openDesign("CompatibleEncryptedProperty.xml");
        this.save();
    }

    public void testComputedColumnsProperty() throws Exception {
        this.openDesign("CompatibleComputedColumnProperty.xml");
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("CompatibleComputedColumnProperty_golden.xml"));
    }

    public void testOdaDataSetproperty() throws Exception {
        this.openDesign("CompatibleOdaDataSetProperty.xml");
        OdaDataSetHandle dataSetHandle = (OdaDataSetHandle)this.designHandle.findDataSet("dataset1");
        ParserCompatibilityTest.assertNotNull((Object)dataSetHandle);
        ParserCompatibilityTest.assertEquals(null, (String)dataSetHandle.getQueryScript());
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("CompatibleOdaDataSetProperty_golden.xml"));
    }

    public void testDataSetCachedRowCount() throws Exception {
        this.openDesign("CompatibleDataSetCachedRowCount.xml");
        OdaDataSetHandle dataSetHandle = (OdaDataSetHandle)this.designHandle.findDataSet("Data Set");
        ParserCompatibilityTest.assertNotNull((Object)dataSetHandle);
        ParserCompatibilityTest.assertEquals((int)500, (int)dataSetHandle.getCachedRowCount());
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("CompatibleDataSetCachedRowCount_golden.xml"));
    }

    public void testReportProperty() throws Exception {
        this.openDesign("CompatibleReportProperties.xml");
        ParserCompatibilityTest.assertEquals((String)"message", (String)this.designHandle.getIncludeResource());
        ParserCompatibilityTest.assertEquals((String)"cheet sheet", (String)this.designHandle.getCheatSheet());
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("CompatibleReportProperties_golden.xml"));
    }

    public void testListingGroupProperty() throws Exception {
        this.openDesign("CompatibleListingGroupProperties.xml");
        ListHandle list = (ListHandle)this.designHandle.findElement("My List");
        SlotHandle groupSlot = list.getGroups();
        GroupHandle group = (GroupHandle)groupSlot.get(0);
        ParserCompatibilityTest.assertEquals((String)"2004/12/12", (String)group.getGroupStart());
        group.setGroupStart("101");
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("CompatibleListingGroupProperties_golden.xml"));
    }

    public void testTextDataProperty() throws Exception {
        this.openDesign("CompatibleTextDataProperties.xml");
        TextDataHandle dataHandle = (TextDataHandle)this.designHandle.findElement("Multi Line Data");
        ParserCompatibilityTest.assertNotNull((Object)dataHandle.getElement());
        ParserCompatibilityTest.assertEquals((String)"value expr", (String)dataHandle.getValueExpr());
        ParserCompatibilityTest.assertEquals((String)"content type expr", (String)dataHandle.getContentTypeExpr());
        ParserCompatibilityTest.assertEquals((String)"content type expr", (String)dataHandle.getContentType());
        dataHandle = (TextDataHandle)this.designHandle.findElement("Text Data");
        ParserCompatibilityTest.assertEquals((String)"rtf", (String)dataHandle.getContentType());
        dataHandle.setContentType("plain");
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("CompatibleTextDataProperties_golden.xml"));
    }

    public void testOdaDataSourceWithDriverNameAndExtensionName() throws Exception {
        this.openDesign("CompatibleOdaDataSourceWithDriverNameOrExtensionName.xml");
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("CompatibleOdaDataSourceWithDriverNameOrExtensionName_golden.xml"));
    }

    public void testOdaDataSetWithType() throws Exception {
        this.openDesign("CompatibleOdaDataSetWithType.xml");
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("CompatibleOdaDataSetWithType_golden.xml"));
    }

    public void testDataSetParamWithIsNullable() throws Exception {
        this.openDesign("CompatibleDataSetParamWithIsNullable.xml");
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("CompatibleDataSetParamWithIsNullable_golden.xml"));
    }

    public void testTableItemHighlightRule() throws Exception {
        this.openDesign("TableItemCompatibleTest.xml");
        TableHandle tableHandle = (TableHandle)this.designHandle.findElement("My table");
        ParserCompatibilityTest.assertNotNull((Object)tableHandle);
        PrivateStyleHandle styleHandle = (PrivateStyleHandle)tableHandle.getPrivateStyle();
        Iterator highlightHandles = styleHandle.highlightRulesIterator();
        HighlightRuleHandle highlightHandle = (HighlightRuleHandle)highlightHandles.next();
        ParserCompatibilityTest.assertNotNull((Object)highlightHandle);
        ParserCompatibilityTest.assertEquals((String)"[this]", (String)highlightHandle.getTestExpression());
        ParserCompatibilityTest.assertEquals((String)"is-null", (String)highlightHandle.getOperator());
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("TableHighlightRuleCompatible_golden.xml"));
    }

    public void testDataHighlightRule() throws Exception {
        this.openDesign("DataItemCompatibleTest.xml");
        DataItem data = (DataItem)this.design.findElement("Body Data");
        DataItemHandle dataHandle = (DataItemHandle)data.getHandle((Module)this.design);
        ParserCompatibilityTest.assertNotNull((Object)dataHandle);
        PrivateStyleHandle styleHandle = (PrivateStyleHandle)dataHandle.getPrivateStyle();
        Iterator highlightHandles = styleHandle.highlightRulesIterator();
        HighlightRuleHandle highlightHandle = (HighlightRuleHandle)highlightHandles.next();
        ParserCompatibilityTest.assertNotNull((Object)highlightHandle);
        ParserCompatibilityTest.assertEquals((String)"[this]", (String)highlightHandle.getTestExpression());
        ParserCompatibilityTest.assertEquals((String)"is-null", (String)highlightHandle.getOperator());
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("DataItemHighlightRuleCompatible_golden.xml"));
    }

    public void testWrongExtensionID() throws Exception {
        this.openDesign("WrongExtensionID.xml");
        this.save();
        OdaDataSetHandle setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("dataset1");
        ParserCompatibilityTest.assertNull((Object)setHandle.getProperty("queryScript"));
        ParserCompatibilityTest.assertEquals((String)"1", (String)setHandle.getStringProperty("tmpVar"));
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("WrongExtensionID_golden.xml"));
    }

    public void testOnMumbleProperty() throws Exception {
        this.openDesign("TableOnMumbleCompatibleTest.xml");
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("TableOnMumbleCompatibleTest_golden.xml"));
    }

    public void testIncludedLibraryCompatible() throws Exception {
        this.openDesign("IncludedLibraryCompatibleTest.xml");
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("IncludedLibraryCompatibleTest_golden.xml"));
    }

    public void testCompatibilityOfPageBreaks() throws Exception {
        this.openDesign("CompatiblePageBreaks.xml");
        TableHandle table = (TableHandle)this.designHandle.findElement("table1");
        ParserCompatibilityTest.assertEquals((Object)"auto", (Object)table.getProperty("pageBreakAfter"));
        ParserCompatibilityTest.assertEquals((Object)"always", (Object)table.getProperty("pageBreakBefore"));
        ParserCompatibilityTest.assertEquals((Object)"auto", (Object)((GroupHandle)table.getGroups().get(0)).getProperty("pageBreakAfter"));
        ParserCompatibilityTest.assertEquals((Object)"inherit", (Object)((GroupHandle)table.getGroups().get(0)).getHeader().get(0).getProperty("pageBreakAfter"));
        ParserCompatibilityTest.assertEquals((Object)"always", (Object)((GroupHandle)table.getGroups().get(0)).getFooter().get(0).getProperty("pageBreakAfter"));
    }

    public void testScalarParameterFormatCompatible() throws Exception {
        this.openDesign("CompatibleScalarParameterFormat.xml");
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("CompatibleScalarParameterFormat_golden.xml"));
    }

    public void testObsoleteParser() throws Exception {
        this.openDesign("TextDataItemParseTest_obsolete.xml");
        TextDataHandle dataHandle = (TextDataHandle)this.designHandle.findElement("Multi Line Data");
        ParserCompatibilityTest.assertNotNull((Object)dataHandle.getElement());
        ParserCompatibilityTest.assertEquals((String)"value expr", (String)dataHandle.getValueExpr());
        ParserCompatibilityTest.assertEquals((String)"content type expr", (String)dataHandle.getContentTypeExpr());
    }

    public void testImageName() throws Exception {
        this.openDesign("CompatibleImageNameParseTest.xml");
        ImageHandle image = (ImageHandle)this.designHandle.findElement("Image1");
        ParserCompatibilityTest.assertNull((Object)image.getProperty("boundDataColumns"));
        ParserCompatibilityTest.assertEquals((String)"image.jpg1", (String)image.getImageName());
    }

    public void testFlatfileExtendsionId() throws Exception {
        this.openDesign("CompatibleFlatFileExtensionId.xml");
        OdaDataSourceHandle source = (OdaDataSourceHandle)this.designHandle.findDataSource("Data Source1");
        ParserCompatibilityTest.assertEquals((String)"org.eclipse.datatools.connectivity.oda.flatfile", (String)source.getExtensionID());
        OdaDataSetHandle set = (OdaDataSetHandle)this.designHandle.findDataSet("Data Set1");
        ParserCompatibilityTest.assertEquals((String)"org.eclipse.datatools.connectivity.oda.flatfile.dataSet", (String)set.getExtensionID());
    }

    public void testOdaResultSets() throws Exception {
        this.openDesign("CompatibleOdaResultSetTest.xml");
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("CompatibleOdaResultSet_golden.xml"));
    }

    public void testScriptDataSetResultSets() throws Exception {
        this.openDesign("CompatibleScriptDataSetResultSets.xml");
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("CompatibleScriptDataSetResultSets_golden.xml"));
    }

    public void testMigrateNameSpace() throws Exception {
        this.openDesign("CompatibleConvertExtensionId.xml");
        OdaDataSourceHandle dataSource = (OdaDataSourceHandle)this.designHandle.findDataSource("Data Source");
        ParserCompatibilityTest.assertNotNull((Object)dataSource);
        ParserCompatibilityTest.assertEquals((String)"org.eclipse.datatools.enablement.oda.xml", (String)dataSource.getExtensionID());
        OdaDataSetHandle dataSet = (OdaDataSetHandle)this.designHandle.findDataSet("Data Set");
        ParserCompatibilityTest.assertNotNull((Object)dataSet);
        ParserCompatibilityTest.assertEquals((String)"org.eclipse.datatools.enablement.oda.xml.dataSet", (String)dataSet.getExtensionID());
    }

    public void testTOC() throws Exception {
        this.openDesign("CompatibleTOC.xml");
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("CompatibleTOC_golden.xml"));
        this.openDesign("CompatibleTOC_1.xml");
        TableHandle table1 = (TableHandle)this.designHandle.findElement("My table");
        GroupHandle group = (GroupHandle)table1.getGroups().get(0);
        ParserCompatibilityTest.assertEquals((String)"[Country]", (String)group.getTocExpression());
        ParserCompatibilityTest.assertEquals((String)"[Country]", (String)group.getTOC().getExpression());
        ListHandle list1 = (ListHandle)this.designHandle.findElement("My List");
        group = (GroupHandle)list1.getGroups().get(0);
        ParserCompatibilityTest.assertEquals((String)"[Country]", (String)group.getTocExpression());
        ParserCompatibilityTest.assertEquals((String)"[Country]", (String)group.getTOC().getExpression());
    }

    public void testODAPrivateProperties() throws Exception {
        this.openDesign("CompatibleOdaPrivateProps.xml");
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("CompatibleOdaPrivateProps_golden.xml"));
    }

    public void testScalarParamAllowProps() throws Exception {
        this.openDesign("CompatibleScalarParamAllowPropsTest.xml");
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("CompatibleScalarParamAllowPropsTest_golden.xml"));
    }

    public void testColumnBinding() throws Exception {
        this.openDesign("CompatibleColumnBindingTest.xml");
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("CompatibleColumnBindingTest_golden.xml"));
    }

    public void testCompatibileLevelName() throws Exception {
        this.openDesign("CompatibleLevelName.xml");
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("CompatibleLevelName_golden.xml"));
    }

    public void testCompatibleInvalidCharsInName() throws Exception {
        this.openDesign("CompatibleInvalidCharsInName.xml");
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("CompatibleInvalidCharsInName_golden.xml"));
    }

    public void testIncludeResource() throws DesignFileException {
        this.openDesign(this.resouceFileName, ULocale.ENGLISH);
        List list = this.designHandle.getListProperty("includeResource");
        ParserCompatibilityTest.assertEquals((int)1, (int)list.size());
        ParserCompatibilityTest.assertEquals((Object)"library", list.get(0));
    }

    public void testCDATAParser() throws Exception {
        this.openDesign("CompatibleCDATAParseTest.xml");
        TextItemHandle text = (TextItemHandle)this.designHandle.findElement("text1");
        ParserCompatibilityTest.assertEquals((String)"text & < > ' \" static", (String)text.getContent());
        text = (TextItemHandle)this.designHandle.findElement("text2");
        ParserCompatibilityTest.assertEquals((String)"text &amp; &lt; &gt; &apos; &quot; static", (String)text.getContent());
        text = (TextItemHandle)this.designHandle.findElement("text3");
        ParserCompatibilityTest.assertEquals((String)"]]&gt;\n\n\n]]&gt; ]] &amp;gt; &amp;&amp;gt;", (String)text.getOnPrepare());
        this.save();
        this.saveOutputFile("CompatibleCDATAParseTest_golden.xml");
    }

    public void testScalarParamSortBy() throws Exception {
        this.openDesign("CompatibleSortByParseTest.xml");
        ScalarParameterHandle paramHandle = (ScalarParameterHandle)this.designHandle.getParameters().get(0);
        ExpressionHandle exprHandle = paramHandle.getExpressionProperty("sortByColumn");
        ParserCompatibilityTest.assertNotNull((Object)exprHandle);
        ParserCompatibilityTest.assertTrue((boolean)(exprHandle.getValue() instanceof Expression));
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("CompatibleSortByParseTest_golden.xml"));
    }

    public void testParameterType() throws Exception {
        this.openDesign("CompatibleParameterTypeTest.xml");
        SlotHandle params = this.designHandle.getParameters();
        ScalarParameterHandle handle = (ScalarParameterHandle)params.get(0);
        ParserCompatibilityTest.assertEquals((String)"any", (String)handle.getDataType());
        handle = (ScalarParameterHandle)params.get(1);
        ParserCompatibilityTest.assertEquals((String)"string", (String)handle.getDataType());
        try {
            handle.setDataType("any");
            ParserCompatibilityTest.fail();
        }
        catch (PropertyValueException e) {
            ParserCompatibilityTest.assertEquals((String)"Error.PropertyValueException.CHOICE_NOT_FOUND", (String)e.getErrorCode());
        }
        OdaDataSetHandle dataSet = (OdaDataSetHandle)this.designHandle.findDataSet("firstDataSet");
        Iterator parameters = dataSet.parametersIterator();
        OdaDataSetParameterHandle parameter = (OdaDataSetParameterHandle)parameters.next();
        ParserCompatibilityTest.assertEquals((String)"any", (String)parameter.getDataType());
        parameter = (OdaDataSetParameterHandle)parameters.next();
        ParserCompatibilityTest.assertEquals((String)"string", (String)parameter.getDataType());
        try {
            handle.setDataType("any");
            ParserCompatibilityTest.fail();
        }
        catch (PropertyValueException e) {
            ParserCompatibilityTest.assertEquals((String)"Error.PropertyValueException.CHOICE_NOT_FOUND", (String)e.getErrorCode());
        }
        JointDataSetHandle jointDataSet = (JointDataSetHandle)this.designHandle.findDataSet("JointDataSet");
        parameters = jointDataSet.parametersIterator();
        parameter = (DataSetParameterHandle)parameters.next();
        ParserCompatibilityTest.assertEquals((String)"any", (String)parameter.getDataType());
        parameter = (DataSetParameterHandle)parameters.next();
        ParserCompatibilityTest.assertEquals((String)"string", (String)parameter.getDataType());
        try {
            handle.setDataType("any");
            ParserCompatibilityTest.fail();
        }
        catch (PropertyValueException e) {
            ParserCompatibilityTest.assertEquals((String)"Error.PropertyValueException.CHOICE_NOT_FOUND", (String)e.getErrorCode());
        }
    }

    public void testNewHandlerOnEachEventProp() throws Exception {
        this.openDesign("CompatibleNewHandlerOnEachEventPropTest.xml");
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("CompatibleNewHandlerOnEachEventPropTest_golden.xml"));
    }

    public void testPageMargin() throws Exception {
        this.openDesign("CompatiblePageMarginTest.xml");
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("CompatiblePageMarginTest_golden.xml"));
    }

    public void testExtendedPageMargin() throws Exception {
        this.openDesign("CompatibleExtendedPageMarginTest.xml");
        SimpleMasterPageHandle page = (SimpleMasterPageHandle)this.designHandle.findMasterPage("NewSimpleMasterPage");
        ParserCompatibilityTest.assertEquals((String)"0.1in", (String)page.getTopMargin().getStringValue());
        ParserCompatibilityTest.assertEquals((String)"0.2in", (String)page.getLeftMargin().getStringValue());
        ParserCompatibilityTest.assertEquals((String)"0.3in", (String)page.getBottomMargin().getStringValue());
        ParserCompatibilityTest.assertEquals((String)"0.4in", (String)page.getRightMargin().getStringValue());
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("CompatibleExtendedPageMarginTest_golden.xml"));
    }

    public void testQueryTextParser() throws Exception {
        this.openDesign("CompatibleQueryTextParseTest.xml");
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("CompatibleQueryTextParseTest_golden.xml"));
    }

    public void testPropertyToExpression() throws Exception {
        this.openDesign("CompatiblePropToExprTest.xml");
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("CompatiblePropToExprTest_golden.xml"));
    }

    public void testVariableNameParser() throws Exception {
        this.openDesign("CompatibleVariableNameTest.xml");
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("CompatibleVariableNameTest_golden.xml"));
    }

    public void testReportLayoutPreference() throws Exception {
        this.openDesign("CompatibleReportLayoutPreferenceTest.xml");
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("CompatibleReportLayoutPreferenceTest_golden.xml"));
    }

    public void testDisplayNameID() throws Exception {
        this.openDesign("CompatibleDisplayNameIDTest.xml");
        this.save();
        ParserCompatibilityTest.assertTrue((boolean)this.compareFile("CompatibleDisplayNameIDTest_golden.xml"));
    }
}

