/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionConditionHandle;
import org.eclipse.birt.report.model.api.DimensionJoinConditionHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.FormatValueHandle;
import org.eclipse.birt.report.model.api.LevelAttributeHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.RuleHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.elements.structures.DimensionCondition;
import org.eclipse.birt.report.model.api.elements.structures.DimensionJoinCondition;
import org.eclipse.birt.report.model.api.elements.structures.FormatValue;
import org.eclipse.birt.report.model.api.elements.structures.LevelAttribute;
import org.eclipse.birt.report.model.api.elements.structures.Rule;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.HierarchyHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularHierarchyHandle;
import org.eclipse.birt.report.model.api.olap.TabularLevelHandle;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class TabularCubeParserTest
extends BaseTestCase {
    private final String FILE_NAME = "CubeParserTest.xml";
    private final String FILE_NAME_EXTENDS = "CubeParserTest_3.xml";
    private final String PARSE_TEST_FILE = "CubeParserTest_5.xml";

    public void testParser() throws Exception {
        this.openDesign("CubeParserTest_5.xml");
        TabularCubeParserTest.assertNotNull((Object)this.designHandle);
        TabularCubeHandle cube = (TabularCubeHandle)this.designHandle.findCube("testCube");
        TabularCubeParserTest.assertEquals((Object)this.designHandle.findDataSet("firstDataSet"), (Object)cube.getDataSet());
        TabularCubeParserTest.assertTrue((boolean)cube.autoPrimaryKey());
        ExpressionHandle expressionHandle = cube.getACLExpression();
        Expression value = (Expression)expressionHandle.getValue();
        TabularCubeParserTest.assertEquals((String)"ACL expression", (String)value.getStringExpression());
        TabularCubeParserTest.assertEquals((String)"javascript", (String)value.getType());
        Iterator iter = cube.filtersIterator();
        FilterConditionHandle filterConditionHandle = (FilterConditionHandle)iter.next();
        TabularCubeParserTest.assertEquals((String)"filter expression", (String)filterConditionHandle.getExpr());
        iter = cube.joinConditionsIterator();
        DimensionConditionHandle cubeJoinConditionHandle = (DimensionConditionHandle)iter.next();
        TabularCubeParserTest.assertEquals((Object)this.design.findOLAPElement("testHierarchy"), (Object)cubeJoinConditionHandle.getHierarchy().getElement());
        MemberHandle conditionMemberHandle = cubeJoinConditionHandle.getJoinConditions();
        TabularCubeParserTest.assertEquals((int)3, (int)conditionMemberHandle.getListValue().size());
        DimensionJoinConditionHandle joinCondition = (DimensionJoinConditionHandle)conditionMemberHandle.getAt(0);
        TabularCubeParserTest.assertEquals((String)"cubeKey", (String)joinCondition.getCubeKey());
        TabularCubeParserTest.assertEquals((String)"key", (String)joinCondition.getHierarchyKey());
        TabularCubeParserTest.assertEquals((Object)this.designHandle.findLevel("testDimension/testLevel"), (Object)joinCondition.getLevel());
        joinCondition = (DimensionJoinConditionHandle)conditionMemberHandle.getAt(1);
        TabularCubeParserTest.assertEquals((String)"cubeKey2", (String)joinCondition.getCubeKey());
        TabularCubeParserTest.assertEquals((String)"key2", (String)joinCondition.getHierarchyKey());
        joinCondition = (DimensionJoinConditionHandle)conditionMemberHandle.getAt(2);
        TabularCubeParserTest.assertEquals((String)"cubeKey4", (String)joinCondition.getCubeKey());
        TabularCubeParserTest.assertEquals((String)"key4", (String)joinCondition.getHierarchyKey());
        cubeJoinConditionHandle = (DimensionConditionHandle)iter.next();
        TabularCubeParserTest.assertNull((Object)cubeJoinConditionHandle.getHierarchy());
        TabularCubeParserTest.assertEquals((String)"nonExistingHierarchy", (String)cubeJoinConditionHandle.getHierarchyName());
        conditionMemberHandle = cubeJoinConditionHandle.getJoinConditions();
        TabularCubeParserTest.assertEquals((int)1, (int)conditionMemberHandle.getListValue().size());
        PropertyHandle propHandle = cube.getPropertyHandle("dimensions");
        TabularCubeParserTest.assertEquals((int)1, (int)propHandle.getContentCount());
        TabularCubeParserTest.assertEquals((int)1, (int)cube.getContentCount("dimensions"));
        DimensionHandle dimension = (DimensionHandle)propHandle.getContent(0);
        TabularCubeParserTest.assertEquals((Object)dimension, (Object)cube.getContent("dimensions", 0));
        TabularCubeParserTest.assertEquals((String)"testDimension", (String)dimension.getName());
        TabularCubeParserTest.assertTrue((boolean)dimension.isTimeType());
        expressionHandle = dimension.getACLExpression();
        value = (Expression)expressionHandle.getValue();
        TabularCubeParserTest.assertEquals((String)"ACL expression", (String)value.getStringExpression());
        TabularCubeParserTest.assertEquals((String)"javascript", (String)value.getType());
        propHandle = dimension.getPropertyHandle("hierarchies");
        TabularCubeParserTest.assertEquals((int)1, (int)propHandle.getContentCount());
        TabularCubeParserTest.assertEquals((int)1, (int)dimension.getContentCount("hierarchies"));
        TabularHierarchyHandle hierarchy = (TabularHierarchyHandle)propHandle.getContent(0);
        TabularCubeParserTest.assertEquals((Object)hierarchy, (Object)dimension.getContent("hierarchies", 0));
        TabularCubeParserTest.assertEquals((Object)hierarchy, (Object)dimension.getDefaultHierarchy());
        TabularCubeParserTest.assertEquals((String)"testHierarchy", (String)hierarchy.getName());
        TabularCubeParserTest.assertEquals((Object)this.designHandle.findDataSet("secondDataSet"), (Object)hierarchy.getDataSet());
        TabularLevelHandle level = (TabularLevelHandle)hierarchy.getLevel("testLevel");
        TabularCubeParserTest.assertNotNull((Object)level);
        propHandle = cube.getPropertyHandle("dimensions");
        TabularCubeParserTest.assertEquals((int)1, (int)propHandle.getContentCount());
        TabularCubeParserTest.assertEquals((int)1, (int)cube.getContentCount("dimensions"));
        iter = hierarchy.filtersIterator();
        filterConditionHandle = (FilterConditionHandle)iter.next();
        TabularCubeParserTest.assertEquals((String)"filter expression", (String)filterConditionHandle.getExpr());
        List primaryKeys = hierarchy.getPrimaryKeys();
        TabularCubeParserTest.assertEquals((int)3, (int)primaryKeys.size());
        TabularCubeParserTest.assertEquals((Object)"key", primaryKeys.get(0));
        TabularCubeParserTest.assertEquals((Object)"key2", primaryKeys.get(1));
        TabularCubeParserTest.assertEquals((Object)"key4", primaryKeys.get(2));
        propHandle = hierarchy.getPropertyHandle("levels");
        TabularCubeParserTest.assertEquals((int)1, (int)propHandle.getContentCount());
        TabularCubeParserTest.assertEquals((int)1, (int)hierarchy.getContentCount("levels"));
        level = (TabularLevelHandle)propHandle.getContent(0);
        TabularCubeParserTest.assertEquals((Object)level, (Object)hierarchy.getContent("levels", 0));
        TabularCubeParserTest.assertEquals((String)"testLevel", (String)level.getName());
        TabularCubeParserTest.assertEquals((String)"column1", (String)level.getColumnName());
        TabularCubeParserTest.assertEquals((String)"integer", (String)level.getDataType());
        TabularCubeParserTest.assertEquals((String)"prefix", (String)level.getInterval());
        TabularCubeParserTest.assertEquals((String)"month", (String)level.getDateTimeLevelType());
        TabularCubeParserTest.assertEquals((String)"mmm", (String)level.getDateTimeFormat());
        TabularCubeParserTest.assertEquals((double)3.0, (double)level.getIntervalRange(), (double)0.0);
        TabularCubeParserTest.assertEquals((String)"Jan", (String)level.getIntervalBase());
        TabularCubeParserTest.assertEquals((String)"dynamic", (String)level.getLevelType());
        expressionHandle = level.getACLExpression();
        value = (Expression)expressionHandle.getValue();
        TabularCubeParserTest.assertEquals((String)"ACL expression", (String)value.getStringExpression());
        TabularCubeParserTest.assertEquals((String)"javascript", (String)value.getType());
        expressionHandle = level.getMemberACLExpression();
        value = (Expression)expressionHandle.getValue();
        TabularCubeParserTest.assertEquals((String)"member ACL expression", (String)value.getStringExpression());
        TabularCubeParserTest.assertEquals((String)"javascript", (String)value.getType());
        iter = level.staticValuesIterator();
        RuleHandle rule = (RuleHandle)iter.next();
        TabularCubeParserTest.assertEquals((String)"rule expression", (String)rule.getRuleExpression());
        TabularCubeParserTest.assertEquals((String)"display expression", (String)rule.getDisplayExpression());
        rule = (RuleHandle)iter.next();
        TabularCubeParserTest.assertEquals((String)"rule expression2", (String)rule.getRuleExpression());
        TabularCubeParserTest.assertEquals((String)"display expression2", (String)rule.getDisplayExpression());
        iter = level.attributesIterator();
        LevelAttributeHandle attribute = (LevelAttributeHandle)iter.next();
        TabularCubeParserTest.assertEquals((String)"var1", (String)attribute.getName());
        TabularCubeParserTest.assertEquals((String)"string", (String)attribute.getDataType());
        attribute = (LevelAttributeHandle)iter.next();
        TabularCubeParserTest.assertEquals((String)"var2", (String)attribute.getName());
        TabularCubeParserTest.assertEquals((String)"integer", (String)attribute.getDataType());
        ActionHandle action = level.getActionHandle();
        TabularCubeParserTest.assertEquals((String)"http://localhost:8080/bluehero", (String)action.getURI());
        FormatValueHandle format = level.getFormat();
        TabularCubeParserTest.assertNotNull((Object)format);
        TabularCubeParserTest.assertEquals((String)"testLevelFormatCategory", (String)format.getCategory());
        TabularCubeParserTest.assertEquals((String)"testLevelFormatPattern", (String)format.getPattern());
        TabularCubeParserTest.assertEquals((Object)TEST_LOCALE, (Object)format.getLocale());
        propHandle = cube.getPropertyHandle("measureGroups");
        TabularCubeParserTest.assertEquals((int)1, (int)propHandle.getContentCount());
        TabularCubeParserTest.assertEquals((int)1, (int)cube.getContentCount("measureGroups"));
        MeasureGroupHandle measureGroup = (MeasureGroupHandle)propHandle.getContent(0);
        TabularCubeParserTest.assertEquals((Object)measureGroup, (Object)cube.getContent("measureGroups", 0));
        TabularCubeParserTest.assertEquals((String)"testMeasureGroup", (String)measureGroup.getName());
        propHandle = measureGroup.getPropertyHandle("measures");
        MeasureHandle measure = (MeasureHandle)propHandle.getContent(0);
        TabularCubeParserTest.assertEquals((String)"testMeasure", (String)measure.getName());
        TabularCubeParserTest.assertEquals((String)"column", (String)measure.getMeasureExpression());
        TabularCubeParserTest.assertEquals((String)"min", (String)measure.getFunction());
        TabularCubeParserTest.assertFalse((boolean)measure.isCalculated());
        TabularCubeParserTest.assertEquals((String)"string", (String)measure.getDataType());
        expressionHandle = measure.getACLExpression();
        value = (Expression)expressionHandle.getValue();
        TabularCubeParserTest.assertEquals((String)"ACL expression", (String)value.getStringExpression());
        TabularCubeParserTest.assertEquals((String)"javascript", (String)value.getType());
        action = measure.getActionHandle();
        TabularCubeParserTest.assertEquals((String)"http://localhost:8080/bluehero", (String)action.getURI());
        format = measure.getFormat();
        TabularCubeParserTest.assertNotNull((Object)format);
        TabularCubeParserTest.assertEquals((String)"testMeasureFormatCategory", (String)format.getCategory());
        TabularCubeParserTest.assertEquals((String)"testMeasureFormatPattern", (String)format.getPattern());
        TabularCubeParserTest.assertNull((Object)format.getLocale());
        TabularCubeParserTest.assertEquals((String)"justify", (String)level.getAlignment());
        TabularCubeParserTest.assertEquals((String)"justify", (String)measure.getAlignment());
        TabularCubeParserTest.assertFalse((boolean)measure.isVisible());
    }

    public void testWriter() throws Exception {
        this.openDesign("CubeParserTest.xml");
        TabularCubeParserTest.assertNotNull((Object)this.designHandle);
        String namePrix = "new";
        String valuePrix = "updated ";
        ElementFactory factory = this.designHandle.getElementFactory();
        TabularCubeHandle cube = (TabularCubeHandle)this.designHandle.findCube("testCube");
        cube.setDataSet(this.designHandle.findDataSet("secondDataSet"));
        cube.setName(String.valueOf(namePrix) + cube.getName());
        cube.setAutoPrimaryKey(false);
        ExpressionHandle expressionHandle = cube.getACLExpression();
        expressionHandle.setValue((Object)new Expression((Object)("new " + expressionHandle.getStringValue()), "constant"));
        PropertyHandle propHandle = cube.getPropertyHandle("dimensionConditions");
        propHandle.removeItem(1);
        DimensionCondition condition = new DimensionCondition();
        DimensionConditionHandle structHandle = cube.addDimensionCondition(condition);
        DimensionJoinConditionHandle joinConditionHandle = structHandle.addJoinCondition(new DimensionJoinCondition());
        joinConditionHandle.setCubeKey("addCubeKey");
        joinConditionHandle.setHierarchyKey("addHierarchyKey");
        joinConditionHandle.setLevel("testDimension/noLevel");
        structHandle = (DimensionConditionHandle)propHandle.get(0);
        MemberHandle memberHandle = structHandle.getMember("hierarchy");
        memberHandle.setValue((Object)(String.valueOf(valuePrix) + "hierarchy"));
        structHandle.removeJoinCondition(1);
        cube.add("dimensions", (DesignElementHandle)factory.newTabularDimension(null));
        DimensionHandle dimension = (DimensionHandle)cube.getContent("dimensions", 0);
        dimension.setName(String.valueOf(namePrix) + dimension.getName());
        dimension.setTimeType(false);
        dimension.setDefaultHierarchy((HierarchyHandle)factory.newTabularHierarchy("testDefaultHierarchy"));
        expressionHandle = dimension.getACLExpression();
        expressionHandle.setValue((Object)new Expression((Object)("new " + expressionHandle.getStringValue()), "constant"));
        dimension.add("hierarchies", (DesignElementHandle)factory.newTabularHierarchy(null));
        TabularHierarchyHandle hierarchy = (TabularHierarchyHandle)dimension.getContent("hierarchies", 0);
        hierarchy.setName(String.valueOf(namePrix) + hierarchy.getName());
        hierarchy.setDataSet(this.designHandle.findDataSet("firstDataSet"));
        propHandle = hierarchy.getPropertyHandle("primaryKeys");
        propHandle.removeItem((Object)"key2");
        propHandle.addItem((Object)(String.valueOf(valuePrix) + "key"));
        hierarchy.add("levels", (DesignElementHandle)factory.newTabularLevel(dimension, null));
        TabularLevelHandle level = (TabularLevelHandle)hierarchy.getContent("levels", 0);
        level.setName(String.valueOf(namePrix) + level.getName());
        level.setColumnName(String.valueOf(valuePrix) + level.getColumnName());
        level.setDataType("string");
        level.setDateTimeLevelType("quarter");
        level.setDateTimeFormat("mm");
        level.setIntervalRange(5.0);
        level.setIntervalBase(String.valueOf(valuePrix) + level.getIntervalBase());
        level.setLevelType("mirrored");
        expressionHandle = level.getACLExpression();
        expressionHandle.setValue((Object)new Expression((Object)("new " + expressionHandle.getStringValue()), "constant"));
        expressionHandle = level.getMemberACLExpression();
        expressionHandle.setValue((Object)new Expression((Object)("new " + expressionHandle.getStringValue()), "constant"));
        propHandle = level.getPropertyHandle("staticValues");
        propHandle.removeItem(0);
        Rule rule = new Rule();
        rule.setProperty("displayExpre", (Object)"new display expression");
        rule.setProperty("ruleExpre", (Object)"new rule expression");
        propHandle.insertItem((IStructure)rule, 0);
        propHandle = level.getPropertyHandle("attributes");
        propHandle.removeItem(propHandle.get(1));
        LevelAttribute config = new LevelAttribute();
        config.setName("var3");
        config.setDataType("boolean");
        propHandle.insertItem((IStructure)config, 0);
        Action action = StructureFactory.createAction();
        level.setAction(action);
        FormatValue levelFormat = StructureFactory.newFormatValue();
        levelFormat.setCategory("testLevelFormatCategory");
        levelFormat.setPattern("testLevelFormatPattern");
        levelFormat.setLocale(TEST_LOCALE);
        level.setFormat(levelFormat);
        cube.add("measureGroups", (DesignElementHandle)factory.newTabularMeasureGroup(null));
        MeasureGroupHandle measureGroup = (MeasureGroupHandle)cube.getContent("measureGroups", 0);
        measureGroup.setName(String.valueOf(namePrix) + measureGroup.getName());
        measureGroup.add("measures", (DesignElementHandle)factory.newTabularMeasure(null));
        MeasureHandle measure = (MeasureHandle)measureGroup.getContent("measures", 0);
        measure.setName(String.valueOf(namePrix) + measure.getName());
        measure.setMeasureExpression(String.valueOf(valuePrix) + measure.getMeasureExpression());
        measure.setFunction("count");
        measure.setCalculated(true);
        measure.setDataType("boolean");
        expressionHandle = measure.getACLExpression();
        expressionHandle.setValue((Object)new Expression((Object)("new " + expressionHandle.getStringValue()), "constant"));
        action = StructureFactory.createAction();
        measure.setAction(action);
        FormatValue measureFormat = StructureFactory.newFormatValue();
        measureFormat.setCategory("testMeasureFormatCategory");
        measureFormat.setPattern("testMeasureFormatPattern");
        measureFormat.setLocale(TEST_LOCALE);
        measure.setFormat(measureFormat);
        level.setAlignment("center");
        measure.setAlignment("center");
        measure.setVisible(true);
        this.save();
        TabularCubeParserTest.assertTrue((boolean)this.compareFile("CubeParserTest_golden.xml"));
    }

    public void testCommand() throws Exception {
        this.openDesign("CubeParserTest.xml");
        TabularCubeParserTest.assertNotNull((Object)this.designHandle);
        TabularCubeHandle cube = (TabularCubeHandle)this.designHandle.findCube("testCube");
        try {
            cube.setName(null);
            TabularCubeParserTest.fail();
        }
        catch (NameException nameException) {}
        IDesignElement clonedCube = cube.copy();
        TabularCubeParserTest.assertNotNull((Object)clonedCube);
        this.designHandle.rename(clonedCube.getHandle((Module)this.design));
        this.designHandle.getSlot(9).add(clonedCube.getHandle((Module)this.design));
        this.save();
        TabularCubeParserTest.assertTrue((boolean)this.compareFile("CubeParserTest_golden_1.xml"));
    }

    public void testExtends() throws Exception {
        this.openDesign("CubeParserTest_3.xml");
        TabularCubeParserTest.assertNotNull((Object)this.designHandle);
        this.libraryHandle = this.designHandle.getLibrary("Lib1");
        TabularCubeHandle cube = (TabularCubeHandle)this.libraryHandle.findCube("testCube");
        TabularCubeHandle newCube = (TabularCubeHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)cube, "Customer Cube");
        this.designHandle.getCubes().add((DesignElementHandle)newCube);
        this.save();
        TabularCubeParserTest.assertTrue((boolean)this.compareFile("TabularCubeParserTest_extends_golden_1.xml"));
    }

    public void testMergeDimensionConditions() throws Exception {
        this.openDesign("CubeParserTest_4.xml");
        TabularCubeHandle cube = (TabularCubeHandle)this.designHandle.findCube("testCube");
        TabularCubeParserTest.assertNotNull((Object)cube.findDimensionCondition("testHierarchy"));
        TabularCubeParserTest.assertEquals((Object)cube.findDimensionCondition("testHierarchy").getStructure(), (Object)cube.findDimensionCondition((HierarchyHandle)this.design.findOLAPElement("testHierarchy").getHandle((Module)this.design)).getStructure());
        this.save();
        TabularCubeParserTest.assertTrue((boolean)this.compareFile("CubeParserTest_golden_3.xml"));
    }

    public void testClearStructureForElementRemove() throws Exception {
        this.openDesign("CubeParserTest.xml");
        LevelHandle levelHandle = this.designHandle.findLevel("testDimension/testLevel");
        levelHandle.dropAndClear();
        this.save();
        TabularCubeParserTest.assertTrue((boolean)this.compareFile("CubeParserTest_golden_4.xml"));
    }

    private static void checkNotificationStatus(MyListener listener) {
        TabularCubeParserTest.assertEquals((int)5, (int)listener.getEventType());
        TabularCubeParserTest.assertEquals((String)"accessControls", (String)listener.getPropName());
        listener.reset();
    }

    private static class MyListener
    implements Listener {
        private String propName = null;
        private int eventType = -1;

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            this.eventType = ev.getEventType();
            assert (this.eventType == 5);
            this.propName = ((PropertyEvent)ev).getPropertyName();
        }

        MyListener() {
        }

        String getPropName() {
            return this.propName;
        }

        int getEventType() {
            return this.eventType;
        }

        void reset() {
            this.propName = null;
            this.eventType = -1;
        }
    }
}

