/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class TextItemParseTest
extends BaseTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testWrite() throws Exception {
        this.openDesign("TextItemParseTest.xml");
        TextItemHandle text = (TextItemHandle)this.designHandle.findElement("text1");
        String contentType = text.getContentType();
        TextItemParseTest.assertEquals((String)"html", (String)contentType);
        text.setContentType("html");
        text.setContent("new content hello <> <html></html>");
        text.setHasExpression(false);
        text.setRole("Div");
        text.setLanguage("English");
        text.setAltText("Alt Text");
        text.setOrder(1);
        text = (TextItemHandle)this.designHandle.findElement("text2");
        text.setContent("    text & < > ' \" static    ]]>");
        TextItemParseTest.assertEquals((Object)"    text & < > ' \" static    ]]>", (Object)text.getProperty("content"));
        TextItemParseTest.assertEquals((String)"    text & < > ' \" static    ]]>", (String)text.getStringProperty("content"));
        text = (TextItemHandle)this.designHandle.findElement("text3");
        text.setContentKey("odd 1");
        this.save();
        TextItemParseTest.assertTrue((boolean)this.compareFile("TextItemParseTest_golden.xml"));
    }

    public void testProperties() throws Exception {
        this.openDesign("TextItemParseTest.xml");
        TextItemHandle text = (TextItemHandle)this.designHandle.findElement("text1");
        String contentType = text.getContentType();
        TextItemParseTest.assertEquals((String)"html", (String)contentType);
        TextItemParseTest.assertTrue((boolean)text.hasExpression());
        TextItemParseTest.assertEquals((String)"text & < > ' \" static", (String)text.getContent());
        TextItemParseTest.assertEquals((String)"Div", (String)text.getRole());
        TextItemParseTest.assertEquals((String)"English", (String)text.getLanguage());
        TextItemParseTest.assertEquals((String)"Alt Text", (String)text.getAltText());
        TextItemParseTest.assertEquals((int)1, (int)text.getOrder());
        text = (TextItemHandle)this.designHandle.findElement("text2");
        TextItemParseTest.assertNull((Object)text.getContentKey());
        TextItemParseTest.assertEquals((String)"auto", (String)text.getContentType());
        TextItemParseTest.assertEquals((String)"    text value expr  ]]>  ", (String)text.getContent());
        TextItemParseTest.assertEquals((String)"div", (String)text.getRole());
        text = (TextItemHandle)this.designHandle.findElement("text3");
        TextItemParseTest.assertEquals((String)"dynamic", (String)text.getContentKey());
        TextItemParseTest.assertEquals((String)"auto", (String)text.getContentType());
        TextItemParseTest.assertEquals((String)"text & &lt; &gt; &apos; &quot; static", (String)text.getContent());
        text = (TextItemHandle)this.designHandle.findElement("text4");
        TextItemParseTest.assertEquals((String)"<hello>text & </hello>&lt; <hello>&gt; &apos; &quot; static</hello>", (String)text.getContent());
    }
}

