/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import com.ibm.icu.util.ULocale;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.IDesignEngine;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.util.ReportDesignSerializer;
import org.eclipse.birt.report.model.writer.DesignWriter;
import org.eclipse.birt.report.model.writer.DesignWriterUtil;

public abstract class BaseTestCase
extends TestCase {
    protected static IDesignEngine engine = null;
    protected ReportDesignHandle designHandle = null;
    protected LibraryHandle libraryHandle = null;
    protected ModuleHandle moduleHandle = null;
    protected SessionHandle sessionHandle = null;
    protected ReportDesign design = null;
    protected ByteArrayOutputStream os = null;
    protected static final String ROM_DEF_NAME = "rom.def";
    protected static final String TEST_FOLDER = "test/";
    protected static final String OUTPUT_FOLDER = "/output/";
    protected static final String INPUT_FOLDER = "input/";
    protected static final String GOLDEN_FOLDER = "golden/";
    protected static final ULocale TEST_LOCALE = new ULocale("aa");
    protected ReportDesignHandle beforeSerializedDesignHandle = null;

    protected void setUp() throws Exception {
        super.setUp();
        ThreadResources.setLocale((ULocale)ULocale.ENGLISH);
        if (engine == null) {
            engine = new DesignEngine(new DesignConfig());
        }
    }

    protected void resetMetadata() {
        MetaDataDictionary.reset();
        MetaDataDictionary.initialize();
    }

    protected void tearDown() throws Exception {
        if (this.beforeSerializedDesignHandle != null) {
            this.designHandle = this.beforeSerializedDesignHandle;
        }
        if (this.designHandle != null) {
            this.designHandle.close();
        }
        if (this.libraryHandle != null) {
            this.libraryHandle.close();
        }
        if (this.os != null) {
            this.os.close();
        }
        super.tearDown();
    }

    protected ReportDesignHandle createDesign() {
        return this.createDesign(null);
    }

    protected ReportDesignHandle createDesign(ULocale locale) {
        if (engine == null) {
            engine = new DesignEngine(new DesignConfig());
            this.resetMetadata();
        }
        this.sessionHandle = engine.newSessionHandle(locale);
        this.designHandle = this.sessionHandle.createDesign();
        this.design = (ReportDesign)this.designHandle.getModule();
        this.removeExtensionStyles(this.design);
        return this.designHandle;
    }

    private void removeExtensionStyles(ReportDesign design) {
        ContainerSlot styles = design.getSlot(0);
        styles.clear();
    }

    protected LibraryHandle createLibrary() {
        return this.createLibrary(null);
    }

    protected LibraryHandle createLibrary(ULocale locale) {
        if (engine == null) {
            engine = new DesignEngine(new DesignConfig());
            this.resetMetadata();
        }
        this.sessionHandle = engine.newSessionHandle(locale);
        this.libraryHandle = this.sessionHandle.createLibrary();
        return this.libraryHandle;
    }

    protected void openDesign(String fileName) throws DesignFileException {
        this.openDesign(fileName, true);
    }

    protected void openDesign(String fileName, boolean inSingleJarMode) throws DesignFileException {
        this.openDesign(fileName, ULocale.getDefault(), inSingleJarMode);
    }

    protected void openDesign(String fileName, ULocale locale, boolean inSingleJarMode) throws DesignFileException {
        if (inSingleJarMode) {
            fileName = INPUT_FOLDER + fileName;
        }
        if (engine == null) {
            engine = new DesignEngine(new DesignConfig());
            this.resetMetadata();
        }
        this.sessionHandle = engine.newSessionHandle(locale);
        BaseTestCase.assertNotNull((Object)this.sessionHandle);
        this.designHandle = inSingleJarMode ? this.sessionHandle.openDesign(this.getResource(fileName).toString()) : this.sessionHandle.openDesign(fileName);
        this.design = (ReportDesign)this.designHandle.getModule();
    }

    protected void openDesign(String fileName, ULocale locale) throws DesignFileException {
        this.openDesign(fileName, locale, true);
    }

    protected void openLibrary(String fileName) throws DesignFileException {
        this.openLibrary(fileName, true);
    }

    protected void openLibrary(String fileName, boolean inSingleJarMode) throws DesignFileException {
        this.openLibrary(fileName, ULocale.getDefault(), inSingleJarMode);
    }

    protected void openLibrary(String fileName, ULocale locale) throws DesignFileException {
        this.openLibrary(fileName, locale, true);
    }

    protected void openLibrary(String fileName, ULocale locale, boolean inSingleJarMode) throws DesignFileException {
        if (inSingleJarMode) {
            fileName = INPUT_FOLDER + fileName;
        }
        if (engine == null) {
            engine = new DesignEngine(new DesignConfig());
            this.resetMetadata();
        }
        this.sessionHandle = engine.newSessionHandle(locale);
        BaseTestCase.assertNotNull((Object)this.sessionHandle);
        this.libraryHandle = inSingleJarMode ? this.sessionHandle.openLibrary(this.getResource(fileName).toString(), this.getResourceAStream(fileName)) : this.sessionHandle.openLibrary(fileName);
    }

    protected void openModule(String fileName) throws DesignFileException {
        this.openModule(fileName, ULocale.getDefault());
    }

    protected void openModule(String fileName, ULocale locale) throws DesignFileException {
        if (engine == null) {
            engine = new DesignEngine(new DesignConfig());
            this.resetMetadata();
        }
        fileName = INPUT_FOLDER + fileName;
        this.sessionHandle = engine.newSessionHandle(locale);
        BaseTestCase.assertNotNull((Object)this.sessionHandle);
        this.moduleHandle = this.sessionHandle.openModule(this.getResource(fileName).toString(), this.getResourceAStream(fileName));
    }

    protected void openDesign(String fileName, InputStream is) throws DesignFileException {
        this.openDesign(fileName, is, ULocale.getDefault());
    }

    protected void openDesign(String fileName, InputStream is, ULocale locale) throws DesignFileException {
        if (engine == null) {
            engine = new DesignEngine(new DesignConfig());
            this.resetMetadata();
        }
        this.sessionHandle = engine.newSessionHandle(locale);
        this.designHandle = this.sessionHandle.openDesign(fileName, is);
        this.design = (ReportDesign)this.designHandle.getModule();
    }

    protected boolean compareFile(String goldenFileName, String outputFileName) throws Exception {
        Reader readerA = null;
        InputStreamReader readerB = null;
        boolean same = true;
        StringBuffer errorText = new StringBuffer();
        try {
            try {
                goldenFileName = GOLDEN_FOLDER + goldenFileName;
                outputFileName = String.valueOf(this.getTempFolder()) + OUTPUT_FOLDER + outputFileName;
                readerA = new InputStreamReader(this.getResourceAStream(goldenFileName));
                readerB = new FileReader(outputFileName);
                same = this.compareFile(readerA, readerB);
            }
            catch (IOException e) {
                errorText.append(e.toString());
                errorText.append("\n");
                e.printStackTrace();
                try {
                    if (readerA != null) {
                        readerA.close();
                    }
                    if (readerB != null) {
                        readerB.close();
                    }
                }
                catch (Exception e2) {
                    readerA = null;
                    readerB = null;
                    errorText.append(e2.toString());
                    throw new Exception(errorText.toString());
                }
            }
        }
        finally {
            try {
                if (readerA != null) {
                    readerA.close();
                }
                if (readerB != null) {
                    readerB.close();
                }
            }
            catch (Exception e) {
                readerA = null;
                readerB = null;
                errorText.append(e.toString());
                throw new Exception(errorText.toString());
            }
        }
        return same;
    }

    protected boolean compareFile(String goldenFileName) throws Exception {
        String tmpGoldenFileName = GOLDEN_FOLDER + goldenFileName;
        InputStream streamA = this.getResourceAStream(tmpGoldenFileName);
        if (this.os == null) {
            return false;
        }
        String outContent = this.os.toString("utf-8");
        ByteArrayInputStream streamB = new ByteArrayInputStream(this.os.toByteArray());
        InputStreamReader readerA = new InputStreamReader(streamA);
        InputStreamReader readerB = new InputStreamReader(streamB);
        boolean ok = true;
        try {
            ok = this.compareFile(readerA, readerB);
        }
        catch (Exception e) {
            String outFileName = goldenFileName.replaceAll("golden", "out");
            this.saveOutputFile(outFileName, outContent);
            throw e;
        }
        return ok;
    }

    private boolean compareFile(Reader goldenReader, Reader outputReader) throws Exception {
        StringBuffer errorText = new StringBuffer();
        BufferedReader lineReaderA = null;
        BufferedReader lineReaderB = null;
        boolean same = true;
        int lineNo = 1;
        try {
            lineReaderA = new BufferedReader(goldenReader);
            lineReaderB = new BufferedReader(outputReader);
            String strA = lineReaderA.readLine().trim();
            String strB = lineReaderB.readLine().trim();
            while (strA != null) {
                same = strA.trim().equals(strB.trim());
                if (!same) {
                    StringBuffer message = new StringBuffer();
                    message.append("line=");
                    message.append(lineNo);
                    message.append(" is different:\n");
                    message.append(" The line from golden file: ");
                    message.append(strA);
                    message.append("\n");
                    message.append(" The line from output file: ");
                    message.append(strB);
                    message.append("\n");
                    throw new Exception(message.toString());
                }
                strA = lineReaderA.readLine();
                strB = lineReaderB.readLine();
                ++lineNo;
            }
            same = strB == null;
        }
        finally {
            try {
                if (lineReaderA != null) {
                    lineReaderA.close();
                }
                if (lineReaderB != null) {
                    lineReaderB.close();
                }
            }
            catch (Exception e) {
                lineReaderA = null;
                lineReaderB = null;
                errorText.append(e.toString());
                throw new Exception(errorText.toString());
            }
        }
        return same;
    }

    protected boolean compareFileWithOS(String goldenFileName, ByteArrayOutputStream os) throws Exception {
        String tmpGoldenFileName = GOLDEN_FOLDER + goldenFileName;
        InputStream streamA = this.getResourceAStream(tmpGoldenFileName);
        if (os == null) {
            return false;
        }
        String outContent = os.toString("utf-8");
        ByteArrayInputStream streamB = new ByteArrayInputStream(os.toByteArray());
        InputStreamReader readerA = new InputStreamReader(streamA);
        InputStreamReader readerB = new InputStreamReader(streamB);
        boolean ok = true;
        try {
            ok = this.compareFile(readerA, readerB);
        }
        catch (Exception e) {
            String outFileName = goldenFileName.replaceAll("golden", "out");
            this.saveOutputFile(outFileName, outContent);
            throw e;
        }
        return ok;
    }

    protected void printSemanticErrors() {
        this.printSemanticError(this.design);
    }

    protected void printSemanticError(ReportDesign design) {
        if (design != null) {
            this.printErrorList(design.getAllErrors());
        }
    }

    protected void printSyntaxError(DesignFileException e) {
        if (e != null) {
            this.printErrorList(e.getErrorList());
        }
    }

    private void printErrorList(List errors) {
        if (errors != null && !errors.isEmpty()) {
            for (ErrorDetail ex : errors) {
                System.out.println(ex);
            }
        }
    }

    protected void dumpErrors(String filename) throws Exception {
        String outputFolder = String.valueOf(this.getTempFolder()) + OUTPUT_FOLDER;
        File f = new File(outputFolder);
        if (!f.exists() && !f.mkdir()) {
            throw new Exception("Can not create the output folder!");
        }
        filename = String.valueOf(outputFolder) + filename;
        if (this.design == null) {
            return;
        }
        PrintWriter writer = new PrintWriter(new FileOutputStream(filename));
        List errors = this.design.getAllErrors();
        ErrorDetail ex = null;
        int i = 0;
        while (i < errors.size()) {
            ex = (ErrorDetail)errors.get(i);
            writer.print(this.design.getFileName());
            writer.println(ex);
            ++i;
        }
        writer.close();
    }

    protected void save() throws IOException {
        this.save((ModuleHandle)this.designHandle);
    }

    protected void save(ModuleHandle moduleHandle) throws IOException {
        this.os = new ByteArrayOutputStream();
        if (moduleHandle != null) {
            moduleHandle.serialize((OutputStream)this.os);
        }
        this.os.close();
    }

    protected void saveLibrary() throws IOException {
        this.save((ModuleHandle)this.libraryHandle);
    }

    protected String getTempFolder() {
        String tempDir = System.getProperty("java.io.tmpdir");
        if (!tempDir.endsWith(File.separator)) {
            tempDir = String.valueOf(tempDir) + File.separator;
        }
        String outputPath = String.valueOf(tempDir) + "org.eclipse.birt.report.model" + this.getFullQualifiedClassName();
        return outputPath;
    }

    protected InputStream getResourceAStream(String name) {
        return ((Object)((Object)this)).getClass().getResourceAsStream(name);
    }

    protected URL getResource(String name) {
        return ((Object)((Object)this)).getClass().getResource(name);
    }

    protected String getFullQualifiedClassName() {
        String className = ((Object)((Object)this)).getClass().getName();
        int lastDotIndex = className.lastIndexOf(".");
        className = className.substring(0, lastDotIndex);
        className = "/" + className.replace('.', '/');
        return className;
    }

    protected boolean isWindowsPlatform() {
        return System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0;
    }

    protected String copyContentToFile(String resourceName) throws Exception {
        File tmpFolder;
        URL url = this.getResource(resourceName);
        InputStream is = url.openStream();
        String folder = this.getTempFolder();
        int index = resourceName.lastIndexOf(INPUT_FOLDER);
        if (index > 0) {
            String relateDir = resourceName.substring(0, index - 1);
            folder = String.valueOf(folder) + "/" + relateDir;
        }
        if (!(tmpFolder = new File(folder = String.valueOf(folder) + "/" + INPUT_FOLDER)).exists()) {
            tmpFolder.mkdirs();
        }
        String filename = "";
        int lastSlash = resourceName.lastIndexOf("/");
        if (lastSlash != -1) {
            filename = resourceName.substring(lastSlash + 1);
        }
        FileOutputStream fos = new FileOutputStream(String.valueOf(folder) + filename);
        byte[] fileData = new byte[5120];
        int readCount = -1;
        while ((readCount = is.read(fileData)) != -1) {
            fos.write(fileData, 0, readCount);
        }
        fos.close();
        is.close();
        return String.valueOf(folder) + filename;
    }

    protected void saveOutputFile(String fileName) throws Exception {
        String strDesign = this.os.toString();
        this.saveOutputFile(fileName, strDesign);
    }

    protected void saveOutputFile(String fileName, String content) throws Exception {
        String folder = String.valueOf(this.getTempFolder()) + OUTPUT_FOLDER;
        File tmpFolder = new File(folder);
        if (!tmpFolder.exists()) {
            tmpFolder.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(String.valueOf(folder) + fileName);
        fos.write(content.getBytes("UTF-8"));
        fos.close();
    }

    protected static String serializeStringList(List strs) {
        if (strs == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < strs.size()) {
            sb.append((String)strs.get(i));
            if (i != strs.size() - 1) {
                sb.append(", ");
            }
            ++i;
        }
        return sb.toString();
    }

    protected void serializeDocument() throws Exception {
        this.serializeDocument(false);
    }

    protected void serializeDocument(boolean enableExternalDataMart) throws Exception {
        ReportDesignHandle beforeSerializedDesignHandle = this.designHandle;
        this.os = new ByteArrayOutputStream();
        ReportDesignSerializer visitor = new ReportDesignSerializer();
        this.designHandle.getModule().apply((ElementVisitor)visitor);
        this.design = visitor.getTarget();
        this.designHandle = (ReportDesignHandle)this.design.getHandle((Module)this.design);
        if (enableExternalDataMart) {
            this.design.prepareToSave();
            DesignWriter writer = (DesignWriter)this.design.getWriter();
            DesignWriterUtil.enableExternalDataMarts((DesignWriter)writer);
            writer.write((OutputStream)this.os);
            this.design.onSave();
        } else {
            this.designHandle.serialize((OutputStream)this.os);
        }
        this.beforeSerializedDesignHandle = beforeSerializedDesignHandle;
    }
}

