/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.writer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.elements.structures.DateTimeFormatValue;
import org.eclipse.birt.report.model.api.elements.structures.HighlightRule;
import org.eclipse.birt.report.model.api.elements.structures.TOC;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class DesignWriterTest
extends BaseTestCase {
    @Override
    protected void setUp() throws Exception {
        this.openDesign("DesignWriterTest.xml");
        DesignWriterTest.assertEquals((int)0, (int)this.design.getErrorList().size());
    }

    public void testSerializeOutputStream() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.designHandle.serialize((OutputStream)out);
        ByteArrayInputStream is = new ByteArrayInputStream(out.toByteArray());
        this.openDesign("", is);
        DesignWriterTest.assertNotNull((Object)this.design);
        this.save();
        DesignWriterTest.assertTrue((boolean)this.compareFile("DesignWriterTest_golden.xml"));
    }

    public void testUTF8Encoding() throws Exception {
        try {
            this.openDesign("DesignWriterTest_1.xml");
            DesignWriterTest.fail();
        }
        catch (DesignFileException e) {
            List list = e.getErrorList();
            ErrorDetail tmp = (ErrorDetail)list.get(0);
            DesignWriterTest.assertEquals((String)tmp.getMessage(), (String)"Invalid byte 1 of 1-byte UTF-8 sequence.");
        }
        this.createDesign();
        ElementFactory factory = new ElementFactory((Module)this.design);
        TextItemHandle handle = factory.newTextItem("bodyText");
        this.designHandle.getBody().add((DesignElementHandle)handle);
        LabelHandle labelHandle = factory.newLabel("bodyLabel");
        this.designHandle.getBody().add((DesignElementHandle)labelHandle);
        labelHandle.setText("doesn\u2019t have");
        labelHandle.setName("he llo<&\"");
        labelHandle = factory.newLabel("bodyLabel1");
        this.designHandle.getBody().add((DesignElementHandle)labelHandle);
        labelHandle.setText("<><>");
        labelHandle.setName("\u4e2d\u6587");
        handle.setContent("doesn\u2019t have");
        this.save();
        this.readOutputFile("DesignWriterTest_1_out.xml");
        handle = (TextItemHandle)this.designHandle.findElement("bodyText");
        DesignWriterTest.assertEquals((String)"doesn\u2019t have", (String)handle.getContent());
        labelHandle = (LabelHandle)this.designHandle.findElement("he llo<&\"");
        DesignWriterTest.assertNotNull((Object)labelHandle);
        labelHandle = (LabelHandle)this.designHandle.findElement("\u4e2d\u6587");
        DesignWriterTest.assertNotNull((Object)labelHandle);
    }

    public void testBOMSignature() throws Exception {
        this.openDesign("DesignWriterTest_UTF8BOM.xml");
        DesignWriterTest.assertNotNull((Object)this.designHandle);
        this.save();
        this.createDesign();
        this.readOutputFile("DesignWriterTest_UTF8BOM_out.xml");
        DesignWriterTest.assertEquals((String)"UTF-8", (String)this.design.getUTFSignature());
        DesignWriterTest.assertNotNull((Object)this.designHandle);
    }

    public void testWriter() throws Exception {
        this.createDesign();
        ElementFactory elemFactory = new ElementFactory((Module)this.design);
        SharedStyleHandle style = elemFactory.newStyle("Style1");
        style.setBorderBottomStyle("solid");
        this.designHandle.getStyles().add((DesignElementHandle)style);
        ImageHandle image = elemFactory.newImage("Image1");
        Action action = StructureFactory.createAction();
        image.setAction(action);
        this.designHandle.getBody().add((DesignElementHandle)image);
        this.save();
        DesignWriterTest.assertTrue((boolean)this.compareFile("testWriter_golden.xml"));
    }

    public void testSave() throws Exception {
        this.openDesign("DesignWriterTest.xml");
        String folder = String.valueOf(this.getTempFolder()) + "/output/";
        File f = new File(folder);
        if (!f.exists()) {
            f.mkdirs();
        }
        this.designHandle.setFileName(f.toURL() + "DesignWriterTest.xml");
        this.designHandle.save();
    }

    private void readOutputFile(String outputFileName) throws Exception {
        String fileContent = this.os.toString("utf-8");
        ByteArrayInputStream is = new ByteArrayInputStream(fileContent.getBytes("utf-8"));
        this.openDesign(outputFileName, is);
    }

    public void testStructContainStrucut() throws Exception {
        this.createDesign();
        ElementFactory elemFactory = new ElementFactory((Module)this.design);
        LabelHandle labelHandle = elemFactory.newLabel("label1");
        this.designHandle.getBody().add((DesignElementHandle)labelHandle);
        TOC toc = StructureFactory.createTOC((String)"toc");
        DateTimeFormatValue formatValueToSet = new DateTimeFormatValue();
        formatValueToSet.setCategory("Short Date");
        formatValueToSet.setPattern("yyyy/mm/dd");
        toc.setProperty("dateTimeFormat", (Object)formatValueToSet);
        labelHandle.addTOC(toc);
        this.save();
        this.compareFile("DesignWriterTest_1_golden.xml");
    }

    public void testStructListContainStruct() throws Exception {
        this.createDesign();
        ElementFactory elemFactory = new ElementFactory((Module)this.design);
        SharedStyleHandle styleHandle = elemFactory.newStyle("style1");
        this.designHandle.getStyles().add((DesignElementHandle)styleHandle);
        HighlightRule rule = StructureFactory.createHighlightRule();
        DateTimeFormatValue formatValueToSet = new DateTimeFormatValue();
        formatValueToSet.setCategory("Short Date");
        formatValueToSet.setPattern("yyyy/mm/dd");
        rule.setProperty("dateTimeFormat", (Object)formatValueToSet);
        ArrayList<HighlightRule> list = new ArrayList<HighlightRule>();
        list.add(rule);
        styleHandle.getElement().setProperty("highlightRules", list);
        this.save();
        this.compareFile("DesignWriterTest_2_golden.xml");
    }
}

