/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import java.util.logging.Level;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.engine.api.DefaultStatusHandler;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.HTMLEmitterConfig;
import org.eclipse.birt.report.engine.api.IStatusHandler;
import org.eclipse.birt.report.model.api.DefaultResourceLocator;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.tests.engine.EngineCase;

public class EngineConfigTest
extends EngineCase {
    protected EngineConfig engineConfig = new EngineConfig();

    public static Test suite() {
        return new TestSuite(EngineConfigTest.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public EngineConfigTest(String name) {
        super(name);
    }

    public void testGetEmitterConfigs() {
        HTMLEmitterConfig eConfig = new HTMLEmitterConfig();
        this.engineConfig.setEmitterConfiguration("pdf", (Object)eConfig);
        HTMLEmitterConfig eConfigNew = (HTMLEmitterConfig)this.engineConfig.getEmitterConfigs().get("pdf");
        EngineConfigTest.assertEquals((String)"Not identical", (Object)eConfig, (Object)eConfigNew);
    }

    public void testGetScriptObjects() {
        this.engineConfig.addScriptableJavaObject("jo1", (Object)new String("jostring"));
        EngineConfigTest.assertEquals((String)"Not identical", this.engineConfig.getScriptObjects().get("jo1"), (Object)"jostring");
    }

    public void testGetConfigMap() {
        this.engineConfig.setConfigurationVariable("config_var1", "config_value");
        EngineConfigTest.assertEquals(this.engineConfig.getConfigMap().get("config_var1"), (Object)"config_value");
    }

    public void testGetStatusHandler() {
        EngineConfigTest.assertNotNull((Object)this.engineConfig.getStatusHandler());
        DefaultStatusHandler handler = new DefaultStatusHandler();
        this.engineConfig.setStatusHandler((IStatusHandler)handler);
        DefaultStatusHandler handlerNew = (DefaultStatusHandler)this.engineConfig.getStatusHandler();
        EngineConfigTest.assertEquals((String)"Not identical", (Object)handler, (Object)handlerNew);
    }

    public void testSetEngineHome() {
        this.engine.getConfig().setEngineHome("c:/");
        EngineConfigTest.assertEquals((String)"Not identical", (String)"c:/", (String)this.engine.getConfig().getBIRTHome());
    }

    public void testSetLogConfig() {
        this.engineConfig.setLogConfig("DirectoryName", Level.parse("WARNING"));
        EngineConfigTest.assertNotNull((Object)this.engineConfig.getLogLevel());
        EngineConfigTest.assertEquals((Object)Level.parse("WARNING"), (Object)this.engineConfig.getLogLevel());
    }

    public void testGetLogDirectory() {
        System.out.println("LogDirctory" + this.engineConfig.getLogDirectory());
    }

    public void testGetMaxRowsPerQuery() {
        this.engineConfig.setMaxRowsPerQuery(200);
        EngineConfigTest.assertEquals((int)200, (int)this.engineConfig.getMaxRowsPerQuery());
    }

    public void testGetResourceLocator() {
        DefaultResourceLocator resource = new DefaultResourceLocator();
        this.engineConfig.setResourceLocator((IResourceLocator)resource);
        EngineConfigTest.assertNotNull((Object)this.engineConfig.getResourceLocator());
    }
}

