/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.tests.engine.BaseEmitter;

public class IBandContentTest
extends BaseEmitter {
    private String reportName = "IBandContentTest.rptdesign";

    @Override
    protected String getReportName() {
        return this.reportName;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT(this.reportName, this.reportName);
    }

    @Override
    public void tearDown() {
        this.removeResource();
    }

    public void testBandType() {
        ITableBandContent bandContent = new ReportContent().createTableBandContent();
        bandContent.setBandType(0);
        IBandContentTest.assertEquals((int)0, (int)bandContent.getBandType());
        bandContent.setBandType(2);
        IBandContentTest.assertEquals((int)2, (int)bandContent.getBandType());
        bandContent.setBandType(4);
        IBandContentTest.assertEquals((int)4, (int)bandContent.getBandType());
        bandContent.setBandType(3);
        IBandContentTest.assertEquals((int)3, (int)bandContent.getBandType());
        bandContent.setBandType(1);
        IBandContentTest.assertEquals((int)1, (int)bandContent.getBandType());
    }

    public void testBandFromReport() throws EngineException {
        this.runandrender_emitter("emitter_html", false);
    }

    @Override
    public void endTableGroup(ITableGroupContent group) {
        IBandContent groupHeader = group.getHeader();
        IBandContent groupFooter = group.getFooter();
        IBandContentTest.assertEquals((int)3, (int)groupHeader.getBandType());
        IBandContentTest.assertNull((Object)groupFooter);
    }

    @Override
    public void endTable(ITableContent table) {
        ITableBandContent header = table.getHeader();
        ITableBandContent footer = table.getFooter();
        IBandContentTest.assertEquals((int)1, (int)header.getBandType());
        IBandContentTest.assertNull((Object)footer);
    }
}

