/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.IDataExtractionTask;
import org.eclipse.birt.report.engine.api.IDataIterator;
import org.eclipse.birt.report.engine.api.IExtractionResults;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IResultMetaData;
import org.eclipse.birt.report.tests.engine.EngineCase;

public class IDataIteratorTest
extends EngineCase {
    private String report = "IDataIteratorTest.rptdesign";
    private String output = "IDataIteratorTest.rptdocument";
    private IDataExtractionTask task;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT(this.report, this.report);
    }

    @Override
    public void tearDown() {
        this.removeResource();
    }

    public void testIDataIterator() throws BirtException {
        this.run(this.report, this.output);
        String outputFile = this.genOutputFile(this.output);
        IReportDocument reportDoc = this.engine.openReportDocument(outputFile);
        this.task = this.engine.createDataExtractionTask(reportDoc);
        this.task.selectResultSet("ELEMENT_6");
        IExtractionResults results = this.task.extract();
        IDataIterator iterator = results.nextResultIterator();
        this.checkGetQueryResults(iterator, results);
        this.checkGetResultMetaData(iterator);
        this.checkGetValue(iterator);
        this.checkNext(iterator);
    }

    private void checkGetQueryResults(IDataIterator iterator, IExtractionResults results) {
        IDataIteratorTest.assertEquals((Object)results, (Object)iterator.getQueryResults());
    }

    private void checkGetResultMetaData(IDataIterator iterator) {
        try {
            IResultMetaData metaData = iterator.getResultMetaData();
            IDataIteratorTest.assertEquals((int)4, (int)metaData.getColumnCount());
        }
        catch (BirtException e) {
            e.printStackTrace();
            IDataIteratorTest.fail();
        }
    }

    private void checkGetValue(IDataIterator iterator) {
        try {
            if (iterator.next()) {
                IDataIteratorTest.assertEquals((int)10334, (int)Integer.parseInt(iterator.getValue(0).toString()));
                IDataIteratorTest.assertEquals((String)"Fri Nov 19 00:00:00 CST 2004", (String)iterator.getValue(1).toString());
                IDataIteratorTest.assertEquals((String)"On Hold", (String)iterator.getValue(2).toString());
                IDataIteratorTest.assertEquals((String)"0.9385160294251204", (String)iterator.getValue(3).toString());
                IDataIteratorTest.assertEquals((int)10334, (int)Integer.parseInt(iterator.getValue("ORDERNUMBER").toString()));
                IDataIteratorTest.assertEquals((String)"Fri Nov 19 00:00:00 CST 2004", (String)iterator.getValue("ORDERDATE").toString());
                IDataIteratorTest.assertEquals((String)"0.9385160294251204", (String)iterator.getValue("col1").toString());
                IDataIteratorTest.assertEquals((String)"On Hold", (String)iterator.getValue("STATUS").toString());
            } else {
                IDataIteratorTest.fail();
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            IDataIteratorTest.fail();
        }
        catch (BirtException e) {
            e.printStackTrace();
            IDataIteratorTest.fail();
        }
    }

    private void checkNext(IDataIterator iterator) {
        int count = 0;
        try {
            while (iterator.next()) {
                ++count;
            }
        }
        catch (BirtException e) {
            e.printStackTrace();
            IDataIteratorTest.fail();
        }
        IDataIteratorTest.assertEquals((int)6, (int)count);
    }
}

