/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.core.archive.FolderArchiveReader;
import org.eclipse.birt.core.archive.FolderArchiveWriter;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.tests.engine.EngineCase;
import org.eclipse.birt.report.tests.engine.api.RenderTaskTest;

public class RenderFolderDocumentTest
extends EngineCase {
    private String separator = System.getProperty("file.separator");
    private String inputFolder = String.valueOf(this.genInputFolder()) + this.separator;
    private String outputFolder = String.valueOf(this.genOutputFolder()) + this.separator;
    private String folderArchive;
    private String htmlOutput;
    private IReportDocument reportDoc;
    private IRenderTask renderTask;
    private IRenderOption htmlOption;
    private IRenderOption pdfOption;

    public RenderFolderDocumentTest(String name) {
        super(name);
    }

    public static Test Suite() {
        return new TestSuite(RenderTaskTest.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.htmlOption = new HTMLRenderOption();
        this.htmlOption.setOutputFormat("HTML");
    }

    @Override
    public void tearDown() {
        this.removeResource();
    }

    public void testRenderFolderDocument_simple() {
        String renderDoc = "folderdocument_case1";
        this.renderFolderDocument(renderDoc);
    }

    public void testRenderFolderDocument_longtext() {
        String renderDoc = "folderdocument_long_text";
        this.renderFolderDocument(renderDoc);
    }

    public void testRenderFolderDocument_masterpage() {
        String renderDoc = "folderdocument_master_page";
        this.renderFolderDocument(renderDoc);
    }

    public void testRenderFolderDocument_multidatasets() {
        String renderDoc = "folderdocument_multiple_datasets";
        this.renderFolderDocument(renderDoc);
    }

    public void testRenderFolderDocument_multipages() {
        String renderDoc = "folderdocument_pages9";
        this.renderFolderDocument(renderDoc);
    }

    public void testRenderFolderDocument_nesttable() {
        String renderDoc = "folderdocument_table_nest_pages";
        this.renderFolderDocument(renderDoc);
    }

    public void testRenderFolderDocument_chart() {
        String renderDoc = "folderdocument_chart";
        this.renderFolderDocument(renderDoc);
    }

    public void testDropDocumentFolder_content() {
        String report_design = "report_document";
        this.dropFolder(report_design, "content");
    }

    public void testDropDocumentFolder_data() {
        String report_design = "report_document";
        this.dropFolder(report_design, "Data");
    }

    public void testDropDocumentFolder_design() {
        String report_design = "report_document";
        this.dropFolder(report_design, "design");
    }

    public void testDropDocumentFolder_blank() {
        String report_design = "report_document";
        this.dropFolder(report_design, "");
    }

    public void testDropDocumentFolder_nonexist() {
        String report_design = "report_document";
        this.dropFolder(report_design, "nonexist");
    }

    private void dropFolder(String report_design, String dropDir) {
        this.folderArchive = String.valueOf(this.outputFolder) + "drop_" + report_design + this.separator;
        String design = String.valueOf(this.inputFolder) + report_design + ".rptdesign";
        this.copyResource_INPUT(String.valueOf(report_design) + ".rptdesign", String.valueOf(report_design) + ".rptdesign");
        try {
            this.createFolderDocument(design, this.folderArchive);
            FolderArchiveWriter writer = new FolderArchiveWriter(this.folderArchive);
            File doc = new File(this.folderArchive);
            if (doc.exists() && (doc = new File(String.valueOf(this.folderArchive) + this.separator + dropDir)).exists()) {
                writer.dropStream(dropDir);
                RenderFolderDocumentTest.assertFalse((String)("FolderArchiveWriter failed to drop folder" + dropDir + " in document"), (boolean)doc.exists());
            }
            writer.finish();
        }
        catch (EngineException e) {
            e.printStackTrace();
            RenderFolderDocumentTest.fail((String)("RunTask failed to create folder-based document!" + e.getLocalizedMessage()));
        }
        catch (IOException e) {
            e.printStackTrace();
            RenderFolderDocumentTest.fail((String)("RunTask failed to create folder-based document!" + e.getLocalizedMessage()));
        }
    }

    private void createFolderDocument(String design, String folderDoc) throws IOException, EngineException {
        this.folderArchive = folderDoc;
        FolderArchiveWriter writer = new FolderArchiveWriter(this.folderArchive);
        IReportRunnable runnable = this.engine.openReportDesign(design);
        IRunTask runTask = this.engine.createRunTask(runnable);
        runTask.run((IDocArchiveWriter)writer);
        runTask.close();
        writer.finish();
    }

    private void renderFolderDocument(String docName) {
        String designName = docName.substring(15);
        String report_design = String.valueOf(this.inputFolder) + designName + ".rptdesign";
        this.copyResource_INPUT(String.valueOf(designName) + ".rptdesign", String.valueOf(designName) + ".rptdesign");
        this.folderArchive = String.valueOf(this.outputFolder) + docName + this.separator;
        this.htmlOutput = String.valueOf(this.outputFolder) + docName + ".html";
        new File(this.outputFolder).mkdirs();
        try {
            this.createFolderDocument(report_design, this.folderArchive);
            FolderArchiveReader reader = new FolderArchiveReader(this.folderArchive);
            this.reportDoc = this.engine.openReportDocument(this.folderArchive);
            this.renderTask = this.engine.createRenderTask(this.reportDoc);
            this.htmlOption.setOutputFileName(this.htmlOutput);
            HTMLRenderContext renderContext = new HTMLRenderContext();
            renderContext.setImageDirectory("image");
            HashMap<String, HTMLRenderContext> appContext = new HashMap<String, HTMLRenderContext>();
            appContext.put("HTML_RENDER_CONTEXT", renderContext);
            this.renderTask.setRenderOption(this.htmlOption);
            this.renderTask.setAppContext(appContext);
            this.renderTask.setLocale(Locale.ENGLISH);
            this.renderTask.setPageRange("All");
            this.renderTask.render();
            this.renderTask.close();
            RenderFolderDocumentTest.assertNotNull((String)(String.valueOf(docName) + ".html failed to render from folder-based document"), (Object)this.htmlOutput);
            reader.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            RenderFolderDocumentTest.assertTrue((String)("IOException (when create and render " + docName + " folder-based document)"), (boolean)false);
        }
        catch (EngineException ee) {
            ee.printStackTrace();
            RenderFolderDocumentTest.assertTrue((String)("EngineException (when create and render " + docName + " folder-based document)"), (boolean)false);
        }
    }
}

