/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.core.archive.FileArchiveWriter;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.tests.engine.EngineCase;

public class RenderTaskTest
extends EngineCase {
    private String report_design;
    private String report_document;
    private IReportDocument reportDoc;
    private String outputFileName;
    private String separator = System.getProperty("file.separator");
    private List errors = null;
    protected String path = String.valueOf(this.getInputResourceFolder()) + File.separator + this.getFullQualifiedClassName() + File.separator;
    private String inputPath = String.valueOf(this.path) + "input" + this.separator;
    String outputPath = String.valueOf(this.genOutputFolder()) + "/";

    public RenderTaskTest(String name) {
        super(name);
    }

    public static Test Suite() {
        return new TestSuite(RenderTaskTest.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.engine.getConfig().setLogConfig(String.valueOf(this.genOutputFolder()) + "/", Level.WARNING);
    }

    @Override
    public void tearDown() {
        this.removeResource();
    }

    public void testRender_orderreport() {
        this.errors = this.renderReport("OrderReport", "All");
        RenderTaskTest.assertNull((Object)this.errors);
    }

    public void testRender_simple() {
        this.errors = this.renderReport("case1", "All");
        RenderTaskTest.assertNull((Object)this.errors);
    }

    public void testRender_table() {
        this.errors = this.renderReport("table_pages", "All");
        RenderTaskTest.assertNull((Object)this.errors);
    }

    public void testRender_longtext() {
        this.errors = this.renderReport("long_text", "All");
        RenderTaskTest.assertNull((Object)this.errors);
    }

    public void testRender_multiple_datasets() {
        this.errors = this.renderReport("multiple_datasets", "All");
        RenderTaskTest.assertNull((Object)this.errors);
    }

    public void testRender_nesttable() {
        this.errors = this.renderReport("table_nest_pages", "All");
        RenderTaskTest.assertNull((Object)this.errors);
    }

    public void testRender_oncreate() {
        this.errors = this.renderReport("oncreate-style-label", "All");
        RenderTaskTest.assertNull((Object)this.errors);
    }

    public void testRender_script() {
        this.errors = this.renderReport("javascript-support-data", "All");
        RenderTaskTest.assertNull((Object)this.errors);
    }

    public void testRender_masterpage() {
        this.errors = this.renderReport("master_page", "All");
        RenderTaskTest.assertNull((Object)this.errors);
    }

    public void testRender_chart() {
        this.errors = this.renderReport("chart", "All");
        RenderTaskTest.assertNull((Object)this.errors);
    }

    public void testRender_complex() {
        this.errors = this.renderReport("complex_report", "All");
        RenderTaskTest.assertNull((Object)this.errors);
    }

    public void testRender_areachart() {
        this.errors = this.renderReport("area3dChart", "All");
        RenderTaskTest.assertNull((Object)this.errors);
    }

    public void testRender_meterchart() {
        this.errors = this.renderReport("MeterChart", "All");
        RenderTaskTest.assertNull((Object)this.errors);
    }

    public void testRender_dynamic_image() {
        this.errors = this.renderReport("image_in_DB", "All");
        RenderTaskTest.assertNull((Object)this.errors);
    }

    public void testRender_multiple_masterpage() {
        this.errors = this.renderReport("multiple_masterpage", "All");
        RenderTaskTest.assertNull((Object)this.errors);
    }

    public void testRender_data() {
        this.errors = this.renderReport("smoke_data", "All");
        RenderTaskTest.assertNull((Object)this.errors);
    }

    public void testRender_library() {
        this.copyResource_INPUT("library1.rptlibrary", "library1.rptlibrary");
        this.renderReport("report_from_library1", "All");
        RenderTaskTest.assertNull((Object)this.errors);
    }

    public void testRenderPageRange_all() {
        this.errors = this.renderReport("pages9", "All");
        RenderTaskTest.assertNull((Object)this.errors);
    }

    public void testRenderPageRange_null() {
        this.errors = this.renderReport("pages9", null);
        RenderTaskTest.assertNull((Object)this.errors);
    }

    public void testRenderPageRange_blank() {
        this.errors = this.renderReport("pages9", "");
        RenderTaskTest.assertNull((Object)this.errors);
    }

    public void testRenderPageRange_number() {
        this.errors = this.renderReport("pages9", "2");
        RenderTaskTest.assertNull((Object)this.errors);
    }

    public void testRenderPageRange_comma() {
        this.errors = this.renderReport("pages9", "3,5");
        RenderTaskTest.assertNull((Object)this.errors);
    }

    public void testRenderPageRange_dash1() {
        this.errors = this.renderReport("pages9", "2-8");
        RenderTaskTest.assertNull((Object)this.errors);
    }

    public void testRenderBookmark_label() {
        this.renderReportBookmark("items_bookmark", "label");
        this.renderReportBookmark("multiple_masterpage", "label");
    }

    public void testRenderBookmark_text() {
        this.renderReportBookmark("items_bookmark", "text");
        this.renderReportBookmark("multiple_masterpage", "text");
    }

    public void testRenderBookmark_image() {
        this.renderReportBookmark("items_bookmark", "image");
        this.renderReportBookmark("multiple_masterpage", "image");
    }

    public void testRenderBookmark_gridrow() {
        this.renderReportBookmark("items_bookmark", "gridrow");
        this.renderReportBookmark("multiple_masterpage", "gridrow");
    }

    public void testRenderBookmark_chart() {
        this.renderReportBookmark("items_bookmark", "chart");
        this.renderReportBookmark("multiple_masterpage", "chart");
    }

    public void testRenderReportlet_list() throws Exception {
        InstanceID iid = this.findIid("iid_reportlet", "LIST");
        this.renderReportlet("iid_reportlet", iid, "LIST");
    }

    public void testRenderReportlet_table() throws Exception {
        InstanceID iid = this.findIid("iid_reportlet", "TABLE");
        this.renderReportlet("iid_reportlet", iid, "TABLE");
    }

    public void testRenderReportlet_chart() throws Exception {
        InstanceID iid = this.findIid("iid_reportlet", "Chart");
        this.renderReportlet("iid_reportlet", iid, "Chart");
    }

    public void testRenderReportlet_bookmark() {
        this.renderReportlet("reportlet_bookmark_toc", "bk_table");
    }

    public void testRenderReportlet_toc() {
        this.renderReportlet("reportlet_bookmark_toc", "toc_chart");
    }

    public void testRenderReportlet_complex_list() throws Exception {
        InstanceID iid = this.findIid("iid_reportlet_complex", "LIST");
        this.renderReportlet("iid_reportlet_complex", iid, "LIST");
    }

    public void testRenderReportlet_complex_table() throws Exception {
        InstanceID iid = this.findIid("iid_reportlet_complex", "TABLE");
        this.renderReportlet("iid_reportlet_complex", iid, "TABLE");
    }

    public void testRenderPDFNPE() {
        this.report_design = String.valueOf(this.inputPath) + "case1.rptdesign";
        this.report_document = String.valueOf(this.outputPath) + "pdfbug_reportdocument";
        this.copyResource_INPUT("case1.rptdesign", "case1.rptdesign");
        try {
            this.createReportDocument(this.report_design, this.report_document);
            this.reportDoc = this.engine.openReportDocument(this.report_document);
            HTMLRenderOption pdfRenderOptions = new HTMLRenderOption();
            HTMLRenderContext renderContext = new HTMLRenderContext();
            renderContext.setImageDirectory("image");
            HashMap<String, HTMLRenderContext> appContext = new HashMap<String, HTMLRenderContext>();
            appContext.put("HTML_RENDER_CONTEXT", renderContext);
            pdfRenderOptions.setOutputFormat("pdf");
            pdfRenderOptions.getOutputSetting().put("url-encoding", "UTF-8");
            this.outputFileName = String.valueOf(this.outputPath) + "pdfbug/pdf/page1" + ".pdf";
            this.removeFile(this.outputFileName);
            pdfRenderOptions.setOutputFileName(this.outputFileName);
            IRenderTask task = this.engine.createRenderTask(this.reportDoc);
            task.setLocale(Locale.ENGLISH);
            task.setAppContext(appContext);
            task.setRenderOption((IRenderOption)pdfRenderOptions);
            task.render();
            task.close();
            File pdfFile = new File(this.outputFileName);
            RenderTaskTest.assertTrue((String)"Render pdf failed when target path doesn't exist", (boolean)pdfFile.exists());
            RenderTaskTest.assertTrue((String)"Render pdf failed when target path doesn't exist", (pdfFile.length() != 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            RenderTaskTest.fail((String)"Render pdf failed when target path doesn't exist");
        }
    }

    private InstanceID findIid(String fileName, String type) {
        InstanceID iid = null;
        this.report_document = String.valueOf(this.outputPath) + fileName + ".rptdocument";
        this.report_design = String.valueOf(this.inputPath) + fileName + ".rptdesign";
        this.copyResource_INPUT(String.valueOf(fileName) + ".rptdesign", String.valueOf(fileName) + ".rptdesign");
        try {
            this.createReportDocument(this.report_design, this.report_document);
            this.reportDoc = this.engine.openReportDocument(this.report_document);
            IRenderTask task = this.engine.createRenderTask(this.reportDoc);
            task.setLocale(Locale.ENGLISH);
            HTMLRenderOption htmlRenderOptions = new HTMLRenderOption();
            HashMap<String, HTMLRenderContext> appContext = new HashMap<String, HTMLRenderContext>();
            HTMLRenderContext renderContext = new HTMLRenderContext();
            renderContext.setImageDirectory(String.valueOf(this.outputPath) + "image");
            appContext.put("HTML_RENDER_CONTEXT", renderContext);
            task.setAppContext(appContext);
            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
            htmlRenderOptions.setOutputStream((OutputStream)ostream);
            htmlRenderOptions.setOutputFormat("html");
            htmlRenderOptions.setEnableMetadata(true);
            task.setRenderOption((IRenderOption)htmlRenderOptions);
            task.render();
            task.close();
            String content = ostream.toString("utf-8");
            Pattern typePattern = Pattern.compile("(element_type=\"" + type + "\".*iid=\".*\")");
            Matcher matcher = typePattern.matcher(content);
            if (matcher.find()) {
                String tmp_type = matcher.group(1);
                String strIid = tmp_type.substring(tmp_type.indexOf("iid"));
                strIid = strIid.substring(5, strIid.indexOf("\"", 6));
                iid = InstanceID.parse((String)strIid);
                return iid;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            RenderTaskTest.assertFalse((String)("Failed to find instance id of " + type), (boolean)true);
        }
        return iid;
    }

    protected void renderReportlet(String docName, InstanceID iid, String type) throws Exception {
        if (iid == null) {
            RenderTaskTest.assertFalse((String)("Failed to find instance id of " + type), (boolean)true);
        } else {
            this.copyFile(this.genOutputFile(String.valueOf(docName) + ".rptdocument"), String.valueOf(this.inputPath) + docName + ".rptdocument");
            this.report_document = String.valueOf(this.inputPath) + docName + ".rptdocument";
            this.createDir(docName);
            try {
                this.reportDoc = this.engine.openReportDocument(this.report_document);
                IRenderTask task = this.engine.createRenderTask(this.reportDoc);
                HTMLRenderOption htmlRenderOptions = new HTMLRenderOption();
                HTMLRenderContext renderContext = new HTMLRenderContext();
                renderContext.setImageDirectory("image");
                HashMap<String, HTMLRenderContext> appContext = new HashMap<String, HTMLRenderContext>();
                appContext.put("HTML_RENDER_CONTEXT", renderContext);
                this.outputFileName = String.valueOf(this.outputPath) + docName + "/html/" + type + ".html";
                htmlRenderOptions.setOutputFileName(this.outputFileName);
                htmlRenderOptions.setEmitterID(null);
                htmlRenderOptions.setOutputFormat("html");
                task.setAppContext(appContext);
                task.setRenderOption((IRenderOption)htmlRenderOptions);
                task.setInstanceID(iid);
                task.render();
                RenderTaskTest.assertEquals((String)("Exception when render reportlet-" + docName + " to html."), (int)0, (int)task.getErrors().size());
                RenderTaskTest.assertTrue((String)("Render reportlet-" + docName + " to html failed. "), (boolean)new File(this.outputFileName).exists());
                this.outputFileName = String.valueOf(this.outputPath) + docName + "/pdf/" + type + ".pdf";
                htmlRenderOptions.setOutputFileName(this.outputFileName);
                htmlRenderOptions.setOutputFormat("pdf");
                htmlRenderOptions.setEmitterID(null);
                task.setRenderOption((IRenderOption)htmlRenderOptions);
                task.setInstanceID(iid);
                task.setAppContext(appContext);
                task.render();
                RenderTaskTest.assertEquals((String)("Exception when render reportlet-" + docName + " to pdf."), (int)0, (int)task.getErrors().size());
                task.close();
                RenderTaskTest.assertTrue((String)("Render reportlet-" + docName + " to pdf failed. "), (boolean)new File(this.outputFileName).exists());
            }
            catch (Exception e) {
                e.printStackTrace();
                RenderTaskTest.assertTrue((String)("Render reportlet " + type + "from" + docName + " failed. " + e.getLocalizedMessage()), (boolean)false);
            }
        }
    }

    protected void renderReportlet(String docName, String bookmark) {
        this.report_document = String.valueOf(this.outputPath) + docName + ".rptdocument";
        this.report_design = String.valueOf(this.inputPath) + docName + ".rptdesign";
        this.copyResource_INPUT(String.valueOf(docName) + ".rptdesign", String.valueOf(docName) + ".rptdesign");
        boolean toc = false;
        String s_toc = null;
        if (bookmark.substring(0, 3).equals("toc")) {
            toc = true;
        }
        this.createDir(docName);
        try {
            this.createReportDocument(this.report_design, this.report_document);
            this.reportDoc = this.engine.openReportDocument(this.report_document);
            IRenderTask task = this.engine.createRenderTask(this.reportDoc);
            HTMLRenderOption htmlRenderOptions = new HTMLRenderOption();
            HTMLRenderContext renderContext = new HTMLRenderContext();
            renderContext.setImageDirectory("image");
            HashMap<String, HTMLRenderContext> appContext = new HashMap<String, HTMLRenderContext>();
            appContext.put("HTML_RENDER_CONTEXT", renderContext);
            task.setAppContext(appContext);
            this.outputFileName = String.valueOf(this.outputPath) + docName + "/html/" + bookmark + ".html";
            htmlRenderOptions.setOutputFileName(this.outputFileName);
            htmlRenderOptions.setOutputFormat("html");
            htmlRenderOptions.setEmitterID(null);
            s_toc = toc ? ((TOCNode)this.reportDoc.findTOCByName(bookmark).get(0)).getBookmark() : bookmark;
            task.setReportlet(s_toc);
            task.setRenderOption((IRenderOption)htmlRenderOptions);
            task.render();
            RenderTaskTest.assertEquals((String)("Exception when render reportlet-" + docName + " to html."), (int)0, (int)task.getErrors().size());
            RenderTaskTest.assertTrue((String)("Render reportlet-" + docName + " to html failed. "), (boolean)new File(this.outputFileName).exists());
            this.outputFileName = String.valueOf(this.outputPath) + docName + "/pdf/" + bookmark + ".pdf";
            htmlRenderOptions.setOutputFileName(this.outputFileName);
            htmlRenderOptions.setOutputFormat("pdf");
            htmlRenderOptions.setEmitterID(null);
            task.setRenderOption((IRenderOption)htmlRenderOptions);
            task.setReportlet(s_toc);
            task.render();
            RenderTaskTest.assertEquals((String)("Exception when render reportlet-" + docName + " to pdf."), (int)0, (int)task.getErrors().size());
            task.close();
            RenderTaskTest.assertTrue((String)("Render reportlet-" + docName + " to pdf failed. "), (boolean)new File(this.outputFileName).exists());
        }
        catch (Exception e) {
            e.printStackTrace();
            RenderTaskTest.assertTrue((String)("Render reportlet " + bookmark + "from" + docName + " failed. " + e.getLocalizedMessage()), (boolean)false);
        }
    }

    protected List renderReport(String fileName, String pageRange) {
        this.report_design = String.valueOf(this.inputPath) + fileName + ".rptdesign";
        this.report_document = String.valueOf(this.outputPath) + fileName + "_reportdocument";
        this.copyResource_INPUT(String.valueOf(fileName) + ".rptdesign", String.valueOf(fileName) + ".rptdesign");
        this.createDir(fileName);
        try {
            this.createReportDocument(this.report_design, this.report_document);
            this.reportDoc = this.engine.openReportDocument(this.report_document);
            HTMLRenderOption htmlRenderOptions = new HTMLRenderOption();
            HTMLRenderOption pdfRenderOptions = new HTMLRenderOption();
            HTMLRenderContext renderContext = new HTMLRenderContext();
            renderContext.setImageDirectory("image");
            HashMap<String, HTMLRenderContext> appContext = new HashMap<String, HTMLRenderContext>();
            appContext.put("HTML_RENDER_CONTEXT", renderContext);
            htmlRenderOptions.setOutputFormat("html");
            pdfRenderOptions.setOutputFormat("pdf");
            htmlRenderOptions.getOutputSetting().put("url-encoding", "UTF-8");
            pdfRenderOptions.getOutputSetting().put("url-encoding", "UTF-8");
            if (pageRange != null && pageRange.equals("no")) {
                this.outputFileName = String.valueOf(this.outputPath) + fileName + "/html/page1" + ".html";
                this.removeFile(this.outputFileName);
                htmlRenderOptions.setOutputFileName(this.outputFileName);
                IRenderTask task = this.engine.createRenderTask(this.reportDoc);
                task.setLocale(Locale.ENGLISH);
                task.setAppContext(appContext);
                task.setRenderOption((IRenderOption)htmlRenderOptions);
                task.setPageNumber(1L);
                task.render();
                RenderTaskTest.assertEquals((String)("Exception when render the first page to html from " + fileName), (int)0, (int)task.getErrors().size());
                task.close();
                File htmlFile = new File(this.outputFileName);
                RenderTaskTest.assertTrue((String)("Render " + fileName + " to html failed. "), (boolean)htmlFile.exists());
                RenderTaskTest.assertTrue((String)("Render " + fileName + " to html failed. "), (htmlFile.length() != 0L ? 1 : 0) != 0);
                this.outputFileName = String.valueOf(this.outputPath) + fileName + "/pdf/page1" + ".pdf";
                this.removeFile(this.outputFileName);
                pdfRenderOptions.setOutputFileName(this.outputFileName);
                task = this.engine.createRenderTask(this.reportDoc);
                task.setLocale(Locale.ENGLISH);
                task.setAppContext(appContext);
                task.setRenderOption((IRenderOption)pdfRenderOptions);
                task.setPageNumber(1L);
                task.render();
                RenderTaskTest.assertEquals((String)("Exception when render the first page to pdf from " + fileName), (int)0, (int)task.getErrors().size());
                task.close();
                File pdfFile = new File(this.outputFileName);
                RenderTaskTest.assertTrue((String)("Render " + fileName + " to pdf failed. "), (boolean)pdfFile.exists());
                RenderTaskTest.assertTrue((String)("Render " + fileName + " to pdf failed. "), (pdfFile.length() != 0L ? 1 : 0) != 0);
            } else {
                this.outputFileName = String.valueOf(this.outputPath) + fileName + "/html/page" + pageRange + ".html";
                this.removeFile(this.outputFileName);
                htmlRenderOptions.setOutputFileName(this.outputFileName);
                IRenderTask task = this.engine.createRenderTask(this.reportDoc);
                task.setLocale(Locale.ENGLISH);
                task.setAppContext(appContext);
                task.setRenderOption((IRenderOption)htmlRenderOptions);
                task.setPageRange(pageRange);
                task.render();
                if (task.getErrors().size() > 0) {
                    return task.getErrors();
                }
                task.close();
                File htmlFile = new File(this.outputFileName);
                if (pageRange != null && (pageRange.equals("0") || pageRange.equals("abc"))) {
                    RenderTaskTest.assertFalse((boolean)htmlFile.exists());
                } else {
                    RenderTaskTest.assertTrue((String)("Render " + fileName + " to html failed. " + pageRange), (boolean)htmlFile.exists());
                    RenderTaskTest.assertTrue((String)("Render " + fileName + " to html failed. " + pageRange), (htmlFile.length() != 0L ? 1 : 0) != 0);
                }
                this.outputFileName = String.valueOf(this.outputPath) + fileName + "/pdf/page" + pageRange + ".pdf";
                this.removeFile(this.outputFileName);
                pdfRenderOptions.setOutputFileName(this.outputFileName);
                task = this.engine.createRenderTask(this.reportDoc);
                task.setLocale(Locale.ENGLISH);
                task.setAppContext(new HashMap());
                task.setRenderOption((IRenderOption)pdfRenderOptions);
                task.setPageRange(pageRange);
                task.render();
                if (task.getErrors().size() > 0) {
                    return task.getErrors();
                }
                task.close();
                File pdfFile = new File(this.outputFileName);
                if (pageRange != null && (pageRange.equals("0") || pageRange.equals("abc"))) {
                    RenderTaskTest.assertFalse((boolean)pdfFile.exists());
                } else {
                    RenderTaskTest.assertTrue((String)("Render " + fileName + " to pdf failed. " + pageRange), (boolean)pdfFile.exists());
                    RenderTaskTest.assertTrue((String)("Render " + fileName + " to pdf failed. " + pageRange), (pdfFile.length() != 0L ? 1 : 0) != 0);
                }
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            RenderTaskTest.assertTrue((String)("Render " + fileName + " failed. " + e.getLocalizedMessage()), (boolean)false);
            return null;
        }
    }

    protected void renderReportBookmark(String fileName, String bookmark) {
        this.report_design = String.valueOf(this.inputPath) + fileName + ".rptdesign";
        this.report_document = String.valueOf(this.outputPath) + fileName + "_reportdocument";
        this.copyResource_INPUT(String.valueOf(fileName) + ".rptdesign", String.valueOf(fileName) + ".rptdesign");
        this.createDir(fileName);
        try {
            this.createReportDocument(this.report_design, this.report_document);
            this.reportDoc = this.engine.openReportDocument(this.report_document);
            HTMLRenderOption options = new HTMLRenderOption();
            HTMLRenderContext renderContext = new HTMLRenderContext();
            renderContext.setImageDirectory("image");
            HashMap<String, HTMLRenderContext> appContext = new HashMap<String, HTMLRenderContext>();
            appContext.put("HTML_RENDER_CONTEXT", renderContext);
            options.setOutputFormat("html");
            options.setEmitterID(null);
            options.getOutputSetting().put("url-encoding", "UTF-8");
            this.outputFileName = String.valueOf(this.outputPath) + fileName + "/html/bookmark_" + bookmark + ".html";
            this.removeFile(this.outputFileName);
            options.setOutputFileName(this.outputFileName);
            IRenderTask task = this.engine.createRenderTask(this.reportDoc);
            task.setLocale(Locale.ENGLISH);
            task.setAppContext(appContext);
            task.setBookmark(bookmark);
            task.setRenderOption((IRenderOption)options);
            task.render();
            RenderTaskTest.assertEquals((String)("Exception when render html with given bookmark from " + fileName), (int)0, (int)task.getErrors().size());
            task.close();
            File htmlFile = new File(this.outputFileName);
            RenderTaskTest.assertTrue((String)("Render item with bookmark " + bookmark + " to html failed. "), (boolean)htmlFile.exists());
            RenderTaskTest.assertTrue((String)("Render item with bookmark " + bookmark + " to html failed. "), (htmlFile.length() != 0L ? 1 : 0) != 0);
            this.outputFileName = String.valueOf(this.outputPath) + fileName + "/pdf/bookmark_" + bookmark + ".pdf";
            options.setOutputFileName(this.outputFileName);
            options.setOutputFormat("pdf");
            options.setEmitterID(null);
            task = this.engine.createRenderTask(this.reportDoc);
            task.setLocale(Locale.ENGLISH);
            task.setAppContext(appContext);
            task.setBookmark(bookmark);
            task.setRenderOption((IRenderOption)options);
            task.render();
            RenderTaskTest.assertEquals((String)("Exception when render pdf with given bookmark from " + fileName), (int)0, (int)task.getErrors().size());
            task.close();
            File pdfFile = new File(this.outputFileName);
            RenderTaskTest.assertTrue((String)("Render item with bookmark " + bookmark + " to pdf failed. "), (boolean)pdfFile.exists());
            RenderTaskTest.assertTrue((String)("Render item with bookmark " + bookmark + " to pdf failed. "), (pdfFile.length() != 0L ? 1 : 0) != 0);
            this.removeFile(String.valueOf(this.outputPath) + fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            RenderTaskTest.assertTrue((String)("Render " + fileName + " failed. " + e.getLocalizedMessage()), (boolean)false);
        }
    }

    protected void createReportDocument(String reportdesign, String reportdocument) throws Exception {
        FileArchiveWriter archive = new FileArchiveWriter(reportdocument);
        IReportRunnable report = this.engine.openReportDesign(reportdesign);
        IRunTask runTask = this.engine.createRunTask(report);
        runTask.setAppContext(new HashMap());
        runTask.run((IDocArchiveWriter)archive);
        int i = runTask.getErrors().size();
        if (i > 0) {
            System.out.println("error is " + runTask.getErrors().get(0).toString());
        }
        RenderTaskTest.assertEquals((String)("Exception when generate document from " + reportdesign), (int)0, (int)i);
        runTask.close();
    }

    protected void createDir(String name) {
        String out = "output";
        File fdir = new File(String.valueOf(this.path) + out + "/" + name + "/");
        fdir.mkdir();
        fdir = new File(String.valueOf(this.path) + out + "/" + name + "/html/");
        fdir.mkdir();
        fdir = new File(String.valueOf(this.path) + out + "/" + name + "/pdf/");
        fdir.mkdir();
    }
}

