/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.engine.api.EmitterInfo;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IParameterDefnBase;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ScalarParameterDefn;
import org.eclipse.birt.report.tests.engine.EngineCase;

public class ReportEngineTest
extends EngineCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT("report_engine.rptdesign", "report_engine.rptdesign");
        this.copyResource_INPUT("parameter.rptdesign", "parameter.rptdesign");
    }

    @Override
    public void tearDown() {
        this.removeResource();
    }

    public ReportEngineTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ReportEngineTest.class);
    }

    public void testGetConfig() {
        EngineConfig config = new EngineConfig();
        config.setTempDir("tempdir");
        ReportEngine engine = new ReportEngine(config);
        EngineConfig configGet = engine.getConfig();
        ReportEngineTest.assertEquals((String)"getConfig() fail", (String)config.getTempDir(), (String)configGet.getTempDir());
    }

    public void testOpenReportDesign() throws EngineException {
        EngineConfig config = new EngineConfig();
        config.setTempDir("tempdir");
        ReportEngine engine = new ReportEngine(config);
        String designName = this.genInputFile("report_engine.rptdesign");
        try {
            IReportRunnable reportRunner = engine.openReportDesign(designName);
            designName = "file:" + designName;
            designName = designName.replace('/', '\\');
            String reportName = reportRunner.getReportName().replace('/', '\\');
            ReportEngineTest.assertEquals((String)"openReportDesign(String) fail", (String)designName.substring(designName.indexOf("org"), designName.length()), (String)reportName.substring(reportName.indexOf("org"), reportName.length()));
            ReportEngineTest.assertNotNull((String)"openReportDesign(String) fail", (Object)reportRunner.getImage("23.gif"));
        }
        catch (EngineException ee) {
            ee.printStackTrace();
            ReportEngineTest.fail((String)"openReportDesign(String) fail");
        }
        engine.destroy();
    }

    public void testOpenReportDesign1() {
        EngineConfig config = new EngineConfig();
        config.setTempDir("tempdir");
        ReportEngine engine = new ReportEngine(config);
        String designName = this.genInputFile("report_engine.rptdesign");
        try {
            File file = new File(designName);
            FileInputStream fis = new FileInputStream(file);
            IReportRunnable reportRunner = engine.openReportDesign((InputStream)fis);
            ReportEngineTest.assertEquals((String)"openReportDesign(InputStream) fail", (String)"<stream>", (String)reportRunner.getReportName());
            ReportEngineTest.assertNotNull((String)"openReportDesign(InputStream) fail", (Object)reportRunner.getImage("23.gif"));
        }
        catch (EngineException ee) {
            ee.printStackTrace();
        }
        catch (FileNotFoundException fe) {
            fe.printStackTrace();
        }
        engine.destroy();
    }

    public void testCreateGetParameterDefinitionTask() {
        EngineConfig config = new EngineConfig();
        ReportEngine engine = new ReportEngine(config);
        String designName = this.genInputFile("parameter.rptdesign");
        try {
            IReportRunnable reportRunner = engine.openReportDesign(designName);
            IGetParameterDefinitionTask getParamTask = engine.createGetParameterDefinitionTask(reportRunner);
            getParamTask.evaluateDefaults();
            IParameterDefnBase paramDefn = getParamTask.getParameterDefn("p1");
            System.err.println(paramDefn.getTypeName());
            System.err.println(paramDefn instanceof ScalarParameterDefn);
            ReportEngineTest.assertEquals((String)"creatGetParameterDefinitionTask() fail", (Object)"abc", (Object)getParamTask.getDefaultValue(paramDefn));
        }
        catch (EngineException ee) {
            ee.printStackTrace();
        }
    }

    public void testGetEmitterInfos() {
        EngineConfig config = new EngineConfig();
        ReportEngine engine = new ReportEngine(config);
        EmitterInfo[] emitters = engine.getEmitterInfo();
        boolean found = false;
        int i = 0;
        while (i < emitters.length) {
            if (emitters[i] != null && emitters[i].getID().equalsIgnoreCase("org.eclipse.birt.report.tests.engine.emitter.html")) {
                found = true;
                ReportEngineTest.assertEquals((String)"emitter_html", (String)emitters[i].getFormat());
                ReportEngineTest.assertEquals((String)"resource/test_emitter.gif", (String)emitters[i].getIcon());
                ReportEngineTest.assertEquals((String)"text/html", (String)emitters[i].getMimeType());
                ReportEngineTest.assertEquals((String)"org.eclipse.birt.report.tests.engine.emitter.html", (String)emitters[i].getNamespace());
                ReportEngineTest.assertEquals((String)"page-break-pagination", (String)emitters[i].getPagination());
                break;
            }
            ++i;
        }
        ReportEngineTest.assertTrue((boolean)found);
    }
}

