/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import java.util.Date;
import java.util.Locale;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.engine.api.ReportParameterConverter;
import org.eclipse.birt.report.tests.engine.EngineCase;

public class ReportParameterConverterTest
extends EngineCase {
    public ReportParameterConverterTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ReportParameterConverterTest.class);
    }

    public void testFormat() {
        String pStr = new String("p1Value");
        Date pDate = new Date("2005/05/06");
        Boolean pBool = new Boolean("false");
        new Integer(2);
        new Float(0.25);
        ReportParameterConverter converter = new ReportParameterConverter("(@@)", Locale.US);
        String pGet = "";
        pGet = converter.format((Object)pStr);
        ReportParameterConverterTest.assertEquals((String)"format string fail", (String)"p1Val(ue)", (String)pGet);
        converter = new ReportParameterConverter("yyyy", Locale.US);
        pGet = converter.format((Object)pDate);
        ReportParameterConverterTest.assertEquals((String)"format datetime fail", (String)"2005", (String)pGet);
        converter = new ReportParameterConverter("", Locale.US);
        pGet = converter.format((Object)pBool);
        ReportParameterConverterTest.assertEquals((String)"format  fail", (String)"false", (String)pGet);
    }

    public void testParse() {
        String str1 = "str";
        String date1 = "2005/05/06";
        String bool1 = "true";
        String int1 = "8";
        String float1 = "3.5";
        ReportParameterConverter converter = new ReportParameterConverter("(@@)", Locale.US);
        ReportParameterConverterTest.assertTrue((String)"parse string fail", (boolean)(converter.parse(str1, 1) instanceof String));
        ReportParameterConverterTest.assertEquals((String)"str", (String)converter.parse(str1, 1).toString());
        ReportParameterConverterTest.assertTrue((String)"parse datetime fail", (boolean)(converter.parse(date1, 4) instanceof Date));
        ReportParameterConverterTest.assertEquals((String)"Tue Jan 05 00:00:00 CST 2173", (String)converter.parse(date1, 4).toString());
        ReportParameterConverterTest.assertTrue((String)"parse boolean fail", (boolean)(converter.parse(bool1, 5) instanceof Boolean));
        ReportParameterConverterTest.assertEquals((String)"true", (String)converter.parse(bool1, 5).toString());
        ReportParameterConverterTest.assertTrue((String)"parse float fail", (boolean)(converter.parse(float1, 2) instanceof Double));
        float1 = "2.3E02";
        ReportParameterConverterTest.assertEquals((String)"230.0", (String)converter.parse(float1, 2).toString());
        ReportParameterConverterTest.assertTrue((String)"parse integer fail", (boolean)(converter.parse(int1, 6) instanceof Integer));
    }
}

