/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.integration.wtp.ui.project.facet;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.integration.wtp.ui.internal.util.DataUtil;
import org.eclipse.birt.integration.wtp.ui.internal.webapplication.ContextParamBean;
import org.eclipse.birt.integration.wtp.ui.internal.webapplication.FilterBean;
import org.eclipse.birt.integration.wtp.ui.internal.webapplication.FilterMappingBean;
import org.eclipse.birt.integration.wtp.ui.internal.webapplication.ListenerBean;
import org.eclipse.birt.integration.wtp.ui.internal.webapplication.ServletBean;
import org.eclipse.birt.integration.wtp.ui.internal.webapplication.ServletMappingBean;
import org.eclipse.birt.integration.wtp.ui.internal.webapplication.TagLibBean;
import org.eclipse.birt.integration.wtp.ui.internal.webapplication.WebAppBean;
import org.eclipse.birt.integration.wtp.ui.internal.wizards.IBirtWizardConstants;
import org.eclipse.birt.integration.wtp.ui.internal.wizards.SimpleImportOverwriteQuery;
import org.eclipse.birt.integration.wtp.ui.project.facet.IBirtFacetUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.core.Description;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.Listener;
import org.eclipse.jst.javaee.core.ParamValue;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.jsp.JspConfig;
import org.eclipse.jst.javaee.jsp.JspFactory;
import org.eclipse.jst.javaee.jsp.TagLib;
import org.eclipse.jst.javaee.web.Filter;
import org.eclipse.jst.javaee.web.FilterMapping;
import org.eclipse.jst.javaee.web.Servlet;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebFactory;

public class BirtFacetUtil25
implements IBirtFacetUtil,
IBirtWizardConstants {
    @Override
    public void configureContextParam(Map map, IProject project, SimpleImportOverwriteQuery query, IProgressMonitor monitor) {
        WebApp webApp = this.getWebApp(map, project, monitor);
        if (webApp == null) {
            return;
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String name = DataUtil.getString(it.next(), false);
            ContextParamBean bean = (ContextParamBean)map.get(name);
            if (bean == null) continue;
            List list = webApp.getContextParams();
            int index = this.getContextParamIndexByName(list, name);
            if (index >= 0) {
                String ret = query.queryOverwrite("Context-param '" + name + "'");
                if ("NO".equalsIgnoreCase(ret)) continue;
                if ("CANCEL".equalsIgnoreCase(ret)) {
                    monitor.setCanceled(true);
                    return;
                }
                list.remove(index);
            }
            String value = bean.getValue();
            String description = bean.getDescription();
            ParamValue param = JavaeeFactory.eINSTANCE.createParamValue();
            param.setParamName(name);
            param.setParamValue(value);
            if (description != null) {
                Description descriptionObj = JavaeeFactory.eINSTANCE.createDescription();
                descriptionObj.setValue(description);
                param.getDescriptions().add(descriptionObj);
            }
            webApp.getContextParams().add(param);
        }
    }

    private int getContextParamIndexByName(List list, String name) {
        if (list == null || name == null) {
            return -1;
        }
        Iterator it = list.iterator();
        int index = 0;
        while (it.hasNext()) {
            ParamValue param;
            Object paramObj = it.next();
            if (paramObj instanceof ParamValue && name.equals((param = (ParamValue)paramObj).getParamName())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public void configureFilter(Map map, IProject project, SimpleImportOverwriteQuery query, IProgressMonitor monitor) {
        WebApp webApp = this.getWebApp(map, project, monitor);
        if (webApp == null) {
            return;
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String name = DataUtil.getString(it.next(), false);
            FilterBean bean = (FilterBean)map.get(name);
            if (bean == null) continue;
            Object obj = this.getFilterByName(webApp, name);
            if (obj != null) {
                String ret = query.queryOverwrite("Filter '" + name + "'");
                if ("NO".equalsIgnoreCase(ret)) continue;
                if ("CANCEL".equalsIgnoreCase(ret)) {
                    monitor.setCanceled(true);
                    return;
                }
                webApp.getFilters().remove(obj);
            }
            String className = bean.getClassName();
            String description = bean.getDescription();
            Filter filter = WebFactory.eINSTANCE.createFilter();
            filter.setFilterName(name);
            filter.setFilterClass(className);
            Description descriptionObj = JavaeeFactory.eINSTANCE.createDescription();
            descriptionObj.setValue(description);
            webApp.getFilters().add(filter);
        }
    }

    private Object getFilterByName(WebApp webApp, String name) {
        if (webApp == null || name == null) {
            return null;
        }
        List filters = webApp.getFilters();
        for (Filter filter : filters) {
            if (filter == null || !name.equals(filter.getFilterName())) continue;
            return filter;
        }
        return null;
    }

    @Override
    public void configureFilterMapping(Map map, IProject project, SimpleImportOverwriteQuery query, IProgressMonitor monitor) {
        WebApp webApp = this.getWebApp(map, project, monitor);
        if (webApp == null) {
            return;
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String key = DataUtil.getString(it.next(), false);
            FilterMappingBean bean = (FilterMappingBean)map.get(key);
            if (bean == null) continue;
            Object obj = this.getFilterMappingByKey(webApp.getFilterMappings(), key);
            if (obj != null) {
                String ret = query.queryOverwrite("Filter-mapping '" + key + "'");
                if ("NO".equalsIgnoreCase(ret)) continue;
                if ("CANCEL".equalsIgnoreCase(ret)) {
                    monitor.setCanceled(true);
                    return;
                }
                webApp.getFilterMappings().remove(obj);
            }
            String name = bean.getName();
            FilterMapping mapping = WebFactory.eINSTANCE.createFilterMapping();
            Filter filter = (Filter)this.getFilterByName(webApp, name);
            if (filter == null) continue;
            mapping.setFilterName(filter.getFilterName());
            if (bean.getUri() != null) {
                UrlPatternType urlPattern = JavaeeFactory.eINSTANCE.createUrlPatternType();
                urlPattern.setValue(bean.getUri());
                mapping.getUrlPatterns().add(urlPattern);
            }
            mapping.getServletNames().add(bean.getServletName());
            Servlet servlet = this.findServletByName(webApp, bean.getServletName());
            if (servlet == null && bean.getUri() == null) continue;
            webApp.getFilterMappings().add(mapping);
        }
    }

    private Object getFilterMappingByKey(List list, String key) {
        if (list == null || key == null) {
            return null;
        }
        for (FilterMapping filterMapping : list) {
            if (filterMapping == null) continue;
            String name = filterMapping.getFilterName();
            List servletNames = filterMapping.getServletNames();
            for (String servletName : servletNames) {
                List urlPatterns = filterMapping.getUrlPatterns();
                for (UrlPatternType urlPattern : urlPatterns) {
                    String uri = urlPattern.getValue();
                    String curKey = this.getFilterMappingString(name, servletName, uri);
                    if (!key.equals(curKey)) continue;
                    return filterMapping;
                }
            }
        }
        return null;
    }

    private String getFilterMappingString(String name, String servletName, String uri) {
        return String.valueOf(name != null ? name : "") + (servletName != null ? servletName : "") + (uri != null ? uri : "");
    }

    @Override
    public void configureListener(Map map, IProject project, SimpleImportOverwriteQuery query, IProgressMonitor monitor) {
        WebApp webApp = this.getWebApp(map, project, monitor);
        if (webApp == null) {
            return;
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String name = DataUtil.getString(it.next(), false);
            ListenerBean bean = (ListenerBean)map.get(name);
            if (bean == null) continue;
            String className = bean.getClassName();
            String description = bean.getDescription();
            Object obj = this.getListenerByClassName(webApp.getListeners(), className);
            if (obj != null) continue;
            Listener listener = JavaeeFactory.eINSTANCE.createListener();
            listener.setListenerClass(className);
            if (description != null) {
                Description descriptionObj = JavaeeFactory.eINSTANCE.createDescription();
                descriptionObj.setValue(description);
                listener.getDescriptions().add(descriptionObj);
            }
            webApp.getListeners().remove(listener);
            webApp.getListeners().add(listener);
        }
    }

    private Object getListenerByClassName(List list, String className) {
        if (list == null || className == null) {
            return null;
        }
        for (Listener listener : list) {
            if (listener == null || !className.equals(listener.getListenerClass())) continue;
            return listener;
        }
        return null;
    }

    @Override
    public void configureServlet(Map map, IProject project, SimpleImportOverwriteQuery query, IProgressMonitor monitor) {
        WebApp webApp = this.getWebApp(map, project, monitor);
        if (webApp == null) {
            return;
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String name = DataUtil.getString(it.next(), false);
            ServletBean bean = (ServletBean)map.get(name);
            if (bean == null) continue;
            Servlet obj = this.findServletByName(webApp, name);
            if (obj != null) {
                String ret = query.queryOverwrite("Servlet '" + name + "'");
                if ("NO".equalsIgnoreCase(ret)) continue;
                if ("CANCEL".equalsIgnoreCase(ret)) {
                    monitor.setCanceled(true);
                    return;
                }
                webApp.getServlets().remove(obj);
            }
            String className = bean.getClassName();
            bean.getDescription();
            Servlet servlet = WebFactory.eINSTANCE.createServlet();
            servlet.setServletName(name);
            servlet.setServletClass(className);
            servlet.setLoadOnStartup((Object)1);
            webApp.getServlets().add(servlet);
        }
    }

    private WebApp getWebApp(Map map, IProject project, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return null;
        }
        if (map == null || project == null) {
            return null;
        }
        IModelProvider modelProvider = ModelProviderManager.getModelProvider((IProject)project);
        Object modelObject = modelProvider.getModelObject();
        if (!(modelObject instanceof WebApp)) {
            return null;
        }
        WebApp webApp = (WebApp)modelObject;
        return webApp;
    }

    @Override
    public void configureServletMapping(Map map, IProject project, SimpleImportOverwriteQuery query, IProgressMonitor monitor) {
        WebApp webApp = this.getWebApp(map, project, monitor);
        if (webApp == null) {
            return;
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String uri = DataUtil.getString(it.next(), false);
            ServletMappingBean bean = (ServletMappingBean)map.get(uri);
            if (bean == null) continue;
            Object obj = this.getServletMappingByUri(webApp.getServletMappings(), uri);
            if (obj != null) {
                String ret = query.queryOverwrite("Servlet-mapping '" + uri + "'");
                if ("NO".equalsIgnoreCase(ret)) continue;
                if ("CANCEL".equalsIgnoreCase(ret)) {
                    monitor.setCanceled(true);
                    return;
                }
                webApp.getServletMappings().remove(obj);
            }
            String name = bean.getName();
            ServletMapping mapping = WebFactory.eINSTANCE.createServletMapping();
            Servlet servlet = this.findServletByName(webApp, name);
            if (servlet == null) continue;
            mapping.setServletName(servlet.getServletName());
            UrlPatternType urlPattern = JavaeeFactory.eINSTANCE.createUrlPatternType();
            urlPattern.setValue(uri);
            mapping.getUrlPatterns().add(urlPattern);
            webApp.getServletMappings().add(mapping);
        }
    }

    @Override
    public void configureTaglib(Map map, IProject project, SimpleImportOverwriteQuery query, IProgressMonitor monitor) {
    }

    public void configureTaglibOrig(Map map, IProject project, SimpleImportOverwriteQuery query, IProgressMonitor monitor) {
        WebApp webApp = this.getWebApp(map, project, monitor);
        if (webApp == null) {
            return;
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String uri = DataUtil.getString(it.next(), false);
            TagLibBean bean = (TagLibBean)map.get(uri);
            if (bean == null) continue;
            Object obj = this.getTagLibByUri(webApp, uri);
            if (obj != null) {
                String ret = query.queryOverwrite("Taglib '" + uri + "'");
                if ("NO".equalsIgnoreCase(ret)) continue;
                if ("CANCEL".equalsIgnoreCase(ret)) {
                    monitor.setCanceled(true);
                    return;
                }
                List jspConfigs = webApp.getJspConfigs();
                for (JspConfig jspConfig : jspConfigs) {
                    jspConfig.getTagLibs().remove(obj);
                }
            }
            String location = bean.getLocation();
            JspConfig jspConfig = JspFactory.eINSTANCE.createJspConfig();
            TagLib ref = JspFactory.eINSTANCE.createTagLib();
            ref.setTaglibUri(uri);
            ref.setTaglibLocation(location);
            jspConfig.getTagLibs().add(ref);
            webApp.getJspConfigs().add(jspConfig);
        }
    }

    private Object getTagLibByUri(WebApp webapp, String uri) {
        if (webapp == null || uri == null) {
            return null;
        }
        List jspConfigs = webapp.getJspConfigs();
        for (JspConfig jspConfig : jspConfigs) {
            List list = jspConfig.getTagLibs();
            for (Object obj : list) {
                TagLib ref = (TagLib)obj;
                if (!uri.equals(ref.getTaglibUri())) continue;
                return ref;
            }
        }
        return null;
    }

    @Override
    public void configureWebApp(WebAppBean webAppBean, IProject project, SimpleImportOverwriteQuery query, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        if (webAppBean == null || project == null) {
            return;
        }
        IModelProvider modelProvider = ModelProviderManager.getModelProvider((IProject)project);
        Object modelObject = modelProvider.getModelObject();
        if (!(modelObject instanceof WebApp)) {
            return;
        }
        WebApp webApp = (WebApp)modelObject;
        Description descriptionObj = JavaeeFactory.eINSTANCE.createDescription();
        descriptionObj.setValue(webAppBean.getDescription());
        webApp.getDescriptions().add(descriptionObj);
    }

    private Servlet findServletByName(WebApp webApp, String name) {
        for (Servlet servlet : webApp.getServlets()) {
            if (servlet.getServletName() == null || !servlet.getServletName().trim().equals(name)) continue;
            return servlet;
        }
        return null;
    }

    private Object getServletMappingByUri(List list, String uri) {
        if (list == null || uri == null) {
            return null;
        }
        for (ServletMapping servletMapping : list) {
            if (servletMapping == null) continue;
            List urlPaterns = servletMapping.getUrlPatterns();
            for (UrlPatternType patern : urlPaterns) {
                if (patern == null || !uri.equals(patern.getValue())) continue;
                return servletMapping;
            }
        }
        return null;
    }

    @Override
    public void initializeWebapp(Map map, IProject project) {
        if (project == null) {
            return;
        }
        if (map == null) {
            map = new HashMap();
        }
        IModelProvider modelProvider = ModelProviderManager.getModelProvider((IProject)project);
        WebApp webapp = (WebApp)modelProvider.getModelObject();
        this.initializeContextParam(map, webapp);
    }

    protected void initializeContextParam(Map map, WebApp webapp) {
        if (webapp == null) {
            return;
        }
        Map son = (Map)map.get("context-param");
        if (son == null) {
            return;
        }
        List list = webapp.getContextParams();
        for (String name : son.keySet()) {
            Description descObj;
            Object obj = this.getContextParamByName(list, name);
            if (obj == null) continue;
            String value = null;
            String description = null;
            ParamValue param = (ParamValue)obj;
            name = param.getParamName();
            value = param.getParamValue();
            List descList = param.getDescriptions();
            if (descList != null && descList.size() > 0 && (descObj = (Description)descList.get(0)) != null) {
                description = descObj.getValue();
            }
            if (value == null) continue;
            ContextParamBean bean = new ContextParamBean(name, value);
            bean.setDescription(description);
            son.put(name, bean);
        }
    }

    private Object getContextParamByName(List list, String name) {
        if (list == null || name == null) {
            return null;
        }
        for (Object paramObj : list) {
            ParamValue param = (ParamValue)paramObj;
            if (!name.equals(param.getParamName())) continue;
            return param;
        }
        return null;
    }
}

