/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart;

import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.Stretch;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.util.ChartDefaultValueUtil;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.AbstractChartInsets;
import org.eclipse.birt.chart.ui.swt.AbstractChartIntSpinner;
import org.eclipse.birt.chart.ui.swt.ChartCombo;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.LineAttributesComposite;
import org.eclipse.birt.chart.ui.swt.composites.LocalizedNumberEditorComposite;
import org.eclipse.birt.chart.ui.swt.fieldassist.TextNumberEditorAssistField;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.util.ChartUIExtensionUtil;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class PlotClientAreaSheet
extends AbstractPopupSheet
implements Listener,
ModifyListener,
SelectionListener {
    static final int AUTO = -1;
    private transient Composite cmpContent;
    private transient ChartCombo cmbAnchor;
    private transient ChartCombo cmbStretch;
    private transient LineAttributesComposite outlineIncluding;
    private transient LineAttributesComposite outlineWithin;
    private transient AbstractChartInsets icIncluding;
    private transient AbstractChartInsets icWithin;
    private transient AbstractChartIntSpinner iscVSpacing;
    private transient AbstractChartIntSpinner iscHSpacing;
    private transient LocalizedNumberEditorComposite txtHeight;
    private transient LocalizedNumberEditorComposite txtWidth;
    private transient FillChooserComposite fccShadow;
    private Button btnHeight;
    private Button btnWidth;

    public PlotClientAreaSheet(String title, ChartWizardContext context) {
        super(title, context, true);
    }

    protected Composite getComponent(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.AreaFormat_ID");
        this.cmpContent = new Composite(parent, 0);
        this.cmpContent.setLayout((Layout)new GridLayout());
        Group grpAreaIncluding = new Group(this.cmpContent, 0);
        grpAreaIncluding.setLayout((Layout)new GridLayout(2, true));
        GridData gd = new GridData(768);
        grpAreaIncluding.setLayoutData((Object)gd);
        grpAreaIncluding.setText(this.getChart() instanceof ChartWithAxes ? Messages.getString("ChartPlotSheetImpl.Label.AreaIncludingAxes") : Messages.getString("ChartPlotSheetImpl.Label.PlotArea"));
        Composite leftComp = new Composite((Composite)grpAreaIncluding, 0);
        GridData gdL = new GridData(768);
        leftComp.setLayout((Layout)new GridLayout(3, false));
        leftComp.setLayoutData((Object)gdL);
        Composite rightComp = new Composite((Composite)grpAreaIncluding, 0);
        GridData gdR = new GridData(768);
        rightComp.setLayout((Layout)new GridLayout(1, false));
        rightComp.setLayoutData((Object)gdR);
        Label lblAnchor = new Label(leftComp, 0);
        GridData gdLBLAnchor = new GridData();
        lblAnchor.setLayoutData((Object)gdLBLAnchor);
        lblAnchor.setText(Messages.getString("MoreOptionsChartPlotSheet.Label.Anchor"));
        this.cmbAnchor = this.getContext().getUIFactory().createChartCombo(leftComp, 12, (EObject)this.getBlockForProcessing(), "anchor", ChartDefaultValueUtil.getDefaultPlot((Chart)this.getChart()).getAnchor().getName());
        GridData gdCBAnchor = new GridData(768);
        gdCBAnchor.horizontalSpan = 2;
        this.cmbAnchor.setLayoutData((Object)gdCBAnchor);
        this.cmbAnchor.addSelectionListener((SelectionListener)this);
        this.cmbAnchor.getWidget().setVisibleItemCount(30);
        Label lblStretch = new Label(leftComp, 0);
        GridData gd2 = new GridData();
        lblStretch.setLayoutData((Object)gd2);
        lblStretch.setText(Messages.getString("MoreOptionsChartPlotSheet.Label.Stretch"));
        this.cmbStretch = this.getContext().getUIFactory().createChartCombo(leftComp, 12, (EObject)this.getBlockForProcessing(), "stretch", ChartDefaultValueUtil.getDefaultPlot((Chart)this.getChart()).getStretch().getName());
        gd2 = new GridData(768);
        gd2.horizontalSpan = 2;
        this.cmbStretch.setLayoutData((Object)gd2);
        this.cmbStretch.addSelectionListener((SelectionListener)this);
        Label lblVerticalSpacing = new Label(leftComp, 0);
        lblVerticalSpacing.setLayoutData((Object)new GridData());
        lblVerticalSpacing.setText(Messages.getString("BlockAttributeComposite.Lbl.VerticalSpacing"));
        this.iscVSpacing = this.getContext().getUIFactory().createChartIntSpinner(leftComp, 0, this.getBlockForProcessing().getVerticalSpacing(), (EObject)this.getBlockForProcessing(), "verticalSpacing", true);
        GridData gd3 = new GridData(768);
        gd3.horizontalSpan = 2;
        this.iscVSpacing.setLayoutData((Object)gd3);
        this.iscVSpacing.addListener((Listener)this);
        Label lblHorizontalSpacing = new Label(leftComp, 0);
        lblHorizontalSpacing.setLayoutData((Object)new GridData());
        lblHorizontalSpacing.setText(Messages.getString("BlockAttributeComposite.Lbl.HorizontalSpacing"));
        this.iscHSpacing = this.getContext().getUIFactory().createChartIntSpinner(leftComp, 0, this.getBlockForProcessing().getHorizontalSpacing(), (EObject)this.getBlockForProcessing(), "horizontalSpacing", true);
        gd3 = new GridData(768);
        gd3.horizontalSpan = 2;
        this.iscHSpacing.setLayoutData((Object)gd3);
        this.iscHSpacing.addListener((Listener)this);
        new Label(leftComp, 0).setText(Messages.getString("PlotClientAreaSheet.Label.HeightHint"));
        this.txtHeight = new LocalizedNumberEditorComposite(leftComp, 2048);
        new TextNumberEditorAssistField(this.txtHeight.getTextControl(), null);
        this.txtHeight.setLayoutData(new GridData(768));
        this.txtHeight.addModifyListener(this);
        this.btnHeight = new Button(leftComp, 32);
        this.btnHeight.setText(Messages.getString("PlotClientAreaSheet.Btn.Auto"));
        gd3 = new GridData();
        this.btnHeight.setLayoutData((Object)gd3);
        this.btnHeight.addSelectionListener((SelectionListener)this);
        new Label(leftComp, 0).setText(Messages.getString("PlotClientAreaSheet.Label.WidthHint"));
        this.txtWidth = new LocalizedNumberEditorComposite(leftComp, 2048);
        new TextNumberEditorAssistField(this.txtWidth.getTextControl(), null);
        this.txtWidth.setLayoutData(new GridData(768));
        this.txtWidth.addModifyListener(this);
        this.btnWidth = new Button(leftComp, 32);
        this.btnWidth.setText(Messages.getString("PlotClientAreaSheet.Btn.Auto2"));
        gd3 = new GridData();
        this.btnWidth.setLayoutData((Object)gd3);
        this.btnWidth.addSelectionListener((SelectionListener)this);
        this.updateHeightWidthHint();
        Group grpOutline = new Group(rightComp, 0);
        GridData gdGRPOutline = new GridData(768);
        gdGRPOutline.widthHint = 150;
        grpOutline.setLayoutData((Object)gdGRPOutline);
        grpOutline.setLayout((Layout)new FillLayout());
        grpOutline.setText(Messages.getString("MoreOptionsChartPlotSheet.Label.Outline"));
        int lineStyles = 11;
        this.outlineIncluding = new LineAttributesComposite((Composite)grpOutline, 0, lineStyles |= this.getContext().getUIFactory().supportAutoUI() ? 16 : lineStyles, this.getContext(), this.getBlockForProcessing().getOutline(), ChartDefaultValueUtil.getDefaultPlot((Chart)this.getChart()).getOutline());
        this.outlineIncluding.addListener(this);
        this.icIncluding = this.getContext().getUIFactory().createChartInsetsComposite(rightComp, 0, 2, this.getBlockForProcessing().getInsets(), this.getChart().getUnits(), this.getContext().getUIServiceProvider(), this.getContext(), ChartDefaultValueUtil.getDefaultPlot((Chart)this.getChart()).getInsets());
        GridData gdInsets = new GridData(768);
        this.icIncluding.setLayoutData((Object)gdInsets);
        Group grpAreaWithin = new Group(this.cmpContent, 0);
        grpAreaWithin.setLayout((Layout)new GridLayout(4, false));
        gd3 = new GridData(768);
        grpAreaWithin.setLayoutData((Object)gd3);
        grpAreaWithin.setText(this.getChart() instanceof ChartWithAxes ? Messages.getString("ChartPlotSheetImpl.Label.AreaWithinAxes") : Messages.getString("ChartPlotSheetImpl.Label.ClientArea"));
        this.createClientArea(grpAreaWithin);
        this.populateLists();
        return this.cmpContent;
    }

    private void updateHeightWidthHint() {
        double hint;
        if (this.getBlockForProcessing().isSetHeightHint()) {
            hint = this.getBlockForProcessing().getHeightHint();
            if (hint == -1.0) {
                this.btnHeight.setSelection(true);
                this.txtHeight.unsetValue();
                this.txtHeight.setEnabled(false);
            } else {
                this.btnHeight.setSelection(false);
                this.txtHeight.setValue(hint);
            }
        } else {
            this.btnHeight.setSelection(true);
            this.txtHeight.unsetValue();
            this.txtHeight.setEnabled(false);
        }
        if (this.getBlockForProcessing().isSetWidthHint()) {
            hint = this.getBlockForProcessing().getWidthHint();
            if (hint == -1.0) {
                this.btnWidth.setSelection(true);
                this.txtWidth.unsetValue();
                this.txtWidth.setEnabled(false);
            } else {
                this.btnWidth.setSelection(false);
                this.txtWidth.setValue(hint);
            }
        } else {
            this.btnWidth.setSelection(true);
            this.txtWidth.unsetValue();
            this.txtWidth.setEnabled(false);
        }
    }

    private void createClientArea(Group grpAreaWithin) {
        boolean isNot3D = !ChartUIUtil.is3DType((Chart)this.getChart());
        Label lblShadow = new Label((Composite)grpAreaWithin, 0);
        GridData gdLBLShadow = new GridData();
        lblShadow.setLayoutData((Object)gdLBLShadow);
        lblShadow.setText(Messages.getString("ClientAreaAttributeComposite.Lbl.Shadow"));
        lblShadow.setEnabled(isNot3D);
        int fillStyles = 152;
        this.fccShadow = new FillChooserComposite((Composite)grpAreaWithin, 0, fillStyles |= this.getContext().getUIFactory().supportAutoUI() ? 4 : fillStyles, this.getContext(), (Fill)this.getBlockForProcessing().getClientArea().getShadowColor());
        GridData gdFCCShadow = new GridData(768);
        this.fccShadow.setLayoutData(gdFCCShadow);
        this.fccShadow.addListener(this);
        this.fccShadow.setEnabled(isNot3D);
        Group grpOutline = new Group((Composite)grpAreaWithin, 0);
        GridData gdGRPOutline = new GridData(768);
        gdGRPOutline.horizontalSpan = 2;
        gdGRPOutline.verticalSpan = 2;
        grpOutline.setLayoutData((Object)gdGRPOutline);
        grpOutline.setLayout((Layout)new FillLayout());
        grpOutline.setText(Messages.getString("MoreOptionsChartPlotSheet.Label.Outline"));
        int lineStyles = 11;
        this.outlineWithin = new LineAttributesComposite((Composite)grpOutline, 0, lineStyles |= this.getContext().getUIFactory().supportAutoUI() ? 16 : lineStyles, this.getContext(), this.getBlockForProcessing().getClientArea().getOutline(), ChartDefaultValueUtil.getDefaultPlot((Chart)this.getChart()).getClientArea().getOutline());
        this.outlineWithin.addListener(this);
        this.outlineWithin.setAttributesEnabled(ChartUIUtil.is3DWallFloorSet((Chart)this.getChart()));
        this.icWithin = this.getContext().getUIFactory().createChartInsetsComposite((Composite)grpAreaWithin, 0, 2, this.getBlockForProcessing().getClientArea().getInsets(), this.getChart().getUnits(), this.getContext().getUIServiceProvider(), this.getContext(), ChartDefaultValueUtil.getDefaultPlot((Chart)this.getChart()).getClientArea().getInsets());
        GridData gdInsets = new GridData(768);
        gdInsets.horizontalSpan = 2;
        this.icWithin.setLayoutData((Object)gdInsets);
        this.icWithin.setEnabled(isNot3D);
    }

    private void populateLists() {
        NameSet ns = LiteralHelper.anchorSet;
        this.cmbAnchor.setItems(ns.getDisplayNames());
        this.cmbAnchor.setItemData(ns.getNames());
        this.cmbAnchor.setSelection(this.getBlockForProcessing().getAnchor().getName());
        ns = LiteralHelper.stretchSet;
        this.cmbStretch.setItems(ns.getDisplayNames());
        this.cmbStretch.setItemData(ns.getNames());
        this.cmbStretch.setSelection(this.getBlockForProcessing().getStretch().getName());
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget.equals((Object)this.txtHeight)) {
            if (this.txtHeight.isSetValue()) {
                double height = this.txtHeight.getValue();
                double max = this.getChart().getBlock().getBounds().getHeight();
                max = max > 0.0 ? max : 130.0;
                height = height > max ? max : height;
                this.getBlockForProcessing().setHeightHint(height);
                if (height != this.txtHeight.getValue()) {
                    this.txtHeight.setValue(height);
                }
            } else {
                this.getBlockForProcessing().unsetHeightHint();
            }
        } else if (e.widget.equals((Object)this.txtWidth)) {
            if (this.txtWidth.isSetValue()) {
                double width = this.txtWidth.getValue();
                double max = this.getChart().getBlock().getBounds().getWidth();
                max = max > 0.0 ? max : 220.0;
                width = width > max ? max : width;
                this.getBlockForProcessing().setWidthHint(width);
                if (width != this.txtWidth.getValue()) {
                    this.txtWidth.setValue(width);
                }
            } else {
                this.getBlockForProcessing().unsetWidthHint();
            }
        }
    }

    public void handleEvent(Event event) {
        boolean isUnset;
        boolean bl = isUnset = event.detail == ChartUIExtensionUtil.PROPERTY_UNSET;
        if (event.widget.equals((Object)this.outlineIncluding)) {
            switch (event.type) {
                case 1: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getBlockForProcessing().getOutline(), (String)"style", (Object)event.data, (boolean)isUnset);
                    break;
                }
                case 2: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getBlockForProcessing().getOutline(), (String)"thickness", (Object)((Integer)event.data), (boolean)isUnset);
                    break;
                }
                case 3: {
                    this.getBlockForProcessing().getOutline().setColor((ColorDefinition)event.data);
                    break;
                }
                case 4: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getBlockForProcessing().getOutline(), (String)"visible", (Object)((Boolean)event.data), (boolean)isUnset);
                }
            }
        } else if (event.widget.equals((Object)this.outlineWithin)) {
            switch (event.type) {
                case 1: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getBlockForProcessing().getClientArea().getOutline(), (String)"style", (Object)event.data, (boolean)isUnset);
                    break;
                }
                case 2: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getBlockForProcessing().getClientArea().getOutline(), (String)"thickness", (Object)((Integer)event.data), (boolean)isUnset);
                    break;
                }
                case 3: {
                    this.getBlockForProcessing().getClientArea().getOutline().setColor((ColorDefinition)event.data);
                    break;
                }
                case 4: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getBlockForProcessing().getClientArea().getOutline(), (String)"visible", (Object)((Boolean)event.data), (boolean)isUnset);
                }
            }
        } else if (event.widget.equals((Object)this.fccShadow)) {
            this.getBlockForProcessing().getClientArea().setShadowColor((ColorDefinition)event.data);
        } else if (event.widget.equals(this.iscHSpacing)) {
            ChartElementUtil.setEObjectAttribute((EObject)this.getBlockForProcessing(), (String)"horizontalSpacing", (Object)((Integer)event.data), (event.detail == ChartUIExtensionUtil.PROPERTY_UNSET ? 1 : 0) != 0);
        } else if (event.widget.equals(this.iscVSpacing)) {
            ChartElementUtil.setEObjectAttribute((EObject)this.getBlockForProcessing(), (String)"verticalSpacing", (Object)((Integer)event.data), (event.detail == ChartUIExtensionUtil.PROPERTY_UNSET ? 1 : 0) != 0);
        } else if (event.widget.equals(this.icIncluding)) {
            this.getBlockForProcessing().setInsets((Insets)event.data);
        } else if (event.widget.equals(this.icWithin)) {
            this.getBlockForProcessing().getClientArea().setInsets((Insets)event.data);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Plot plot = this.getBlockForProcessing();
        Object oSource = e.getSource();
        if (oSource.equals(this.cmbAnchor)) {
            String selectedAnchor = this.cmbAnchor.getSelectedItemData();
            if (selectedAnchor != null) {
                plot.setAnchor(Anchor.getByName((String)selectedAnchor));
            }
        } else if (oSource.equals(this.cmbStretch)) {
            String selectedStretch = this.cmbStretch.getSelectedItemData();
            if (selectedStretch != null) {
                plot.setStretch(Stretch.getByName((String)selectedStretch));
            }
        } else if (oSource == this.btnHeight) {
            if (this.btnHeight.getSelection()) {
                plot.unsetHeightHint();
                this.txtHeight.setEnabled(false);
            } else {
                this.txtHeight.setEnabled(true);
                if (this.txtHeight.isSetValue()) {
                    plot.setHeightHint(this.txtHeight.getValue());
                } else {
                    plot.unsetHeightHint();
                }
            }
        } else if (oSource == this.btnWidth) {
            if (this.btnWidth.getSelection()) {
                plot.setWidthHint(-1.0);
                this.txtWidth.setEnabled(false);
            } else {
                this.txtWidth.setEnabled(true);
                if (this.txtWidth.isSetValue()) {
                    plot.setWidthHint(this.txtWidth.getValue());
                } else {
                    plot.unsetWidthHint();
                }
            }
        }
    }

    public String getTitleText() {
        return Messages.getString("AttributeSheetImpl.Title.SheetTitle");
    }

    private Plot getBlockForProcessing() {
        return this.getChart().getPlot();
    }
}

