/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineConstants;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.api.script.eventadapter.AutoTextEventAdapter;
import org.eclipse.birt.report.engine.api.script.eventadapter.CellEventAdapter;
import org.eclipse.birt.report.engine.api.script.eventadapter.DataItemEventAdapter;
import org.eclipse.birt.report.engine.api.script.eventadapter.DynamicTextEventAdapter;
import org.eclipse.birt.report.engine.api.script.eventadapter.GridEventAdapter;
import org.eclipse.birt.report.engine.api.script.eventadapter.ImageEventAdapter;
import org.eclipse.birt.report.engine.api.script.eventadapter.LabelEventAdapter;
import org.eclipse.birt.report.engine.api.script.eventadapter.ListEventAdapter;
import org.eclipse.birt.report.engine.api.script.eventadapter.ListGroupEventAdapter;
import org.eclipse.birt.report.engine.api.script.eventadapter.RowEventAdapter;
import org.eclipse.birt.report.engine.api.script.eventadapter.TableEventAdapter;
import org.eclipse.birt.report.engine.api.script.eventadapter.TableGroupEventAdapter;
import org.eclipse.birt.report.engine.api.script.eventadapter.TextItemEventAdapter;
import org.eclipse.birt.report.engine.api.script.eventhandler.IAutoTextEventHandler;
import org.eclipse.birt.report.engine.api.script.eventhandler.ICellEventHandler;
import org.eclipse.birt.report.engine.api.script.eventhandler.IDataItemEventHandler;
import org.eclipse.birt.report.engine.api.script.eventhandler.IDynamicTextEventHandler;
import org.eclipse.birt.report.engine.api.script.eventhandler.IGridEventHandler;
import org.eclipse.birt.report.engine.api.script.eventhandler.IImageEventHandler;
import org.eclipse.birt.report.engine.api.script.eventhandler.ILabelEventHandler;
import org.eclipse.birt.report.engine.api.script.eventhandler.IListEventHandler;
import org.eclipse.birt.report.engine.api.script.eventhandler.IListGroupEventHandler;
import org.eclipse.birt.report.engine.api.script.eventhandler.IRowEventHandler;
import org.eclipse.birt.report.engine.api.script.eventhandler.ITableEventHandler;
import org.eclipse.birt.report.engine.api.script.eventhandler.ITableGroupEventHandler;
import org.eclipse.birt.report.engine.api.script.eventhandler.ITextItemEventHandler;
import org.eclipse.birt.report.engine.api.script.instance.IAutoTextInstance;
import org.eclipse.birt.report.engine.api.script.instance.ICellInstance;
import org.eclipse.birt.report.engine.api.script.instance.IDataItemInstance;
import org.eclipse.birt.report.engine.api.script.instance.IDynamicTextInstance;
import org.eclipse.birt.report.engine.api.script.instance.IGridInstance;
import org.eclipse.birt.report.engine.api.script.instance.IImageInstance;
import org.eclipse.birt.report.engine.api.script.instance.ILabelInstance;
import org.eclipse.birt.report.engine.api.script.instance.IListInstance;
import org.eclipse.birt.report.engine.api.script.instance.IReportElementInstance;
import org.eclipse.birt.report.engine.api.script.instance.IRowInstance;
import org.eclipse.birt.report.engine.api.script.instance.ITableInstance;
import org.eclipse.birt.report.engine.api.script.instance.ITextItemInstance;
import org.eclipse.birt.report.engine.executor.EventHandlerManager;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.AutoTextItemDesign;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.DefaultReportItemVisitorImpl;
import org.eclipse.birt.report.engine.ir.DynamicTextItemDesign;
import org.eclipse.birt.report.engine.ir.Expression;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.ImageItemDesign;
import org.eclipse.birt.report.engine.ir.LabelItemDesign;
import org.eclipse.birt.report.engine.ir.ListGroupDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.ir.TableGroupDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.ir.TemplateDesign;
import org.eclipse.birt.report.engine.ir.TextItemDesign;
import org.eclipse.birt.report.model.api.DesignElementHandle;

public class ScriptExecutor {
    public static final String PROPERTYSEPARATOR = EngineConstants.PROPERTYSEPARATOR;
    public static final String WEBAPP_CLASSPATH_KEY = "webapplication.projectclasspath";
    public static final String WORKSPACE_CLASSPATH_KEY = "workspace.projectclasspath";
    public static final String PROJECT_CLASSPATH_KEY = "user.projectclasspath";
    protected static Logger log = Logger.getLogger(ScriptExecutor.class.getName());
    private static ScriptChecker scriptChecker = new ScriptChecker();

    protected static ScriptStatus handleScript(Object scope, Expression expr, ExecutionContext context) throws BirtException {
        return ScriptExecutor.handleScriptInternal(scope, expr, context);
    }

    private static ScriptStatus handleScriptInternal(Object scope, Expression expr, ExecutionContext context) throws BirtException {
        if (expr != null) {
            try {
                if (scope != null) {
                    context.newScope(scope);
                }
                Object result = null;
                result = context.evaluate(expr);
                ScriptStatus scriptStatus = new ScriptStatus(true, result);
                return scriptStatus;
            }
            finally {
                if (scope != null) {
                    context.exitScope();
                }
            }
        }
        return ScriptStatus.NO_RUN;
    }

    protected static boolean needOnCreate(ReportItemDesign design) {
        if (design == null) {
            return false;
        }
        return design.getOnCreate() != null || design.getJavaClass() != null;
    }

    protected static boolean needOnRender(ReportItemDesign design) {
        if (design == null) {
            return false;
        }
        return design.getOnRender() != null || design.getJavaClass() != null;
    }

    public static boolean needOnPageBreak(ReportItemDesign design, ExecutionContext context) {
        if (design == null) {
            return false;
        }
        if (design.getOnPageBreak() != null) {
            return true;
        }
        String javaClass = design.getJavaClass();
        if (javaClass == null) {
            return false;
        }
        Object extensionData = design.getExtensionData();
        if (extensionData != null) {
            return (Boolean)extensionData;
        }
        EventHandlerManager eventHandlerManager = context.getEventHandlerManager();
        Class clazz = null;
        boolean result = false;
        try {
            clazz = EventHandlerManager.loadClass(javaClass, context);
            result = (Boolean)design.accept(scriptChecker, clazz);
        }
        catch (EngineException e) {
            e.printStackTrace();
        }
        design.setExtensionData(result);
        return result;
    }

    protected static Object getInstance(DesignElementHandle handle, ExecutionContext context) throws EngineException {
        EventHandlerManager eventHandlerManager = context.getEventHandlerManager();
        return eventHandlerManager.getInstance(handle, context);
    }

    protected static Object getInstance(String className, ExecutionContext context) throws EngineException {
        EventHandlerManager eventHandlerManager = context.getEventHandlerManager();
        return EventHandlerManager.getInstance(className, context);
    }

    protected static Object getInstance(ReportItemDesign design, ExecutionContext context) throws EngineException {
        EventHandlerManager eventHandlerManager = context.getEventHandlerManager();
        return eventHandlerManager.getInstance(design, context);
    }

    protected static void addClassCastException(ExecutionContext context, Exception e, DesignElementHandle handle, Class requiredInterface) {
        EngineException ex = new EngineException("Error.ScriptClassCastError", new Object[]{handle.getEventHandlerClass(), requiredInterface.getName()}, (Throwable)e);
        log.log(Level.WARNING, e.getMessage(), e);
        if (context == null) {
            return;
        }
        context.addException(handle, (BirtException)ex);
    }

    protected static void addException(ExecutionContext context, Exception e) {
        ScriptExecutor.addException(context, e, null);
    }

    protected static void addException(ExecutionContext context, Exception e, DesignElementHandle handle) {
        EngineException eex = null;
        eex = e instanceof EngineException ? (EngineException)e : (e instanceof BirtException ? new EngineException((BirtException)e) : new EngineException("Error.UnhandledScriptError", e));
        log.log(Level.WARNING, eex.getMessage(), eex);
        if (context == null) {
            return;
        }
        if (handle == null) {
            context.addException(eex);
        } else {
            context.addException(handle, (BirtException)eex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScriptChecker
    extends DefaultReportItemVisitorImpl {
        private ScriptChecker() {
        }

        @Override
        public Object visitListItem(ListItemDesign list, Object value) {
            return this.checkOnPageBreakMethod((Class)value, IListEventHandler.class, IListInstance.class, ListEventAdapter.class);
        }

        @Override
        public Object visitTextItem(TextItemDesign text, Object value) {
            return this.checkOnPageBreakMethod((Class)value, ITextItemEventHandler.class, ITextItemInstance.class, TextItemEventAdapter.class);
        }

        @Override
        public Object visitLabelItem(LabelItemDesign label, Object value) {
            return this.checkOnPageBreakMethod((Class)value, ILabelEventHandler.class, ILabelInstance.class, LabelEventAdapter.class);
        }

        @Override
        public Object visitAutoTextItem(AutoTextItemDesign autoText, Object value) {
            return this.checkOnPageBreakMethod((Class)value, IAutoTextEventHandler.class, IAutoTextInstance.class, AutoTextEventAdapter.class);
        }

        @Override
        public Object visitDataItem(DataItemDesign data, Object value) {
            return this.checkOnPageBreakMethod((Class)value, IDataItemEventHandler.class, IDataItemInstance.class, DataItemEventAdapter.class);
        }

        @Override
        public Object visitDynamicTextItem(DynamicTextItemDesign multiLine, Object value) {
            return this.checkOnPageBreakMethod((Class)value, IDynamicTextEventHandler.class, IDynamicTextInstance.class, DynamicTextEventAdapter.class);
        }

        @Override
        public Object visitGridItem(GridItemDesign grid, Object value) {
            return this.checkOnPageBreakMethod((Class)value, IGridEventHandler.class, IGridInstance.class, GridEventAdapter.class);
        }

        @Override
        public Object visitTableItem(TableItemDesign table, Object value) {
            return this.checkOnPageBreakMethod((Class)value, ITableEventHandler.class, ITableInstance.class, TableEventAdapter.class);
        }

        @Override
        public Object visitImageItem(ImageItemDesign image, Object value) {
            return this.checkOnPageBreakMethod((Class)value, IImageEventHandler.class, IImageInstance.class, ImageEventAdapter.class);
        }

        @Override
        public Object visitRow(RowDesign row, Object value) {
            return this.checkOnPageBreakMethod((Class)value, IRowEventHandler.class, IRowInstance.class, RowEventAdapter.class);
        }

        @Override
        public Object visitCell(CellDesign cell, Object value) {
            return this.checkOnPageBreakMethod((Class)value, ICellEventHandler.class, ICellInstance.class, CellEventAdapter.class);
        }

        @Override
        public Object visitTemplate(TemplateDesign template, Object value) {
            return this.checkOnPageBreakMethod((Class)value, ITextItemEventHandler.class, ITextItemInstance.class, TextItemEventAdapter.class);
        }

        @Override
        public Object visitListGroup(ListGroupDesign group, Object value) {
            return this.checkOnPageBreakMethod((Class)value, IListGroupEventHandler.class, IReportElementInstance.class, ListGroupEventAdapter.class);
        }

        @Override
        public Object visitTableGroup(TableGroupDesign group, Object value) {
            return this.checkOnPageBreakMethod((Class)value, ITableGroupEventHandler.class, IReportElementInstance.class, TableGroupEventAdapter.class);
        }

        @Override
        public Object visitReportItem(ReportItemDesign item, Object value) {
            return false;
        }

        public Object checkOnPageBreakMethod(Class<?> clazz, Class<?> handler, Class<?> instance, Class<?> adapter) {
            if (!handler.isAssignableFrom(clazz)) {
                return false;
            }
            try {
                Method method = clazz.getMethod("onPageBreak", instance, IReportContext.class);
                if (method.getDeclaringClass() != adapter) {
                    return true;
                }
                return false;
            }
            catch (SecurityException securityException) {
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return false;
            }
        }
    }

    protected static class ScriptStatus {
        private boolean didRun;
        private Object result;
        public static final ScriptStatus NO_RUN = new ScriptStatus(false, null);

        public ScriptStatus(boolean didRun, Object result) {
            this.didRun = didRun;
            this.result = result;
        }

        public boolean didRun() {
            return this.didRun;
        }

        public Object result() {
            return this.result;
        }
    }
}

