/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.swt.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.CursorType;
import org.eclipse.birt.chart.util.SecurityUtil;

public class SwtUtil {
    private static final ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.device.extension/util");
    public static final Map<CursorType, Integer> CURSOR_MAP = new HashMap<CursorType, Integer>();

    static {
        CURSOR_MAP.put(CursorType.CROSSHAIR, 2);
        CURSOR_MAP.put(CursorType.DEFAULT, 0);
        CURSOR_MAP.put(CursorType.POINTER, 21);
        CURSOR_MAP.put(CursorType.MOVE, 5);
        CURSOR_MAP.put(CursorType.TEXT, 19);
        CURSOR_MAP.put(CursorType.WAIT, 1);
        CURSOR_MAP.put(CursorType.ERESIZE, 12);
        CURSOR_MAP.put(CursorType.NE_RESIZE, 14);
        CURSOR_MAP.put(CursorType.NW_RESIZE, 17);
        CURSOR_MAP.put(CursorType.NRESIZE, 10);
        CURSOR_MAP.put(CursorType.SE_RESIZE, 15);
        CURSOR_MAP.put(CursorType.SW_RESIZE, 16);
        CURSOR_MAP.put(CursorType.SRESIZE, 11);
        CURSOR_MAP.put(CursorType.WRESIZE, 13);
    }

    private SwtUtil() {
    }

    public static void openURL(String href) {
        if (href == null) {
            return;
        }
        if (href.startsWith("file:")) {
            href = href.substring(5);
            while (href.startsWith("/")) {
                href = href.substring(1);
            }
            href = "file:///" + href;
        }
        final String localHref = href;
        Process p = null;
        try {
            p = SecurityUtil.execRuntimeCommand((Runtime)Runtime.getRuntime(), (String)("/usr/bin/open " + localHref));
        }
        catch (IOException iOException) {
            p = null;
        }
        if (p == null) {
            Thread launcher = new Thread(){

                public void run() {
                    try {
                        String encodedLocalHref = SwtUtil.urlEncodeForSpaces(localHref.toCharArray());
                        Process p = SwtUtil.openWebBrowser(encodedLocalHref);
                        try {
                            if (p != null) {
                                p.waitFor();
                            }
                        }
                        catch (InterruptedException e) {
                            logger.log((Exception)e);
                        }
                    }
                    catch (IOException e) {
                        logger.log((Exception)e);
                    }
                }
            };
            launcher.start();
        }
    }

    private static String urlEncodeForSpaces(char[] input) {
        StringBuffer retu = new StringBuffer(input.length);
        int i = 0;
        while (i < input.length) {
            if (input[i] == ' ') {
                retu.append("%20");
            } else {
                retu.append(input[i]);
            }
            ++i;
        }
        return retu.toString();
    }

    private static Process openWebBrowser(String href) throws IOException {
        Process p = null;
        String webBrowser = null;
        try {
            webBrowser = "netscape";
            p = SecurityUtil.execRuntimeCommand((Runtime)Runtime.getRuntime(), (String)(String.valueOf(webBrowser) + "  " + href));
        }
        catch (IOException iOException) {
            p = null;
            webBrowser = "mozilla";
        }
        if (p == null) {
            try {
                p = SecurityUtil.execRuntimeCommand((Runtime)Runtime.getRuntime(), (String)(String.valueOf(webBrowser) + " " + href));
            }
            catch (IOException iOException) {
                p = null;
                webBrowser = "explorer";
            }
        }
        if (p == null) {
            try {
                p = SecurityUtil.execRuntimeCommand((Runtime)Runtime.getRuntime(), (String)(String.valueOf(webBrowser) + " " + href));
            }
            catch (IOException e) {
                p = null;
                throw e;
            }
        }
        return p;
    }
}

