/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.EOFException;
import java.io.IOException;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.i18n.CoreMessages;

public class ArchiveEntryInputStream
extends RAInputStream {
    private ArchiveEntry entry;

    ArchiveEntryInputStream(ArchiveEntry entry) {
        this.entry = entry;
    }

    public void close() throws IOException {
        if (this.entry != null) {
            try {
                this.entry.close();
            }
            finally {
                this.entry = null;
            }
        }
    }

    public int read() throws IOException {
        return this.entry.read();
    }

    public int available() throws IOException {
        long av = this.entry.getLength() - this.getOffset();
        if (av > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)av;
    }

    public long getOffset() throws IOException {
        return this.entry.getPosition();
    }

    public long length() throws IOException {
        return this.entry.getLength();
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        int n = 0;
        do {
            if ((count = this.read(b, off + n, len - n)) >= 0) continue;
            throw new EOFException();
        } while ((n += count) < len);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.entry.read(b, off, len);
    }

    public int readInt() throws IOException {
        return this.entry.readInt();
    }

    public long readLong() throws IOException {
        return this.entry.readLong();
    }

    public void refresh() throws IOException {
        if (this.entry != null) {
            this.entry.refresh();
        }
    }

    public void seek(long localPos) throws IOException {
        if (localPos < 0L) {
            throw new IOException(CoreMessages.getFormattedString("error.InvalidSeekOffset", localPos));
        }
        if (localPos >= this.entry.getLength()) {
            throw new EOFException(CoreMessages.getString("error.ExceedFileLength"));
        }
        this.entry.seek(localPos);
    }
}

