/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.stream;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.stream.StreamID;
import org.eclipse.birt.data.engine.impl.document.stream.StreamReader;
import org.eclipse.birt.data.engine.impl.document.stream.WrapperedRAInputStream;

public class DataStreamReader
extends StreamReader {
    public DataStreamReader(DataEngineContext context, StreamID id) throws DataException {
        try {
            this.streamMap = new HashMap();
            this.id = id;
            this.context = context;
            RAInputStream is = context.getInputStream(id.getStartStream(), id.getSubQueryStream(), 21);
            DataInputStream metaIndexStream = new DataInputStream((InputStream)is);
            int type = is.readInt();
            int size = is.readInt();
            long offset = is.getOffset();
            this.streamMap.put(type, new WrapperedRAInputStream(context.getInputStream(id.getStartStream(), id.getSubQueryStream(), 21), offset, size));
            metaIndexStream.close();
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage());
        }
    }

    public RAInputStream getRAInputStream(int streamType) throws DataException {
        Object temp = this.streamMap.get(streamType);
        if (temp == null) {
            throw new DataException("data.engine.document.error.cannotLoadStream", DataEngineContext.getPath(this.id.getStartStream(), this.id.getSubQueryStream(), streamType));
        }
        return (RAInputStream)temp;
    }
}

