/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.index;

import java.io.IOException;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.btree.BTreeFile;

class ArchiveOutputFile
implements BTreeFile {
    IDocArchiveWriter archive;
    String name;
    RAOutputStream output;
    RAInputStream input;
    int totalBlock;

    ArchiveOutputFile(IDocArchiveWriter archive, String name) throws IOException {
        this.archive = archive;
        this.name = name;
        if (archive.exists(name)) {
            this.input = archive.getInputStream(name);
            this.output = archive.getOutputStream(name);
        } else {
            this.output = archive.createOutputStream(name);
            this.input = archive.getInputStream(name);
        }
        this.totalBlock = (int)((this.input.length() + 4096L - 1L) / 4096L);
    }

    public void close() throws IOException {
        if (this.output != null) {
            this.output.close();
        }
        if (this.input != null) {
            this.input.close();
        }
    }

    public int allocBlock() throws IOException {
        return this.totalBlock++;
    }

    public int getTotalBlock() throws IOException {
        return this.totalBlock;
    }

    public Object lock() throws IOException {
        return this.archive.lock(this.name);
    }

    public void readBlock(int blockId, byte[] bytes) throws IOException {
        this.input.refresh();
        this.input.seek((long)(blockId * 4096));
        this.input.read(bytes);
    }

    public void unlock(Object lock) throws IOException {
        this.archive.unlock(lock);
    }

    public void writeBlock(int blockId, byte[] bytes) throws IOException {
        if (blockId >= this.totalBlock) {
            this.totalBlock = blockId + 1;
        }
        this.output.seek((long)(blockId * 4096));
        this.output.write(bytes);
        this.output.flush();
    }
}

