/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.group;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.executor.transform.group.AggrValuesUpdator;
import org.eclipse.birt.data.engine.executor.transform.group.GroupInfo;
import org.eclipse.birt.data.engine.executor.transform.group.GroupInfoUpdator;
import org.eclipse.birt.data.engine.executor.transform.group.GroupInformationUtil;
import org.eclipse.birt.data.engine.odi.IAggrValueHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncrementalUpdateCaculator {
    protected ResultSetPopulator populator;
    protected List<GroupInfo>[] originGroups;
    protected int[] groupSize;
    protected String tempDir;
    protected GroupInformationUtil groupInfoUtil;
    protected boolean doFiltering;
    protected GroupInfoUpdator[] groupUpdators;
    protected AggrValuesUpdator[] aggrValuesUpdators;

    public IncrementalUpdateCaculator(ResultSetPopulator populator) throws DataException {
        this.populator = populator;
        this.tempDir = populator.getSession().getTempDir();
        List<IAggrValueHolder> aggrValues = populator.getResultIterator().getAggrValueHolders();
        this.aggrValuesUpdators = new AggrValuesUpdator[aggrValues.size()];
        int i = 0;
        while (i < this.aggrValuesUpdators.length) {
            this.aggrValuesUpdators[i] = new AggrValuesUpdator(aggrValues.get(i), populator);
            ++i;
        }
        this.groupInfoUtil = populator.getGroupProcessorManager().getGroupCalculationUtil().getGroupInformationUtil();
        this.originGroups = this.groupInfoUtil.getGroups();
        this.groupSize = new int[this.originGroups.length];
        this.groupUpdators = new GroupInfoUpdator[this.originGroups.length];
        i = 0;
        while (i < this.originGroups.length) {
            this.groupUpdators[i] = new GroupInfoUpdator(i, this.tempDir, this.originGroups[i], this.getLastGroupIndex(i), this.aggrValuesUpdators);
            this.groupSize[i] = this.originGroups[i].size();
            ++i;
        }
    }

    protected int getLastGroupIndex(int level) throws DataException {
        int last = level < this.originGroups.length - 1 ? this.originGroups[level + 1].size() - 1 : this.populator.getCache().getCount() - 1;
        return last;
    }

    protected int getCurrentGroupIndex(int level) throws DataException {
        return this.groupInfoUtil.getCurrentGroupIndex(level);
    }

    public List<GroupInfo>[] getGroups() {
        ArrayList<List<GroupInfo>> groups = new ArrayList<List<GroupInfo>>();
        int i = 0;
        while (i < this.groupUpdators.length) {
            this.groupUpdators[i].close();
            groups.add(this.groupUpdators[i].getGroups());
            ++i;
        }
        return groups.toArray(new List[0]);
    }

    protected void acceptAggrValues(int rowIndex) {
        int i = 0;
        while (i < this.aggrValuesUpdators.length) {
            this.aggrValuesUpdators[i].onRow(rowIndex);
            ++i;
        }
    }
}

