/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.util;

import java.sql.Driver;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.oda.jdbc.JDBCDriverManager;

public final class JDBCDriverInformation {
    private String driverClassName = null;
    private int majorVersion = 0;
    private int minorVersion = 0;
    private String urlFormat = null;
    private String driverDisplayName = null;
    private boolean hide = false;

    private JDBCDriverInformation() {
    }

    public static JDBCDriverInformation newInstance(Class driverClass) {
        block4: {
            try {
                Driver d = JDBCDriverManager.getInstance().getDriverInstance(driverClass, false);
                if (d == null) break block4;
                JDBCDriverInformation info = JDBCDriverInformation.newInstance(driverClass.getName());
                try {
                    info.setMajorVersion(d.getMajorVersion());
                    info.setMinorVersion(d.getMinorVersion());
                }
                catch (Throwable e) {
                    Logger.getLogger(JDBCDriverInformation.class.getName()).log(Level.WARNING, e.getMessage(), e);
                }
                return info;
            }
            catch (Throwable e) {
                Logger.getLogger(JDBCDriverInformation.class.getName()).log(Level.WARNING, e.getMessage(), e);
            }
        }
        return null;
    }

    public static JDBCDriverInformation newInstance(String driverClassName) {
        JDBCDriverInformation info = new JDBCDriverInformation();
        info.setDriverClassName(driverClassName);
        return info;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    protected void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    protected void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public String getUrlFormat() {
        return this.urlFormat;
    }

    protected void setUrlFormat(String urlFormat) {
        this.urlFormat = urlFormat;
    }

    public String getDisplayName() {
        return this.driverDisplayName;
    }

    public void setDisplayName(String displayName) {
        this.driverDisplayName = displayName;
    }

    public boolean getHide() {
        return this.hide;
    }

    public void setHide(String hide) {
        if (hide != null) {
            this.hide = hide.equals("true");
        }
    }

    public void setHide(boolean flag) {
        this.hide = flag;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.driverClassName);
        if (this.majorVersion != 0 || this.minorVersion != 0) {
            buffer.append(" (");
            buffer.append(this.majorVersion);
            buffer.append(".");
            buffer.append(this.minorVersion);
            buffer.append(")");
        }
        return buffer.toString();
    }

    public String getDisplayString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.driverClassName);
        if (this.majorVersion != 0 || this.minorVersion != 0 || this.driverDisplayName != null) {
            buffer.append(" (");
            if (this.driverDisplayName != null) {
                buffer.append(this.driverDisplayName);
            }
            if (this.majorVersion != 0 || this.minorVersion != 0) {
                if (this.driverDisplayName != null) {
                    buffer.append(" ");
                }
                buffer.append("v");
                buffer.append(this.majorVersion);
                buffer.append(".");
                buffer.append(this.minorVersion);
            }
            buffer.append(")");
        }
        return buffer.toString();
    }

    public boolean equals(Object anotherObj) {
        if (this == anotherObj) {
            return true;
        }
        if (!(anotherObj instanceof JDBCDriverInformation)) {
            return false;
        }
        JDBCDriverInformation info = (JDBCDriverInformation)anotherObj;
        return this.driverClassName != null && this.driverClassName.equalsIgnoreCase(info.driverClassName) && this.majorVersion == info.majorVersion && this.minorVersion == info.minorVersion;
    }

    public int hashCode() {
        int hashcode = 0;
        if (this.driverClassName != null) {
            hashcode += this.driverClassName.hashCode() * 11;
        }
        return hashcode + this.majorVersion * 13 + this.minorVersion * 17;
    }
}

