/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.util;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetUIUtil;
import org.eclipse.birt.report.designer.data.ui.dataset.PromptParameterDialog;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.model.adapter.oda.IAmbiguousOption;
import org.eclipse.birt.report.model.adapter.oda.ModelOdaAdapter;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.core.resources.IProject;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.helper.DriverExtensionHelper;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.DesignSessionRequest;
import org.eclipse.datatools.connectivity.oda.design.DesignSessionResponse;
import org.eclipse.datatools.connectivity.oda.design.DesignerState;
import org.eclipse.datatools.connectivity.oda.design.OdaDesignSession;
import org.eclipse.datatools.connectivity.oda.design.SessionStatus;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.util.ResourceIdentifiers;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.widgets.Display;

public class DTPUtil {
    private static DTPUtil instance = null;
    private SessionStatus sessionStatus = null;
    private DesignerState designerState = null;
    private ModelOdaAdapter modelOdaAdapter = new ModelOdaAdapter();
    private static final String SAMPELDB_DATA_SOURCE_ID = "org.eclipse.birt.report.data.oda.sampledb";
    private static final String JDBC_DATA_SOURCE_ID = "org.eclipse.birt.report.data.oda.jdbc";
    private static Logger logger = Logger.getLogger(DTPUtil.class.getName());

    private DTPUtil() {
    }

    public static synchronized DTPUtil getInstance() {
        if (instance == null) {
            instance = new DTPUtil();
        }
        return instance;
    }

    public void updateDataSourceHandle(DesignSessionResponse response, DataSourceDesign requestDesign, OdaDataSourceHandle dataSourceHandle) {
        this.initDesignSessionFields(response);
        if (this.isSessionOk()) {
            if (new EcoreUtil.EqualityHelper().equals((EObject)requestDesign, (EObject)response.getDataSourceDesign())) {
                return;
            }
            try {
                this.updateROMDesignerState(dataSourceHandle);
                this.modelOdaAdapter.updateDataSourceHandle(response.getDataSourceDesign(), dataSourceHandle);
            }
            catch (SemanticException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    public void updateDataSetHandle(OdaDesignSession designSession, OdaDataSetHandle dataSetHandle) {
        DataSetDesign requestDesign = designSession.getRequestDataSetDesign();
        DesignSessionResponse response = designSession.getResponse();
        this.initDesignSessionFields(response);
        if (this.isSessionOk()) {
            if (new EcoreUtil.EqualityHelper().equals((EObject)requestDesign, (EObject)response.getDataSetDesign())) {
                return;
            }
            try {
                this.modelOdaAdapter.updateDataSetHandle(dataSetHandle, designSession);
            }
            catch (SemanticException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    public void updateDataSetHandle(DesignSessionResponse response, DataSetDesign requestDesign, OdaDataSetHandle dataSetHandle, boolean isSourceChanged) {
        this.initDesignSessionFields(response);
        if (this.isSessionOk()) {
            EcoreUtil.EqualityHelper equalityHelper = new EcoreUtil.EqualityHelper();
            if (equalityHelper.equals((EObject)response.getDataSetDesign(), (EObject)requestDesign) && equalityHelper.equals((EObject)response.getDesignerState(), (EObject)this.designerState)) {
                return;
            }
            try {
                IAmbiguousOption ambiguousOption;
                DataSetDesign design = response.getDataSetDesign();
                if (ReportPlugin.getDefault().getPluginPreferences().getBoolean("prompt_enable") && (ambiguousOption = this.modelOdaAdapter.getAmbiguousOption(design, dataSetHandle)) != null && !ambiguousOption.getAmbiguousParameters().isEmpty()) {
                    PromptParameterDialog dialog = new PromptParameterDialog(Messages.getString((String)"PromptParameterDialog.title"));
                    dialog.setInput(ambiguousOption);
                    if (dialog.open() == 0) {
                        Object result = dialog.getResult();
                        if (result instanceof List) {
                            List selectedParameters = (List)result;
                            this.updateROMDesignerState(dataSetHandle);
                            this.modelOdaAdapter.updateDataSetHandle(design, dataSetHandle, selectedParameters, null, isSourceChanged);
                            this.refreshCachedMetaData(dataSetHandle);
                            return;
                        }
                    } else {
                        this.updateROMDesignerState(dataSetHandle);
                        this.modelOdaAdapter.updateDataSetHandle(design, dataSetHandle, isSourceChanged);
                        this.refreshCachedMetaData(dataSetHandle);
                        return;
                    }
                }
                this.updateROMDesignerState(dataSetHandle);
                this.modelOdaAdapter.updateDataSetHandle(design, dataSetHandle, isSourceChanged);
                this.refreshCachedMetaData(dataSetHandle);
            }
            catch (SemanticException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    private void refreshCachedMetaData(OdaDataSetHandle dataSetHandle) throws SemanticException {
        if (dataSetHandle.getCachedMetaDataHandle() != null && dataSetHandle.getCachedMetaDataHandle().getResultSet() != null) {
            dataSetHandle.getCachedMetaDataHandle().getResultSet().clearValue();
        }
        DataSetUIUtil.updateColumnCache((DataSetHandle)dataSetHandle);
    }

    public OdaDataSourceHandle createOdaDataSourceHandle(DesignSessionResponse response, ModuleHandle parentHandle) throws SemanticException {
        this.initDesignSessionFields(response);
        OdaDataSourceHandle dataSourceHandle = null;
        if (this.isSessionOk()) {
            DataSourceDesign dataSourceDesign = response.getDataSourceDesign();
            if (dataSourceDesign.getOdaExtensionId().equals(SAMPELDB_DATA_SOURCE_ID)) {
                dataSourceDesign.setOdaExtensionId(JDBC_DATA_SOURCE_ID);
            }
            dataSourceHandle = this.modelOdaAdapter.createDataSourceHandle(dataSourceDesign, parentHandle);
            this.updateROMDesignerState(dataSourceHandle);
        }
        return dataSourceHandle;
    }

    public OdaDataSetHandle createOdaDataSetHandle(DesignSessionResponse response, ModuleHandle parentHandle) throws SemanticException {
        this.initDesignSessionFields(response);
        OdaDataSetHandle dataSetHandle = null;
        if (this.isSessionOk()) {
            dataSetHandle = this.modelOdaAdapter.createDataSetHandle(response.getDataSetDesign(), parentHandle);
            this.updateROMDesignerState(dataSetHandle);
        }
        return dataSetHandle;
    }

    public DesignSessionRequest createDesignSessionRequest(OdaDataSourceHandle dataSourceHandle) throws URISyntaxException {
        DataSourceDesign dataSourceDesign = this.modelOdaAdapter.createDataSourceDesign(dataSourceHandle);
        this.supplementDesignAttributes(dataSourceDesign);
        DesignSessionRequest designSessionRequest = DesignFactory.eINSTANCE.createDesignSessionRequest(dataSourceDesign);
        this.designerState = this.modelOdaAdapter.newOdaDesignerState(dataSourceHandle);
        if (this.designerState != null) {
            designSessionRequest.setDesignerState(this.designerState);
        }
        return designSessionRequest;
    }

    public void supplementDesignAttributes(DataSourceDesign dataSourceDesign) throws URISyntaxException {
        this.applyResourceIdentifiers(dataSourceDesign);
        this.applyEffectiveDataSourceId(dataSourceDesign);
    }

    public void applyResourceIdentifiers(DataSourceDesign dataSourceDesign) throws URISyntaxException {
        if (Utility.getReportModuleHandle() == null) {
            return;
        }
        DesignSessionUtil.setDataSourceResourceIdentifiers((DataSourceDesign)dataSourceDesign, (URI)this.getBIRTResourcePath(), (URI)this.getReportDesignPath());
    }

    private void applyEffectiveDataSourceId(DataSourceDesign dataSourceDesign) {
        String effectiveExtensionId;
        String odaExtensionId;
        String string = odaExtensionId = dataSourceDesign != null ? dataSourceDesign.getOdaExtensionId() : null;
        if (odaExtensionId == null) {
            return;
        }
        try {
            effectiveExtensionId = DriverExtensionHelper.getEffectiveDataSourceId((String)odaExtensionId);
        }
        catch (OdaException ex) {
            logger.log(Level.INFO, "Unable to determine the effective runtime data source id of " + odaExtensionId + ".  Exception: " + ex.getMessage());
            return;
        }
        if (!odaExtensionId.equalsIgnoreCase(effectiveExtensionId)) {
            dataSourceDesign.setEffectiveOdaExtensionId(effectiveExtensionId);
        }
    }

    public URI getReportDesignPath() {
        if (Utility.getReportModuleHandle() == null || Utility.getReportModuleHandle().getSystemId() == null) {
            return null;
        }
        try {
            return new URI(Utility.getReportModuleHandle().getSystemId().getPath());
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public URI getBIRTResourcePath() {
        if (this.getCurrentProject() == null) {
            try {
                ModuleHandle handle = SessionHandleAdapter.getInstance().getReportDesignHandle();
                if (handle != null) {
                    return new URI(this.encode(handle.getResourceFolder()));
                }
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        try {
            return new URI(this.encode(ReportPlugin.getDefault().getResourceFolder(this.getCurrentProject(), null)));
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    private IProject getCurrentProject() {
        final IProject[] project = new IProject[1];
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (display.getThread().equals(Thread.currentThread())) {
            project[0] = UIUtil.getCurrentProject();
        } else {
            display.syncExec(new Runnable(){

                public void run() {
                    project[0] = UIUtil.getCurrentProject();
                }
            });
        }
        return project[0];
    }

    private String encode(String location) {
        try {
            return new File(location).toURI().toASCIIString().replace(new File("").toURI().toASCIIString(), "");
        }
        catch (Exception exception) {
            return location;
        }
    }

    public DesignSessionRequest createDesignSessionRequest(OdaDataSetHandle dataSetHandle) {
        return this.modelOdaAdapter.createOdaDesignSession(dataSetHandle).getRequest();
    }

    public DesignSessionRequest createDesignSessionRequest(DataSetDesign requestDataSetDesign, DesignerState requestDesignerState) {
        DesignSessionRequest newRequest = DesignFactory.eINSTANCE.createDesignSessionRequest(requestDataSetDesign);
        this.designerState = requestDesignerState;
        newRequest.setDesignerState(requestDesignerState);
        return newRequest;
    }

    public void updateDataSetDesign(DesignSessionResponse response, DataSetHandle handle, String propName) {
        this.initDesignSessionFields(response);
        if (this.isSessionOk()) {
            this.modelOdaAdapter.updateDataSetDesign((OdaDataSetHandle)handle, response.getDataSetDesign(), propName);
        }
    }

    private void initDesignSessionFields(DesignSessionResponse response) {
        this.sessionStatus = response.getSessionStatus();
        this.designerState = response.getDesignerState();
    }

    private boolean isSessionOk() {
        assert (this.sessionStatus != null);
        if (this.sessionStatus.getValue() != 0) {
            logger.log(Level.WARNING, Messages.getFormattedString((String)"dataset.warning.invalidReponseStatus", (Object[])new Object[]{this.sessionStatus.toString()}));
            return false;
        }
        return true;
    }

    private void updateROMDesignerState(Object obj) throws SemanticException {
        if (this.designerState == null || obj == null) {
            return;
        }
        if (obj instanceof OdaDataSourceHandle) {
            this.modelOdaAdapter.updateROMDesignerState(this.designerState, (OdaDataSourceHandle)obj);
        } else if (obj instanceof OdaDataSetHandle) {
            this.modelOdaAdapter.updateROMDesignerState(this.designerState, (OdaDataSetHandle)obj);
        }
    }

    public IAmbiguousOption getAmbiguousOption(DataSetDesign design, OdaDataSetHandle handle) {
        return this.modelOdaAdapter.getAmbiguousOption(design, handle);
    }

    public ResourceIdentifiers createResourceIdentifiers() {
        ResourceIdentifiers ri = new ResourceIdentifiers();
        ri.setDesignResourceBaseURI(this.getReportDesignPath());
        ri.setApplResourceBaseURI(this.getBIRTResourcePath());
        return ri;
    }
}

