/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.ide.adapters;

import java.util.HashMap;
import org.eclipse.birt.report.designer.internal.ui.ide.adapters.ReportProjectPreference;
import org.eclipse.birt.report.designer.ui.preferences.IReportPreferenceFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;

public class IDEReportPreferenceFactory
implements IReportPreferenceFactory {
    private String pluginId = "";
    protected HashMap prefsMap = new HashMap();

    public IDEReportPreferenceFactory(Plugin plugin) {
        this.pluginId = plugin.getBundle().getSymbolicName();
    }

    public boolean hasSpecialSettings(Object adaptable, String name) {
        IProject project = this.getProject(adaptable);
        if (project == null) {
            return false;
        }
        Preferences preference = this.getReportPreference(adaptable);
        if (preference != null) {
            return !preference.isDefault(name);
        }
        return false;
    }

    public Preferences getReportPreference(Object adaptable) {
        IProject project = this.getProject(adaptable);
        if (project == null) {
            return null;
        }
        if (!this.containsReportPreference(adaptable)) {
            ReportProjectPreference prefs = new ReportProjectPreference(this.pluginId, project);
            this.prefsMap.put(project.getFullPath().toOSString(), prefs);
        }
        return (ReportProjectPreference)((Object)this.prefsMap.get(project.getFullPath().toOSString()));
    }

    public boolean containsReportPreference(Object adaptable) {
        IProject project = this.getProject(adaptable);
        if (project == null) {
            return false;
        }
        return this.prefsMap.containsKey(project.getFullPath().toOSString());
    }

    public boolean saveReportPreference(Object adaptable) {
        ReportProjectPreference prefs = (ReportProjectPreference)this.getReportPreference(adaptable);
        if (prefs == null) {
            return true;
        }
        return prefs.save();
    }

    public boolean removeReportPreference(Object adaptable) {
        if (this.containsReportPreference(adaptable)) {
            IProject project = this.getProject(adaptable);
            ReportProjectPreference prefs = (ReportProjectPreference)((Object)this.prefsMap.get(project.getFullPath().toOSString()));
            this.prefsMap.remove(project.getFullPath().toOSString());
            return prefs.delete();
        }
        return true;
    }

    private IProject getProject(Object adaptable) {
        if (adaptable instanceof IProject) {
            return (IProject)adaptable;
        }
        return null;
    }
}

