/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.editors;

import java.util.List;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.lib.commands.SetCurrentEditModelCommand;
import org.eclipse.birt.report.designer.internal.lib.editparts.LibraryGraphicalPartFactory;
import org.eclipse.birt.report.designer.internal.lib.palette.LibraryTemplateTransferDropTargetListener;
import org.eclipse.birt.report.designer.internal.lib.providers.LibraryBreadcrumbNodeProvider;
import org.eclipse.birt.report.designer.internal.lib.views.outline.LibraryOutlinePage;
import org.eclipse.birt.report.designer.internal.ui.editors.breadcrumb.EditorBreadcrumb;
import org.eclipse.birt.report.designer.internal.ui.editors.breadcrumb.ReportLayoutEditorBreadcrumb;
import org.eclipse.birt.report.designer.internal.ui.editors.breadcrumb.providers.DefaultBreadcrumbNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.editors.layout.ReportEditorWithPalette;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.palette.DesignerPaletteFactory;
import org.eclipse.birt.report.designer.internal.ui.views.data.DataViewPage;
import org.eclipse.birt.report.designer.internal.ui.views.property.ReportPropertySheetPage;
import org.eclipse.birt.report.designer.ui.views.attributes.AttributeViewPage;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public abstract class LibraryLayoutEditor
extends ReportEditorWithPalette {
    private IEditorPart parentEditorPart;

    public LibraryLayoutEditor() {
    }

    public LibraryLayoutEditor(IEditorPart parent) {
        super(parent);
        this.parentEditorPart = parent;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void performRequest(ReportRequest request) {
        if ("open editor".equals(request.getType()) && request.getSelectionModelList().size() == 1 && request.getSelectionModelList().get(0) instanceof SlotHandle) {
            SlotHandle slt = (SlotHandle)request.getSelectionModelList().get(0);
            if (slt.getSlotID() == 6) {
                this.handleOpenDesigner(request);
            }
            return;
        }
        super.performRequest(request);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        IEditorPart report = this.getSite().getPage().getActiveEditor();
        if (report != null) {
            this.updateActions(this.getSelectionActions());
        }
    }

    protected void handleSelectionChange(ReportRequest request) {
        List list = request.getSelectionModelList();
        if ((request.getSource() instanceof LibraryOutlinePage || request.getSource() instanceof TableEditPart || request.getSource() instanceof EditorBreadcrumb) && !this.isInContainer(list)) {
            int size = list.size();
            Object obj = null;
            if (size != 0) {
                obj = list.get(size - 1);
                SetCurrentEditModelCommand command = new SetCurrentEditModelCommand(obj);
                command.execute();
                return;
            }
        }
        super.handleSelectionChange(request);
    }

    protected void handleCreateElement(ReportRequest request) {
        List list = request.getSelectionModelList();
        int size = list.size();
        Object obj = null;
        if (size != 0) {
            obj = list.get(size - 1);
        }
        SetCurrentEditModelCommand command = new SetCurrentEditModelCommand(obj);
        command.execute();
        super.handleCreateElement(request);
    }

    private boolean isInContainer(List list) {
        boolean retValue = false;
        int size = list.size();
        int i = 0;
        while (i < size) {
            Object obj = list.get(i);
            if (!(obj instanceof RowHandle) && !(obj instanceof CellHandle)) {
                retValue = false;
                break;
            }
            retValue = true;
            ++i;
        }
        return retValue;
    }

    protected TemplateTransferDropTargetListener createTemplateTransferDropTargetListener(EditPartViewer viewer) {
        return new LibraryTemplateTransferDropTargetListener(viewer);
    }

    private void handleOpenDesigner(ReportRequest request) {
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContentOutlinePage.class) {
            LibraryOutlinePage outline = new LibraryOutlinePage(this.getModel());
            this.getModelEventManager().addModelEventProcessor(outline.getModelProcessor());
            return outline;
        }
        if (adapter == DataViewPage.class) {
            DataViewPage page = (DataViewPage)super.getAdapter(adapter);
            if (page == null) {
                return null;
            }
            return page;
        }
        if (adapter == AttributeViewPage.class) {
            AttributeViewPage page = (AttributeViewPage)super.getAdapter(adapter);
            if (page == null) {
                return null;
            }
            return page;
        }
        if (adapter == IPropertySheetPage.class) {
            ReportPropertySheetPage sheetPage = new ReportPropertySheetPage(this.getModel());
            return sheetPage;
        }
        return super.getAdapter(adapter);
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.paletteRoot == null) {
            this.paletteRoot = DesignerPaletteFactory.createPalette();
        }
        return this.paletteRoot;
    }

    protected IEditorPart getMultiPageEditor() {
        return this.parentEditorPart;
    }

    protected int getFileType() {
        return 1;
    }

    protected EditPartFactory getEditPartFactory() {
        return new LibraryGraphicalPartFactory();
    }

    protected ReportLayoutEditorBreadcrumb createBreadcrumb() {
        ReportLayoutEditorBreadcrumb breadcrumb = new ReportLayoutEditorBreadcrumb((GraphicalEditorWithFlyoutPalette)this);
        breadcrumb.setBreadcrumbNodeProvider((DefaultBreadcrumbNodeProvider)new LibraryBreadcrumbNodeProvider());
        return breadcrumb;
    }
}

