/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.samplesview.view;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceEntry;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.samplereports.description.DescriptionMessages;
import org.eclipse.birt.report.designer.ui.samplesview.sampleslocator.ISampleReportEntry;
import org.eclipse.birt.report.designer.ui.samplesview.sampleslocator.SampleIncludedSourceEntry;
import org.eclipse.birt.report.designer.ui.samplesview.util.SampleReportCanvas;
import org.eclipse.birt.report.designer.ui.samplesview.util.SampleReportsExplorerProvider;
import org.eclipse.birt.report.designer.ui.samplesview.util.SampleReportsSorter;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.widget.CSashForm;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class ReportExamples {
    private static final String CONTRIBUTION_ITEM_TEXT = Messages.getString((String)"SampleReportsView.Text.Contribute_Samples");
    private Composite mainComposite;
    private SampleReportCanvas previewCanvas;
    private TreeViewer samplesTree;
    private Text description;
    private Object selectedElement;
    private ISampleReportEntry sampleEntry;
    private List listenerList = new ArrayList();

    public ReportExamples(Composite parent) {
        this.mainComposite = parent;
        this.createControl();
    }

    public Shell getShell() {
        return this.mainComposite.getShell();
    }

    private void createControl() {
        this.mainComposite.setLayout((Layout)new FillLayout());
        CSashForm hSash = new CSashForm(this.mainComposite, 65792);
        this.createSamplesGroup(hSash);
        this.createDisplayGroup(hSash);
    }

    private void createSamplesGroup(CSashForm hSash) {
        Group samplesGroup = new Group((Composite)hSash, 0);
        samplesGroup.setText(Messages.getString((String)"SampleReportsView.Text.Explorer"));
        samplesGroup.setLayout((Layout)new GridLayout(1, false));
        this.createSamplesExplorer((Composite)samplesGroup);
    }

    private void createDisplayGroup(CSashForm hSash) {
        Composite displayGroup = new Composite((Composite)hSash, 0);
        displayGroup.setLayout((Layout)new FillLayout());
        CSashForm vSash = new CSashForm(displayGroup, 66048);
        this.createPreviewGroup(vSash);
        this.createDescriptionGroup(vSash);
        hSash.setWeights(new int[]{2, 3});
    }

    private void createSamplesExplorer(Composite samplesGroup) {
        this.samplesTree = new TreeViewer(samplesGroup, 2820);
        this.samplesTree.getTree().setLayoutData((Object)new GridData(1808));
        this.configTreeViewer();
        this.refreshRoot();
    }

    private void createPreviewGroup(CSashForm vSash) {
        Group previewGroup = new Group((Composite)vSash, 0);
        previewGroup.setLayout((Layout)new GridLayout());
        previewGroup.setLayoutData((Object)new GridData(1808));
        previewGroup.setText(Messages.getString((String)"SampleReportsView.Text.Preview"));
        this.previewCanvas = new SampleReportCanvas((Composite)previewGroup, 2048);
        this.previewCanvas.setLayoutData(new GridData(1808));
        this.previewCanvas.setBackground(Display.getDefault().getSystemColor(1));
    }

    private void createDescriptionGroup(CSashForm vSash) {
        Group descriptionGroup = new Group((Composite)vSash, 0);
        descriptionGroup.setLayout((Layout)new GridLayout());
        descriptionGroup.setLayoutData((Object)new GridData(768));
        descriptionGroup.setText(Messages.getString((String)"SampleReportsView.Text.Description"));
        vSash.setWeights(new int[]{8, -1});
        vSash.setExactSizes(new int[]{-1, 60});
        this.description = new Text((Composite)descriptionGroup, 584);
        GridData gd = new GridData(1808);
        this.description.setLayoutData((Object)gd);
        this.description.setText(Messages.getString((String)"SampleReportsView.defautDescription"));
    }

    private void setSelectedElement(TreeItem element) {
        this.selectedElement = element;
        this.fireSelectedChangeEvent(element);
    }

    private void fireSelectedChangeEvent(TreeItem element) {
        Event changeEvent = new Event();
        changeEvent.type = 13;
        changeEvent.widget = element;
        int i = 0;
        while (i < this.listenerList.size()) {
            ((Listener)this.listenerList.get(i)).handleEvent(changeEvent);
            ++i;
        }
    }

    public Object getSelectedElement() {
        return this.selectedElement;
    }

    private void configTreeViewer() {
        SampleReportsExplorerProvider provider = new SampleReportsExplorerProvider();
        this.samplesTree.setContentProvider((IContentProvider)provider);
        this.samplesTree.setLabelProvider((IBaseLabelProvider)provider);
        this.samplesTree.getTree().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem item = (TreeItem)e.item;
                if (item != null) {
                    if (item.getData() instanceof ReportDesignHandle) {
                        String reportname = item.getText().substring(0, item.getText().lastIndexOf("."));
                        ReportExamples.this.description.setText(DescriptionMessages.getDescription(reportname));
                        ReportExamples.this.previewSampleReport(reportname);
                        ReportExamples.this.setSelectedElement(item);
                    } else if (item.getText().equals(CONTRIBUTION_ITEM_TEXT)) {
                        ReportExamples.this.description.setText(DescriptionMessages.getDescription("Contribute_Samples"));
                        ReportExamples.this.previewCanvas.setSampleImage(null);
                        ReportExamples.this.previewCanvas.redraw();
                        ReportExamples.this.setSelectedElement(item);
                    } else {
                        ReportExamples.this.description.setText(Messages.getString((String)"SampleReportsView.defautDescription"));
                        ReportExamples.this.previewCanvas.setSampleImage(null);
                        ReportExamples.this.previewCanvas.redraw();
                        ReportExamples.this.setSelectedElement(item);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                Object selectedObject = ((StructuredSelection)ReportExamples.this.samplesTree.getSelection()).getFirstElement();
                try {
                    Tree tree = (Tree)e.getSource();
                    TreeItem[] selectedItems = tree.getSelection();
                    if (selectedItems.length > 0) {
                        if (selectedItems[0].getExpanded()) {
                            selectedItems[0].setExpanded(false);
                        } else {
                            ReportExamples.this.samplesTree.expandToLevel(selectedObject, selectedItems[0].getExpanded() ? 0 : 1);
                        }
                    }
                }
                catch (Exception exception) {}
            }
        });
        this.samplesTree.getTree().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Object input = ReportExamples.this.samplesTree.getInput();
                if (input instanceof Object[]) {
                    Object[] array = (Object[])input;
                    int i = 0;
                    while (i < array.length) {
                        if (array[i] instanceof ResourceEntry) {
                            ((ResourceEntry)array[i]).dispose();
                        }
                        ++i;
                    }
                }
            }
        });
        this.samplesTree.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeItem item;
                Object obj = ReportExamples.this.getSelectedElement();
                if (obj instanceof TreeItem && (item = (TreeItem)obj).getText().equals(CONTRIBUTION_ITEM_TEXT)) {
                    ContributeDialog dialog = new ContributeDialog(ReportExamples.this.getShell());
                    dialog.open();
                }
            }
        });
        this.samplesTree.setSorter((ViewerSorter)new SampleReportsSorter());
    }

    private void previewSampleReport(String name) {
        InputStream imageStream = null;
        try {
            URL imagePath = SampleIncludedSourceEntry.getImagePath(name);
            if (imagePath != null) {
                imageStream = imagePath.openStream();
            }
        }
        catch (IOException e) {
            ExceptionUtil.handle((Throwable)e);
        }
        if (imageStream != null) {
            Image sampleImage = new Image((Device)Display.getDefault(), imageStream);
            this.previewCanvas.setSampleImage(sampleImage);
            this.previewCanvas.redraw();
        }
    }

    private void refreshRoot() {
        ResourceEntry contributionItem = new ResourceEntry(){

            public String getName() {
                return CONTRIBUTION_ITEM_TEXT;
            }

            public String getDisplayName() {
                return CONTRIBUTION_ITEM_TEXT;
            }

            public Image getImage() {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
            }

            public URL getURL() {
                return null;
            }

            public ResourceEntry getParent() {
                return null;
            }

            public boolean hasChildren() {
                return false;
            }

            public ResourceEntry[] getChildren() {
                return new ResourceEntry[0];
            }

            public ResourceEntry[] getChildren(ResourceEntry.Filter filter) {
                return new ResourceEntry[0];
            }

            public boolean isFile() {
                return false;
            }

            public boolean isRoot() {
                return false;
            }

            public void dispose() {
            }

            public Object getAdapter(Class adapter) {
                return null;
            }
        };
        Object adapter = null;
        int status = Platform.getAdapterManager().queryAdapter((Object)this, ISampleReportEntry.class.getName());
        if (status == 2) {
            adapter = Platform.getAdapterManager().getAdapter((Object)this, ISampleReportEntry.class.getName());
        } else if (status == 1) {
            adapter = Platform.getAdapterManager().loadAdapter((Object)this, ISampleReportEntry.class.getName());
        }
        if (adapter == null) {
            return;
        }
        this.sampleEntry = (ISampleReportEntry)adapter;
        if (this.samplesTree != null && !this.samplesTree.getTree().isDisposed()) {
            int length = this.sampleEntry.getEntries().length;
            ResourceEntry[] sampleEntries = this.sampleEntry.getEntries();
            ResourceEntry[] entries = new ResourceEntry[length + 1];
            int i = 0;
            while (i < length) {
                entries[i] = sampleEntries[i];
                ++i;
            }
            entries[length] = contributionItem;
            this.samplesTree.setInput((Object)entries);
            this.samplesTree.expandToLevel(2);
        }
    }

    public void setFocus() {
        this.mainComposite.setFocus();
    }

    public void dispose() {
        if (this.samplesTree != null && this.samplesTree.getTree() != null && !this.samplesTree.getTree().isDisposed()) {
            this.samplesTree.getTree().dispose();
            this.samplesTree = null;
        }
        if (this.previewCanvas != null && !this.previewCanvas.isDisposed()) {
            this.previewCanvas.dispose();
            this.previewCanvas = null;
        }
        if (this.description != null && !this.description.isDisposed()) {
            this.description.dispose();
            this.description = null;
        }
        this.listenerList.clear();
    }

    public void removeSelectedListener(Listener selectedListener) {
        this.listenerList.remove(selectedListener);
    }

    public void addSelectedListener(Listener selectedListener) {
        this.listenerList.add(selectedListener);
    }

    public TreeViewer getTreeViewer() {
        return this.samplesTree;
    }

    private static class ContributeDialog
    extends TitleAreaDialog {
        public ContributeDialog(Shell shell) {
            super(shell);
        }

        protected Control createDialogArea(Composite parent) {
            Composite container = (Composite)super.createDialogArea(parent);
            this.setTitle(Messages.getString((String)"ReportExamples.ContributeSamples.title"));
            this.setMessage(Messages.getString((String)"ReportExamples.ContributeSamples.messages"));
            super.getShell().setText(Messages.getString((String)"ReportExamples.ContributeSamples.title"));
            Composite composite = new Composite(container, 0);
            GridData gd = new GridData(1810);
            gd.widthHint = 380;
            gd.heightHint = 200;
            gd.horizontalIndent = 10;
            composite.setLayoutData((Object)gd);
            composite.setLayout((Layout)new GridLayout());
            new Label(composite, 0);
            Link link = new Link(composite, 64);
            link.setLayoutData((Object)new GridData(770));
            Object[] arguments = new String[]{"<a>", "</a>"};
            String linkText = Messages.getFormattedString((String)"ReportExamples.ContributeSamples.description", (Object[])arguments);
            link.setText(linkText);
            link.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ContributeDialog.this.openLink("https://bugs.eclipse.org/bugs/enter_bug.cgi?product=BIRT&bug_severity=enhancement");
                }
            });
            link.setSize(300, 50);
            return container;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        }

        protected void openLink(String href) {
            if (href.startsWith("file:")) {
                href = href.substring(5);
                while (href.startsWith("/")) {
                    href = href.substring(1);
                }
                href = "file:///" + href;
            }
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            try {
                IWebBrowser browser = support.getExternalBrowser();
                browser.openURL(new URL(this.urlEncodeForSpaces(href.toCharArray())));
            }
            catch (MalformedURLException e) {
                this.openWebBrowserError(href, e);
            }
            catch (PartInitException e) {
                this.openWebBrowserError(href, e);
            }
        }

        private String urlEncodeForSpaces(char[] input) {
            StringBuffer retu = new StringBuffer(input.length);
            int i = 0;
            while (i < input.length) {
                if (input[i] == ' ') {
                    retu.append("%20");
                } else {
                    retu.append(input[i]);
                }
                ++i;
            }
            return retu.toString();
        }

        private void openWebBrowserError(String href, Throwable t) {
            String title = Messages.getString((String)"ReportExamples.OpenBrowser.Error.title");
            String msg = Messages.getString((String)"ReportExamples.OpenBrowser.Error.message");
            MessageBox messageBox = new MessageBox(UIUtil.getDefaultShell(), 33);
            messageBox.setText(title);
            messageBox.setMessage(msg);
            messageBox.open();
        }
    }
}

