/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.RTFHTMLHandler;
import org.eclipse.birt.report.designer.internal.ui.util.RTFParser;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.FormatBuilder;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.AlphabeticallyComparator;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.BidiSegmentEvent;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.TextEditorAction;

public class TextEditor
extends BaseDialog {
    private static final String ACTION_TEXT_EDIT_DYNAMIC_TEXT = Messages.getString((String)"TextEditDialog.action.text.editDynamicText");
    private static final String ACTION_TEXT_FORMAT_DATE_TIME = Messages.getString((String)"TextEditDialog.action.text.formatDateTime");
    private static final String ACTION_TEXT_FORMAT_STRING = Messages.getString((String)"TextEditDialog.action.text.formatString");
    private static final String ACTION_TEXT_FORMAT_NUMBER = Messages.getString((String)"TextEditDialog.action.text.formatNumber");
    private static final String ACTION_TEXT_FORMAT_HTML = Messages.getString((String)"TextEditDialog.action.text.formatHTML");
    private static final String ACTION_BIDI_DIRECTION = Messages.getString((String)"TextEditDialog.action.text.direction");
    private static final String TOOL_TIP_TAG_FONT = Messages.getString((String)"TextEditDialog.toolTip.tag.font");
    private static final String TOOL_TIP_TAG_U = Messages.getString((String)"TextEditDialog.toolTip.tag.u");
    private static final String TOOL_TIP_TAG_I = Messages.getString((String)"TextEditDialog.toolTip.tag.i");
    private static final String TOOL_TIP_TAG_B = Messages.getString((String)"TextEditDialog.toolTip.tag.b");
    private static final String TOOL_TIP_VALUE_OF = Messages.getString((String)"TextEditDialog.toolTip.valueOf");
    private static final String TOOL_TIP_FORMAT_HTML = Messages.getString((String)"TextEditDialog.toolTip.formatHTML");
    private static final String TOOL_TIP_TAG_DD = Messages.getString((String)"TextEditDialog.toolTip.tag.dd");
    private static final String TOOL_TIP_TAG_DT = Messages.getString((String)"TextEditDialog.toolTip.tag.dt");
    private static final String TOOL_TIP_TAG_LI = Messages.getString((String)"TextEditDialog.toolTip.tag.li");
    private static final String TOOL_TIP_TAG_UL = Messages.getString((String)"TextEditDialog.toolTip.tag.ul");
    private static final String TOOL_TIP_TAG_DL = Messages.getString((String)"TextEditDialog.toolTip.tag.dl");
    private static final String TOOL_TIP_TAG_BIRT_IMAGE = Messages.getString((String)"TextEditDialog.toolTip.tag.birtImage");
    private static final String TOOL_TIP_TAG_DEL = Messages.getString((String)"TextEditDialog.toolTip.tag.del");
    private static final String TOOL_TIP_TAG_INS = Messages.getString((String)"TextEditDialog.toolTip.tag.ins");
    private static final String TOOL_TIP_TAG_A = Messages.getString((String)"TextEditDialog.toolTip.tag.a");
    private static final String TOOL_TIP_TAG_IMG = Messages.getString((String)"TextEditDialog.toolTip.tag.img");
    private static final String TOOL_TIP_TAG_GENERIC_STYLE = Messages.getString((String)"TextEditDialog.toolTip.tag.genericStyleContainer");
    private static final String TOOL_TIP_TAG_P = Messages.getString((String)"TextEditDialog.toolTip.tag.p");
    private static final String TOOL_TIP_TAG_BR = Messages.getString((String)"TextEditDialog.toolTip.tag.br");
    private static final String TOOL_TIP_TAG_CENTER = Messages.getString((String)"TextEditDialog.toolTip.tag.center");
    private static final String TOOL_TIP_TAG_TT = Messages.getString((String)"TextEditDialog.toolTip.tag.tt");
    private static final String TOOL_TIP_TAG_CODE = Messages.getString((String)"TextEditDialog.toolTip.tag.code");
    private static final String TOOL_TIP_TAG_PRE = Messages.getString((String)"TextEditDialog.toolTip.tag.pre");
    private static final String TOOL_TIP_TAG_STRONG = Messages.getString((String)"TextEditDialog.toolTip.tag.strong");
    private static final String TOOL_TIP_TAG_EM = Messages.getString((String)"TextEditDialog.toolTip.tag.em");
    private static final String TOOL_TIP_TAG_SUP = Messages.getString((String)"TextEditDialog.toolTip.tag.sup");
    private static final String TOOL_TIP_TAG_SUB = Messages.getString((String)"TextEditDialog.toolTip.tag.sub");
    private static final String TOOL_TIP_TAG_H6 = Messages.getString((String)"TextEditDialog.toolTip.tag.h6");
    private static final String TOOL_TIP_TAG_H5 = Messages.getString((String)"TextEditDialog.toolTip.tag.h5");
    private static final String TOOL_TIP_TAG_H4 = Messages.getString((String)"TextEditDialog.toolTip.tag.h4");
    private static final String TOOL_TIP_TAG_H3 = Messages.getString((String)"TextEditDialog.toolTip.tag.h3");
    private static final String TOOL_TIP_TAG_H2 = Messages.getString((String)"TextEditDialog.toolTip.tag.h2");
    private static final String TOOL_TIP_TAG_H1 = Messages.getString((String)"TextEditDialog.toolTip.tag.h1");
    private static final String TOOL_TIP_TEXT_REDO = Messages.getString((String)"TextEditDialog.toolTipText.redo");
    private static final String TOOL_TIP_TEXT_UNDO = Messages.getString((String)"TextEditDialog.toolTipText.undo");
    private static final String TOOL_TIP_TEXT_DELETE = Messages.getString((String)"TextEditDialog.toolTipText.delete");
    private static final String TOOL_TIP_TEXT_PASTE = Messages.getString((String)"TextEditDialog.toolTipText.paste");
    private static final String TOOL_TIP_TEXT_CUT = Messages.getString((String)"TextEditDialog.toolTipText.cut");
    private static final String TOOL_TIP_TEXT_COPY = Messages.getString((String)"TextEditDialog.toolTipText.copy");
    private static final String TOOL_TIP_TEXT_FX = Messages.getString((String)"TextEditDialog.toolTipText.fx");
    public static final String DLG_TITLE_NEW = Messages.getString((String)"TextEditDialog.title.DlgNew");
    public static final String DLG_TITLE_EDIT = Messages.getString((String)"TextEditDialog.title.DlgEdit");
    private static final int FORMAT_CHOICE_INDEX_FORMATTING = 0;
    private static final int FORMAT_CHOICE_INDEX_LAYOUT = 1;
    private static final int FORMAT_CHOICE_INDEX_CONTENT = 2;
    private static final int FORMAT_CHOICE_INDEX_LISTS = 3;
    private static final int FORMAT_CHOICE_INDEX_DYNAMIC_TEXT = 4;
    private static final IChoiceSet contentTypeChoiceSet = ChoiceSetFactory.getElementChoiceSet("Text", "contentType");
    private static final String[] contentTypeDisplayNames = ChoiceSetFactory.getDisplayNamefromChoiceSet(contentTypeChoiceSet, (Comparator)new AlphabeticallyComparator());
    private TextItemHandle handle;
    private String oldValue = "";
    private StyledText textEditor;
    private SourceViewer textViewer;
    private CCombo textTypeChoicer;
    private CCombo formatChoicer;
    private ToolBar formatTagsBar;
    private ToolBar commonTagsBar;
    private ToolItem tagItem;
    private Composite formatParent;
    private String TEXT_EDIT_LAST_STAGE = "org.eclipse.birt.report.designer.ui.dialogs.TextEditor.lastStage";
    private boolean isEditModel = false;

    public TextEditor(Shell parentShell, String title, TextItemHandle handle) {
        super(parentShell, title);
        this.handle = handle;
        if (handle.getContent() != null) {
            this.oldValue = handle.getContent();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        this.createToolBar(composite);
        Label label = new Label(composite, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        this.createFormatBar(composite);
        this.createTextArea(composite);
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.TextEditor_ID");
        return composite;
    }

    private void createToolBar(Composite composite) {
        Composite innerParent = new Composite(composite, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        innerParent.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(3, false);
        layout.marginLeft = 0;
        layout.marginTop = 0;
        innerParent.setLayout((Layout)layout);
        ToolBar toolBar = new ToolBar(innerParent, 0x800000);
        toolBar.setLayoutData((Object)new GridData());
        ToolItem copy = new ToolItem(toolBar, 0);
        copy.setImage(ReportPlatformUIImages.getImage("IMG_TOOL_COPY"));
        copy.setToolTipText(TOOL_TIP_TEXT_COPY);
        copy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextEditor.this.textEditor.copy();
            }
        });
        ToolItem cut = new ToolItem(toolBar, 0);
        cut.setImage(ReportPlatformUIImages.getImage("IMG_TOOL_CUT"));
        cut.setToolTipText(TOOL_TIP_TEXT_CUT);
        cut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextEditor.this.textEditor.cut();
            }
        });
        ToolItem paste = new ToolItem(toolBar, 0);
        paste.setImage(ReportPlatformUIImages.getImage("IMG_TOOL_PASTE"));
        paste.setToolTipText(TOOL_TIP_TEXT_PASTE);
        paste.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextEditor.this.textEditor.paste();
            }
        });
        ToolItem delete = new ToolItem(toolBar, 0);
        delete.setImage(ReportPlatformUIImages.getImage("IMG_TOOL_DELETE"));
        delete.setToolTipText(TOOL_TIP_TEXT_DELETE);
        delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TextEditor.this.textEditor.getSelectionCount() > 0) {
                    TextEditor.this.textEditor.insert("");
                }
            }
        });
        ToolItem undo = new ToolItem(toolBar, 0);
        undo.setImage(ReportPlatformUIImages.getImage("IMG_TOOL_UNDO"));
        undo.setToolTipText(TOOL_TIP_TEXT_UNDO);
        undo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextEditor.this.textViewer.doOperation(1);
            }
        });
        ToolItem redo = new ToolItem(toolBar, 0);
        redo.setImage(ReportPlatformUIImages.getImage("IMG_TOOL_REDO"));
        redo.setToolTipText(TOOL_TIP_TEXT_REDO);
        redo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextEditor.this.textViewer.doOperation(2);
            }
        });
        ToolItem fx = new ToolItem(toolBar, 0);
        fx.setImage(ReportPlatformUIImages.getImage("Enable Expression Builder"));
        fx.setToolTipText(TOOL_TIP_TEXT_FX);
        fx.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextEditor.this.editDynamicTextDirectly();
            }
        });
        new ToolItem(toolBar, 2);
        this.textTypeChoicer = new CCombo(innerParent, 0x800008);
        GridData data = new GridData();
        data.widthHint = this.textTypeChoicer.computeSize((int)-1, (int)-1).x + 100;
        this.textTypeChoicer.setLayoutData((Object)data);
        this.textTypeChoicer.setVisibleItemCount(30);
        this.textTypeChoicer.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(25));
        this.textTypeChoicer.setItems(contentTypeDisplayNames);
        int index = this.getContentChoiceType(this.textTypeChoicer, this.handle.getContentType());
        if (index < 0) {
            index = 0;
        }
        this.textTypeChoicer.select(index);
        index = this.getContentChoiceType(this.textTypeChoicer, "plain");
        final int PLAIN_INDEX = index < 0 ? 0 : index;
        this.textTypeChoicer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = TextEditor.this.textTypeChoicer.getSelectionIndex();
                TextEditor.this.formatChoicer.setEnabled(index != PLAIN_INDEX);
                TextEditor.this.formatTagsBar.setEnabled(index != PLAIN_INDEX);
                TextEditor.this.commonTagsBar.setEnabled(index != PLAIN_INDEX);
                if (TextEditor.this.formatParent != null && !TextEditor.this.formatParent.isDisposed()) {
                    TextEditor.this.formatParent.setEnabled(TextEditor.this.formatTagsBar.isEnabled());
                    int i = 0;
                    while (i < TextEditor.this.formatParent.getChildren().length) {
                        Control control = TextEditor.this.formatParent.getChildren()[i];
                        control.setEnabled(TextEditor.this.formatParent.getEnabled());
                        ++i;
                    }
                }
                ToolItem[] toolItems = TextEditor.this.formatTagsBar.getItems();
                ToolItem[] commonTags = TextEditor.this.commonTagsBar.getItems();
                int i = 1;
                while (i < toolItems.length) {
                    toolItems[i].setEnabled(TextEditor.this.formatTagsBar.isEnabled());
                    ++i;
                }
                i = 1;
                while (i < commonTags.length) {
                    commonTags[i].setEnabled(TextEditor.this.commonTagsBar.isEnabled());
                    ++i;
                }
                TextEditor.this.textEditor.setFocus();
                TextEditor.this.applyOrientation();
                TextEditor.this.resetOkButtonStatus(true);
            }
        });
        this.commonTagsBar = new ToolBar(innerParent, 0x800000);
        this.commonTagsBar.setLayoutData((Object)new GridData(32));
        this.commonTagsBar.setEnabled(this.textTypeChoicer.getSelectionIndex() != PLAIN_INDEX);
        this.createCommonTags(this.commonTagsBar);
    }

    private int getContentChoiceType(CCombo typeChoicer, String contentType) {
        IChoice choice = contentTypeChoiceSet.findChoice(contentType);
        if (choice == null) {
            return -1;
        }
        String displayName = choice.getDisplayName();
        return typeChoicer.indexOf(displayName);
    }

    private void createFormatBar(Composite composite) {
        Composite innerParent = new Composite(composite, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        innerParent.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(3, false);
        layout.marginLeft = 0;
        layout.marginTop = 0;
        innerParent.setLayout((Layout)layout);
        this.formatChoicer = new CCombo(innerParent, 0x800008);
        GridData gdata = new GridData(32);
        gdata.widthHint = 200;
        gdata.horizontalIndent = 5;
        this.formatChoicer.setLayoutData((Object)gdata);
        this.formatChoicer.setVisibleItemCount(30);
        this.formatChoicer.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(25));
        this.formatChoicer.setItems(new String[]{Messages.getString((String)"TextEditDialog.formatChoice.formatting"), Messages.getString((String)"TextEditDialog.formatChoice.layout"), Messages.getString((String)"TextEditDialog.formatChoice.content"), Messages.getString((String)"TextEditDialog.formatChoice.lists"), Messages.getString((String)"TextEditDialog.formatChoice.dynamicText")});
        int index = this.getContentChoiceType(this.textTypeChoicer, "plain");
        int PLAIN_INDEX = index < 0 ? 0 : index;
        int formatIndex = ReportPlugin.getDefault().getPreferenceStore().getInt(this.TEXT_EDIT_LAST_STAGE);
        formatIndex = formatIndex < 0 ? 0 : formatIndex;
        this.formatChoicer.select(formatIndex);
        this.formatChoicer.setEnabled(this.textTypeChoicer.getSelectionIndex() != PLAIN_INDEX);
        this.formatTagsBar = new ToolBar(innerParent, 0x800000);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.formatTagsBar.setLayoutData((Object)data);
        new ToolItem(this.formatTagsBar, 2);
        this.formatTagsBar.setEnabled(this.textTypeChoicer.getSelectionIndex() != PLAIN_INDEX);
        this.createFormatTags(formatIndex, this.formatTagsBar);
        ToolItem[] toolItems = this.formatTagsBar.getItems();
        int i = 1;
        while (i < toolItems.length) {
            toolItems[i].setEnabled(this.formatTagsBar.isEnabled());
            ++i;
        }
        this.formatChoicer.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private BidiSegmentListener listener = new BidiSegmentListener(){

                public void lineGetSegments(BidiSegmentEvent event) {
                    event.segments = UIUtil.getExpressionBidiSegments(event.lineText);
                }
            };

            public void widgetSelected(SelectionEvent e) {
                int index = TextEditor.this.formatChoicer.getSelectionIndex();
                ToolItem[] toolItems = TextEditor.this.formatTagsBar.getItems();
                int i = 1;
                while (i < toolItems.length) {
                    toolItems[i].dispose();
                    ++i;
                }
                TextEditor.this.createFormatTags(index, TextEditor.this.formatTagsBar);
                TextEditor.this.textEditor.setFocus();
                if (index == 4) {
                    TextEditor.this.textViewer.getTextWidget().addBidiSegmentListener(this.listener);
                } else {
                    TextEditor.this.textViewer.getTextWidget().removeBidiSegmentListener(this.listener);
                }
                TextEditor.this.textViewer.getTextWidget().redraw();
            }
        });
    }

    private void createTextArea(Composite parent) {
        IVerticalRuler ruler = null;
        int style = this.updateBidiStyle(68418);
        this.textViewer = new SourceViewer(parent, ruler, style);
        this.textViewer.setDocument((IDocument)new Document());
        this.textEditor = this.textViewer.getTextWidget();
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.widthHint = 600;
        gd.heightHint = 300;
        this.textEditor.setLayoutData((Object)gd);
        this.textEditor.setText(this.oldValue);
        this.textEditor.setFocus();
        this.textEditor.setFont(JFaceResources.getTextFont());
        this.textEditor.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (this.isUndoKeyPress(e)) {
                    TextEditor.this.textViewer.doOperation(1);
                } else if (this.isRedoKeyPress(e)) {
                    TextEditor.this.textViewer.doOperation(2);
                }
            }

            public void keyReleased(KeyEvent e) {
            }

            private boolean isUndoKeyPress(KeyEvent e) {
                return (e.stateMask & 0x40000) > 0 && (e.keyCode == 122 || e.keyCode == 90);
            }

            private boolean isRedoKeyPress(KeyEvent e) {
                return (e.stateMask & 0x40000) > 0 && (e.keyCode == 121 || e.keyCode == 89);
            }
        });
        this.textEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TextEditor.this.resetOkButtonStatus(true);
            }
        });
        this.textViewer.configure(new SourceViewerConfiguration());
        this.textEditor.invokeAction(17039368);
        ResourceBundle bundle = ResourceBundle.getBundle("org.eclipse.birt.report.designer.nls.messages");
        final EBTextAction undoAction = new EBTextAction(bundle, "TextAreaContextMenu.Undo.", this.textViewer, 1);
        undoAction.setAccelerator(262234);
        final EBTextAction redoAction = new EBTextAction(bundle, "TextAreaContextMenu.Redo.", this.textViewer, 2);
        redoAction.setAccelerator(262233);
        final EBTextAction cutAction = new EBTextAction(bundle, "TextAreaContextMenu.Cut.", this.textViewer, 3);
        cutAction.setAccelerator(262232);
        final EBTextAction copyAction = new EBTextAction(bundle, "TextAreaContextMenu.Copy.", this.textViewer, 4);
        copyAction.setAccelerator(262211);
        final EBTextAction pasteAction = new EBTextAction(bundle, "TextAreaContextMenu.Paste.", this.textViewer, 5);
        pasteAction.setAccelerator(262230);
        final EBTextAction selectAllAction = new EBTextAction(bundle, "TextAreaContextMenu.SelectAll.", this.textViewer, 7);
        selectAllAction.setAccelerator(262209);
        MenuManager menuMgr = new MenuManager("#EB Context");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.add((IContributionItem)new Separator("group.undo"));
                menuManager.add((IContributionItem)new Separator("group.copy"));
                menuManager.add((IContributionItem)new Separator("group.edit"));
                menuManager.add((IContributionItem)new Separator("group.rest"));
                undoAction.update();
                redoAction.update();
                copyAction.update();
                cutAction.update();
                pasteAction.update();
                selectAllAction.update();
                menuManager.appendToGroup("group.undo", (IAction)undoAction);
                menuManager.appendToGroup("group.undo", (IAction)redoAction);
                menuManager.appendToGroup("group.copy", (IAction)cutAction);
                menuManager.appendToGroup("group.copy", (IAction)copyAction);
                menuManager.appendToGroup("group.copy", (IAction)pasteAction);
                menuManager.appendToGroup("group.copy", (IAction)new Action(Messages.getString((String)"TextEditor.PasteFormattedText")){

                    public void run() {
                        TextEditor.this.pasteClipboard();
                    }
                });
                menuManager.appendToGroup("group.edit", (IAction)selectAllAction);
                int index = TextEditor.this.getContentChoiceType(TextEditor.this.textTypeChoicer, "plain");
                final int PLAIN_INDEX = index < 0 ? 0 : index;
                Action action = new Action(ACTION_TEXT_FORMAT_HTML){

                    public boolean isEnabled() {
                        return TextEditor.this.textTypeChoicer.getSelectionIndex() != PLAIN_INDEX;
                    }

                    public void run() {
                        String result = " format=\"HTML\"";
                        TextEditor.this.textEditor.insert(result);
                    }
                };
                menuManager.appendToGroup("group.rest", (IAction)action);
                action = new Action(ACTION_TEXT_FORMAT_NUMBER){

                    public boolean isEnabled() {
                        return TextEditor.this.textTypeChoicer.getSelectionIndex() != PLAIN_INDEX;
                    }

                    public void run() {
                        TextEditor.this.insertFormat(2);
                    }
                };
                menuManager.appendToGroup("group.rest", (IAction)action);
                action = new Action(ACTION_TEXT_FORMAT_STRING){

                    public boolean isEnabled() {
                        return TextEditor.this.textTypeChoicer.getSelectionIndex() != PLAIN_INDEX;
                    }

                    public void run() {
                        TextEditor.this.insertFormat(1);
                    }
                };
                menuManager.appendToGroup("group.rest", (IAction)action);
                action = new Action(ACTION_TEXT_FORMAT_DATE_TIME){

                    public boolean isEnabled() {
                        return TextEditor.this.textTypeChoicer.getSelectionIndex() != PLAIN_INDEX;
                    }

                    public void run() {
                        TextEditor.this.insertFormat(3);
                    }
                };
                menuManager.appendToGroup("group.rest", (IAction)action);
                action = new Action(ACTION_TEXT_EDIT_DYNAMIC_TEXT){

                    public boolean isEnabled() {
                        return TextEditor.this.textTypeChoicer.getSelectionIndex() != PLAIN_INDEX;
                    }

                    public void run() {
                        TextEditor.this.editDynamicTextDirectly();
                    }
                };
                menuManager.appendToGroup("group.rest", (IAction)action);
                action = new Action(ACTION_BIDI_DIRECTION){

                    public boolean isEnabled() {
                        return true;
                    }

                    public void run() {
                        TextEditor.this.textEditor.setOrientation(this.isChecked() ? 0x4000000 : 0x2000000);
                    }
                };
                action.setChecked((TextEditor.this.textEditor.getOrientation() & 0x4000000) != 0);
                menuManager.appendToGroup("group.rest", (IAction)action);
            }
        });
        this.textEditor.setMenu(menuMgr.createContextMenu((Control)this.textEditor));
    }

    private void pasteClipboard() {
        RTFTransfer rtfTransfer;
        Clipboard cb = new Clipboard(Display.getCurrent());
        Object contents = cb.getContents((Transfer)(rtfTransfer = RTFTransfer.getInstance()));
        if (contents != null) {
            RTFHTMLHandler handler = new RTFHTMLHandler();
            try {
                RTFParser.parse(contents.toString(), handler);
                this.textEditor.insert(handler.toHTML());
                return;
            }
            catch (Exception exception) {}
        } else {
            HTMLTransfer htmlTransfer = HTMLTransfer.getInstance();
            contents = cb.getContents((Transfer)htmlTransfer);
            if (contents != null) {
                this.textEditor.insert(contents.toString());
                return;
            }
        }
        TextTransfer plainTextTransfer = TextTransfer.getInstance();
        String text = (String)cb.getContents((Transfer)plainTextTransfer, 1);
        this.textEditor.insert(text);
    }

    private void createCommonTags(ToolBar toolBar) {
        new ToolItem(toolBar, 2);
        HTMLTag tag = new HTMLTag("<B>", true);
        tag.setToolTipText(TOOL_TIP_TAG_B);
        this.createToolItemWithHTMLTag(toolBar, tag);
        tag = new HTMLTag("<I>", true);
        tag.setToolTipText(TOOL_TIP_TAG_I);
        this.createToolItemWithHTMLTag(toolBar, tag);
        tag = new HTMLTag("<U>", true);
        tag.setToolTipText(TOOL_TIP_TAG_U);
        this.createToolItemWithHTMLTag(toolBar, tag);
        tag = new HTMLTag("<FONT>", true);
        tag.setToolTipText(TOOL_TIP_TAG_FONT);
        tag.addAttribute("size");
        tag.addAttribute("color");
        tag.addAttribute("face");
        this.createToolItemWithHTMLTag(toolBar, tag);
        ToolItem[] toolItems = this.commonTagsBar.getItems();
        int i = 1;
        while (i < toolItems.length) {
            toolItems[i].setEnabled(this.commonTagsBar.isEnabled());
            ++i;
        }
    }

    private void createFormatTags(int index, ToolBar toolBar) {
        if (this.formatParent != null && !this.formatParent.isDisposed()) {
            this.formatParent.dispose();
            toolBar.getParent().layout();
        }
        switch (index) {
            case 0: {
                HTMLTag tag = new HTMLTag("<H1>", true);
                tag.setToolTipText(TOOL_TIP_TAG_H1);
                this.createToolItemWithHTMLTag(toolBar, tag);
                tag = new HTMLTag("<H2>", true);
                tag.setToolTipText(TOOL_TIP_TAG_H2);
                this.createToolItemWithHTMLTag(toolBar, tag);
                tag = new HTMLTag("<H3>", true);
                tag.setToolTipText(TOOL_TIP_TAG_H3);
                this.createToolItemWithHTMLTag(toolBar, tag);
                tag = new HTMLTag("<H4>", true);
                tag.setToolTipText(TOOL_TIP_TAG_H4);
                this.createToolItemWithHTMLTag(toolBar, tag);
                tag = new HTMLTag("<H5>", true);
                tag.setToolTipText(TOOL_TIP_TAG_H5);
                this.createToolItemWithHTMLTag(toolBar, tag);
                tag = new HTMLTag("<H6>", true);
                tag.setToolTipText(TOOL_TIP_TAG_H6);
                this.createToolItemWithHTMLTag(toolBar, tag);
                tag = new HTMLTag("<SUB>", true);
                tag.setToolTipText(TOOL_TIP_TAG_SUB);
                this.createToolItemWithHTMLTag(toolBar, tag);
                tag = new HTMLTag("<SUP>", true);
                tag.setToolTipText(TOOL_TIP_TAG_SUP);
                this.createToolItemWithHTMLTag(toolBar, tag);
                tag = new HTMLTag("<EM>", true);
                tag.setToolTipText(TOOL_TIP_TAG_EM);
                this.createToolItemWithHTMLTag(toolBar, tag);
                tag = new HTMLTag("<STRONG>", true);
                tag.setToolTipText(TOOL_TIP_TAG_STRONG);
                this.createToolItemWithHTMLTag(toolBar, tag);
                tag = new HTMLTag("<PRE>", true);
                tag.setToolTipText(TOOL_TIP_TAG_PRE);
                this.createToolItemWithHTMLTag(toolBar, tag);
                tag = new HTMLTag("<CODE>", true);
                tag.setToolTipText(TOOL_TIP_TAG_CODE);
                this.createToolItemWithHTMLTag(toolBar, tag);
                tag = new HTMLTag("<TT>", true);
                tag.setToolTipText(TOOL_TIP_TAG_TT);
                this.createToolItemWithHTMLTag(toolBar, tag);
                ((GridData)toolBar.getLayoutData()).horizontalSpan = 2;
                toolBar.getParent().layout(true, true);
                break;
            }
            case 1: {
                HTMLTag tag = new HTMLTag("<CENTER>", true);
                tag.setToolTipText(TOOL_TIP_TAG_CENTER);
                this.createToolItemWithHTMLTag(toolBar, tag);
                tag = new HTMLTag("<BR>", false);
                tag.setToolTipText(TOOL_TIP_TAG_BR);
                this.createToolItemWithHTMLTag(toolBar, tag);
                tag = new HTMLTag("<P>", true);
                tag.setToolTipText(TOOL_TIP_TAG_P);
                this.createToolItemWithHTMLTag(toolBar, tag);
                tag = new HTMLTag("<DIV>", true);
                tag.setToolTipText(TOOL_TIP_TAG_GENERIC_STYLE);
                this.createToolItemWithHTMLTag(toolBar, tag);
                tag = new HTMLTag("<SPAN>", true);
                tag.setToolTipText(TOOL_TIP_TAG_GENERIC_STYLE);
                this.createToolItemWithHTMLTag(toolBar, tag);
                ((GridData)toolBar.getLayoutData()).horizontalSpan = 2;
                toolBar.getParent().layout(true, true);
                break;
            }
            case 2: {
                HTMLTag tag = new HTMLTag("<IMG>", false);
                tag.setToolTipText(TOOL_TIP_TAG_IMG);
                tag.addAttribute("src");
                tag.addAttribute("alt");
                this.createToolItemWithHTMLTag(toolBar, tag);
                tag = new HTMLTag("<A>", true);
                tag.setToolTipText(TOOL_TIP_TAG_A);
                tag.addAttribute("name");
                tag.addAttribute("href");
                this.createToolItemWithHTMLTag(toolBar, tag);
                tag = new HTMLTag("<INS>", true);
                tag.setToolTipText(TOOL_TIP_TAG_INS);
                tag.addAttribute("cite");
                this.createToolItemWithHTMLTag(toolBar, tag);
                tag = new HTMLTag("<DEL>", true);
                tag.setToolTipText(TOOL_TIP_TAG_DEL);
                tag.addAttribute("cite");
                this.createToolItemWithHTMLTag(toolBar, tag);
                tag = new HTMLTag("<IMAGE>", true);
                tag.setToolTipText(TOOL_TIP_TAG_BIRT_IMAGE);
                tag.addAttribute("name");
                tag.addAttribute("type");
                this.createToolItemWithHTMLTag(toolBar, tag);
                ((GridData)toolBar.getLayoutData()).horizontalSpan = 2;
                toolBar.getParent().layout(true, true);
                break;
            }
            case 3: {
                HTMLTag tag = new HTMLTag("<DL>", true);
                tag.setToolTipText(TOOL_TIP_TAG_DL);
                this.createToolItemWithHTMLTag(toolBar, tag);
                tag = new HTMLTag("<UL>", true);
                tag.setToolTipText(TOOL_TIP_TAG_UL);
                this.createToolItemWithHTMLTag(toolBar, tag);
                tag = new HTMLTag("<LI>", true);
                tag.setToolTipText(TOOL_TIP_TAG_LI);
                this.createToolItemWithHTMLTag(toolBar, tag);
                tag = new HTMLTag("<DT>", true);
                tag.setToolTipText(TOOL_TIP_TAG_DT);
                this.createToolItemWithHTMLTag(toolBar, tag);
                tag = new HTMLTag("<DD>", true);
                tag.setToolTipText(TOOL_TIP_TAG_DD);
                this.createToolItemWithHTMLTag(toolBar, tag);
                ((GridData)toolBar.getLayoutData()).horizontalSpan = 2;
                toolBar.getParent().layout(true, true);
                break;
            }
            case 4: {
                final ToolItem value = new ToolItem(toolBar, 0);
                value.setText("<VALUE-OF>");
                value.setToolTipText(TOOL_TIP_VALUE_OF);
                value.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ExpressionBuilder expressionBuilder = new ExpressionBuilder("");
                        expressionBuilder.setExpressionProvider(new ExpressionProvider((DesignElementHandle)TextEditor.this.handle));
                        if (expressionBuilder.open() == 0 && !expressionBuilder.getResult().equals("")) {
                            Point point = TextEditor.this.textEditor.getSelection();
                            int start = point.x < point.y ? point.x : point.y;
                            String result = String.valueOf(value.getText()) + expressionBuilder.getResult() + value.getText().replaceFirst("<", "</");
                            TextEditor.this.textEditor.insert(result);
                            TextEditor.this.textEditor.setSelection(start + result.length());
                        }
                    }
                });
                ToolItem formatHTML = new ToolItem(toolBar, 0);
                formatHTML.setText("<VALUE-OF Format HTML>");
                formatHTML.setToolTipText(TOOL_TIP_FORMAT_HTML);
                formatHTML.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String result = " format=\"HTML\"";
                        TextEditor.this.textEditor.insert(result);
                    }
                });
                this.formatParent = new Composite(toolBar.getParent(), 0);
                GridLayout gdLayout = new GridLayout();
                gdLayout.numColumns = 3;
                this.formatParent.setLayout((Layout)gdLayout);
                GridData gd = new GridData();
                this.formatParent.setLayoutData((Object)gd);
                new Label(this.formatParent, 0).setText("<VALUE-OF");
                final CCombo combo = new CCombo(this.formatParent, 0x800008);
                GridData gdata = new GridData(32);
                gdata.widthHint = 150;
                combo.setLayoutData((Object)gdata);
                combo.setVisibleItemCount(30);
                combo.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(25));
                combo.setItems(new String[]{Messages.getString((String)"TextEditDialog.action.item.formatNumber"), Messages.getString((String)"TextEditDialog.action.item.formatString"), Messages.getString((String)"TextEditDialog.action.item.formatDateTime")});
                new Label(this.formatParent, 0).setText(">");
                combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        int index = combo.getSelectionIndex();
                        combo.select(-1);
                        switch (index) {
                            case 0: {
                                TextEditor.this.insertFormat(2);
                                break;
                            }
                            case 1: {
                                TextEditor.this.insertFormat(1);
                                break;
                            }
                            case 2: {
                                TextEditor.this.insertFormat(3);
                            }
                        }
                        TextEditor.this.textEditor.setFocus();
                    }
                });
                ((GridData)toolBar.getLayoutData()).horizontalSpan = 1;
                toolBar.getParent().layout(true, true);
                boolean enabled = toolBar.isEnabled();
                if (enabled) break;
                this.formatParent.setEnabled(false);
                int i = 0;
                while (i < this.formatParent.getChildren().length) {
                    this.formatParent.getChildren()[i].setEnabled(false);
                    ++i;
                }
                break;
            }
        }
    }

    private void insertFormat(int style) {
        FormatBuilder dialog = new FormatBuilder(style);
        if (dialog.open() == 0 && ((Object[])dialog.getResult())[1] != null) {
            String result = " format=\"" + ((Object[])dialog.getResult())[1] + "\"";
            this.textEditor.insert(result);
        }
    }

    protected void createToolItemWithHTMLTag(ToolBar parent, final HTMLTag tag) {
        this.tagItem = new ToolItem(parent, 0);
        this.tagItem.setText(tag.getName());
        this.tagItem.setToolTipText(tag.getToolTip());
        this.tagItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String frontTag = tag.getName();
                String backTag = tag.getName().replaceFirst("<", "</");
                if (!tag.getAttributes().isEmpty()) {
                    StringBuffer buffer = new StringBuffer();
                    Iterator<String> iter = tag.getAttributes().iterator();
                    while (iter.hasNext()) {
                        buffer.append(" " + iter.next() + "=\"\"");
                    }
                    frontTag = tag.getName().replaceFirst(">", String.valueOf(buffer.toString()) + ">");
                }
                Point point = TextEditor.this.textEditor.getSelection();
                int start = point.x < point.y ? point.x : point.y;
                String selectedText = TextEditor.this.textEditor.getSelectionText();
                if (tag.isPair()) {
                    String text = selectedText.length() == 0 ? String.valueOf(frontTag) + TextEditor.this.textEditor.getLineDelimiter() + TextEditor.this.textEditor.getLineDelimiter() + backTag : String.valueOf(frontTag) + selectedText + backTag;
                    TextEditor.this.textEditor.insert(text);
                } else {
                    TextEditor.this.textEditor.insert(String.valueOf(frontTag) + selectedText);
                }
                if (!tag.getAttributes().isEmpty()) {
                    TextEditor.this.textEditor.setCaretOffset(start + tag.getName().length() + tag.getAttributes().get(0).length() + 2);
                } else {
                    int offset = start + frontTag.length();
                    if (tag.isPair() && selectedText.length() == 0) {
                        offset = TextEditor.this.textEditor.getOffsetAtLine(TextEditor.this.textEditor.getLineAtOffset(start) + 1);
                    }
                    TextEditor.this.textEditor.setCaretOffset(offset);
                }
            }
        });
    }

    protected void okPressed() {
        String result = this.textEditor.getText();
        try {
            int index = this.textTypeChoicer.getSelectionIndex();
            if (index < 0) {
                this.handle.setContentType("auto");
            } else {
                IChoice choice = contentTypeChoiceSet.findChoiceByDisplayName(this.textTypeChoicer.getText());
                if (choice == null) {
                    this.handle.setContentType("auto");
                } else {
                    this.handle.setContentType(choice.getDisplayName());
                }
            }
            this.handle.setContent(result.length() > 0 ? result : null);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
        this.setResult(this.handle);
        super.okPressed();
    }

    public boolean close() {
        ReportPlugin.getDefault().getPreferenceStore().setValue(this.TEXT_EDIT_LAST_STAGE, this.formatChoicer.getSelectionIndex());
        return super.close();
    }

    private int updateBidiStyle(int style) {
        return style |= this.handle.isDirectionRTL() ? 0x4000000 : 0x2000000;
    }

    private void applyOrientation() {
        this.textEditor.setOrientation(this.handle.isDirectionRTL() ? 0x4000000 : 0x2000000);
    }

    private void editDynamicTextDirectly() {
        this.textEditor.selectAll();
        ExpressionBuilder eb = new ExpressionBuilder(this.textEditor.getSelectionText());
        eb.setExpressionProvider(new ExpressionProvider((DesignElementHandle)this.handle));
        if (eb.open() == 0 && !eb.getResult().equals("")) {
            this.textEditor.insert(eb.getResult());
        }
    }

    protected boolean needRememberLastSize() {
        return true;
    }

    protected void resetOkButtonStatus(Boolean enabled) {
        Button okButton = this.getButton(0);
        if (okButton != null && okButton.isEnabled() != enabled.booleanValue()) {
            okButton.setEnabled(enabled.booleanValue());
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        if (this.isEditModal()) {
            this.resetOkButtonStatus(false);
        }
    }

    public void setEditModal(boolean isEditModel) {
        this.isEditModel = isEditModel;
    }

    public boolean isEditModal() {
        return this.isEditModel;
    }

    static class EBTextAction
    extends TextEditorAction {
        SourceViewer sourceViewer;
        int operationCode;

        public EBTextAction(ResourceBundle bundle, String prefix, SourceViewer sourceViewer, int operationCode) {
            super(bundle, prefix, null);
            this.sourceViewer = sourceViewer;
            this.operationCode = operationCode;
            this.update();
        }

        public void update() {
            if (this.sourceViewer != null) {
                this.setEnabled(this.sourceViewer.canDoOperation(this.operationCode));
            }
        }

        public void run() {
            this.sourceViewer.doOperation(this.operationCode);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HTMLTag {
        private String name;
        private boolean isPair;
        private String toolTip;
        private List<String> attributes = new ArrayList<String>();

        public HTMLTag(String name, boolean isPair) {
            this.name = name;
            this.isPair = isPair;
        }

        public void setToolTipText(String text) {
            this.toolTip = text;
        }

        public void addAttribute(String obj) {
            this.getAttributes().add(obj);
        }

        public String getName() {
            return this.name;
        }

        public String getToolTip() {
            return this.toolTip;
        }

        public boolean isPair() {
            return this.isPair;
        }

        public List<String> getAttributes() {
            return this.attributes;
        }
    }
}

