/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.odp.device;

import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.io.IOException;
import java.util.Map;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.emitter.odp.OdpContext;
import org.eclipse.birt.report.engine.emitter.odp.OdpWriter;
import org.eclipse.birt.report.engine.emitter.odp.util.OdpUtil;
import org.eclipse.birt.report.engine.layout.emitter.AbstractPage;
import org.eclipse.birt.report.engine.layout.emitter.Image;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.nLayout.area.style.TextStyle;
import org.eclipse.birt.report.engine.odf.pkg.ImageEntry;
import org.eclipse.birt.report.engine.odf.pkg.ImageManager;
import org.eclipse.birt.report.engine.odf.style.HyperlinkInfo;
import org.eclipse.birt.report.engine.odf.style.StyleBuilder;
import org.eclipse.birt.report.engine.odf.style.StyleEntry;

public class OdpPage
extends AbstractPage {
    private OdpWriter writer;
    private boolean isDisposed;
    private HyperlinkInfo link;
    private OdpContext context;
    private StyleEntry textFrameStyle;

    public OdpPage(int pageWidth, int pageHeight, Color backgroundColor, OdpWriter writer, OdpContext context) {
        super(pageWidth, pageHeight);
        this.context = context;
        writer.newPage(this.pageWidth, this.pageHeight, backgroundColor, context.getMasterPageManager().getCurrentMasterPage());
        this.writer = writer;
        this.isDisposed = false;
        this.textFrameStyle = StyleBuilder.createEmptyStyleEntry((int)7);
        this.textFrameStyle.setProperty(61, (Object)"none");
        this.textFrameStyle.setProperty(60, (Object)"none");
        context.addStyle(this.textFrameStyle);
    }

    public void restoreState() {
    }

    public void saveState() {
    }

    public void dispose() {
        if (!this.isDisposed) {
            this.writer.endPage();
            this.isDisposed = true;
        }
    }

    protected void clip(float startX, float startY, float width, float height) {
    }

    protected void drawBackgroundColor(Color color, float x, float y, float width, float height) {
        if (color == null) {
            return;
        }
        StyleEntry rectStyle = StyleBuilder.createEmptyStyleEntry((int)7);
        rectStyle.setProperty(62, (Object)OdpUtil.getColorString(color));
        rectStyle.setProperty(61, (Object)"solid");
        rectStyle.setProperty(60, (Object)"none");
        this.context.addStyle(rectStyle);
        this.writer.drawBackgroundColor(x, y, width, height, rectStyle);
    }

    protected void drawBackgroundImage(float x, float y, float width, float height, float imageWidth, float imageHeight, int repeat, String imageUrl, float absPosX, float absPosY) throws IOException {
        if (imageUrl == null) {
            return;
        }
        ImageEntry entry = this.context.getImageManager().addImage(imageUrl, null, null);
        Image image = entry.getImage();
        if (imageWidth == 0.0f) {
            imageWidth = image.getWidth();
        }
        if (imageHeight == 0.0f) {
            imageHeight = image.getHeight();
        }
        this.writer.drawBackgroundImage(entry.getUri(), x, y, width, height, imageWidth, imageHeight, absPosX, absPosY, repeat);
    }

    protected void drawImage(String imageId, byte[] imageData, String extension, float imageX, float imageY, float height, float width, String helpText, Map params) throws Exception {
        if (extension == null && imageId != null) {
            extension = "." + ImageManager.getImageExtension((String)imageId);
        }
        ImageEntry entry = this.context.getImageManager().addImage(imageData, extension);
        this.writer.drawImage(imageId, null, entry.getUri(), extension, imageX, imageY, height, width, helpText, this.link);
    }

    protected void drawImage(String imageId, String extension, float imageX, float imageY, float height, float width, String helpText, Map params) throws Exception {
        if (imageId == null) {
            return;
        }
        ImageEntry entry = this.context.getImageManager().addImage(imageId, null, extension);
        this.writer.drawImage(imageId, null, entry.getUri(), extension, imageX, imageY, height, width, helpText, this.link);
    }

    protected void drawLine(float startX, float startY, float endX, float endY, float width, Color color, int lineStyle) {
        if (color == null || 0.0f == width || lineStyle == 28) {
            return;
        }
        StyleEntry entry = StyleBuilder.createEmptyStyleEntry((int)7);
        entry.setProperty(7, (Object)OdpUtil.getColorString(color));
        entry.setProperty(63, (Object)Float.valueOf(width / 72.0f));
        if (lineStyle == 22 || lineStyle == 20) {
            entry.setProperty(60, (Object)"dash");
        } else {
            entry.setProperty(60, (Object)"solid");
        }
        this.context.addStyle(entry);
        this.writer.drawLine(startX, startY, endX, endY, entry);
    }

    public void drawText(String text, int textX, int textY, int textWidth, int textHeight, TextStyle textStyle) {
        float x = this.convertToPoint(textX);
        float y = this.convertToPoint(textY);
        float width = this.convertToPoint(textWidth);
        float height = this.convertToPoint(textHeight);
        FontInfo fontInfo = textStyle.getFontInfo();
        float baseline = this.convertToPoint(fontInfo.getBaseline());
        this.drawText(text, x, y, baseline, width, height, textStyle);
    }

    protected void drawText(String text, float textX, float textY, float baseline, float width, float height, TextStyle textStyle) {
        FontInfo fontInfo = textStyle.getFontInfo();
        float descend = fontInfo.getBaseFont().getFontDescriptor(3, fontInfo.getFontSize());
        StyleEntry style = StyleBuilder.createEmptyStyleEntry((int)1);
        style.setProperty(27, (Object)textStyle.getDirection());
        style.setProperty(7, (Object)OdpUtil.getColorString(textStyle.getColor()));
        style.setProperty(47, (Object)new FloatValue(9, (float)textStyle.getLetterSpacing() / 1000.0f));
        BaseFont baseFont = fontInfo.getBaseFont();
        String fontName = OdpUtil.getFontName(baseFont);
        style.setProperty(0, (Object)fontName);
        style.setProperty(1, (Object)fontInfo.getFontSize());
        if ((fontInfo.getFontStyle() & 1) != 0) {
            style.setProperty(3, (Object)"bold");
        }
        if ((fontInfo.getFontStyle() & 2) != 0) {
            style.setProperty(2, (Object)"italic");
        }
        if (textStyle.isLinethrough()) {
            style.setProperty(4, (Object)true);
        }
        if (textStyle.isOverline()) {
            style.setProperty(59, (Object)true);
        }
        if (textStyle.isUnderline()) {
            style.setProperty(5, (Object)true);
        }
        this.context.addStyle(style);
        this.writer.drawText(text, textX, textY, width, height + descend * 0.6f, this.textFrameStyle, style, this.link);
    }

    public void setLink(HyperlinkInfo link) {
        this.link = link;
    }

    protected void drawBackgroundImage(float x, float y, float width, float height, float imageWidth, float imageHeight, int repeat, String imageUrl, byte[] imageData, float absPosX, float absPosY) throws IOException {
        this.drawBackgroundImage(x, y, width, height, imageWidth, imageHeight, repeat, imageUrl, absPosX, absPosY);
    }
}

