/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.config.ppt;

import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.PDFRenderOption;
import org.eclipse.birt.report.engine.emitter.config.AbstractConfigurableOptionObserver;
import org.eclipse.birt.report.engine.emitter.config.AbstractEmitterDescriptor;
import org.eclipse.birt.report.engine.emitter.config.ConfigurableOption;
import org.eclipse.birt.report.engine.emitter.config.IConfigurableOption;
import org.eclipse.birt.report.engine.emitter.config.IConfigurableOptionObserver;
import org.eclipse.birt.report.engine.emitter.config.IOptionValue;
import org.eclipse.birt.report.engine.emitter.config.OptionValue;
import org.eclipse.birt.report.engine.emitter.config.ppt.i18n.Messages;

public class PPTEmitterDescriptor
extends AbstractEmitterDescriptor {
    protected static final String FONT_SUBSTITUTION = "FontSubstitution";
    protected static final String BIDI_PROCESSING = "BIDIProcessing";
    protected static final String TEXT_WRAPPING = "TextWrapping";
    protected static final String CHART_DPI = "ChartDpi";

    protected void initOptions() {
        this.loadDefaultValues("org.eclipse.birt.report.engine.emitter.ppt.config");
        ConfigurableOption bidiProcessing = new ConfigurableOption(BIDI_PROCESSING);
        bidiProcessing.setDisplayName(this.getMessage("OptionDisplayValue.BidiProcessing"));
        bidiProcessing.setDataType(IConfigurableOption.DataType.BOOLEAN);
        bidiProcessing.setDisplayType(IConfigurableOption.DisplayType.CHECKBOX);
        bidiProcessing.setDefaultValue((Object)Boolean.TRUE);
        bidiProcessing.setToolTip(null);
        bidiProcessing.setDescription(this.getMessage("OptionDescription.BidiProcessing"));
        ConfigurableOption textWrapping = new ConfigurableOption(TEXT_WRAPPING);
        textWrapping.setDisplayName(this.getMessage("OptionDisplayValue.TextWrapping"));
        textWrapping.setDataType(IConfigurableOption.DataType.BOOLEAN);
        textWrapping.setDisplayType(IConfigurableOption.DisplayType.CHECKBOX);
        textWrapping.setDefaultValue((Object)Boolean.TRUE);
        textWrapping.setToolTip(null);
        textWrapping.setDescription(this.getMessage("OptionDescription.TextWrapping"));
        ConfigurableOption fontSubstitution = new ConfigurableOption(FONT_SUBSTITUTION);
        fontSubstitution.setDisplayName(this.getMessage("OptionDisplayValue.FontSubstitution"));
        fontSubstitution.setDataType(IConfigurableOption.DataType.BOOLEAN);
        fontSubstitution.setDisplayType(IConfigurableOption.DisplayType.CHECKBOX);
        fontSubstitution.setDefaultValue((Object)Boolean.TRUE);
        fontSubstitution.setToolTip(null);
        fontSubstitution.setDescription(this.getMessage("OptionDescription.FontSubstitution"));
        ConfigurableOption pageOverFlow = new ConfigurableOption("pdfRenderOption.pageOverflow");
        pageOverFlow.setDisplayName(this.getMessage("OptionDisplayValue.PageOverFlow"));
        pageOverFlow.setDataType(IConfigurableOption.DataType.INTEGER);
        pageOverFlow.setDisplayType(IConfigurableOption.DisplayType.COMBO);
        pageOverFlow.setChoices((IOptionValue[])new OptionValue[]{new OptionValue((Object)1, this.getMessage("OptionDisplayValue.CLIP_CONTENT")), new OptionValue((Object)2, this.getMessage("OptionDisplayValue.FIT_TO_PAGE_SIZE")), new OptionValue((Object)4, this.getMessage("OptionDisplayValue.OUTPUT_TO_MULTIPLE_PAGES")), new OptionValue((Object)8, this.getMessage("OptionDisplayValue.ENLARGE_PAGE_SIZE"))});
        pageOverFlow.setDefaultValue((Object)1);
        pageOverFlow.setToolTip(null);
        pageOverFlow.setDescription(this.getMessage("OptionDescription.PageOverFlow"));
        ConfigurableOption chartDpi = new ConfigurableOption(CHART_DPI);
        chartDpi.setDisplayName(this.getMessage("OptionDisplayValue.ChartDpi"));
        chartDpi.setDataType(IConfigurableOption.DataType.INTEGER);
        chartDpi.setDisplayType(IConfigurableOption.DisplayType.TEXT);
        chartDpi.setDefaultValue((Object)new Integer(192));
        chartDpi.setToolTip(this.getMessage("Tooltip.ChartDpi"));
        chartDpi.setDescription(this.getMessage("OptionDescription.ChartDpi"));
        this.options = new IConfigurableOption[]{bidiProcessing, textWrapping, fontSubstitution, pageOverFlow, chartDpi};
        this.applyDefaultValues();
    }

    private String getMessage(String key) {
        return Messages.getString(key, this.locale);
    }

    public IConfigurableOptionObserver createOptionObserver() {
        return new PPTOptionObserver();
    }

    public String getDescription() {
        return this.getMessage("PPTEmitter.Description");
    }

    public String getDisplayName() {
        return this.getMessage("PPTEmitter.DisplayName");
    }

    public String getID() {
        return "org.eclipse.birt.report.engine.emitter.ppt";
    }

    public String getRenderOptionName(String name) {
        assert (name != null);
        if (TEXT_WRAPPING.equals(name)) {
            return "pdfRenderOption.textWrapping";
        }
        if (BIDI_PROCESSING.equals(name)) {
            return "pdfRenderOption.bidiProcessing";
        }
        if (FONT_SUBSTITUTION.equals(name)) {
            return "pdfRenderOption.fontSubstitution";
        }
        if (CHART_DPI.equals(name)) {
            return CHART_DPI;
        }
        return name;
    }

    class PPTOptionObserver
    extends AbstractConfigurableOptionObserver {
        PPTOptionObserver() {
        }

        public IConfigurableOption[] getOptions() {
            return PPTEmitterDescriptor.this.options;
        }

        public IRenderOption getPreferredRenderOption() {
            PDFRenderOption renderOption = new PDFRenderOption();
            renderOption.setEmitterID(PPTEmitterDescriptor.this.getID());
            renderOption.setOutputFormat("ppt");
            if (this.values != null && this.values.length > 0) {
                IOptionValue[] iOptionValueArray = this.values;
                int n = this.values.length;
                int n2 = 0;
                while (n2 < n) {
                    IOptionValue optionValue = iOptionValueArray[n2];
                    if (optionValue != null) {
                        renderOption.setOption(PPTEmitterDescriptor.this.getRenderOptionName(optionValue.getName()), optionValue.getValue());
                    }
                    ++n2;
                }
            }
            return renderOption;
        }
    }
}

