/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.emitter.excel.BookmarkDef;
import org.eclipse.birt.report.engine.emitter.excel.SheetData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataCache {
    protected static Logger logger = Logger.getLogger(DataCache.class.getName());
    private List<ArrayList<SheetData>> columns = new ArrayList<ArrayList<SheetData>>();
    private int maxColumnCount;
    private int maxRowIndex = 0;
    private int offset = 0;
    private Map<Integer, Float> rowIndex2Height = new HashMap<Integer, Float>();

    public DataCache(DataCache cache) {
        int i = 0;
        while (i < cache.columns.size()) {
            this.columns.add(new ArrayList());
            ++i;
        }
        this.maxColumnCount = cache.maxColumnCount;
    }

    public DataCache(int offset, int maxColumnCount) {
        this.columns.add(new ArrayList());
        this.maxColumnCount = maxColumnCount;
    }

    public void insertColumns(int startColumn, int columnCount) {
        int startPosition;
        if (columnCount == 0) {
            return;
        }
        int i = startPosition = startColumn + 1;
        while (i <= startColumn + columnCount) {
            if (i < this.maxColumnCount) {
                this.columns.add(i, new ArrayList());
            }
            ++i;
        }
    }

    public void insertColumns(int columnCount) {
        if (columnCount == 0) {
            return;
        }
        int currentColumnCount = this.columns.size();
        int i = 0;
        while (i <= columnCount) {
            if (i + currentColumnCount < this.maxColumnCount) {
                this.columns.add(new ArrayList());
            }
            ++i;
        }
    }

    public void addData(int col, SheetData data) {
        if (col < this.getColumnCount()) {
            int rowIndex = data.getRowIndex();
            this.columns.get(col).add(data);
            this.maxRowIndex = this.maxRowIndex > rowIndex ? this.maxRowIndex : rowIndex;
            BookmarkDef bookmark = data.getBookmark();
            if (bookmark == null) {
                return;
            }
            bookmark.setColumnNo(col + 1);
            bookmark.setRowNo(rowIndex);
        }
    }

    public int getMaxRow() {
        return this.maxRowIndex;
    }

    protected boolean valid(int row, int col) {
        return col < this.getColumnCount();
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public int getMaxRowIndex(int column) {
        SheetData lastData = this.getColumnLastData(column);
        if (lastData != null) {
            return lastData.getRowIndex();
        }
        return 0;
    }

    public void setRowHeight(int rowIndex, float height) {
        if (!this.rowIndex2Height.containsKey(rowIndex) || height > this.rowIndex2Height.get(rowIndex).floatValue()) {
            this.rowIndex2Height.put(rowIndex, Float.valueOf(height));
        }
    }

    public float getRowHeight(int rowIndex) {
        if (this.rowIndex2Height.containsKey(rowIndex)) {
            return this.rowIndex2Height.get(rowIndex).floatValue();
        }
        return 0.0f;
    }

    public boolean hasRowHeight(int rowIndex) {
        return this.rowIndex2Height.containsKey(rowIndex) && this.rowIndex2Height.get(rowIndex).floatValue() != 0.0f;
    }

    public SheetData getColumnLastData(int index) {
        ArrayList<SheetData> columnDatas;
        if (index < this.getColumnCount() && !(columnDatas = this.columns.get(index)).isEmpty()) {
            return columnDatas.get(columnDatas.size() - 1);
        }
        return null;
    }

    public Iterator<SheetData[]> getRowIterator() {
        return this.getRowIterator(null, null);
    }

    public Iterator<SheetData[]> getRowIterator(DataFilter filter, RowIndexAdjuster rowIndexAdjuster) {
        return new DataCacheIterator(filter, rowIndexAdjuster);
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DataCacheIterator
    implements Iterator<SheetData[]> {
        private int[] columnIndexes;
        private int rowIndex = 1;
        private DataFilter dataFilter;
        private RowIndexAdjuster rowIndexAdjuster;

        public DataCacheIterator(DataFilter dataFilter, RowIndexAdjuster rowIndexAdjuster) {
            this.dataFilter = dataFilter;
            this.rowIndexAdjuster = rowIndexAdjuster;
            this.columnIndexes = new int[DataCache.this.columns.size()];
        }

        @Override
        public boolean hasNext() {
            return this.rowIndex <= DataCache.this.maxRowIndex;
        }

        @Override
        public SheetData[] next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            SheetData[] rowDatas = new SheetData[this.columnIndexes.length];
            int i = 0;
            while (i < this.columnIndexes.length) {
                ArrayList columnData = (ArrayList)DataCache.this.columns.get(i);
                int cursor = this.columnIndexes[i];
                int size = columnData.size();
                int j = cursor;
                while (j < size) {
                    SheetData data = (SheetData)columnData.get(j);
                    int dataRowIndex = this.getRowIndex(data);
                    if (dataRowIndex == this.rowIndex) {
                        if (this.dataFilter == null || this.dataFilter.accept(data)) {
                            rowDatas[i] = data;
                        }
                        this.columnIndexes[i] = j + 1;
                        break;
                    }
                    if (dataRowIndex > this.rowIndex) {
                        this.columnIndexes[i] = j;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            ++this.rowIndex;
            return rowDatas;
        }

        protected int getRowIndex(SheetData data) {
            if (this.rowIndexAdjuster != null) {
                return this.rowIndexAdjuster.getRowIndex(data);
            }
            return data.getRowIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface DataFilter {
        public boolean accept(SheetData var1);
    }

    public static interface RowIndexAdjuster {
        public int getRowIndex(SheetData var1);
    }
}

