/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel.layout;

import com.ibm.icu.util.ULocale;
import java.awt.Color;
import java.io.IOException;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.excel.BookmarkDef;
import org.eclipse.birt.report.engine.emitter.excel.Data;
import org.eclipse.birt.report.engine.emitter.excel.DataCache;
import org.eclipse.birt.report.engine.emitter.excel.DateTimeUtil;
import org.eclipse.birt.report.engine.emitter.excel.ExcelUtil;
import org.eclipse.birt.report.engine.emitter.excel.ExcelWriter;
import org.eclipse.birt.report.engine.emitter.excel.HyperlinkDef;
import org.eclipse.birt.report.engine.emitter.excel.IExcelWriter;
import org.eclipse.birt.report.engine.emitter.excel.ImageData;
import org.eclipse.birt.report.engine.emitter.excel.NumberFormatValue;
import org.eclipse.birt.report.engine.emitter.excel.RowData;
import org.eclipse.birt.report.engine.emitter.excel.SheetData;
import org.eclipse.birt.report.engine.emitter.excel.StyleBuilder;
import org.eclipse.birt.report.engine.emitter.excel.StyleConstant;
import org.eclipse.birt.report.engine.emitter.excel.StyleEngine;
import org.eclipse.birt.report.engine.emitter.excel.StyleEntry;
import org.eclipse.birt.report.engine.emitter.excel.layout.ColumnsInfo;
import org.eclipse.birt.report.engine.emitter.excel.layout.ContainerSizeInfo;
import org.eclipse.birt.report.engine.emitter.excel.layout.ExcelContext;
import org.eclipse.birt.report.engine.emitter.excel.layout.LayoutUtil;
import org.eclipse.birt.report.engine.emitter.excel.layout.Page;
import org.eclipse.birt.report.engine.emitter.excel.layout.XlsCell;
import org.eclipse.birt.report.engine.emitter.excel.layout.XlsContainer;
import org.eclipse.birt.report.engine.emitter.excel.layout.XlsTable;
import org.eclipse.birt.report.engine.i18n.EngineResourceHandle;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.layout.emitter.Image;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.presentation.ContentEmitterVisitor;
import org.eclipse.birt.report.engine.util.FlashFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelLayoutEngine {
    protected static Logger logger = Logger.getLogger(ExcelLayoutEngine.class.getName());
    public static final float DEFAULT_ROW_HEIGHT = 15.0f;
    private int autoBookmarkIndex = 0;
    public static final String AUTO_GENERATED_BOOKMARK = "auto_generated_bookmark_";
    public static final int MAX_ROW_OFFICE2007 = 0x100000;
    public static final int MAX_COL_OFFICE2007 = 16384;
    public static final int MAX_ROW_OFFICE2003 = 65535;
    public static final int MAX_COLUMN_OFFICE2003 = 255;
    protected int maxRow = 65535;
    protected int maxCol = 255;
    private HashMap<String, String> cachedBookmarks = new HashMap();
    protected StyleEngine engine;
    private Stack<XlsContainer> containers = new Stack();
    private Stack<XlsTable> tables = new Stack();
    protected ExcelContext context = null;
    private String messageFlashObjectNotSupported;
    private String messageReportItemNotSupported;
    private ULocale locale;
    private HashMap<String, BookmarkDef> bookmarks = new HashMap();
    protected Stack<Boolean> rowVisibilities = new Stack();
    protected Page page;
    protected IExcelWriter writer;
    protected ContentEmitterVisitor contentVisitor;
    protected boolean pageWidthApplied = false;

    public ExcelLayoutEngine(ExcelContext context, ContentEmitterVisitor contentVisitor) {
        this.context = context;
        this.locale = context.getLocale();
        EngineResourceHandle resourceHandle = new EngineResourceHandle(this.locale);
        this.messageFlashObjectNotSupported = resourceHandle.getMessage("Error.FlashObjectNotSupported");
        this.messageReportItemNotSupported = resourceHandle.getMessage("Error.ReportItemNotSupported");
        this.contentVisitor = contentVisitor;
    }

    protected void createWriter() {
        this.writer = new ExcelWriter(this.context);
    }

    public void initalize(IStyle style) {
        this.setCacheSize();
        this.engine = new StyleEngine(this);
        this.createWriter();
    }

    private void initializePage(IPageContent pageContent) {
        this.context.parsePageSize(pageContent);
        ContainerSizeInfo rule = new ContainerSizeInfo(0, this.context.getContentWidth());
        IStyle pageStyle = pageContent.getComputedStyle();
        this.containers.push(this.createContainer(rule, pageStyle, null));
    }

    protected void createPage(XlsContainer pageContainer) {
        this.page = new Page(this.context.getContentWidth(), this.engine, this.maxCol, this.context.getSheetName(), pageContainer);
        this.page.initalize();
        this.context.setPage(this.page);
    }

    private void setCacheSize() {
        if (this.context.getOfficeVersion().equals("office2007")) {
            this.maxCol = 16384;
        }
    }

    public void processForeign(IForeignContent foreign, HyperlinkDef link) throws BirtException {
        this.addForeignContainer(foreign.getComputedStyle(), link);
        this.contentVisitor.visitChildren((IContent)foreign, null);
        this.endContainer();
    }

    public XlsContainer getCurrentContainer() {
        return this.containers.peek();
    }

    public Stack<XlsContainer> getContainers() {
        return this.containers;
    }

    public void startPage(IPageContent pageContent) throws BirtException {
        if (this.page == null || this.context.isEnableMultipleSheet()) {
            this.initializePage(pageContent);
            this.newPage();
        }
        this.page.startPage(pageContent);
        XlsContainer topContainer = this.containers.peek();
        topContainer.setStyle(StyleBuilder.createStyleEntry(pageContent.getComputedStyle()));
        if (!this.page.isOutputInMasterPage() && pageContent.getPageHeader() != null) {
            this.contentVisitor.visitChildren(pageContent.getPageHeader(), null);
        }
    }

    private void newPage() {
        this.pageWidthApplied = false;
        this.createPage((XlsContainer)this.containers.get(0));
        for (XlsTable table : this.tables) {
            this.splitColumns(table.getColumnsInfo(), table.getParent().getSizeInfo());
        }
        this.resetContainers();
    }

    public void endPage(IPageContent pageContent) throws BirtException {
        Object pageLabelObj;
        IContent footer = pageContent.getPageFooter();
        if (!this.page.isOutputInMasterPage() && footer != null) {
            this.contentVisitor.visitChildren(footer, null);
        }
        if ((pageLabelObj = this.context.getReportContext().getPageVariable("pageLabel")) instanceof String) {
            String pageLabel = (String)pageLabelObj;
            pageLabel = ExcelUtil.getValidSheetName(pageLabel);
            this.page.setSheetName(pageLabel);
        }
        this.outputSheet(this.page);
        this.containers.clear();
        this.page = null;
    }

    public void startTable(ITableContent table) {
        XlsContainer currentContainer = this.getCurrentContainer();
        if (currentContainer == null) {
            this.addContainer(null);
            return;
        }
        ContainerSizeInfo sizeInfo = currentContainer.getSizeInfo();
        int width = sizeInfo.getWidth();
        ColumnsInfo info = null;
        int dpi = this.context.getDpi();
        if (this.context.isAutoLayout()) {
            info = LayoutUtil.createTable(table, width, dpi, this.autoExtend());
        } else {
            int[] columns = LayoutUtil.createFixedTable(table, LayoutUtil.getElementWidth((IContent)table, width, dpi), dpi);
            info = new ColumnsInfo(columns);
        }
        String caption = table.getCaption();
        if (caption != null) {
            this.addCaption(caption, table.getComputedStyle());
        }
        this.addTable((IContainerContent)table, info, sizeInfo);
    }

    private boolean autoExtend() {
        return this.isTop() && this.context.isAutoLayout();
    }

    protected boolean isTop() {
        return this.containers.size() == 1;
    }

    public void addTable(IContainerContent content, ColumnsInfo columns, ContainerSizeInfo size) {
        IStyle style = content.getComputedStyle();
        XlsContainer currentContainer = this.getCurrentContainer();
        if (currentContainer == null) {
            this.addContainer(null);
            this.tables.push(null);
            return;
        }
        if (!this.autoExtend()) {
            this.applyPageWidth();
        }
        ContainerSizeInfo parentSizeInfo = currentContainer.getSizeInfo();
        int[] columnStartCoordinates = this.splitColumns(columns, parentSizeInfo, this.autoExtend());
        this.createTable(columns, style, currentContainer, columnStartCoordinates, content.getBookmark());
    }

    protected int[] splitColumns(ColumnsInfo columnsInfo, ContainerSizeInfo parentSizeInfo) {
        return this.splitColumns(columnsInfo, parentSizeInfo, false);
    }

    protected int[] splitColumns(ColumnsInfo columnsInfo, ContainerSizeInfo parentSizeInfo, boolean autoExtend) {
        int startCoordinate = parentSizeInfo.getStartCoordinate();
        int endCoordinate = parentSizeInfo.getEndCoordinate();
        int[] columnStartCoordinates = this.calculateColumnCoordinates(columnsInfo, startCoordinate, endCoordinate, autoExtend);
        this.page.splitColumns(startCoordinate, endCoordinate, columnStartCoordinates, autoExtend);
        return columnStartCoordinates;
    }

    private boolean isRightAligned(XlsContainer currentContainer) {
        boolean isRightAligned = false;
        String align = (String)currentContainer.getStyle().getProperty(8);
        isRightAligned = "Right".equalsIgnoreCase(align);
        return isRightAligned;
    }

    private void createTable(ColumnsInfo tableInfo, IStyle style, XlsContainer currentContainer, int[] columnStartCoordinates, String bookmark) {
        int leftCordinate = columnStartCoordinates[0];
        int width = columnStartCoordinates[columnStartCoordinates.length - 1] - leftCordinate;
        ContainerSizeInfo sizeInfo = new ContainerSizeInfo(leftCordinate, width);
        StyleEntry styleEntry = this.engine.createEntry(sizeInfo, style, this.getParentStyle());
        XlsTable table = new XlsTable(tableInfo, styleEntry, sizeInfo, currentContainer);
        table.setBookmark(bookmark);
        this.tables.push(table);
        this.addContainer(table);
    }

    protected StyleEntry getParentStyle() {
        return this.getParentStyle(this.getCurrentContainer());
    }

    private int[] calculateColumnCoordinates(ColumnsInfo table, int startCoordinate, int endCoordinate, boolean autoExtend) {
        XlsContainer currentContainer = this.getCurrentContainer();
        if (table == null) {
            return new int[]{startCoordinate};
        }
        int columnCount = table.getColumnCount();
        int totalWidth = 0;
        int i = 0;
        while (i < columnCount) {
            totalWidth += table.getColumnWidth(i);
            ++i;
        }
        boolean overflow = totalWidth > endCoordinate - startCoordinate;
        int[] columnStartCoordinates = new int[columnCount + 1];
        if (!(!this.isRightAligned(currentContainer) || overflow && autoExtend)) {
            columnStartCoordinates[columnCount] = endCoordinate;
            int i2 = columnCount - 1;
            while (i2 >= 0) {
                columnStartCoordinates[i2] = Math.max(startCoordinate, columnStartCoordinates[i2 + 1] - table.getColumnWidth(i2));
                --i2;
            }
        } else {
            columnStartCoordinates[0] = startCoordinate;
            int i3 = 1;
            while (i3 <= columnCount) {
                columnStartCoordinates[i3] = !autoExtend && columnStartCoordinates[i3 - 1] + table.getColumnWidth(i3 - 1) > endCoordinate ? endCoordinate : columnStartCoordinates[i3 - 1] + table.getColumnWidth(i3 - 1);
                ++i3;
            }
        }
        return columnStartCoordinates;
    }

    public void addCell(int col, int colSpan, int rowSpan, IStyle style) {
        XlsTable table = this.tables.peek();
        ContainerSizeInfo cellSizeInfo = table.getColumnSizeInfo(col, colSpan);
        if (cellSizeInfo == null) {
            this.addContainer(null);
            return;
        }
        XlsCell cell = new XlsCell(this.engine.createEntry(cellSizeInfo, style, this.getParentStyle()), cellSizeInfo, this.getCurrentContainer(), rowSpan);
        this.addContainer(cell);
    }

    private boolean isHidden(IContent content) {
        IStyle style;
        return content != null && IStyle.NONE_VALUE.equals((style = content.getStyle()).getProperty(54));
    }

    public void addCell(ICellContent cellcontent, int col, int colSpan, int rowSpan, IStyle style) {
        if (!this.isHidden((IContent)cellcontent)) {
            this.rowVisibilities.pop();
            this.rowVisibilities.push(true);
            if (this.getCurrentContainer() == null) {
                this.addContainer(null);
                return;
            }
            XlsTable table = this.tables.peek();
            ContainerSizeInfo cellSizeInfo = table.getColumnSizeInfo(col, colSpan);
            if (cellSizeInfo == null) {
                this.addContainer(null);
                return;
            }
            int diagonalNumber = cellcontent.getDiagonalNumber();
            StyleEntry cellStyleEntry = null;
            if (diagonalNumber != 0) {
                String diagonalColor = cellcontent.getDiagonalColor();
                String diagonalStyle = cellcontent.getDiagonalStyle();
                int diagonalWidth = PropertyUtil.getDimensionValue((IContent)cellcontent, (DimensionType)cellcontent.getDiagonalWidth(), (int)cellSizeInfo.getWidth());
                cellStyleEntry = this.engine.createCellEntry(cellSizeInfo, style, diagonalColor, diagonalStyle, diagonalWidth, this.getParentStyle());
            } else {
                cellStyleEntry = this.engine.createEntry(cellSizeInfo, style, this.getParentStyle());
            }
            XlsCell cell = new XlsCell(cellStyleEntry, cellSizeInfo, this.getCurrentContainer(), rowSpan);
            this.addContainer(cell);
        }
    }

    public void endCell(ICellContent cell) {
        if (!this.isHidden((IContent)cell)) {
            this.endNormalContainer();
        }
    }

    public void addRow(IStyle style, String bookmark) {
        this.rowVisibilities.push(false);
        XlsContainer parent = this.getCurrentContainer();
        if (parent == null) {
            this.addContainer(null);
            return;
        }
        ContainerSizeInfo sizeInfo = parent.getSizeInfo();
        XlsContainer container = this.createContainer(sizeInfo, style, parent);
        container.setEmpty(false);
        container.setBookmark(bookmark);
        this.addContainer(container);
    }

    public void endRow(float rowHeight) {
        if (this.rowVisibilities.pop().booleanValue()) {
            XlsContainer rowContainer = this.getCurrentContainer();
            this.page.synchronize(rowHeight, rowContainer);
        }
        this.endContainer();
    }

    public void endTable(IContent content) {
        if (!this.tables.isEmpty()) {
            this.tables.pop();
            this.endContainer();
        }
    }

    public void addForeignContainer(IStyle style, HyperlinkDef link) {
        XlsContainer parent = this.getCurrentContainer();
        if (parent == null) {
            this.addContainer(null);
            return;
        }
        if (this.isTop()) {
            this.applyPageWidth();
        }
        ContainerSizeInfo sizeInfo = parent.getSizeInfo();
        StyleEntry entry = this.engine.createEntry(sizeInfo, style, this.getParentStyle(parent));
        this.addContainer(new XlsContainer(entry, sizeInfo, parent));
    }

    private StyleEntry getParentStyle(XlsContainer parent) {
        return parent == null ? null : parent.getStyle();
    }

    private void addContainer(XlsContainer child) {
        if (child != null) {
            XlsContainer parent = child.getParent();
            if (parent instanceof XlsCell) {
                this.page.addEmptyDataToContainer(child, parent);
            }
            if (parent != null) {
                parent.setEmpty(false);
            }
        }
        this.containers.push(child);
    }

    public void endListBandContainer() {
        XlsContainer container = this.getCurrentContainer();
        if (container != null) {
            if (!container.isEmpty()) {
                this.engine.applyContainerBottomStyle(container, this.page);
            }
            this.setParentContainerIndex();
        }
        this.containers.pop();
    }

    public void endContainer() {
        if (this.getCurrentContainer() == null) {
            this.containers.pop();
            return;
        }
        this.setParentContainerIndex();
        this.endNormalContainer();
    }

    private void setParentContainerIndex() {
        XlsContainer container = this.getCurrentContainer();
        XlsContainer parent = container.getParent();
        if (parent != null) {
            parent.setEndRow(container.getEndRow());
        }
    }

    public void endNormalContainer() {
        XlsContainer container = this.getCurrentContainer();
        if (container != null) {
            if (container.isEmpty()) {
                Data data = this.page.createEmptyData(container.getStyle());
                ContainerSizeInfo containerSize = container.getSizeInfo();
                data.setStartX(containerSize.getStartCoordinate());
                data.setEndX(containerSize.getEndCoordinate());
                this.addData(data, container);
                if (!(container instanceof XlsCell)) {
                    this.setParentContainerIndex();
                }
            }
            this.engine.applyContainerBottomStyle(container, this.page);
            this.createBookmark(container);
        }
        this.containers.pop();
    }

    private void createBookmark(XlsContainer container) {
        BookmarkDef bookmark = this.getBookmark(container.getBookmark());
        if (bookmark != null) {
            bookmark.setSheetName(this.context.getSheetName());
            bookmark.setStartRow(container.getStartRow() + 1);
            bookmark.setEndRow(container.getEndRow());
            ContainerSizeInfo size = container.getSizeInfo();
            bookmark.setStartColumn(size.getStartCoordinate());
            bookmark.setEndColumn(size.getEndCoordinate());
            this.page.addBookmark(bookmark);
        }
    }

    public Data addData(Object value, IStyle style, HyperlinkDef link, String bookmark, float height) {
        return this.addData(value, style, link, bookmark, null, height);
    }

    public Data addData(Object value, IStyle style, HyperlinkDef link, String bookmark, String locale, float height) {
        XlsContainer container = this.getCurrentContainer();
        if (container == null) {
            return null;
        }
        ContainerSizeInfo containerSize = container.getSizeInfo();
        StyleEntry entry = this.engine.getStyle(style, containerSize, this.getParentStyle(container));
        this.setDataType(entry, value, locale);
        this.setlinkStyle(entry, link);
        Data data = this.page.createData(value, entry);
        data.setHeight(height);
        data.setHyperlinkDef(link);
        data.setBookmark(this.getBookmark(bookmark));
        data.setStartX(containerSize.getStartCoordinate());
        data.setEndX(containerSize.getEndCoordinate());
        this.addData(data, container);
        return data;
    }

    protected void setlinkStyle(StyleEntry entry, HyperlinkDef link) {
        if (link != null) {
            Color color = link.getColor();
            if (color != null) {
                entry.setProperty(7, color);
            } else {
                entry.setProperty(7, StyleConstant.HYPERLINK_COLOR);
            }
            entry.setProperty(5, true);
            entry.setIsHyperlink(true);
        }
    }

    public void addImageData(IImageContent image, IStyle style, HyperlinkDef link, String bookmark) {
        int imageWidth;
        int imageHeight;
        XlsContainer container = this.getCurrentContainer();
        if (container == null) {
            return;
        }
        ContainerSizeInfo parentSizeInfo = container.getSizeInfo();
        int imageWidthDpi = this.context.getDpi();
        int imageHeightDpi = this.context.getDpi();
        byte[] imageData = null;
        try {
            Image imageInfo = EmitterUtil.parseImage((IImageContent)image, (int)image.getImageSource(), (String)image.getURI(), (String)image.getMIMEType(), (String)image.getExtension());
            imageData = imageInfo.getData();
            int[] imageSize = this.getImageSize(image, imageInfo, parentSizeInfo, imageWidthDpi, imageHeightDpi);
            imageHeight = imageSize[0];
            imageWidth = imageSize[1];
        }
        catch (IOException iOException) {
            imageHeight = LayoutUtil.getImageHeight(image.getHeight(), 0, imageHeightDpi);
            imageWidth = LayoutUtil.getImageWidth(image.getWidth(), parentSizeInfo.getWidth(), 0, imageWidthDpi);
        }
        ColumnsInfo imageColumnsInfo = LayoutUtil.createImage(imageWidth);
        int[] imageCoordinates = this.splitColumns(imageColumnsInfo, parentSizeInfo);
        ContainerSizeInfo imageSize = new ContainerSizeInfo(imageCoordinates[0], imageColumnsInfo.getTotalWidth());
        StyleEntry entry = this.engine.getStyle(style, imageSize, parentSizeInfo, this.getParentStyle(container));
        this.setlinkStyle(entry, link);
        SheetData data = this.createImageData(image, imageData, imageSize.getWidth(), imageHeight, entry, container);
        data.setHyperlinkDef(link);
        data.setBookmark(this.getBookmark(bookmark));
        data.setStartX(imageSize.getStartCoordinate());
        data.setEndX(imageSize.getEndCoordinate());
        this.addData(data, container);
    }

    private int[] getImageSize(IImageContent image, Image imageInfo, ContainerSizeInfo parentSizeInfo, int imageWidthDpi, int imageHeightDpi) {
        int imageWidth;
        float scale;
        int imageHeight;
        if (image.getWidth() == null && image.getHeight() == null) {
            int imageFileWidthDpi = imageInfo.getPhysicalWidthDpi() == -1 ? 0 : imageInfo.getPhysicalWidthDpi();
            int imageFileHeightDpi = imageInfo.getPhysicalHeightDpi() == -1 ? 0 : imageInfo.getPhysicalHeightDpi();
            imageWidthDpi = PropertyUtil.getImageDpi((IImageContent)image, (int)imageFileWidthDpi, (int)0);
            imageHeightDpi = PropertyUtil.getImageDpi((IImageContent)image, (int)imageFileHeightDpi, (int)0);
        }
        int imageInfoHeight = (int)((float)(imageInfo.getHeight() * 1000) * 72.0f / (float)imageHeightDpi);
        int imageInfoWidth = (int)((float)(imageInfo.getWidth() * 1000) * 72.0f / (float)imageWidthDpi);
        if (image.getWidth() == null && image.getHeight() != null) {
            imageHeight = LayoutUtil.getImageHeight(image.getHeight(), imageInfoHeight, imageHeightDpi);
            scale = (float)imageInfoHeight / (float)imageInfoWidth;
            imageWidth = (int)((float)imageHeight / scale);
        } else if (image.getHeight() == null && image.getWidth() != null) {
            imageWidth = LayoutUtil.getImageWidth(image.getWidth(), parentSizeInfo.getWidth(), imageInfoWidth, imageWidthDpi);
            scale = (float)imageInfoHeight / (float)imageInfoWidth;
            imageHeight = (int)((float)imageWidth * scale);
        } else {
            imageHeight = LayoutUtil.getImageHeight(image.getHeight(), imageInfoHeight, imageHeightDpi);
            imageWidth = LayoutUtil.getImageWidth(image.getWidth(), parentSizeInfo.getWidth(), imageInfoWidth, imageWidthDpi);
        }
        int[] imageSize = new int[]{imageHeight, imageWidth};
        return imageSize;
    }

    private SheetData createImageData(IImageContent image, byte[] imageData, int imageWidth, int imageHeight, StyleEntry entry, XlsContainer container) {
        int type = 5;
        entry.setProperty(25, type);
        String uri = image.getURI();
        String mimeType = image.getMIMEType();
        String extension = image.getExtension();
        String altText = image.getAltText();
        if (FlashFile.isFlash((String)mimeType, (String)uri, (String)extension)) {
            if (altText == null) {
                altText = this.messageFlashObjectNotSupported;
            }
            entry.setProperty(25, 2);
            return this.page.createData(altText, entry);
        }
        if (imageData != null) {
            return this.createData(image, imageData, imageWidth, imageHeight, entry, container, type);
        }
        if (altText == null) {
            altText = this.messageReportItemNotSupported;
        }
        entry.setProperty(25, 2);
        return this.page.createData(altText, entry);
    }

    protected SheetData createData(IImageContent image, byte[] data, int imageWidth, int imageHeight, StyleEntry entry, XlsContainer container, int type) {
        int styleId = this.engine.getStyleId(entry);
        ImageData imageData = new ImageData(image, data, imageWidth, imageHeight, styleId, type, container);
        return imageData;
    }

    public Data addDateTime(Object txt, IStyle style, HyperlinkDef link, String bookmark, String dateTimeLocale, float height) {
        XlsContainer currentContainer = this.getCurrentContainer();
        if (currentContainer == null) {
            return null;
        }
        ContainerSizeInfo containerSize = currentContainer.getSizeInfo();
        StyleEntry entry = this.engine.getStyle(style, containerSize, this.getParentStyle(currentContainer));
        this.setlinkStyle(entry, link);
        Data data = null;
        IDataContent dataContent = (IDataContent)txt;
        Object value = dataContent.getValue();
        Date date = ExcelUtil.getDate(value);
        if (date != null && (date instanceof Time || date.getYear() >= 0)) {
            data = this.createDateData(value, entry, style.getDateTimeFormat(), dateTimeLocale);
            data.setHeight(height);
            data.setBookmark(this.getBookmark(bookmark));
            data.setHyperlinkDef(link);
            data.setStartX(containerSize.getStartCoordinate());
            data.setEndX(containerSize.getEndCoordinate());
            this.addData(data, currentContainer);
            return data;
        }
        entry.setProperty(25, 2);
        return this.addData(dataContent.getText(), style, link, bookmark, dateTimeLocale, height);
    }

    public void addCaption(String text, IStyle style) {
        XlsContainer container = this.getCurrentContainer();
        if (container == null) {
            return;
        }
        ContainerSizeInfo containerSize = container.getSizeInfo();
        StyleEntry entry = StyleBuilder.createEmptyStyleEntry();
        entry.setProperty(8, "Center");
        entry.setProperty(1, Float.valueOf(StyleBuilder.convertFontSize(style.getProperty(44))));
        entry.setProperty(25, 2);
        Data data = this.page.createData(text, entry);
        data.setStartX(containerSize.getStartCoordinate());
        data.setEndX(containerSize.getEndCoordinate());
        this.addData(data, container);
    }

    public void addData(SheetData data, XlsContainer container) {
        if (this.getCurrentContainer() == null) {
            return;
        }
        if (this.isTop()) {
            this.applyPageWidth();
        }
        if (this.page.isValid(data)) {
            this.outputDataIfBufferIsFull();
            this.page.addData(data, container);
        }
    }

    protected void applyPageWidth() {
        if (!this.pageWidthApplied) {
            this.page.addPageCoordinate();
            this.pageWidthApplied = true;
        }
    }

    private void setDataType(StyleEntry entry, Object value, String dataLocale) {
        ULocale locale = this.getLocale(dataLocale);
        this.setDataType(entry, value, locale);
    }

    private void setDataType(StyleEntry entry, Object value, ULocale locale) {
        int type = 2;
        if (1 == ExcelUtil.getType(value)) {
            NumberFormatValue numberFormat = (NumberFormatValue)entry.getProperty(23);
            if (numberFormat != null) {
                String format = ExcelUtil.formatNumberPattern(numberFormat.getFormat(), locale);
                NumberFormatValue localizedFormat = null;
                localizedFormat = format != null && !format.equals(numberFormat.getFormat()) ? NumberFormatValue.getInstance(format) : numberFormat;
                entry.setProperty(23, localizedFormat);
            }
            type = 1;
        } else if (ExcelUtil.getType(value) == 0) {
            String format = ExcelUtil.getPattern(value, (String)entry.getProperty(22));
            entry.setProperty(22, format);
            type = 0;
        }
        entry.setProperty(25, type);
    }

    private Data createDateData(Object txt, StyleEntry entry, String timeFormat, String dlocale) {
        ULocale dateLocale = this.getLocale(dlocale);
        timeFormat = ExcelUtil.parse(txt, timeFormat, dateLocale);
        timeFormat = DateTimeUtil.formatDateTime(timeFormat, dateLocale);
        entry.setProperty(22, timeFormat);
        entry.setProperty(25, 0);
        return this.page.createData(txt, entry);
    }

    private ULocale getLocale(String dlocale) {
        return dlocale == null ? this.locale : new ULocale(dlocale);
    }

    private void outputDataIfBufferIsFull() {
        if (this.getCurrentContainer().getEndRow() >= this.maxRow) {
            Page lastPage = this.page;
            this.outputSheet(this.page);
            this.newPage();
            this.page.startPage(lastPage);
            this.page.setHeader(null);
        }
    }

    public void outputSheet(Page page) {
        page.finish();
        try {
            this.outputCacheData(page);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        this.context.setSheetIndex(this.context.getSheetIndex() + 1);
    }

    private XlsContainer createContainer(ContainerSizeInfo sizeInfo, IStyle style, XlsContainer parent) {
        return new XlsContainer(this.engine.createEntry(sizeInfo, style, this.getParentStyle(parent)), sizeInfo, parent);
    }

    public Map<StyleEntry, Integer> getStyleMap() {
        return this.engine.getStyleIDMap();
    }

    public StyleEntry getStyle(int styleId) {
        return this.engine.getStyle(styleId);
    }

    public Page getPage() {
        return this.page;
    }

    public void end(IReportContent report) {
        try {
            this.writer.start(report, this.getStyleMap(), this.getAllBookmarks());
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public void endWriter() {
        try {
            this.writer.end();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    protected void outputRowData(Page page, RowData rowData) throws IOException {
        this.writer.startRow(rowData.getHeight());
        SheetData[] datas = rowData.getRowdata();
        int i = 0;
        while (i < datas.length) {
            SheetData data = datas[i];
            int start = page.getStartColumn(data);
            int end = page.getEndColumn(data);
            int span = Math.max(0, end - start - 1);
            this.outputData(page, data, start, span);
            ++i;
        }
        this.writer.endRow();
    }

    protected void outputData(Page page, SheetData data, int start, int span) throws IOException {
        this.writer.outputData(data, this.engine.getStyle(data.getStyleId()), start, span);
    }

    public void complete(Page page) {
        XlsContainer pageContainer = page.getPageContainer();
        this.engine.applyContainerBottomStyle(pageContainer, page);
        Iterator<SheetData[]> iterator = page.getRowIterator();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                SheetData[] rowData = iterator.next();
                int j = 0;
                while (j < rowData.length) {
                    HyperlinkDef hyperLink;
                    SheetData data = rowData[j];
                    if (data != null && !data.isBlank() && (hyperLink = data.getHyperlinkDef()) != null && hyperLink.getType() == 2) {
                        this.setLinkedBookmark(data, hyperLink);
                    }
                    ++j;
                }
                page.calculateRowHeight(rowData, this.context.isRTL());
            }
        } else {
            ContainerSizeInfo containerSize = pageContainer.getSizeInfo();
            page.addEmptyDataToContainer(pageContainer.getStyle(), pageContainer, containerSize.getStartCoordinate(), containerSize.getWidth());
        }
    }

    public void outputCacheData(Page page) throws IOException {
        this.complete(page);
        ExcelLayoutEngineIterator it = this.getIterator(page);
        if (it.hasNext()) {
            double[] coordinates = page.getCoordinates();
            this.writer.startSheet(coordinates, page.getHeader(), page.getFooter(), page.getSheetName());
            while (it.hasNext()) {
                this.outputRowData(page, (RowData)it.next());
            }
            this.writer.endSheet(coordinates, page.getOrientation(), this.context.getPageWidth(), this.context.getPageHeight(), this.context.getLeftMargin(), this.context.getRightMargin(), this.context.getTopMargin(), this.context.getBottomMargin());
        }
    }

    private void setLinkedBookmark(SheetData data, HyperlinkDef hyperLink) {
        String bookmarkName = hyperLink.getUrl();
        BookmarkDef linkedBookmark = this.bookmarks.get(bookmarkName);
        if (linkedBookmark != null) {
            data.setLinkedBookmark(linkedBookmark);
        } else {
            BookmarkDef newBookmark;
            if (ExcelUtil.isValidBookmarkName(bookmarkName)) {
                newBookmark = new BookmarkDef(bookmarkName);
            } else {
                String generateBookmarkName = this.getGenerateBookmark(bookmarkName);
                newBookmark = new BookmarkDef(generateBookmarkName);
                this.cachedBookmarks.put(bookmarkName, generateBookmarkName);
            }
            data.setLinkedBookmark(newBookmark);
        }
    }

    public Stack<XlsTable> getTable() {
        return this.tables;
    }

    public void addContainerStyle(IStyle computedStyle) {
        this.engine.addContainderStyle(computedStyle, this.getParentStyle());
    }

    public void removeContainerStyle() {
        this.engine.removeForeignContainerStyle();
    }

    public void resetContainers() {
        for (XlsContainer container : this.containers) {
            container.setEndRow(0);
            container.setStartRow(0);
        }
        for (XlsTable table : this.tables) {
            table.setEndRow(0);
        }
    }

    public ExcelLayoutEngineIterator getIterator(Page page) {
        return this.getIterator(page, null, null);
    }

    public ExcelLayoutEngineIterator getIterator(Page page, DataCache.DataFilter filter, DataCache.RowIndexAdjuster rowIndexAdjuster) {
        return new ExcelLayoutEngineIterator(page, filter, rowIndexAdjuster);
    }

    public HashMap<String, BookmarkDef> getAllBookmarks() {
        return this.bookmarks;
    }

    public String getGenerateBookmark(String bookmarkName) {
        String generatedName = this.cachedBookmarks.get(bookmarkName);
        return generatedName != null ? generatedName : AUTO_GENERATED_BOOKMARK + this.autoBookmarkIndex++;
    }

    public boolean isContainerVisible() {
        return this.getCurrentContainer() != null;
    }

    protected BookmarkDef getBookmark(String bookmarkName) {
        if (bookmarkName == null) {
            return null;
        }
        if (this.bookmarks.containsKey(bookmarkName)) {
            return null;
        }
        BookmarkDef bookmark = new BookmarkDef(bookmarkName);
        if (!ExcelUtil.isValidBookmarkName(bookmarkName)) {
            bookmark.setGeneratedName(this.getGenerateBookmark(bookmarkName));
        }
        this.bookmarks.put(bookmarkName, bookmark);
        return bookmark;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExcelLayoutEngineIterator
    implements Iterator<RowData> {
        private Iterator<SheetData[]> rowIterator;
        private Page page;

        public ExcelLayoutEngineIterator(Page page, DataCache.DataFilter filter, DataCache.RowIndexAdjuster rowIndexAdjuster) {
            this.page = page;
            this.rowIterator = page.getRowIterator(filter, rowIndexAdjuster);
        }

        @Override
        public boolean hasNext() {
            return this.rowIterator.hasNext();
        }

        @Override
        public RowData next() {
            SheetData[] row = this.rowIterator.next();
            ArrayList<SheetData> data = new ArrayList<SheetData>();
            int width = Math.min(row.length, ExcelLayoutEngine.this.maxCol - 1);
            int rowIndex = 0;
            int i = 0;
            while (i < width) {
                SheetData d = row[i];
                if (d != null && !d.isBlank()) {
                    rowIndex = d.getRowIndex();
                    data.add(row[i]);
                }
                ++i;
            }
            SheetData[] rowdata = new SheetData[data.size()];
            double rowHeight = this.page.getRowHeight(rowIndex - 1);
            data.toArray(rowdata);
            return new RowData(this.page, rowdata, rowHeight);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

