/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.wpml;

import java.util.Stack;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.css.dom.CompositeStyle;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.emitter.wpml.AbstractEmitterImpl;
import org.eclipse.birt.report.engine.emitter.wpml.WordUtil;
import org.eclipse.birt.report.engine.emitter.wpml.writer.DocWriter;
import org.eclipse.birt.report.engine.layout.pdf.util.HTML2Content;
import org.eclipse.birt.report.engine.presentation.ContentEmitterVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocEmitterImpl
extends AbstractEmitterImpl {
    private static final String OUTPUT_FORMAT = "doc";
    private Stack<IStyle> inlineStyles = new Stack();
    private boolean inForeign = false;
    private boolean hasPInside = false;

    public DocEmitterImpl(ContentEmitterVisitor contentVisitor) {
        this.contentVisitor = contentVisitor;
    }

    @Override
    public void initialize(IEmitterServices service) throws EngineException {
        super.initialize(service);
        this.wordWriter = new DocWriter(this.out);
    }

    @Override
    public String getOutputFormat() {
        return OUTPUT_FORMAT;
    }

    @Override
    public void endContainer(IContainerContent container) {
        boolean flag = this.hasForeignParent(container);
        if (flag) {
            if (!"inline".equalsIgnoreCase(container.getComputedStyle().getDisplay())) {
                this.adjustInline();
            }
            if (!this.styles.isEmpty()) {
                this.styles.pop();
            }
            if (!this.inlineStyles.isEmpty()) {
                this.inlineStyles.pop();
            }
            if (!"inline".equalsIgnoreCase(container.getComputedStyle().getDisplay())) {
                if (this.inForeign && this.hasPInside) {
                    this.context.addContainer(false);
                    this.hasPInside = false;
                } else if (!this.inForeign) {
                    this.context.addContainer(true);
                }
                this.context.setLastIsTable(true);
            }
        }
    }

    @Override
    public void startContainer(IContainerContent container) {
        boolean flag = this.hasForeignParent(container);
        if (flag) {
            if (!"inline".equalsIgnoreCase(container.getComputedStyle().getDisplay())) {
                this.adjustInline();
            }
            if (!"inline".equalsIgnoreCase(container.getComputedStyle().getDisplay())) {
                this.styles.push(container.getComputedStyle());
            } else {
                this.inlineStyles.push(container.getComputedStyle());
            }
        }
    }

    private boolean hasForeignParent(IContainerContent container) {
        IContainerContent con = container;
        while (con != null) {
            if (con.getParent() instanceof IForeignContent) {
                return true;
            }
            con = (IContainerContent)con.getParent();
        }
        return false;
    }

    @Override
    public void endTable(ITableContent table) {
        this.hasPInside = false;
        this.endTable();
        this.decreaseTOCLevel((IContent)table);
    }

    @Override
    public void startForeign(IForeignContent foreign) throws BirtException {
        if ("text/html".equalsIgnoreCase(foreign.getRawType())) {
            boolean inlineBrother;
            this.inForeign = true;
            boolean bl = inlineBrother = !this.context.isFirstInline();
            if (!"inline".equalsIgnoreCase(foreign.getComputedStyle().getDisplay())) {
                this.adjustInline();
                inlineBrother = false;
            } else {
                this.context.endInline();
            }
            HTML2Content.html2Content((IForeignContent)foreign);
            this.context.startCell();
            int width = WordUtil.convertTo(foreign.getWidth(), this.context.getCurrentWidth(), this.reportDpi);
            width = Math.min(width, this.context.getCurrentWidth());
            this.wordWriter.startTable(foreign.getComputedStyle(), width, this.inForeign);
            this.wordWriter.startTableRow(-1.0);
            this.wordWriter.startTableCell(width, foreign.getComputedStyle(), null);
            this.writeToc((IContent)foreign);
            this.contentVisitor.visitChildren((IContent)foreign, null);
            this.adjustInline();
            this.wordWriter.endTableCell(this.context.needEmptyP());
            this.context.endCell();
            this.wordWriter.endTableRow();
            this.wordWriter.endTable();
            this.context.setLastIsTable(true);
            this.context.addContainer(true);
            this.hasPInside = false;
            if (inlineBrother) {
                this.context.startInline();
            }
            this.inForeign = false;
        } else {
            Object rawValue = foreign.getRawValue();
            String text = rawValue == null ? "" : rawValue.toString();
            this.writeContent(-1, text, (IContent)foreign);
        }
    }

    @Override
    protected void writeContent(int type, String txt, IContent content) {
        if (this.inForeign) {
            this.hasPInside = true;
        }
        this.context.addContainer(false);
        AbstractEmitterImpl.InlineFlag inlineFlag = AbstractEmitterImpl.InlineFlag.BLOCK;
        IStyle computedStyle = content.getComputedStyle();
        IStyle inlineStyle = null;
        if ("inline".equalsIgnoreCase(content.getComputedStyle().getDisplay())) {
            if (this.context.isFirstInline()) {
                this.context.startInline();
                inlineFlag = AbstractEmitterImpl.InlineFlag.FIRST_INLINE;
                if (!this.styles.isEmpty()) {
                    computedStyle = new CompositeStyle((IStyle)this.styles.peek(), content.getStyle());
                }
            } else {
                inlineFlag = AbstractEmitterImpl.InlineFlag.MIDDLE_INLINE;
            }
            if (!this.inlineStyles.isEmpty()) {
                inlineStyle = this.mergeStyles(this.inlineStyles);
            }
        } else {
            this.adjustInline();
        }
        this.writeBookmark(content);
        this.writeToc(content, inlineFlag == AbstractEmitterImpl.InlineFlag.MIDDLE_INLINE);
        this.writeText(type, txt, content, inlineFlag, computedStyle, inlineStyle);
        this.context.setLastIsTable(false);
    }

    private IStyle mergeStyles(Stack<IStyle> inlineStyles) {
        IStyle style = inlineStyles.peek();
        int i = 0;
        while (i < 59) {
            if (this.isNullValue(style.getProperty(i))) {
                style.setProperty(i, null);
                int p = inlineStyles.size() - 1;
                while (p >= 0) {
                    IStyle pstyle = (IStyle)inlineStyles.get(p);
                    if (!this.isNullValue(pstyle.getProperty(i))) {
                        style.setProperty(i, pstyle.getProperty(i));
                        break;
                    }
                    --p;
                }
            }
            ++i;
        }
        return style;
    }
}

