/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.odf.pkg;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.ArchiveWriter;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.report.engine.odf.pkg.PackageEntry;
import org.eclipse.birt.report.engine.odf.writer.ManifestWriter;

public class Package {
    private static Logger logger = Logger.getLogger(Package.class.getName());
    private static final String MANIFEST_URI = "META-INF/manifest.xml";
    private static final String MIME_URI = "mimetype";
    private static String tempFileName;
    private Map<String, PackageEntry> entries;
    private ArchiveWriter archiveWriter;
    private ZipOutputStream zipStream;
    private boolean hasEntryWriter;
    private boolean closed = false;
    private String rootMime;

    public static Package createInstance(OutputStream out, String tempFileDir, String rootMime) {
        String name = "/BIRT_ODF_Temp_" + System.currentTimeMillis() + new Random().nextInt(1000);
        tempFileName = String.valueOf(tempFileDir) + name;
        try {
            ArchiveFile archive = new ArchiveFile(tempFileName, "rw");
            archive.setCacheSize(4096L);
            return new Package(archive, out, rootMime);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
            return null;
        }
    }

    private Package(ArchiveFile archive, OutputStream out, String rootMime) throws IOException {
        this.rootMime = rootMime;
        this.closed = false;
        this.archiveWriter = new ArchiveWriter((IArchiveFile)archive);
        this.entries = new HashMap<String, PackageEntry>();
        this.zipStream = new ZipOutputStream(out);
    }

    OutputStream getCachedOutputStream(String uri) throws IOException {
        this.assertOpen();
        return this.archiveWriter.getOutputStream(uri);
    }

    OutputStream getEntryOutputStream(String uri) throws IOException {
        this.assertOpen();
        return new EntryOutputStream(uri);
    }

    public PackageEntry addEntry(String uri, String contentType) {
        PackageEntry entry = new PackageEntry(this, uri, contentType, false);
        this.entries.put(uri, entry);
        return entry;
    }

    void addEntry(PackageEntry entry) {
        this.entries.put(entry.getUri(), entry);
    }

    public PackageEntry addCachedEntry(String uri, String contentType) {
        PackageEntry entry = new PackageEntry(this, uri, contentType, true);
        this.entries.put(uri, entry);
        return entry;
    }

    public void close() throws IOException {
        try {
            this.save();
            this.writeMimeFile();
            this.writeManifest();
        }
        finally {
            this.zipStream.flush();
            this.zipStream.close();
        }
        this.closed = true;
    }

    private void save() throws IOException {
        for (PackageEntry entry : this.entries.values()) {
            if (!entry.isCached()) continue;
            String uri = entry.getUri();
            InputStream input = null;
            try {
                if (uri.startsWith("/")) {
                    uri = uri.substring(1);
                }
                input = this.archiveWriter.getInputStream(entry.getUri());
                this.zipStream.putNextEntry(new ZipEntry(uri));
                int length = -1;
                byte[] buf = new byte[4096];
                while ((length = input.read(buf)) != -1) {
                    this.zipStream.write(buf, 0, length);
                }
                this.zipStream.closeEntry();
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
    }

    private void writeMimeFile() throws IOException {
        this.zipStream.putNextEntry(new ZipEntry(MIME_URI));
        this.zipStream.write(this.rootMime.getBytes());
        this.zipStream.closeEntry();
    }

    private void writeManifest() throws IOException {
        this.zipStream.putNextEntry(new ZipEntry(MANIFEST_URI));
        ManifestWriter writer = new ManifestWriter(this.zipStream);
        writer.start(this.rootMime);
        for (PackageEntry entry : this.entries.values()) {
            writer.writeEntry(entry);
        }
        writer.end();
        this.zipStream.closeEntry();
    }

    private void assertOpen() {
        if (this.closed) {
            throw new IllegalStateException("Package is already closed");
        }
    }

    private class EntryOutputStream
    extends FilterOutputStream {
        public EntryOutputStream(String entry) throws IOException {
            super(Package.this.zipStream);
            if (Package.this.hasEntryWriter) {
                throw new RuntimeException("Can't open more than one entry writers concurrently.");
            }
            Package.this.hasEntryWriter = true;
            Package.this.zipStream.putNextEntry(new ZipEntry(entry));
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            Package.this.zipStream.write(b, off, len);
        }

        @Override
        public void close() {
            Package.this.hasEntryWriter = false;
            try {
                Package.this.zipStream.flush();
                Package.this.zipStream.closeEntry();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        }
    }
}

