/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.content.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.impl.AbstractContent;
import org.eclipse.birt.report.engine.css.dom.CellComputedStyle;
import org.eclipse.birt.report.engine.css.dom.ComputedStyle;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.Expression;

public class CellContent
extends AbstractContent
implements ICellContent {
    protected int rowSpan = -1;
    protected int colSpan = -1;
    protected int column = -1;
    protected Boolean displayGroupIcon;
    protected boolean repeatContent = false;
    CellDesign cellDesign = null;
    private String headers;
    private String scope;
    private String drop;
    private Boolean hasDiagonalLine = null;
    private int diagonalNumber = -1;
    private String diagonalStyle = null;
    private DimensionType diagonalWidth = null;
    private String diagonalColor = null;
    private int antidiagonalNumber = -1;
    private String antidiagonalStyle = null;
    private DimensionType antidiagonalWidth = null;
    private String antidiagonalColor = null;
    protected static final short FIELD_ROW_SPAN = 100;
    protected static final short FIELD_COL_SPAN = 101;
    protected static final short FIELD_COLUMN = 102;
    protected static final short FIELD_START_OF_GROUP = 103;
    protected static final short FIELD_DISPLAY_GROUP_ICON = 104;
    protected static final short FIELD_DROP = 111;
    protected static final short FIELD_HEADERS = 112;
    protected static final short FIELD_SCOPE = 113;
    protected static final short FIELD_REPEAT_CONTENT = 114;
    protected static final short FIELD_DIAGONAL_NUMBER = 115;
    protected static final short FIELD_DIAGONAL_STYLE = 116;
    protected static final short FIELD_DIAGONAL_WIDTH = 117;
    protected static final short FIELD_DIAGONAL_COLOR = 118;
    protected static final short FIELD_ANTIDIAGONAL_NUMBER = 119;
    protected static final short FIELD_ANTIDIAGONAL_STYLE = 120;
    protected static final short FIELD_ANTIDIAGONAL_WIDTH = 121;
    protected static final short FIELD_ANTIDIAGONAL_COLOR = 122;
    private IColumn columnInstance;

    public int getContentType() {
        return 1;
    }

    CellContent(IReportContent report) {
        super(report);
    }

    CellContent(ICellContent cell) {
        super(cell);
        this.colSpan = cell.getColSpan();
        this.rowSpan = cell.getRowSpan();
        this.column = cell.getColumn();
        this.displayGroupIcon = cell.getDisplayGroupIcon();
        this.columnInstance = cell.getColumnInstance();
        if (this.generateBy instanceof CellDesign) {
            this.cellDesign = (CellDesign)this.generateBy;
        }
    }

    public void setGenerateBy(Object generateBy) {
        super.setGenerateBy(generateBy);
        if (generateBy instanceof CellDesign) {
            this.cellDesign = (CellDesign)generateBy;
        }
    }

    public int getRowSpan() {
        if (this.rowSpan == -1 && this.cellDesign != null) {
            this.rowSpan = this.cellDesign.getRowSpan();
        }
        return this.rowSpan;
    }

    public int getColSpan() {
        if (this.colSpan == -1 && this.cellDesign != null) {
            this.colSpan = this.cellDesign.getColSpan();
        }
        return this.colSpan;
    }

    public int getColumn() {
        if (this.column == -1 && this.cellDesign != null) {
            this.column = this.cellDesign.getColumn();
        }
        return this.column;
    }

    public int getRow() {
        if (this.parent != null && this.parent instanceof IRowContent) {
            return ((IRowContent)this.parent).getRowID();
        }
        return 0;
    }

    public void setDrop(String drop) {
        this.drop = drop;
    }

    public Object accept(IContentVisitor visitor, Object value) throws BirtException {
        return visitor.visitCell(this, value);
    }

    public void setRowSpan(int rowSpan) {
        this.rowSpan = rowSpan;
    }

    public void setColSpan(int colSpan) {
        this.colSpan = colSpan;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public IStyle getComputedStyle() {
        if (this.computedStyle == null) {
            if (this.inlineStyle == null || this.inlineStyle.isEmpty()) {
                ComputedStyle pcs;
                ComputedStyle cs;
                String columnStyleClass;
                IColumn tblColumn;
                String cacheKey = this.getStyleClass();
                ITableContent table = ((IRowContent)this.parent).getTable();
                int column = this.getColumn();
                if (column >= 0 && column < table.getColumnCount() && (tblColumn = table.getColumn(column)) != null && (columnStyleClass = tblColumn.getStyleClass()) != null) {
                    cacheKey = String.valueOf(cacheKey) + columnStyleClass;
                }
                if ((cs = (pcs = (ComputedStyle)((IContent)this.parent).getComputedStyle()).getCachedStyle(cacheKey)) == null) {
                    cs = new CellComputedStyle(this);
                    pcs.addCachedStyle(cacheKey, cs);
                }
                this.computedStyle = cs;
            } else {
                this.computedStyle = new CellComputedStyle(this);
            }
        }
        return this.computedStyle;
    }

    protected void writeFields(DataOutputStream out) throws IOException {
        super.writeFields(out);
        if (this.rowSpan != -1) {
            IOUtil.writeShort((OutputStream)out, (short)100);
            IOUtil.writeInt((OutputStream)out, (int)this.rowSpan);
        }
        if (this.colSpan != -1) {
            IOUtil.writeShort((OutputStream)out, (short)101);
            IOUtil.writeInt((OutputStream)out, (int)this.colSpan);
        }
        if (this.column != -1) {
            IOUtil.writeShort((OutputStream)out, (short)102);
            IOUtil.writeInt((OutputStream)out, (int)this.column);
        }
        if (this.displayGroupIcon != null) {
            IOUtil.writeShort((OutputStream)out, (short)104);
            IOUtil.writeBool((OutputStream)out, (boolean)this.displayGroupIcon);
        }
        if (this.drop != null) {
            IOUtil.writeShort((OutputStream)out, (short)111);
            IOUtil.writeString((DataOutputStream)out, (String)this.drop);
        }
        if (this.headers != null) {
            IOUtil.writeShort((OutputStream)out, (short)112);
            IOUtil.writeString((DataOutputStream)out, (String)this.headers);
        }
        if (this.scope != null) {
            IOUtil.writeShort((OutputStream)out, (short)113);
            IOUtil.writeString((DataOutputStream)out, (String)this.scope);
        }
        if (this.repeatContent) {
            IOUtil.writeShort((OutputStream)out, (short)114);
            IOUtil.writeBool((OutputStream)out, (boolean)true);
        }
        if (this.diagonalNumber > 0) {
            IOUtil.writeShort((OutputStream)out, (short)115);
            IOUtil.writeInt((OutputStream)out, (int)this.diagonalNumber);
            if (this.diagonalStyle != null) {
                IOUtil.writeShort((OutputStream)out, (short)116);
                IOUtil.writeString((DataOutputStream)out, (String)this.diagonalStyle);
            }
            if (this.diagonalWidth != null) {
                IOUtil.writeShort((OutputStream)out, (short)117);
                this.diagonalWidth.writeObject(out);
            }
            if (this.diagonalColor != null) {
                IOUtil.writeShort((OutputStream)out, (short)118);
                IOUtil.writeString((DataOutputStream)out, (String)this.diagonalColor);
            }
        }
        if (this.antidiagonalNumber > 0) {
            IOUtil.writeShort((OutputStream)out, (short)119);
            IOUtil.writeInt((OutputStream)out, (int)this.antidiagonalNumber);
            if (this.antidiagonalStyle != null) {
                IOUtil.writeShort((OutputStream)out, (short)120);
                IOUtil.writeString((DataOutputStream)out, (String)this.antidiagonalStyle);
            }
            if (this.antidiagonalWidth != null) {
                IOUtil.writeShort((OutputStream)out, (short)121);
                this.antidiagonalWidth.writeObject(out);
            }
            if (this.antidiagonalColor != null) {
                IOUtil.writeShort((OutputStream)out, (short)122);
                IOUtil.writeString((DataOutputStream)out, (String)this.antidiagonalColor);
            }
        }
    }

    protected void readField(int version, int filedId, DataInputStream in, ClassLoader loader) throws IOException {
        switch (filedId) {
            case 100: {
                this.rowSpan = IOUtil.readInt((InputStream)in);
                break;
            }
            case 101: {
                this.colSpan = IOUtil.readInt((InputStream)in);
                break;
            }
            case 102: {
                this.column = IOUtil.readInt((InputStream)in);
                break;
            }
            case 103: {
                IOUtil.readBool((InputStream)in);
                break;
            }
            case 104: {
                this.displayGroupIcon = IOUtil.readBool((InputStream)in);
                break;
            }
            case 111: {
                this.drop = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 112: {
                this.headers = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 113: {
                this.scope = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 114: {
                this.repeatContent = IOUtil.readBool((InputStream)in);
                break;
            }
            case 115: {
                this.diagonalNumber = IOUtil.readInt((InputStream)in);
                break;
            }
            case 116: {
                this.diagonalStyle = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 117: {
                this.diagonalWidth = new DimensionType();
                this.diagonalWidth.readObject(in);
                break;
            }
            case 118: {
                this.diagonalColor = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 119: {
                this.antidiagonalNumber = IOUtil.readInt((InputStream)in);
                break;
            }
            case 120: {
                this.antidiagonalStyle = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 121: {
                this.antidiagonalWidth = new DimensionType();
                this.antidiagonalWidth.readObject(in);
                break;
            }
            case 122: {
                this.antidiagonalColor = IOUtil.readString((DataInputStream)in);
                break;
            }
            default: {
                super.readField(version, filedId, in, loader);
            }
        }
    }

    public boolean needSave() {
        if (this.rowSpan != -1 || this.colSpan != -1 || this.column != -1) {
            return true;
        }
        if (this.displayGroupIcon != null || this.headers != null || this.scope != null) {
            return true;
        }
        if (this.diagonalNumber > 0 || this.antidiagonalNumber > 0) {
            return true;
        }
        return super.needSave();
    }

    public boolean getDisplayGroupIcon() {
        if (this.displayGroupIcon == null) {
            if (this.cellDesign != null) {
                return this.cellDesign.getDisplayGroupIcon();
            }
            return false;
        }
        return this.displayGroupIcon;
    }

    public void setDisplayGroupIcon(boolean displayGroupIcon) {
        this.displayGroupIcon = displayGroupIcon;
    }

    public IColumn getColumnInstance() {
        int columnId;
        IRowContent row;
        ITableContent table;
        if (this.columnInstance != null) {
            return this.columnInstance;
        }
        if (this.parent instanceof IRowContent && (table = (row = (IRowContent)this.parent).getTable()) != null && (columnId = this.getColumn()) >= 0 && columnId < table.getColumnCount()) {
            this.columnInstance = table.getColumn(columnId);
        }
        return this.columnInstance;
    }

    protected IContent cloneContent() {
        return new CellContent(this);
    }

    public boolean hasDiagonalLine() {
        if (this.hasDiagonalLine != null) {
            return this.hasDiagonalLine;
        }
        if (this.cellDesign != null) {
            return this.cellDesign.hasDiagonalLine();
        }
        return false;
    }

    public void setDiagonalNumber(int diagonalNumber) {
        this.diagonalNumber = diagonalNumber;
        this.hasDiagonalLine = this.getDiagonalNumber() > 0 || this.getAntidiagonalNumber() > 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    public int getDiagonalNumber() {
        if (this.diagonalNumber >= 0) {
            return this.diagonalNumber;
        }
        if (this.cellDesign != null) {
            return this.cellDesign.getDiagonalNumber();
        }
        return 0;
    }

    public void setDiagonalStyle(String diagonalStyle) {
        this.diagonalStyle = diagonalStyle;
    }

    public String getDiagonalStyle() {
        if (this.diagonalStyle != null) {
            return this.diagonalStyle;
        }
        if (this.cellDesign != null) {
            return this.cellDesign.getDiagonalStyle();
        }
        return null;
    }

    public void setDiagonalWidth(DimensionType diagonalWidth) {
        this.diagonalWidth = diagonalWidth;
    }

    public DimensionType getDiagonalWidth() {
        if (this.diagonalWidth != null) {
            return this.diagonalWidth;
        }
        if (this.cellDesign != null) {
            return this.cellDesign.getDiagonalWidth();
        }
        return null;
    }

    public void setDiagonalColor(String diagonalColor) {
        this.diagonalColor = diagonalColor;
    }

    public String getDiagonalColor() {
        if (this.diagonalColor != null) {
            return this.diagonalColor;
        }
        if (this.cellDesign != null) {
            return this.cellDesign.getDiagonalColor();
        }
        return null;
    }

    public void setAntidiagonalNumber(int antidiagonalNumber) {
        this.antidiagonalNumber = antidiagonalNumber;
        this.hasDiagonalLine = this.getDiagonalNumber() > 0 || this.getAntidiagonalNumber() > 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    public int getAntidiagonalNumber() {
        if (this.antidiagonalNumber >= 0) {
            return this.antidiagonalNumber;
        }
        if (this.cellDesign != null) {
            return this.cellDesign.getAntidiagonalNumber();
        }
        return 0;
    }

    public void setAntidiagonalStyle(String antidiagonalStyle) {
        this.antidiagonalStyle = antidiagonalStyle;
    }

    public String getAntidiagonalStyle() {
        if (this.antidiagonalStyle != null) {
            return this.antidiagonalStyle;
        }
        if (this.cellDesign != null) {
            return this.cellDesign.getAntidiagonalStyle();
        }
        return null;
    }

    public void setAntidiagonalWidth(DimensionType antidiagonalWidth) {
        this.antidiagonalWidth = antidiagonalWidth;
    }

    public DimensionType getAntidiagonalWidth() {
        if (this.antidiagonalWidth != null) {
            return this.antidiagonalWidth;
        }
        if (this.cellDesign != null) {
            return this.cellDesign.getAntidiagonalWidth();
        }
        return null;
    }

    public void setAntidiagonalColor(String antidiagonalColor) {
        this.antidiagonalColor = antidiagonalColor;
    }

    public String getAntidiagonalColor() {
        if (this.antidiagonalColor != null) {
            return this.antidiagonalColor;
        }
        if (this.cellDesign != null) {
            return this.cellDesign.getAntidiagonalColor();
        }
        return null;
    }

    public String getHeaders() {
        Expression expr;
        if (this.headers != null) {
            return this.headers;
        }
        if (this.cellDesign != null && (expr = this.cellDesign.getHeaders()) != null && expr.getType() == 0) {
            return expr.getScriptText();
        }
        return null;
    }

    public String getScope() {
        if (this.scope != null) {
            return this.scope;
        }
        if (this.cellDesign != null) {
            return this.cellDesign.getScope();
        }
        return null;
    }

    public void setHeaders(String headers) {
        Expression expr;
        if (this.cellDesign != null && (expr = this.cellDesign.getHeaders()) != null && expr.getType() == 0 && headers.equals(expr.getScriptText())) {
            this.headers = null;
            return;
        }
        this.headers = headers;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean repeatContent() {
        return this.repeatContent;
    }

    public void setRepeatContent(boolean repeatContent) {
        this.repeatContent = repeatContent;
    }
}

