/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.ir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.BIRTCSSEngine;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.ir.Expression;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.PageSetupDesign;
import org.eclipse.birt.report.engine.ir.PageVariableDesign;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.parser.EngineIRTransferV213;
import org.eclipse.birt.report.engine.parser.MultiViewEngineIRVisitor;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.w3c.dom.css.CSSStyleDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Report {
    protected ReportDesignHandle reportDesign;
    protected ArrayList styles = new ArrayList();
    protected HashMap styleTable = new HashMap();
    protected String rootStyleName;
    protected ArrayList queries = new ArrayList();
    protected HashMap queryIDs = new HashMap();
    protected HashMap resultMetaData = new HashMap();
    protected PageSetupDesign pageSetup = new PageSetupDesign();
    protected ArrayList<ReportItemDesign> contents = new ArrayList();
    protected Map<String, Expression> userProperties;
    protected Map mapReportItemIDtoInstance;
    protected HashMap mapReportItemToQuery;
    protected HashMap mapQueryToReportElementHandle;
    protected CSSEngine cssEngine;
    private IStyle rootStyle;
    private ArrayList<PageVariableDesign> pageVariables = new ArrayList();
    private Expression onPageStart;
    private Expression onPageEnd;
    private String scriptLanguage = "javascript";
    private String reportLocale;
    private String javaClass;
    protected String version;

    public Report() {
        this.cssEngine = new BIRTCSSEngine();
    }

    public CSSEngine getCSSEngine() {
        return this.cssEngine;
    }

    public String getJavaClass() {
        return this.javaClass;
    }

    public void setJavaClass(String javaClass) {
        this.javaClass = javaClass;
    }

    public HashMap getReportItemToQueryMap() {
        if (this.mapReportItemToQuery == null) {
            this.mapReportItemToQuery = new HashMap();
        }
        return this.mapReportItemToQuery;
    }

    public void setQueryToReportHandle(ReportElementHandle handle, IDataQueryDefinition[] queries) {
        if (this.mapQueryToReportElementHandle == null) {
            this.mapQueryToReportElementHandle = new HashMap();
        }
        this.mapQueryToReportElementHandle.put(handle, queries);
    }

    public IDataQueryDefinition[] getQueryByReportHandle(ReportElementHandle handle) {
        if (this.mapQueryToReportElementHandle != null) {
            return (IDataQueryDefinition[])this.mapQueryToReportElementHandle.get(handle);
        }
        return null;
    }

    public void setReportItemInstanceID(long id, ReportElementDesign rptElement) {
        if (this.mapReportItemIDtoInstance == null) {
            this.mapReportItemIDtoInstance = new HashMap();
        }
        this.mapReportItemIDtoInstance.put(id, rptElement);
    }

    public ReportElementDesign getReportItemByID(long id) {
        assert (this.mapReportItemIDtoInstance != null);
        return (ReportElementDesign)this.mapReportItemIDtoInstance.get(id);
    }

    public Map<String, Expression> getUserProperties() {
        return this.userProperties;
    }

    public void setUserProperties(Map<String, Expression> userProperties) {
        this.userProperties = userProperties;
    }

    public void setPageSetup(PageSetupDesign pageSetup) {
        this.pageSetup = pageSetup;
    }

    public PageSetupDesign getPageSetup() {
        return this.pageSetup;
    }

    public Collection<ReportItemDesign> getContents() {
        return this.contents;
    }

    public int getContentCount() {
        return this.contents.size();
    }

    public ReportItemDesign getContent(int index) {
        assert (index >= 0 && index < this.contents.size());
        return this.contents.get(index);
    }

    public void addContent(ReportItemDesign item) {
        this.contents.add(item);
    }

    public Map getStyles() {
        return this.styleTable;
    }

    public void addStyle(String name, CSSStyleDeclaration style) {
        assert (style != null);
        this.styles.add(style);
        this.styleTable.put(name, style);
    }

    public IStyle findStyle(String name) {
        if (name == null) {
            return null;
        }
        return (IStyle)this.styleTable.get(name);
    }

    public MasterPageDesign findMasterPage(String name) {
        assert (name != null);
        return this.pageSetup.findMasterPage(name);
    }

    public ReportDesignHandle getReportDesign() {
        return this.reportDesign;
    }

    public void setReportDesign(ReportDesignHandle reportDesign) {
        this.reportDesign = reportDesign;
    }

    public ArrayList getQueries() {
        return this.queries;
    }

    public HashMap getQueryIDs() {
        return this.queryIDs;
    }

    public HashMap getResultMetaData() {
        return this.resultMetaData;
    }

    public String getRootStyleName() {
        return this.rootStyleName;
    }

    public void setRootStyleName(String rootStyleName) {
        this.rootStyleName = rootStyleName;
    }

    public List getErrors() {
        return this.reportDesign.getErrorList();
    }

    public ReportItemDesign findDesign(ReportElementHandle handle) {
        ReportElementDesign elementDesign = this.getReportItemByID(handle.getID());
        if (elementDesign != null) {
            return (ReportItemDesign)elementDesign;
        }
        return new MultiViewEngineIRVisitor(this.reportDesign).translate(handle, this);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void updateVersion(String version) {
        if (version == null) {
            return;
        }
        if (version.equals(this.version)) {
            return;
        }
        if (version.equals("2.1.3")) {
            new EngineIRTransferV213(this.reportDesign, this).transfer();
            return;
        }
    }

    public Collection<PageVariableDesign> getPageVariables() {
        return this.pageVariables;
    }

    public Expression getOnPageStart() {
        return this.onPageStart;
    }

    public void setOnPageStart(Expression onPageStart) {
        this.onPageStart = onPageStart;
    }

    public Expression getOnPageEnd() {
        return this.onPageEnd;
    }

    public void setOnPageEnd(Expression onPageEnd) {
        this.onPageEnd = onPageEnd;
    }

    public String getScriptLanguage() {
        return this.scriptLanguage;
    }

    public void setScriptLanguage(String defaultScript) {
        this.scriptLanguage = defaultScript;
    }

    public String getLocale() {
        return this.reportLocale;
    }

    public void setLocale(String loc) {
        this.reportLocale = loc;
    }
}

