/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.ui.expressions.ExpressionFilter;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.dialogs.CrosstabExpressionProvider;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.TabularDimensionHandle;

public class CrosstabFilterExpressionProvider
extends CrosstabExpressionProvider {
    private boolean isDetail = false;

    public void setDetail(boolean isDetail) {
        this.isDetail = isDetail;
    }

    public CrosstabFilterExpressionProvider(DesignElementHandle handle) {
        super(handle, null);
    }

    protected void addFilterToProvider() {
        this.addFilter(new ExpressionFilter(){

            public boolean select(Object parentElement, Object element) {
                PropertyHandle handle;
                if ("Category".equals(parentElement) && "Measure".equals(element)) {
                    return false;
                }
                if (parentElement instanceof String && ((String)parentElement).equals(CURRENT_CUBE) && element instanceof PropertyHandle && (handle = (PropertyHandle)element).getPropertyDefn().getName().equals("measureGroups")) {
                    return false;
                }
                if (parentElement instanceof PropertyHandle && (handle = (PropertyHandle)parentElement).getPropertyDefn().getName().equals("dimensions")) {
                    try {
                        CrosstabReportItemHandle xtabHandle = CrosstabFilterExpressionProvider.this.getCrosstabReportItemHandle();
                        boolean result = xtabHandle.getDimension(((TabularDimensionHandle)element).getName()) != null;
                        if (CrosstabFilterExpressionProvider.this.isDetail) {
                            result = !result;
                        }
                        return result;
                    }
                    catch (ExtendedElementException extendedElementException) {
                        return false;
                    }
                }
                return true;
            }
        });
    }

    protected List getChildrenList(Object parent) {
        if (this.isDetail) {
            if (parent instanceof TabularDimensionHandle) {
                ArrayList children = new ArrayList();
                TabularDimensionHandle handle = (TabularDimensionHandle)parent;
                if (handle.getDefaultHierarchy().getLevelCount() > 0) {
                    children.addAll(handle.getDefaultHierarchy().getPropertyHandle("levels").getContents());
                }
                return children;
            }
            if (parent instanceof LevelHandle) {
                ArrayList children = new ArrayList();
                return children;
            }
        }
        return super.getChildrenList(parent);
    }
}

