/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveEntryAdapter;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.IArchiveFile;

public class ArchiveView
implements IArchiveFile {
    private boolean sharedArchive = false;
    private IArchiveFile view = null;
    private IArchiveFile archive = null;

    public ArchiveView(IArchiveFile view, IArchiveFile archive, boolean sharedArchive) {
        this.view = view;
        this.archive = archive;
        this.sharedArchive = sharedArchive;
    }

    public ArchiveView(String viewName, String archiveName, String viewMode) throws IOException {
        this.view = new ArchiveFile(viewName, viewMode);
        this.archive = new ArchiveFile(archiveName, "r");
        this.sharedArchive = false;
    }

    public ArchiveView(String viewName, IArchiveFile archive, String viewMode) throws IOException {
        this.view = new ArchiveFile(viewName, viewMode);
        this.archive = archive;
        this.sharedArchive = true;
    }

    public void close() throws IOException {
        try {
            if (!this.sharedArchive) {
                this.archive.close();
            }
        }
        finally {
            this.view.close();
        }
    }

    public synchronized boolean exists(String name) {
        return this.view.exists(name) || this.archive.exists(name);
    }

    public synchronized ArchiveEntry openEntry(String name) throws IOException {
        if (this.view.exists(name)) {
            ArchiveEntry entry = this.view.openEntry(name);
            return new ViewEntry(this, name, entry);
        }
        if (this.archive.exists(name)) {
            ArchiveEntry entry = this.archive.openEntry(name);
            return new ViewEntry(this, name, entry);
        }
        throw new FileNotFoundException(name);
    }

    public synchronized List listEntries(String namePattern) {
        List<String> viewList = this.view.listEntries(namePattern);
        List<String> archiveList = this.archive.listEntries(namePattern);
        for (String entryName : archiveList) {
            if (viewList.contains(entryName)) continue;
            viewList.add(entryName);
        }
        return viewList;
    }

    public synchronized Object lockEntry(String entry) throws IOException {
        if (this.view.exists(entry)) {
            return this.view.lockEntry(entry);
        }
        if (this.archive.exists(entry)) {
            return this.archive.lockEntry(entry);
        }
        return this.view.lockEntry(entry);
    }

    public void refresh() throws IOException {
        this.view.refresh();
    }

    public String getSystemId() {
        return this.view.getSystemId();
    }

    public String getDependId() {
        return this.archive.getSystemId();
    }

    public ArchiveEntry createEntry(String name) throws IOException {
        return this.view.createEntry(name);
    }

    public void flush() throws IOException {
        this.view.flush();
    }

    public void save() throws IOException {
        this.view.save();
    }

    public String getName() {
        return this.view.getName();
    }

    public long getUsedCache() {
        return this.view.getUsedCache();
    }

    public boolean removeEntry(String name) throws IOException {
        return this.view.removeEntry(name);
    }

    public void setCacheSize(long cacheSize) {
        this.view.setCacheSize(cacheSize);
    }

    public synchronized void unlockEntry(Object locker) throws IOException {
        try {
            this.view.unlockEntry(locker);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.archive.unlockEntry(locker);
        }
    }

    public IArchiveFile getArchive() {
        return this.archive;
    }

    public IArchiveFile getView() {
        return this.view;
    }

    static class ViewEntry
    extends ArchiveEntryAdapter {
        IArchiveFile view;
        boolean writable = false;

        ViewEntry(IArchiveFile view, String name, ArchiveEntry entry) {
            super(name, entry);
            this.view = view;
        }

        protected void _setLength(long length) throws IOException {
            this.ensureWritable();
            this.entry.setLength(length);
        }

        protected void _flush() throws IOException {
            this.ensureWritable();
            this.entry.flush();
        }

        public void write(long pos, byte[] b, int off, int len) throws IOException {
            this.ensureWritable();
            this.entry.write(pos, b, off, len);
        }

        void ensureWritable() throws IOException {
            if (!this.writable) {
                ArchiveEntry viewEntry = this.view.createEntry(this.entryName);
                this.copyEntry(this.entry, viewEntry);
                this.entry = viewEntry;
                this.writable = true;
            }
        }

        private void copyEntry(ArchiveEntry src, ArchiveEntry tgt) throws IOException {
            byte[] b = new byte[4096];
            long length = src.getLength();
            long pos = 0L;
            while (pos < length) {
                int size = src.read(pos, b, 0, 4096);
                tgt.write(pos, b, 0, size);
                pos += (long)size;
            }
        }
    }
}

