/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.impl.query;

import javax.olap.OLAPException;
import javax.olap.cursor.CubeCursor;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.ICubeCursor;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.api.query.ISubCubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.CubeCursorImpl;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.eclipse.birt.data.engine.olap.script.JSLevelAccessor;
import org.eclipse.birt.data.engine.olap.script.JSMeasureAccessor;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class SubCubeQueryResults
implements ICubeQueryResults {
    private ICubeCursor cubeCursor;
    private BirtCubeView cubeView;
    private Scriptable subScope;
    private String name;
    private ScriptContext cx;

    public SubCubeQueryResults(ISubCubeQueryDefinition query, ICubeQueryResults parent, Scriptable scope, ScriptContext cx) throws DataException {
        this.cubeView = ((CubeCursorImpl)parent.getCubeCursor()).getCubeView();
        this.subScope = scope;
        this.cx = cx;
        this.cubeCursor = this.getSubCubeCursor(query.getStartingLevelOnColumn(), query.getStartingLevelOnRow());
    }

    protected ICubeCursor getSubCubeCursor(String startingColumnLevel, String startingRowLevel) throws DataException {
        CubeCursor subCubeCursor;
        BirtCubeView subCV;
        if (this.cubeView != null) {
            subCV = this.cubeView.createSubView();
            subCubeCursor = null;
            if (this.subScope == null) {
                Scriptable scope = this.cubeView.getCubeQueryExecutor().getSession().getSharedScope();
                this.subScope = Context.getCurrentContext().newObject(scope);
                this.subScope.setParentScope(scope);
                this.subScope.setPrototype(scope);
            }
            try {
                subCubeCursor = subCV.getCubeCursor(null, startingColumnLevel, startingRowLevel, this.cubeView);
                this.subScope.put("measure", this.subScope, (Object)new JSMeasureAccessor(subCubeCursor, subCV.getMeasureMapping()));
                this.subScope.put("dimension", this.subScope, (Object)new JSLevelAccessor(this.cubeView.getCubeQueryExecutor().getCubeQueryDefinition(), subCV));
            }
            catch (OLAPException e) {
                throw new DataException(e.getLocalizedMessage());
            }
        } else {
            throw new DataException("data.olap.missingParentCursor");
        }
        CubeCursorImpl cubeCursorImpl = new CubeCursorImpl(null, subCubeCursor, this.subScope, this.cx, this.cubeView.getCubeQueryExecutor().getCubeQueryDefinition(), subCV);
        return cubeCursorImpl;
    }

    public void cancel() {
    }

    public ICubeCursor getCubeCursor() throws DataException {
        return this.cubeCursor;
    }

    public void close() throws BirtException {
    }

    public String getID() {
        return null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

