/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.SortOption;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.DataPackage;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.SeriesGrouping;
import org.eclipse.birt.chart.model.data.impl.QueryImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesGroupingImpl;
import org.eclipse.birt.chart.model.impl.ChartModelHelper;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.SeriesGroupingComposite;
import org.eclipse.birt.chart.ui.swt.interfaces.IExpressionButton;
import org.eclipse.birt.chart.ui.swt.interfaces.IUIServiceProvider;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.ChartExpressionUtil;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class GroupSortingDialog
extends TrayDialog
implements Listener {
    protected static final String UNSORTED_OPTION = Messages.getString("BaseSeriesDataSheetImpl.Choice.Unsorted");
    protected static final String AUTO = Messages.getString("GroupSortingDialog.Sort.Locale.Auto");
    public static final Map<String, Integer> STRENGTH_MAP = new HashMap<String, Integer>();
    private static final int ASCII_SORT_STRENGTH = -1;
    protected ChartWizardContext wizardContext;
    private SeriesDefinition sd;
    protected Group cmpSortArea;
    protected Label lblSorting;
    protected Label lblSortExpr;
    protected Combo cmbSorting;
    protected Combo cmbSortExpr;
    protected Label lblSortLocale;
    protected Combo cmbSortLocale;
    protected Label lblSortStrength;
    protected Combo cmbSortStrength;
    protected IExpressionButton btnSortExprBuilder;
    protected boolean fEnableAggregation = true;
    protected SeriesGroupingComposite fGroupingComposite;
    protected final ChartExpressionUtil.ExpressionCodec exprCodec = ChartModelHelper.instance().createExpressionCodec();

    static {
        STRENGTH_MAP.put(Messages.getString("GroupSortingDialog.Sort.Strength.ASCII"), -1);
        STRENGTH_MAP.put(Messages.getString("GroupSortingDialog.Sort.Strength.PRIMARY"), 0);
        STRENGTH_MAP.put(Messages.getString("GroupSortingDialog.Sort.Strength.SECONDARY"), 1);
        STRENGTH_MAP.put(Messages.getString("GroupSortingDialog.Sort.Strength.TERTIARY"), 2);
        STRENGTH_MAP.put(Messages.getString("GroupSortingDialog.Sort.Strength.QUATENARY"), 3);
        STRENGTH_MAP.put(Messages.getString("GroupSortingDialog.Sort.Strength.IDENTICAL"), 15);
    }

    public GroupSortingDialog(Shell shell, ChartWizardContext wizardContext, SeriesDefinition sd) {
        super(shell);
        this.setHelpAvailable(false);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.wizardContext = wizardContext;
        this.sd = sd;
    }

    public GroupSortingDialog(Shell shell, ChartWizardContext wizardContext, SeriesDefinition sd, boolean disableAggregation) {
        super(shell);
        this.setHelpAvailable(false);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.wizardContext = wizardContext;
        this.sd = sd;
        this.fEnableAggregation = disableAggregation;
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        c.pack();
        return c;
    }

    protected Control createDialogArea(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.GroupAndSort_ID");
        this.getShell().setText(Messages.getString("GroupSortingDialog.Label.GroupAndSorting"));
        Composite cmpContent = new Composite(parent, 0);
        GridLayout glContent = new GridLayout(2, false);
        cmpContent.setLayout((Layout)glContent);
        GridData gd = new GridData(1808);
        cmpContent.setLayoutData((Object)gd);
        Composite cmpBasic = new Composite(cmpContent, 0);
        cmpBasic.setLayout((Layout)new GridLayout(2, false));
        gd = new GridData(768);
        cmpBasic.setLayoutData((Object)gd);
        this.createSortArea(cmpBasic);
        if (ChartUIUtil.isGroupingSupported((ChartWizardContext)this.wizardContext)) {
            this.createGroupArea(cmpBasic);
        }
        this.initSortKey();
        this.populateLists();
        return cmpContent;
    }

    protected void createGroupArea(Composite cmpBasic) {
        Composite cmpGrouping = new Composite(cmpBasic, 0);
        GridData gdCMPGrouping = new GridData(768);
        gdCMPGrouping.horizontalSpan = 2;
        cmpGrouping.setLayoutData((Object)gdCMPGrouping);
        cmpGrouping.setLayout((Layout)new FillLayout());
        this.fGroupingComposite = this.createSeriesGroupingComposite(cmpGrouping);
    }

    protected SeriesGroupingComposite createSeriesGroupingComposite(Composite parent) {
        SeriesGrouping grouping = this.getSeriesDefinitionForProcessing().getGrouping();
        if (grouping == null) {
            grouping = SeriesGroupingImpl.create();
            this.getSeriesDefinitionForProcessing().setGrouping(grouping);
        }
        return new SeriesGroupingComposite(parent, 0, grouping, this.fEnableAggregation, this.wizardContext, null);
    }

    protected void updateSortKey() {
        String sExpr = this.btnSortExprBuilder.getExpression();
        this.btnSortExprBuilder.setExpression(sExpr);
        this.getSeriesDefinitionForProcessing().getSortKey().setDefinition(sExpr);
    }

    public void createSortArea(Composite parent) {
        this.cmpSortArea = new Group(parent, 0);
        this.cmpSortArea.setText(Messages.getString("GroupSortingDialog.Composite.Group.Sorting"));
        this.cmpSortArea.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 300;
        this.cmpSortArea.setLayoutData((Object)gd);
        this.lblSorting = new Label((Composite)this.cmpSortArea, 0);
        this.lblSorting.setText(Messages.getString("BaseSeriesDataSheetImpl.Lbl.DataSorting"));
        this.cmbSorting = new Combo((Composite)this.cmpSortArea, 12);
        GridData gdCMBSorting = new GridData(768);
        this.cmbSorting.setLayoutData((Object)gdCMBSorting);
        this.cmbSorting.addListener(13, (Listener)this);
        new Label((Composite)this.cmpSortArea, 0);
        this.lblSortExpr = new Label((Composite)this.cmpSortArea, 0);
        this.lblSortExpr.setText(Messages.getString("BaseGroupSortingDialog.Label.SortOn"));
        this.cmbSortExpr = new Combo((Composite)this.cmpSortArea, 4);
        GridData gdCMBSortExpr = new GridData(768);
        this.cmbSortExpr.setLayoutData((Object)gdCMBSortExpr);
        this.cmbSortExpr.addListener(13, (Listener)this);
        this.cmbSortExpr.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                GroupSortingDialog.this.updateSortKey();
            }
        });
        try {
            this.btnSortExprBuilder = (IExpressionButton)this.wizardContext.getUIServiceProvider().invoke(IUIServiceProvider.Command.EXPRESS_BUTTON_CREATE, new Object[]{this.cmpSortArea, this.cmbSortExpr, this.wizardContext.getExtendedItem(), 1, new Listener(){

                public void handleEvent(Event event) {
                    if (event.data instanceof String[]) {
                        GroupSortingDialog.this.handleBuilderAction((String[])event.data);
                    }
                }
            }});
            Query query = this.getSeriesDefinitionForProcessing().getSortKey();
            if (query != null) {
                this.btnSortExprBuilder.setExpression(query.getDefinition());
            }
        }
        catch (ChartException e) {
            WizardBase.displayException((Throwable)e);
        }
        this.lblSortLocale = new Label((Composite)this.cmpSortArea, 0);
        this.lblSortLocale.setText(Messages.getString("GroupSortingDialog.Composite.Label.SortLocale"));
        this.cmbSortLocale = new Combo((Composite)this.cmpSortArea, 2056);
        GridData gd2 = new GridData(768);
        this.cmbSortLocale.setLayoutData((Object)gd2);
        this.cmbSortLocale.setVisibleItemCount(30);
        this.cmbSortLocale.addListener(13, (Listener)this);
        new Label((Composite)this.cmpSortArea, 0);
        this.lblSortStrength = new Label((Composite)this.cmpSortArea, 0);
        this.lblSortStrength.setText(Messages.getString("GroupSortingDialog.Composite.Label.SortStrength"));
        this.cmbSortStrength = new Combo((Composite)this.cmpSortArea, 2056);
        gd2 = new GridData(768);
        this.cmbSortStrength.setLayoutData((Object)gd2);
        this.cmbSortStrength.setVisibleItemCount(30);
        this.cmbSortStrength.addListener(13, (Listener)this);
        if (this.isInheritColumnsGroups()) {
            this.disableSorting();
        }
    }

    protected void handleBuilderAction(String[] data) {
        if (data.length != 4 || data[1].equals(data[0])) {
            return;
        }
        this.updateSortKey();
    }

    protected SeriesDefinition getSeriesDefinitionForProcessing() {
        return this.sd;
    }

    protected void populateLists() {
        this.populateSortList();
        this.populateSortKeyList();
    }

    protected void populateSortList() {
        this.cmbSorting.add(UNSORTED_OPTION);
        String[] nss = LiteralHelper.sortOptionSet.getDisplayNames();
        int i = 0;
        while (i < nss.length) {
            this.cmbSorting.add(nss[i]);
            ++i;
        }
        if (!this.getSeriesDefinitionForProcessing().isSetSorting()) {
            this.cmbSorting.select(0);
        } else {
            this.cmbSorting.select(LiteralHelper.sortOptionSet.getNameIndex(this.getSeriesDefinitionForProcessing().getSorting().getName()) + 1);
        }
        this.diableSortKeySelectionStateBySortDirection();
        ArrayList<String> localeNames = new ArrayList<String>();
        localeNames.add(AUTO);
        localeNames.addAll(ChartUIUtil.LOCALE_TABLE.keySet());
        this.cmbSortLocale.setItems(localeNames.toArray(new String[0]));
        if (this.getSeriesDefinitionForProcessing().getSortLocale() == null) {
            this.cmbSortLocale.select(0);
        } else {
            String locale = null;
            for (Map.Entry entry : ChartUIUtil.LOCALE_TABLE.entrySet()) {
                if (!this.getSeriesDefinitionForProcessing().getSortLocale().equals(((ULocale)entry.getValue()).getName())) continue;
                locale = (String)entry.getKey();
                break;
            }
            if (locale != null) {
                int index = this.cmbSortLocale.indexOf(locale);
                this.cmbSortLocale.select(index < 0 ? 0 : index);
            }
        }
        ArrayList<String> strengthNames = new ArrayList<String>(STRENGTH_MAP.keySet());
        Collections.sort(strengthNames, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return STRENGTH_MAP.get(o1) - STRENGTH_MAP.get(o2);
            }
        });
        this.cmbSortStrength.setItems(strengthNames.toArray(new String[0]));
        if (!this.getSeriesDefinitionForProcessing().isSetSortStrength()) {
            this.cmbSortStrength.select(3);
        } else {
            String strength = null;
            for (Map.Entry<String, Integer> entry : STRENGTH_MAP.entrySet()) {
                if (this.getSeriesDefinitionForProcessing().getSortStrength() != entry.getValue().intValue()) continue;
                strength = entry.getKey();
            }
            if (strength != null) {
                int index = this.cmbSortStrength.indexOf(strength);
                this.cmbSortStrength.select(index < 0 ? 0 : index);
            }
        }
    }

    private Object[] getPredefinedQuery(Set<String> exprSet) {
        if (!this.onlyCategoryExprAsCategorySortKey()) {
            Object[] queries = this.wizardContext.getPredefinedQuery("value");
            Object[] predefinedQuery = new Object[queries.length + exprSet.size()];
            int i = 0;
            Object[] objectArray = queries;
            int n = queries.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                predefinedQuery[i++] = obj;
                ++n2;
            }
            for (String expr : exprSet) {
                predefinedQuery[i++] = new String[]{expr, "expression"};
            }
            return predefinedQuery;
        }
        return exprSet.toArray(new String[exprSet.size()]);
    }

    protected void populateSortKeyList() {
        this.initSortKey();
        this.updateSortState();
        if (this.cmbSorting.getText().equals(UNSORTED_OPTION)) {
            this.getSeriesDefinitionForProcessing().unsetSorting();
            this.cmbSortExpr.removeAll();
        } else {
            Set<String> exprSet = this.getSortKeySet();
            String sortExpr = this.getSeriesDefinitionForProcessing().getSortKey().getDefinition();
            this.btnSortExprBuilder.setPredefinedQuery(this.getPredefinedQuery(exprSet));
            this.btnSortExprBuilder.setExpression(sortExpr);
            if (sortExpr != null && !"".equals(sortExpr)) {
                exprSet.add(sortExpr);
                this.btnSortExprBuilder.setExpression(sortExpr);
            } else if (!exprSet.isEmpty()) {
                this.cmbSortExpr.select(0);
                Event event = new Event();
                event.type = 13;
                event.widget = this.cmbSortExpr;
                this.cmbSortExpr.notifyListeners(13, event);
            }
        }
        this.setSortKeyInModel();
    }

    protected void updateSortState() {
        this.updateSortKeySelectionState();
        boolean sortEnabled = this.isSortEnabled();
        this.lblSortLocale.setEnabled(sortEnabled);
        this.cmbSortLocale.setEnabled(sortEnabled);
        this.lblSortStrength.setEnabled(sortEnabled);
        this.cmbSortStrength.setEnabled(sortEnabled);
    }

    protected boolean isSortEnabled() {
        return !UNSORTED_OPTION.equals(this.cmbSorting.getText());
    }

    public void handleEvent(Event event) {
        if (event.type == 13) {
            if (event.widget == this.cmbSorting) {
                this.diableSortKeySelectionStateBySortDirection();
                if (this.cmbSorting.getText().equals(UNSORTED_OPTION)) {
                    this.getSeriesDefinitionForProcessing().eUnset((EStructuralFeature)DataPackage.eINSTANCE.getSeriesDefinition_Sorting());
                    this.getSeriesDefinitionForProcessing().getSortKey().setDefinition(null);
                } else {
                    this.getSeriesDefinitionForProcessing().setSorting(SortOption.getByName((String)LiteralHelper.sortOptionSet.getNameByDisplayName(this.cmbSorting.getText())));
                }
                this.populateSortKeyList();
            } else if (event.widget == this.cmbSortLocale) {
                ULocale locale = (ULocale)ChartUIUtil.LOCALE_TABLE.get(this.cmbSortLocale.getText());
                if (locale == null) {
                    this.getSeriesDefinitionForProcessing().setSortLocale(null);
                } else {
                    this.getSeriesDefinitionForProcessing().setSortLocale(locale.getName());
                }
            } else if (event.widget == this.cmbSortStrength) {
                Integer sValue = STRENGTH_MAP.get(this.cmbSortStrength.getText());
                if (sValue == null) {
                    this.getSeriesDefinitionForProcessing().setSortStrength(-1);
                } else {
                    this.getSeriesDefinitionForProcessing().setSortStrength(sValue.intValue());
                }
            }
        }
    }

    protected void setSortKeySelectionState(boolean enabled) {
        this.lblSortExpr.setEnabled(enabled);
        this.cmbSortExpr.setEnabled(enabled);
        if (this.btnSortExprBuilder != null) {
            this.btnSortExprBuilder.setEnabled(enabled);
        }
    }

    protected void updateSortKeySelectionState() {
        this.setSortKeySelectionState(!UNSORTED_OPTION.equals(this.cmbSorting.getText()));
    }

    protected void diableSortKeySelectionStateBySortDirection() {
        if (this.cmbSorting.getText().equals(UNSORTED_OPTION)) {
            this.setSortKeySelectionState(false);
        }
    }

    protected void initSortKey() {
        if (this.getSeriesDefinitionForProcessing().getSortKey() == null) {
            this.getSeriesDefinitionForProcessing().setSortKey(QueryImpl.create(null));
        }
    }

    protected boolean onlyCategoryExprAsCategorySortKey() {
        return ChartUIUtil.hasLimitOnCategorySortKey((ChartWizardContext)this.wizardContext);
    }

    protected boolean isInheritColumnsGroups() {
        int stateInfo = this.wizardContext.getDataServiceProvider().getState();
        return (stateInfo & 1) == 0 && (stateInfo & 2) == 0 && (stateInfo & 0x1000) != 0 && (stateInfo & 0x400) != 0;
    }

    protected void disableSorting() {
        this.lblSorting.setEnabled(false);
        this.cmbSorting.setEnabled(false);
        this.lblSortExpr.setEnabled(false);
        this.cmbSortExpr.setEnabled(false);
        this.lblSortLocale.setEnabled(false);
        this.cmbSortLocale.setEnabled(false);
        this.lblSortStrength.setEnabled(false);
        this.cmbSortStrength.setEnabled(false);
        if (this.btnSortExprBuilder != null) {
            this.btnSortExprBuilder.setEnabled(false);
        }
    }

    protected boolean isYGroupingEnabled() {
        return ChartUtil.isSpecifiedYOptionalExpression((Chart)this.wizardContext.getModel());
    }

    protected Set<String> getBaseSeriesExpression() {
        LinkedHashSet<String> exprList = new LinkedHashSet<String>();
        Chart chart = this.wizardContext.getModel();
        if (chart instanceof ChartWithAxes) {
            SeriesDefinition baseSD;
            Series seBase;
            EList elBaseSeries;
            Axis axPrimaryBase = ((ChartWithAxes)chart).getPrimaryBaseAxes()[0];
            EList elSD = axPrimaryBase.getSeriesDefinitions();
            if (elSD != null && elSD.size() >= 1 && (elBaseSeries = (seBase = (baseSD = (SeriesDefinition)elSD.get(0)).getDesignTimeSeries()).getDataDefinition()) != null && elBaseSeries.size() >= 1) {
                String baseSeriesExpression = ((Query)elBaseSeries.get(0)).getDefinition();
                exprList.add(baseSeriesExpression);
            }
        } else {
            EList lstSDs = ((ChartWithoutAxes)chart).getSeriesDefinitions();
            int i = 0;
            while (i < lstSDs.size()) {
                SeriesDefinition sd = (SeriesDefinition)lstSDs.get(i);
                Series series = sd.getDesignTimeSeries();
                for (Query qSeries : series.getDataDefinition()) {
                    if (qSeries == null || qSeries.getDefinition() == null) continue;
                    exprList.add(qSeries.getDefinition());
                }
                ++i;
            }
        }
        return exprList;
    }

    protected Set<String> getValueSeriesExpressions() {
        LinkedHashSet<String> exprList = new LinkedHashSet<String>();
        Chart chart = this.wizardContext.getModel();
        if (chart instanceof ChartWithAxes) {
            ChartWithAxes cwa = (ChartWithAxes)chart;
            Axis axPrimaryBase = cwa.getPrimaryBaseAxes()[0];
            Axis[] axisArray = cwa.getOrthogonalAxes(axPrimaryBase, true);
            int n = axisArray.length;
            int n2 = 0;
            while (n2 < n) {
                Axis axOrthogonal = axisArray[n2];
                for (SeriesDefinition orthoSD : axOrthogonal.getSeriesDefinitions()) {
                    Series seOrthogonal = orthoSD.getDesignTimeSeries();
                    for (Query qOrthogonalSeries : seOrthogonal.getDataDefinition()) {
                        if (qOrthogonalSeries == null || qOrthogonalSeries.getDefinition() == null || qOrthogonalSeries.getDefinition().length() == 0) continue;
                        exprList.add(qOrthogonalSeries.getDefinition());
                    }
                }
                ++n2;
            }
        } else {
            ChartWithoutAxes cwoa = (ChartWithoutAxes)chart;
            for (SeriesDefinition sd : cwoa.getSeriesDefinitions()) {
                for (SeriesDefinition orthSD : sd.getSeriesDefinitions()) {
                    Series orthSeries = orthSD.getDesignTimeSeries();
                    for (Query qSeries : orthSeries.getDataDefinition()) {
                        if (qSeries == null || qSeries.getDefinition() == null || qSeries.getDefinition().length() == 0) continue;
                        exprList.add(qSeries.getDefinition());
                    }
                }
            }
        }
        return exprList;
    }

    protected Set<String> getSortKeySet() {
        return Collections.emptySet();
    }

    protected void setSortKeyInModel() {
        String sortKey = this.btnSortExprBuilder.getExpression();
        if ("".equals(sortKey)) {
            sortKey = null;
        }
        this.getSeriesDefinitionForProcessing().getSortKey().setDefinition(sortKey);
    }

    protected void okPressed() {
        if (!UNSORTED_OPTION.equals(this.cmbSorting.getText()) && this.cmbSortExpr.getText().isEmpty()) {
            MessageDialog.openWarning(null, (String)Messages.getString("GroupSortingDialog.Sort.SortOn.Warning.Title"), (String)Messages.getString("GroupSortingDialog.Sort.SortOn.Warning.Message"));
        } else {
            super.okPressed();
        }
    }
}

